import { aws_apigatewayv2 as apigatewayv2, aws_ec2 as ec2, aws_lambda as lambda, aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { CustomLambdaFunctionProps } from "../utils";
export declare class TitilerPgstacApiLambdaRuntime extends Construct {
    readonly lambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: TitilerPgstacApiLambdaRuntimeProps);
}
export interface TitilerPgstacApiLambdaRuntimeProps {
    /**
     * VPC into which the lambda should be deployed.
     */
    readonly vpc?: ec2.IVpc;
    /**
     * RDS Instance with installed pgSTAC or pgbouncer server.
     */
    readonly db: rds.IDatabaseInstance | ec2.IInstance;
    /**
     * Subnet into which the lambda should be deployed.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Secret containing connection information for pgSTAC database.
     */
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * Customized environment variables to send to titiler-pgstac runtime. These will be merged with `defaultTitilerPgstacEnv`.
     * The database secret arn is automatically added to the environment variables at deployment.
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * list of buckets the lambda will be granted access to.
     */
    readonly buckets?: string[];
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - defined in the construct.
     */
    readonly lambdaFunctionOptions?: CustomLambdaFunctionProps;
}
export declare class TitilerPgstacApiLambda extends Construct {
    /**
     * URL for the Titiler Pgstac API.
     */
    readonly url: string;
    /**
     * Lambda function for the Titiler Pgstac API.
     */
    readonly lambdaFunction: lambda.Function;
    /**
     * @deprecated - use lambdaFunction instead
     */
    titilerPgstacLambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: TitilerPgstacApiLambdaProps);
}
export interface TitilerPgstacApiLambdaProps extends TitilerPgstacApiLambdaRuntimeProps {
    /**
     * Domain Name for the Titiler Pgstac API. If defined, will create the domain name and integrate it with the Titiler Pgstac API.
     *
     * @default - undefined.
     */
    readonly domainName?: apigatewayv2.IDomainName;
    /**
     * Custom Domain Name Options for Titiler Pgstac API,
     *
     * @deprecated Use 'domainName' instead.
     * @default - undefined.
     */
    readonly titilerPgstacApiDomainName?: apigatewayv2.IDomainName;
}
