"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TitilerPgstacApiLambda = exports.TitilerPgstacApiLambdaRuntime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const path = require("path");
const lambda_api_gateway_1 = require("../lambda-api-gateway");
// default settings that can be overridden by the user-provided environment.
let defaultTitilerPgstacEnv = {
    CPL_VSIL_CURL_ALLOWED_EXTENSIONS: ".tif,.TIF,.tiff",
    GDAL_CACHEMAX: "200",
    GDAL_DISABLE_READDIR_ON_OPEN: "EMPTY_DIR",
    GDAL_INGESTED_BYTES_AT_OPEN: "32768",
    GDAL_HTTP_MERGE_CONSECUTIVE_RANGES: "YES",
    GDAL_HTTP_MULTIPLEX: "YES",
    GDAL_HTTP_VERSION: "2",
    PYTHONWARNINGS: "ignore",
    VSI_CACHE: "TRUE",
    VSI_CACHE_SIZE: "5000000",
    DB_MIN_CONN_SIZE: "1",
    DB_MAX_CONN_SIZE: "1",
};
class TitilerPgstacApiLambdaRuntime extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambdaFunction = new aws_cdk_lib_1.aws_lambda.Function(this, "lambda", {
            // defaults
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_12,
            handler: "handler.handler",
            memorySize: 3008,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, ".."), {
                file: "titiler-pgstac-api/runtime/Dockerfile",
                buildArgs: { PYTHON_VERSION: "3.12" },
            }),
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            environment: {
                ...defaultTitilerPgstacEnv,
                ...props.apiEnv, // if user provided environment variables, merge them with the defaults.
                PGSTAC_SECRET_ARN: props.dbSecret.secretArn,
            },
            // overwrites defaults with user-provided configurable properties
            ...props.lambdaFunctionOptions,
        });
        // grant access to buckets using addToRolePolicy
        if (props.buckets) {
            props.buckets.forEach((bucket) => {
                this.lambdaFunction.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    actions: ["s3:GetObject"],
                    resources: [`arn:aws:s3:::${bucket}/*`],
                }));
            });
        }
        props.dbSecret.grantRead(this.lambdaFunction);
        if (props.vpc) {
            this.lambdaFunction.connections.allowTo(props.db, aws_cdk_lib_1.aws_ec2.Port.tcp(5432), "allow connections from titiler");
        }
    }
}
exports.TitilerPgstacApiLambdaRuntime = TitilerPgstacApiLambdaRuntime;
_a = JSII_RTTI_SYMBOL_1;
TitilerPgstacApiLambdaRuntime[_a] = { fqn: "eoapi-cdk.TitilerPgstacApiLambdaRuntime", version: "10.2.1" };
class TitilerPgstacApiLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const runtime = new TitilerPgstacApiLambdaRuntime(this, "runtime", {
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            db: props.db,
            dbSecret: props.dbSecret,
            apiEnv: props.apiEnv,
            buckets: props.buckets,
            lambdaFunctionOptions: props.lambdaFunctionOptions,
        });
        this.titilerPgstacLambdaFunction = this.lambdaFunction =
            runtime.lambdaFunction;
        const { api } = new lambda_api_gateway_1.LambdaApiGateway(this, "titlier-pgstac-api", {
            lambdaFunction: runtime.lambdaFunction,
            domainName: props.domainName ?? props.titilerPgstacApiDomainName,
        });
        this.url = api.url;
        new aws_cdk_lib_1.CfnOutput(this, "titiler-pgstac-api-output", {
            exportName: `${aws_cdk_lib_1.Stack.of(this).stackName}-titiler-pgstac-url`,
            value: this.url,
        });
    }
}
exports.TitilerPgstacApiLambda = TitilerPgstacApiLambda;
_b = JSII_RTTI_SYMBOL_1;
TitilerPgstacApiLambda[_b] = { fqn: "eoapi-cdk.TitilerPgstacApiLambda", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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