#!/usr/bin/python
#
# Copyright 2018-2020 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.1.6-rc2
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from polyaxon_sdk.api_client import ApiClient
from polyaxon_sdk.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class ProjectDashboardsV1Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_project_dashboard(self, owner, project, body, **kwargs):  # noqa: E501
        """Create project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dashboard(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_project_dashboard_with_http_info(
            owner, project, body, **kwargs
        )  # noqa: E501

    def create_project_dashboard_with_http_info(
        self, owner, project, body, **kwargs
    ):  # noqa: E501
        """Create project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_dashboard_with_http_info(owner, project, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Dashboard, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `create_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `create_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `create_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Dashboard",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_project_dashboard(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Delete project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dashboard(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_project_dashboard_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def delete_project_dashboard_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Delete project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_dashboard_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `delete_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `delete_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `delete_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/{uuid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_project_dashboard(self, owner, project, uuid, **kwargs):  # noqa: E501
        """Get project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dashboard(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_project_dashboard_with_http_info(
            owner, project, uuid, **kwargs
        )  # noqa: E501

    def get_project_dashboard_with_http_info(
        self, owner, project, uuid, **kwargs
    ):  # noqa: E501
        """Get project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_dashboard_with_http_info(owner, project, uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project (required)
        :param str uuid: Uuid identifier of the entity (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Dashboard, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `get_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `get_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and (
            "uuid" not in local_var_params
            or local_var_params["uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `uuid` when calling `get_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "uuid" in local_var_params:
            path_params["uuid"] = local_var_params["uuid"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/{uuid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Dashboard",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_project_dashboard_names(self, owner, project, **kwargs):  # noqa: E501
        """List project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dashboard_names(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListDashboardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_project_dashboard_names_with_http_info(
            owner, project, **kwargs
        )  # noqa: E501

    def list_project_dashboard_names_with_http_info(
        self, owner, project, **kwargs
    ):  # noqa: E501
        """List project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dashboard_names_with_http_info(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListDashboardsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_dashboard_names" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `list_project_dashboard_names`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `list_project_dashboard_names`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/names",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListDashboardsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_project_dashboards(self, owner, project, **kwargs):  # noqa: E501
        """List project dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dashboards(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1ListDashboardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_project_dashboards_with_http_info(
            owner, project, **kwargs
        )  # noqa: E501

    def list_project_dashboards_with_http_info(
        self, owner, project, **kwargs
    ):  # noqa: E501
        """List project dashboards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_project_dashboards_with_http_info(owner, project, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param int offset: Pagination offset.
        :param int limit: Limit size.
        :param str sort: Sort to order the search.
        :param str query: Query filter the search search.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1ListDashboardsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "offset", "limit", "sort", "query"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_dashboards" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `list_project_dashboards`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `list_project_dashboards`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501

        query_params = []
        if (
            "offset" in local_var_params and local_var_params["offset"] is not None
        ):  # noqa: E501
            query_params.append(("offset", local_var_params["offset"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "query" in local_var_params and local_var_params["query"] is not None
        ):  # noqa: E501
            query_params.append(("query", local_var_params["query"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1ListDashboardsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def patch_project_dashboard(
        self, owner, project, dashboard_uuid, body, **kwargs
    ):  # noqa: E501
        """Patch project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_project_dashboard(owner, project, dashboard_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.patch_project_dashboard_with_http_info(
            owner, project, dashboard_uuid, body, **kwargs
        )  # noqa: E501

    def patch_project_dashboard_with_http_info(
        self, owner, project, dashboard_uuid, body, **kwargs
    ):  # noqa: E501
        """Patch project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_project_dashboard_with_http_info(owner, project, dashboard_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Dashboard, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "dashboard_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `patch_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `patch_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'dashboard_uuid' is set
        if self.api_client.client_side_validation and (
            "dashboard_uuid" not in local_var_params
            or local_var_params["dashboard_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `dashboard_uuid` when calling `patch_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `patch_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "dashboard_uuid" in local_var_params:
            path_params["dashboard.uuid"] = local_var_params[
                "dashboard_uuid"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/{dashboard.uuid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Dashboard",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def promote_project_dashboard(
        self, owner, project, dashboard_uuid, **kwargs
    ):  # noqa: E501
        """Promote project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.promote_project_dashboard(owner, project, dashboard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.promote_project_dashboard_with_http_info(
            owner, project, dashboard_uuid, **kwargs
        )  # noqa: E501

    def promote_project_dashboard_with_http_info(
        self, owner, project, dashboard_uuid, **kwargs
    ):  # noqa: E501
        """Promote project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.promote_project_dashboard_with_http_info(owner, project, dashboard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Dashboard, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "dashboard_uuid"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method promote_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `promote_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `promote_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'dashboard_uuid' is set
        if self.api_client.client_side_validation and (
            "dashboard_uuid" not in local_var_params
            or local_var_params["dashboard_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `dashboard_uuid` when calling `promote_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "dashboard_uuid" in local_var_params:
            path_params["dashboard.uuid"] = local_var_params[
                "dashboard_uuid"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/{dashboard.uuid}/promote",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Dashboard",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_project_dashboard(
        self, owner, project, dashboard_uuid, body, **kwargs
    ):  # noqa: E501
        """Update project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dashboard(owner, project, dashboard_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_project_dashboard_with_http_info(
            owner, project, dashboard_uuid, body, **kwargs
        )  # noqa: E501

    def update_project_dashboard_with_http_info(
        self, owner, project, dashboard_uuid, body, **kwargs
    ):  # noqa: E501
        """Update project dashboard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_dashboard_with_http_info(owner, project, dashboard_uuid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Owner of the namespace (required)
        :param str project: Project under namesapce (required)
        :param str dashboard_uuid: UUID (required)
        :param V1Dashboard body: Dashboard body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1Dashboard, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["owner", "project", "dashboard_uuid", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_dashboard" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and (
            "owner" not in local_var_params
            or local_var_params["owner"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `owner` when calling `update_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and (
            "project" not in local_var_params
            or local_var_params["project"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `project` when calling `update_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'dashboard_uuid' is set
        if self.api_client.client_side_validation and (
            "dashboard_uuid" not in local_var_params
            or local_var_params["dashboard_uuid"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `dashboard_uuid` when calling `update_project_dashboard`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params
            or local_var_params["body"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `update_project_dashboard`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "owner" in local_var_params:
            path_params["owner"] = local_var_params["owner"]  # noqa: E501
        if "project" in local_var_params:
            path_params["project"] = local_var_params["project"]  # noqa: E501
        if "dashboard_uuid" in local_var_params:
            path_params["dashboard.uuid"] = local_var_params[
                "dashboard_uuid"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKey"]  # noqa: E501

        return self.api_client.call_api(
            "/api/v1/{owner}/{project}/dashboards/{dashboard.uuid}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="V1Dashboard",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
