import pytest

from mindee.client import Client
from mindee.product.invoice.invoice_v4 import InvoiceV4
from tests.product import get_id, get_version
from tests.utils import PRODUCT_DATA_DIR


@pytest.mark.regression
def test_default_sample():
    client = Client()
    with open(
        PRODUCT_DATA_DIR / "invoices" / "response_v4" / "default_sample.rst",
        encoding="utf-8",
    ) as rst_file:
        rst_ref = rst_file.read()

    sample = client.source_from_path(
        PRODUCT_DATA_DIR / "invoices" / "default_sample.jpg",
    )
    response = client.parse(InvoiceV4, sample)
    doc_response = response.document
    doc_response.id = get_id(rst_ref)
    doc_response.inference.product.version = get_version(rst_ref)
    assert str(doc_response) == rst_ref
