import json

import pytest

from mindee.parsing.common.document import Document
from mindee.parsing.common.page import Page
from mindee.product.passport.passport_v1 import PassportV1
from mindee.product.passport.passport_v1_document import (
    PassportV1Document,
)
from tests.utils import PRODUCT_DATA_DIR

RESPONSE_DIR = PRODUCT_DATA_DIR / "passport" / "response_v1"

PassportV1DocumentType = Document[
    PassportV1Document,
    Page[PassportV1Document],
]


@pytest.fixture
def complete_doc() -> PassportV1DocumentType:
    file_path = RESPONSE_DIR / "complete.json"
    with open(file_path, "r", encoding="utf-8") as open_file:
        json_data = json.load(open_file)
    return Document(PassportV1, json_data["document"])


@pytest.fixture
def empty_doc() -> PassportV1DocumentType:
    file_path = RESPONSE_DIR / "empty.json"
    with open(file_path, "r", encoding="utf-8") as open_file:
        json_data = json.load(open_file)
    return Document(PassportV1, json_data["document"])


def test_complete_doc(complete_doc: PassportV1DocumentType):
    file_path = RESPONSE_DIR / "summary_full.rst"
    with open(file_path, "r", encoding="utf-8") as open_file:
        reference_str = open_file.read()
    assert str(complete_doc) == reference_str


def test_empty_doc(empty_doc: PassportV1DocumentType):
    prediction = empty_doc.inference.prediction
    assert prediction.country.value is None
    assert prediction.id_number.value is None
    assert len(prediction.given_names) == 0
    assert prediction.surname.value is None
    assert prediction.birth_date.value is None
    assert prediction.birth_place.value is None
    assert prediction.gender.value is None
    assert prediction.issuance_date.value is None
    assert prediction.expiry_date.value is None
    assert prediction.mrz1.value is None
    assert prediction.mrz2.value is None
