import pytest

from mindee.client import Client
from mindee.product.receipt.receipt_v5 import ReceiptV5
from tests.product import get_id, get_version
from tests.utils import PRODUCT_DATA_DIR


@pytest.mark.regression
def test_default_sample():
    client = Client()
    with open(
        PRODUCT_DATA_DIR / "expense_receipts" / "response_v5" / "default_sample.rst",
        encoding="utf-8",
    ) as rst_file:
        rst_ref = rst_file.read()

    sample = client.source_from_path(
        PRODUCT_DATA_DIR / "expense_receipts" / "default_sample.jpg",
    )
    response = client.parse(ReceiptV5, sample)
    doc_response = response.document
    doc_response.id = get_id(rst_ref)
    doc_response.inference.product.version = get_version(rst_ref)
    assert str(doc_response) == rst_ref
