---
icon: material/information-slab-circle
---

# :material-information-slab-circle: Introduction

## Description

**EasyDiffraction** is scientific software for calculating diffraction
patterns  
based on structural models and refining model parameters against experimental
data.

It is available as both a cross-platform desktop application and a Python
library.

This documentation covers the usage of the EasyDiffraction Python library.  
For the graphical user interface (GUI) version, refer to the
[GUI documentation](https://docs.easydiffraction.org/app).

## EasyScience

EasyDiffraction is developed using the
[EasyScience framework](https://easyscience.software), which provides tools
for  
building modular and flexible scientific libraries and applications.

## License

EasyDiffraction is released under the
[BSD 3-Clause License](https://raw.githubusercontent.com/easyscience/diffraction-lib/master/LICENSE).

## Releases

The latest version of the EasyDiffraction Python library is
[{{ vars.release_version }}](https://github.com/easyscience/diffraction-lib/releases/latest).

For a complete list of new features, bug fixes, and improvements, see the
[GitHub Releases page](https://github.com/easyscience/diffraction-lib/releases).

## Citation

If you use EasyDiffraction in your work, please cite the specific version you
used.

All official releases of the EasyDiffraction library are archived on  
Zenodo, each with a version-specific Digital Object Identifier (DOI).

Citation details in various styles (e.g., APA, MLA) and formats (e.g., BibTeX,
JSON)  
are available on the
[Zenodo archive page](https://doi.org/10.5281/zenodo.16806521).

## Contributing

We welcome contributions from the community! EasyDiffraction is intended to be a
community-driven, open-source project supported by a diverse group of
contributors.

The project is maintained by the
[European Spallation Source (ESS)](https://ess.eu).

To contribute, see our
[:material-account-plus: Contributing Guidelines](https://github.com/easyscience/diffraction-lib/blob/master/CONTRIBUTING.md)
on GitHub.

## Get in Touch

For general questions or feedback, contact us at
[support@easydiffraction.org](mailto:support@easydiffraction.org).

To report bugs or request features, please use the
[GitHub Issue Tracker](https://github.com/easyscience/diffraction-lib/issues)
(free registration required).
