[coreCIF][1]{:.label-cif}

# \_atom_site

Data items in this category record details about the atom sites in a crystal
structure, such as the positional coordinates and atomic displacement
parameters. Please see the
[IUCr page](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/CATOM_SITE.html)
for further details.

## [\_atom_site.label](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.label.html)

This is a unique identifier for a particular site in the asymmetric unit of the
crystal unit cell.

## [\_atom_site.type_symbol](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.type_symbol.html)

A code to identify the atom specie(s) occupying this site.

## \_atom_site.fract

Atom-site coordinates as fractions of the [\_cell_length](cell.md) values.

- [\_atom_site.fract_x](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.fract_x.html)
- [\_atom_site.fract_y](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.fract_y.html)
- [\_atom_site.fract_z](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.fract_z.html)

## [\_atom_site.occupancy](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.occupancy.html)

The fraction of the atom type present at this site.

## [\_atom_site.ADP_type](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.adp_type.html)

Code for type of atomic displacement parameters used for the site. Currently
only `Biso` (isotropic B) is supported.

## [\_atom_site.B_iso_or_equiv](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.B_iso_or_equiv.html)

Isotropic atomic displacement parameter, or equivalent isotropic atomic
displacement parameter, in angstroms squared.

## [\_atom_site.site_symmetry_multiplicity](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.site_symmetry_multiplicity.html)

`optional parameter`

The number of different sites that are generated by the application of the
space-group symmetry to the coordinates given for this site. It is equal to the
multiplicity given for this Wyckoff site in International Tables for
Crystallography Vol. A (2002).

## [\_atom_site.Wyckoff_symbol](https://www.iucr.org/__data/iucr/cifdic_html/3/CORE_DIC/Iatom_site.Wyckoff_symbol.html)

`optional parameter`

The Wyckoff symbol (letter) as listed in the space-group tables of International
Tables for Crystallography Vol. A.

<!-- prettier-ignore-start -->
[0]: #
[1]: https://www.iucr.org/resources/cif/dictionaries/browse/cif_core
[2]: https://www.iucr.org/resources/cif/dictionaries/browse/cif_pd
<!-- prettier-ignore-end -->
