# SPDX-FileCopyrightText: 2021-2025 EasyDiffraction Python Library contributors <https://github.com/easyscience/diffraction-lib>
# SPDX-License-Identifier: BSD-3-Clause

SPACE_GROUP_LOOKUP_DICT = {
    (1, None): {
        'IT_number': 1,
        'setting': None,
        'IT_coordinate_system_code': None,
        'name_H-M_alt': 'P 1 1 1',
        'crystal_system': 'triclinic',
        'Wyckoff_positions': {
            'a': {'multiplicity': 1, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)']},
        },
    },
    (2, None): {
        'IT_number': 2,
        'setting': None,
        'IT_coordinate_system_code': None,
        'name_H-M_alt': 'P 1 1 1',
        'crystal_system': 'triclinic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (3, 'b1'): {
        'IT_number': 3,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 2 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (3, '-b1'): {
        'IT_number': 3,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 2 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (3, 'c1'): {
        'IT_number': 3,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 2',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,1/2,z)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,1/2,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (3, '-c1'): {
        'IT_number': 3,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 2',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,-1/2,z)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/2,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (3, 'a1'): {
        'IT_number': 3,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 2 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (3, '-a1'): {
        'IT_number': 3,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 2 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,-1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (4, 'b1'): {
        'IT_number': 4,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 21 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)']}},
    },
    (4, '-b1'): {
        'IT_number': 4,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 21 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)']}},
    },
    (4, 'c1'): {
        'IT_number': 4,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 21',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)']}},
    },
    (4, '-c1'): {
        'IT_number': 4,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 21',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)']}},
    },
    (4, 'a1'): {
        'IT_number': 4,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 21 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)']}},
    },
    (4, '-a1'): {
        'IT_number': 4,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 21 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)']}},
    },
    (5, 'b1'): {
        'IT_number': 5,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'C 1 2 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (5, '-b1'): {
        'IT_number': 5,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'A 1 2 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (5, 'c1'): {
        'IT_number': 5,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'A 1 1 2',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (5, '-c1'): {
        'IT_number': 5,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'B 1 1 2',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (5, 'a1'): {
        'IT_number': 5,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'B 2 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (5, '-a1'): {
        'IT_number': 5,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'C 2 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (6, 'b1'): {
        'IT_number': 6,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/2,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)']},
        },
    },
    (6, '-b1'): {
        'IT_number': 6,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/2,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)']},
        },
    },
    (6, 'c1'): {
        'IT_number': 6,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y,-z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)']},
        },
    },
    (6, '-c1'): {
        'IT_number': 6,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y,-z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)']},
        },
    },
    (6, 'a1'): {
        'IT_number': 6,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(1/2,y,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)']},
        },
    },
    (6, '-a1'): {
        'IT_number': 6,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'c': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(1/2,y,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)']},
        },
    },
    (7, 'b1'): {
        'IT_number': 7,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z+1/2)']}},
    },
    (7, '-b1'): {
        'IT_number': 7,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x-1/2,-y,z)']}},
    },
    (7, 'c1'): {
        'IT_number': 7,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x+1/2,y,-z)']}},
    },
    (7, '-c1'): {
        'IT_number': 7,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y-1/2,-z)']}},
    },
    (7, 'a1'): {
        'IT_number': 7,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y+1/2,z)']}},
    },
    (7, '-a1'): {
        'IT_number': 7,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 2, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z-1/2)']}},
    },
    (8, 'b1'): {
        'IT_number': 8,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'C 1 m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)']},
        },
    },
    (8, '-b1'): {
        'IT_number': 8,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'A 1 m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)']},
        },
    },
    (8, 'c1'): {
        'IT_number': 8,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'A 1 1 m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)']},
        },
    },
    (8, '-c1'): {
        'IT_number': 8,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'B 1 1 m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)']},
        },
    },
    (8, 'a1'): {
        'IT_number': 8,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'B m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)']},
        },
    },
    (8, '-a1'): {
        'IT_number': 8,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'C m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'b': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)']},
        },
    },
    (9, 'b1'): {
        'IT_number': 9,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'C 1 c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,z+1/2)']}},
    },
    (9, '-b1'): {
        'IT_number': 9,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'A 1 a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x-1/2,-y,z)']}},
    },
    (9, 'c1'): {
        'IT_number': 9,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'A 1 1 a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x+1/2,y,-z)']}},
    },
    (9, '-c1'): {
        'IT_number': 9,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'B 1 1 b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,y-1/2,-z)']}},
    },
    (9, 'a1'): {
        'IT_number': 9,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'B b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y+1/2,z)']}},
    },
    (9, '-a1'): {
        'IT_number': 9,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'C c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {'a': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,z-1/2)']}},
    },
    (10, 'b1'): {
        'IT_number': 10,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (10, '-b1'): {
        'IT_number': 10,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,1/2)', '(-1/2,-y,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,0,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (10, 'c1'): {
        'IT_number': 10,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/2)', '(-x,-y,1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (10, '-c1'): {
        'IT_number': 10,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/2)', '(-x,-y,1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,-1/2,z)', '(1/2,-1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,-1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,-1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,-1/2,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,-1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (10, 'a1'): {
        'IT_number': 10,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (10, '-a1'): {
        'IT_number': 10,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'o': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,-1/2)', '(-x,1/2,-1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,-1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,-1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,-1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,-1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (11, 'b1'): {
        'IT_number': 11,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 21/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x,-y,-z)', '(x,-y+1/2,z)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (11, '-b1'): {
        'IT_number': 11,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 21/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x,-y,-z)', '(x,-y+1/2,z)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,1/2)', '(-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (11, 'c1'): {
        'IT_number': 11,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 21/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(-x,-y,-z)', '(x,y,-z+1/2)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/4)', '(-x,-y,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (11, '-c1'): {
        'IT_number': 11,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 21/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(-x,-y,-z)', '(x,y,-z+1/2)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,1/4)', '(-x,-y,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,-1/2,0)', '(1/2,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,-1/2,0)', '(0,-1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (11, 'a1'): {
        'IT_number': 11,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 21/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(-x,-y,-z)', '(-x+1/2,y,z)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (11, '-a1'): {
        'IT_number': 11,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 21/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(-x,-y,-z)', '(-x+1/2,y,z)'],
            },
            'e': {'multiplicity': 2, 'site_symmetry': 'm', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,-1/2)', '(1/2,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,-1/2)', '(1/2,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (12, 'b1'): {
        'IT_number': 12,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'C 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,1/4,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-b1'): {
        'IT_number': 12,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'A 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,1/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/4,1/4)', '(0,1/4,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(-1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, 'c1'): {
        'IT_number': 12,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'A 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-c1'): {
        'IT_number': 12,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'B 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,-1/2,1/4)', '(3/4,-1/2,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, 'a1'): {
        'IT_number': 12,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'B 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/2,1/4)', '(1/4,1/2,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-a1'): {
        'IT_number': 12,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'C 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,-1/2)', '(1/4,3/4,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, 'b3'): {
        'IT_number': 12,
        'setting': 2,
        'IT_coordinate_system_code': 'b3',
        'name_H-M_alt': 'I 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,1/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(3/4,1/4,3/4)', '(1/4,1/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-b3'): {
        'IT_number': 12,
        'setting': 5,
        'IT_coordinate_system_code': '-b3',
        'name_H-M_alt': 'I 1 2/m 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,-z)', '(x,-y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(-3/4,1/4,1/4)', '(-1/4,1/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(-3/4,1/4,3/4)', '(-1/4,1/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, 'c3'): {
        'IT_number': 12,
        'setting': 8,
        'IT_coordinate_system_code': 'c3',
        'name_H-M_alt': 'I 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(3/4,3/4,1/4)', '(1/4,1/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-c3'): {
        'IT_number': 12,
        'setting': 11,
        'IT_coordinate_system_code': '-c3',
        'name_H-M_alt': 'I 1 1 2/m',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,-y,-z)', '(x,y,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,-3/4,1/4)', '(3/4,-1/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(3/4,-3/4,1/4)', '(1/4,-1/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, 'a3'): {
        'IT_number': 12,
        'setting': 14,
        'IT_coordinate_system_code': 'a3',
        'name_H-M_alt': 'I 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,3/4,1/4)', '(1/4,1/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,3/4,3/4)', '(1/4,1/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (12, '-a3'): {
        'IT_number': 12,
        'setting': 17,
        'IT_coordinate_system_code': '-a3',
        'name_H-M_alt': 'I 2/m 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'j': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,-z)', '(-x,y,z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,-3/4)', '(1/4,3/4,-1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,3/4,-3/4)', '(1/4,1/4,-1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (13, 'b1'): {
        'IT_number': 13,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 2/c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z+1/2)', '(-x,-y,-z)', '(x,-y,z+1/2)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (13, '-b1'): {
        'IT_number': 13,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 2/a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x-1/2,y,-z)', '(-x,-y,-z)', '(x-1/2,-y,z)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(-1/4,y,1/2)', '(-3/4,-y,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(-1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(-1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(-1/2,0,0)']},
        },
    },
    (13, 'c1'): {
        'IT_number': 13,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 2/a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z)', '(-x,-y,-z)', '(x+1/2,y,-z)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/4,1/2,z)', '(3/4,1/2,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (13, '-c1'): {
        'IT_number': 13,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 2/b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y-1/2,z)', '(-x,-y,-z)', '(x,y-1/2,-z)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(1/2,-1/4,z)', '(1/2,-3/4,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/4,z)', '(0,-3/4,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,-1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,-1/2,0)']},
        },
    },
    (13, 'a1'): {
        'IT_number': 13,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 2/b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y+1/2,-z)', '(-x,-y,-z)', '(-x,y+1/2,z)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/4,1/2)', '(-x,3/4,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (13, '-a1'): {
        'IT_number': 13,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 2/c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z-1/2)', '(-x,-y,-z)', '(-x,y,z-1/2)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,1/2,-1/4)', '(-x,1/2,-3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/4)', '(-x,0,-3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,-1/2)']},
        },
    },
    (14, 'b1'): {
        'IT_number': 14,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'P 1 21/c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z+1/2)', '(-x,-y,-z)', '(x,-y+1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (14, '-b1'): {
        'IT_number': 14,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'P 1 21/a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x-1/2,y+1/2,-z)', '(-x,-y,-z)', '(x-1/2,-y+1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,1/2)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(-1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,0)']},
        },
    },
    (14, 'c1'): {
        'IT_number': 14,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'P 1 1 21/a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z+1/2)', '(-x,-y,-z)', '(x+1/2,y,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (14, '-c1'): {
        'IT_number': 14,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'P 1 1 21/b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y-1/2,z+1/2)', '(-x,-y,-z)', '(x,y-1/2,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,-1/2,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,-1/2,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,-1/2,1/2)']},
        },
    },
    (14, 'a1'): {
        'IT_number': 14,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'P 21/b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z)', '(-x,-y,-z)', '(-x+1/2,y+1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (14, '-a1'): {
        'IT_number': 14,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'P 21/c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z-1/2)', '(-x,-y,-z)', '(-x+1/2,y,z-1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,-1/2)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,-1/2)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,-1/2)']},
        },
    },
    (14, 'b2'): {
        'IT_number': 14,
        'setting': 1,
        'IT_coordinate_system_code': 'b2',
        'name_H-M_alt': 'P 1 21/n 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,y+1/2,-z+1/2)', '(-x,-y,-z)', '(x+1/2,-y+1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (14, '-b2'): {
        'IT_number': 14,
        'setting': 4,
        'IT_coordinate_system_code': '-b2',
        'name_H-M_alt': 'P 1 21/n 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x-1/2,y+1/2,-z+1/2)', '(-x,-y,-z)', '(x-1/2,-y+1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(-1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,1/2)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,1/2)']},
        },
    },
    (14, 'c2'): {
        'IT_number': 14,
        'setting': 7,
        'IT_coordinate_system_code': 'c2',
        'name_H-M_alt': 'P 1 1 21/n',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y+1/2,z+1/2)', '(-x,-y,-z)', '(x+1/2,y+1/2,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (14, '-c2'): {
        'IT_number': 14,
        'setting': 10,
        'IT_coordinate_system_code': '-c2',
        'name_H-M_alt': 'P 1 1 21/n',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y-1/2,z+1/2)', '(-x,-y,-z)', '(x+1/2,y-1/2,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,-1/2,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,-1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,-1/2,1/2)']},
        },
    },
    (14, 'a2'): {
        'IT_number': 14,
        'setting': 13,
        'IT_coordinate_system_code': 'a2',
        'name_H-M_alt': 'P 21/n 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z+1/2)', '(-x,-y,-z)', '(-x+1/2,y+1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (14, '-a2'): {
        'IT_number': 14,
        'setting': 16,
        'IT_coordinate_system_code': '-a2',
        'name_H-M_alt': 'P 21/n 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z-1/2)', '(-x,-y,-z)', '(-x+1/2,y+1/2,z-1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,-1/2)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,-1/2)']},
        },
    },
    (14, 'b3'): {
        'IT_number': 14,
        'setting': 2,
        'IT_coordinate_system_code': 'b3',
        'name_H-M_alt': 'P 1 21/a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,y+1/2,-z)', '(-x,-y,-z)', '(x+1/2,-y+1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (14, '-b3'): {
        'IT_number': 14,
        'setting': 5,
        'IT_coordinate_system_code': '-b3',
        'name_H-M_alt': 'P 1 21/c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z+1/2)', '(-x,-y,-z)', '(x,-y+1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,0,1/2)', '(-1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (14, 'c3'): {
        'IT_number': 14,
        'setting': 8,
        'IT_coordinate_system_code': 'c3',
        'name_H-M_alt': 'P 1 1 21/b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y+1/2,z+1/2)', '(-x,-y,-z)', '(x,y+1/2,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (14, '-c3'): {
        'IT_number': 14,
        'setting': 11,
        'IT_coordinate_system_code': '-c3',
        'name_H-M_alt': 'P 1 1 21/a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z+1/2)', '(-x,-y,-z)', '(x+1/2,y,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,-1/2,0)', '(0,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (14, 'a3'): {
        'IT_number': 14,
        'setting': 14,
        'IT_coordinate_system_code': 'a3',
        'name_H-M_alt': 'P 21/c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z+1/2)', '(-x,-y,-z)', '(-x+1/2,y,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (14, '-a3'): {
        'IT_number': 14,
        'setting': 17,
        'IT_coordinate_system_code': '-a3',
        'name_H-M_alt': 'P 21/b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z)', '(-x,-y,-z)', '(-x+1/2,y+1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,-1/2)', '(1/2,0,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (15, 'b1'): {
        'IT_number': 15,
        'setting': 0,
        'IT_coordinate_system_code': 'b1',
        'name_H-M_alt': 'C 1 2/c 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z+1/2)', '(-x,-y,-z)', '(x,-y,z+1/2)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,1/4,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (15, '-b1'): {
        'IT_number': 15,
        'setting': 3,
        'IT_coordinate_system_code': '-b1',
        'name_H-M_alt': 'A 1 2/a 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x-1/2,y,-z)', '(-x,-y,-z)', '(x-1/2,-y,z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(-1/2,1/4,1/4)', '(0,1/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/4,1/4)', '(-1/2,1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(-1/2,0,0)']},
        },
    },
    (15, 'c1'): {
        'IT_number': 15,
        'setting': 6,
        'IT_coordinate_system_code': 'c1',
        'name_H-M_alt': 'A 1 1 2/a',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z)', '(-x,-y,-z)', '(x+1/2,y,-z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,1/4,1/4)', '(0,3/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/4,1/4)', '(1/2,3/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (15, '-c1'): {
        'IT_number': 15,
        'setting': 9,
        'IT_coordinate_system_code': '-c1',
        'name_H-M_alt': 'B 1 1 2/b',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y-1/2,z)', '(-x,-y,-z)', '(x,y-1/2,-z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(0,-1/4,z)', '(0,-3/4,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,-1/2,1/4)', '(3/4,0,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,-1/2,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,1/2)', '(0,-1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,-1/2,0)']},
        },
    },
    (15, 'a1'): {
        'IT_number': 15,
        'setting': 12,
        'IT_coordinate_system_code': 'a1',
        'name_H-M_alt': 'B 2/b 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y+1/2,-z)', '(-x,-y,-z)', '(-x,y+1/2,z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/2,1/4)', '(1/4,0,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,1/2,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (15, '-a1'): {
        'IT_number': 15,
        'setting': 15,
        'IT_coordinate_system_code': '-a1',
        'name_H-M_alt': 'C 2/c 1 1',
        'crystal_system': 'monoclinic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z-1/2)', '(-x,-y,-z)', '(-x,y,z-1/2)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '2', 'coords_xyz': ['(x,0,-1/4)', '(-x,0,-3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,-1/2)', '(1/4,3/4,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,-1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-1', 'coords_xyz': ['(0,0,0)', '(0,0,-1/2)']},
        },
    },
    (16, 'abc'): {
        'IT_number': 16,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,-z)', '(x,-y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (16, 'ba-c'): {
        'IT_number': 16,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,-z)', '(-x,y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,-1/2)', '(-x,1/2,-1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,-1/2)', '(1/2,-y,-1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,-1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,-1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,-1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (16, 'cab'): {
        'IT_number': 16,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,z)', '(-x,y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (16, '-cba'): {
        'IT_number': 16,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,y,-z)', '(-x,-y,z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/2,y,1/2)', '(-1/2,-y,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(-1/2,1/2,z)', '(-1/2,1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (16, 'bca'): {
        'IT_number': 16,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,-y,-z)', '(-x,-y,z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (16, 'a-cb'): {
        'IT_number': 16,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'u': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,z)', '(x,-y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'r': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'q': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,-1/2,z)', '(1/2,-1/2,-z)']},
            'o': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/2,1/2)', '(-x,-1/2,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (17, 'abc'): {
        'IT_number': 17,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P 2 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(-x,y,-z+1/2)', '(x,-y,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)']},
        },
    },
    (17, 'ba-c'): {
        'IT_number': 17,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P 2 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(x,-y,-z-1/2)', '(-x,y,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,-1/4)', '(-x,1/2,-3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,-1/4)', '(-x,0,-3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,-1/2)']},
        },
    },
    (17, 'cab'): {
        'IT_number': 17,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(-x+1/2,-y,z)', '(-x,y,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,1/2,z)', '(3/4,1/2,-z)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,1/2)', '(1/2,-y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)']},
        },
    },
    (17, '-cba'): {
        'IT_number': 17,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(-x-1/2,y,-z)', '(-x,-y,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/4,y,1/2)', '(-3/4,-y,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(-1/2,1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(-1/2,0,-z)']},
        },
    },
    (17, 'bca'): {
        'IT_number': 17,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P 2 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(x,-y+1/2,-z)', '(-x,-y,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,1/2)', '(-x,3/4,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)']},
        },
    },
    (17, 'a-cb'): {
        'IT_number': 17,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P 2 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(-x,-y-1/2,z)', '(x,-y,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,-1/4,z)', '(1/2,-3/4,-z)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2.', 'coords_xyz': ['(0,-1/4,z)', '(0,-3/4,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/2)', '(-x,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,-1/2,0)']},
        },
    },
    (18, 'abc'): {
        'IT_number': 18,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P 21 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y+1/2,-z)', '(x+1/2,-y+1/2,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)']},
        },
    },
    (18, 'ba-c'): {
        'IT_number': 18,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P 21 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y+1/2,-z)', '(-x+1/2,y+1/2,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)']},
        },
    },
    (18, 'cab'): {
        'IT_number': 18,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y+1/2,z+1/2)', '(-x,y+1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(-x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)']},
        },
    },
    (18, '-cba'): {
        'IT_number': 18,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,y+1/2,-z+1/2)', '(-x,-y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(-x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)']},
        },
    },
    (18, 'bca'): {
        'IT_number': 18,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P 21 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,-y,-z+1/2)', '(-x+1/2,-y,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(0,-y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)']},
        },
    },
    (18, 'a-cb'): {
        'IT_number': 18,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P 21 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,-y,z+1/2)', '(x+1/2,-y,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,-y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)']},
        },
    },
    (19, 'abc'): {
        'IT_number': 19,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z+1/2)', '(-x,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,-z)'],
            }
        },
    },
    (19, 'ba-c'): {
        'IT_number': 19,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y+1/2,z-1/2)', '(x+1/2,-y,-z-1/2)', '(-x+1/2,y+1/2,-z)'],
            }
        },
    },
    (19, 'cab'): {
        'IT_number': 19,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z)', '(-x+1/2,-y,z+1/2)', '(-x,y+1/2,-z+1/2)'],
            }
        },
    },
    (19, '-cba'): {
        'IT_number': 19,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z+1/2)', '(-x-1/2,y+1/2,-z)', '(-x,-y+1/2,z+1/2)'],
            }
        },
    },
    (19, 'bca'): {
        'IT_number': 19,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,-z)', '(-x+1/2,-y,z+1/2)'],
            }
        },
    },
    (19, 'a-cb'): {
        'IT_number': 19,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,y-1/2,-z)', '(-x,-y-1/2,z+1/2)', '(x+1/2,-y,-z+1/2)'],
            }
        },
    },
    (20, 'abc'): {
        'IT_number': 20,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C 2 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(-x,y,-z+1/2)', '(x,-y,-z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)']},
        },
    },
    (20, 'ba-c'): {
        'IT_number': 20,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C 2 2 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(x,-y,-z-1/2)', '(-x,y,-z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,-1/4)', '(-x,0,-3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,-1/2)']},
        },
    },
    (20, 'cab'): {
        'IT_number': 20,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A 21 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(-x+1/2,-y,z)', '(-x,y,-z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)']},
        },
    },
    (20, '-cba'): {
        'IT_number': 20,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A 21 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(-x-1/2,y,-z)', '(-x,-y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(-1/2,0,-z)']},
        },
    },
    (20, 'bca'): {
        'IT_number': 20,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B 2 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(x,-y+1/2,-z)', '(-x,-y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)']},
        },
    },
    (20, 'a-cb'): {
        'IT_number': 20,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B 2 21 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(-x,-y-1/2,z)', '(x,-y,-z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,-1/4,z)', '(0,-3/4,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,-1/2,0)']},
        },
    },
    (21, 'abc'): {
        'IT_number': 21,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,-z)', '(x,-y,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (21, 'ba-c'): {
        'IT_number': 21,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,-z)', '(-x,y,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (21, 'cab'): {
        'IT_number': 21,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,z)', '(-x,y,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (21, '-cba'): {
        'IT_number': 21,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,y,-z)', '(-x,-y,z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (21, 'bca'): {
        'IT_number': 21,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,-y,-z)', '(-x,-y,z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (21, 'a-cb'): {
        'IT_number': 21,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,z)', '(x,-y,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, 'abc'): {
        'IT_number': 22,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,-z)', '(x,-y,-z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, 'ba-c'): {
        'IT_number': 22,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,-z)', '(-x,y,-z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(1/4,y,-1/4)', '(3/4,-y,-1/4)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,-1/4)', '(-x,3/4,-1/4)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, 'cab'): {
        'IT_number': 22,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,z)', '(-x,y,-z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, '-cba'): {
        'IT_number': 22,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,y,-z)', '(-x,-y,z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(-1/4,1/4,z)', '(-1/4,3/4,-z)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(-1/4,y,1/4)', '(-1/4,-y,3/4)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-3/4,1/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, 'bca'): {
        'IT_number': 22,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,-y,-z)', '(-x,-y,z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (22, 'a-cb'): {
        'IT_number': 22,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'F 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,z)', '(x,-y,-z)']},
            'j': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/4,1/4)', '(-x,-1/4,3/4)']},
            'i': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,-1/4,z)', '(3/4,-1/4,-z)']},
            'h': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-3/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, 'abc'): {
        'IT_number': 23,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,-z)', '(x,-y,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, 'ba-c'): {
        'IT_number': 23,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,-z)', '(-x,y,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, 'cab'): {
        'IT_number': 23,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,-y,z)', '(-x,y,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, '-cba'): {
        'IT_number': 23,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(-x,y,-z)', '(-x,-y,z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, 'bca'): {
        'IT_number': 23,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,-y,-z)', '(-x,-y,z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (23, 'a-cb'): {
        'IT_number': 23,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I 2 2 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,-y,z)', '(x,-y,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (24, 'abc'): {
        'IT_number': 24,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z+1/2)', '(-x,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z+1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,y,0)', '(1/4,-y,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)']},
        },
    },
    (24, 'ba-c'): {
        'IT_number': 24,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y+1/2,z-1/2)', '(x+1/2,-y,-z-1/2)', '(-x+1/2,y+1/2,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z-1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,1/4,0)', '(-x,1/4,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,-1/4)', '(0,-y+1/2,-3/4)']},
        },
    },
    (24, 'cab'): {
        'IT_number': 24,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z)', '(-x+1/2,-y,z+1/2)', '(-x,y+1/2,-z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,1/4,z)', '(1/2,1/4,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(1/4,y,0)', '(3/4,-y+1/2,0)']},
        },
    },
    (24, '-cba'): {
        'IT_number': 24,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z+1/2)', '(-x-1/2,y+1/2,-z)', '(-x,-y+1/2,z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,0)', '(-x-1/2,3/4,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,1/4)', '(-1/2,-y,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(-1/4,0,z)', '(-3/4,0,-z+1/2)']},
        },
    },
    (24, 'bca'): {
        'IT_number': 24,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,-z)', '(-x+1/2,-y,z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,0)', '(3/4,-y+1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,1/4)', '(-x,1/2,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z+1/2)']},
        },
    },
    (24, 'a-cb'): {
        'IT_number': 24,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I 21 21 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,y-1/2,-z)', '(-x,-y-1/2,z+1/2)', '(x+1/2,-y,-z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/4)', '(0,-y-1/2,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(1/4,0,z)', '(1/4,-1/2,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(x,-1/4,0)', '(-x+1/2,-3/4,0)']},
        },
    },
    (25, 'abc'): {
        'IT_number': 25,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z)', '(-x,y,z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,1/2,z)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (25, 'ba-c'): {
        'IT_number': 25,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z)', '(x,-y,z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,1/2,z)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (25, 'cab'): {
        'IT_number': 25,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z)', '(x,-y,z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,1/2)', '(x,-y,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (25, '-cba'): {
        'IT_number': 25,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z)', '(x,y,-z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(x,-y,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (25, 'bca'): {
        'IT_number': 25,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z)', '(x,y,-z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(-x,y,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (25, 'a-cb'): {
        'IT_number': 25,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {'multiplicity': 4, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z)', '(-x,y,z)']},
            'h': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,1/2)', '(-x,y,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (26, 'abc'): {
        'IT_number': 26,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m c 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(x,-y,z+1/2)', '(-x,y,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z+1/2)']},
        },
    },
    (26, 'ba-c'): {
        'IT_number': 26,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c m 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(-x,y,z-1/2)', '(x,-y,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z-1/2)']},
        },
    },
    (26, 'cab'): {
        'IT_number': 26,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(x+1/2,y,-z)', '(x,-y,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(x+1/2,1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x+1/2,0,-z)']},
        },
    },
    (26, '-cba'): {
        'IT_number': 26,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(x-1/2,-y,z)', '(x,y,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(x-1/2,-y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x-1/2,-y,0)']},
        },
    },
    (26, 'bca'): {
        'IT_number': 26,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b 21 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x,y+1/2,z)', '(x,y,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(-x,y+1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y+1/2,0)']},
        },
    },
    (26, 'a-cb'): {
        'IT_number': 26,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m 21 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(x,y-1/2,-z)', '(-x,y,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,y-1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y-1/2,-z)']},
        },
    },
    (27, 'abc'): {
        'IT_number': 27,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P c c 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z+1/2)', '(-x,y,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,z+1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (27, 'ba-c'): {
        'IT_number': 27,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c c 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z-1/2)', '(x,-y,z-1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,z-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,z-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,z-1/2)']},
        },
    },
    (27, 'cab'): {
        'IT_number': 27,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x+1/2,y,-z)', '(x+1/2,-y,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,1/2)', '(x+1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x+1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x+1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x+1/2,0,0)']},
        },
    },
    (27, '-cba'): {
        'IT_number': 27,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x-1/2,-y,z)', '(x-1/2,y,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,1/2)', '(x-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x-1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x-1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x-1/2,0,0)']},
        },
    },
    (27, 'bca'): {
        'IT_number': 27,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b 2 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y+1/2,z)', '(x,y+1/2,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,y+1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,y+1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y+1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y+1/2,0)']},
        },
    },
    (27, 'a-cb'): {
        'IT_number': 27,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P b 2 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y-1/2,-z)', '(-x,y-1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,y-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,y-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y-1/2,0)']},
        },
    },
    (28, 'abc'): {
        'IT_number': 28,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y,z)', '(-x+1/2,y,z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,0,z)']},
        },
    },
    (28, 'ba-c'): {
        'IT_number': 28,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P b m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y+1/2,z)', '(x,-y+1/2,z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,1/2,z)']},
        },
    },
    (28, 'cab'): {
        'IT_number': 28,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z)', '(x,-y+1/2,z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(x,3/4,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,0)']},
        },
    },
    (28, '-cba'): {
        'IT_number': 28,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(x,-y,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,0,1/2)']},
        },
    },
    (28, 'bca'): {
        'IT_number': 28,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P c 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(-x,y,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y,1/2)']},
        },
    },
    (28, 'a-cb'): {
        'IT_number': 28,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z)', '(-x+1/2,y,z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,0)']},
        },
    },
    (29, 'abc'): {
        'IT_number': 29,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P c a 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(x+1/2,-y,z)', '(-x+1/2,y,z+1/2)'],
            }
        },
    },
    (29, 'ba-c'): {
        'IT_number': 29,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P b c 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(-x,y+1/2,z)', '(x,-y+1/2,z-1/2)'],
            }
        },
    },
    (29, 'cab'): {
        'IT_number': 29,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(x,y+1/2,-z)', '(x+1/2,-y+1/2,z)'],
            }
        },
    },
    (29, '-cba'): {
        'IT_number': 29,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(x,-y,z+1/2)', '(x-1/2,y,-z+1/2)'],
            }
        },
    },
    (29, 'bca'): {
        'IT_number': 29,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P c 21 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x,y,z+1/2)', '(x,y+1/2,-z+1/2)'],
            }
        },
    },
    (29, 'a-cb'): {
        'IT_number': 29,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P b 21 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(x+1/2,y,-z)', '(-x+1/2,y-1/2,z)'],
            }
        },
    },
    (30, 'abc'): {
        'IT_number': 30,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n c 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y+1/2,z+1/2)', '(-x,y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/2)']},
        },
    },
    (30, 'ba-c'): {
        'IT_number': 30,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c n 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y,z-1/2)', '(x+1/2,-y,z-1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,1/2,z-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,0,z-1/2)']},
        },
    },
    (30, 'cab'): {
        'IT_number': 30,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x+1/2,y,-z+1/2)', '(x+1/2,-y,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x+1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x+1/2,0,1/2)']},
        },
    },
    (30, '-cba'): {
        'IT_number': 30,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x-1/2,-y+1/2,z)', '(x-1/2,y+1/2,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x-1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x-1/2,1/2,0)']},
        },
    },
    (30, 'bca'): {
        'IT_number': 30,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b 2 n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y+1/2,z)', '(x+1/2,y+1/2,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y+1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y+1/2,0)']},
        },
    },
    (30, 'a-cb'): {
        'IT_number': 30,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n 2 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y-1/2,-z+1/2)', '(-x,y-1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y-1/2,1/2)']},
        },
    },
    (31, 'abc'): {
        'IT_number': 31,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m n 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y,z+1/2)', '(x+1/2,-y,z+1/2)', '(-x,y,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(1/2,-y,z+1/2)']},
        },
    },
    (31, 'ba-c'): {
        'IT_number': 31,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P n m 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y+1/2,z-1/2)', '(-x,y+1/2,z-1/2)', '(x,-y,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,1/2,z-1/2)']},
        },
    },
    (31, 'cab'): {
        'IT_number': 31,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y+1/2,-z)', '(x+1/2,y+1/2,-z)', '(x,-y,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x+1/2,1/2,-z)']},
        },
    },
    (31, '-cba'): {
        'IT_number': 31,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z+1/2)', '(x-1/2,-y,z+1/2)', '(x,y,-z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x-1/2,-y,1/2)']},
        },
    },
    (31, 'bca'): {
        'IT_number': 31,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P n 21 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z+1/2)', '(-x,y+1/2,z+1/2)', '(x,y,-z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y+1/2,1/2)']},
        },
    },
    (31, 'a-cb'): {
        'IT_number': 31,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m 21 n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,y-1/2,-z)', '(x+1/2,y-1/2,-z)', '(-x,y,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(1/2,y-1/2,-z)']},
        },
    },
    (32, 'abc'): {
        'IT_number': 32,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P b a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y+1/2,z)', '(-x+1/2,y+1/2,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (32, 'ba-c'): {
        'IT_number': 32,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P b a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y+1/2,z)', '(x+1/2,-y+1/2,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (32, 'cab'): {
        'IT_number': 32,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z+1/2)', '(x,-y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (32, '-cba'): {
        'IT_number': 32,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y+1/2,z+1/2)', '(x,y+1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (32, 'bca'): {
        'IT_number': 32,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P c 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y,z+1/2)', '(x+1/2,y,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(0,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (32, 'a-cb'): {
        'IT_number': 32,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P c 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z+1/2)', '(-x+1/2,y,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (33, 'abc'): {
        'IT_number': 33,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n a 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(x+1/2,-y+1/2,z)', '(-x+1/2,y+1/2,z+1/2)'],
            }
        },
    },
    (33, 'ba-c'): {
        'IT_number': 33,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P b n 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(-x+1/2,y+1/2,z)', '(x+1/2,-y+1/2,z-1/2)'],
            }
        },
    },
    (33, 'cab'): {
        'IT_number': 33,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 21 n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(x,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,z+1/2)'],
            }
        },
    },
    (33, '-cba'): {
        'IT_number': 33,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 21 c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(x,-y+1/2,z+1/2)', '(x-1/2,y+1/2,-z+1/2)'],
            }
        },
    },
    (33, 'bca'): {
        'IT_number': 33,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P c 21 n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x+1/2,y,z+1/2)', '(x+1/2,y+1/2,-z+1/2)'],
            }
        },
    },
    (33, 'a-cb'): {
        'IT_number': 33,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n 21 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'a': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(x+1/2,y,-z+1/2)', '(-x+1/2,y-1/2,z+1/2)'],
            }
        },
    },
    (34, 'abc'): {
        'IT_number': 34,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n n 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y+1/2,z+1/2)', '(-x+1/2,y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)']},
        },
    },
    (34, 'ba-c'): {
        'IT_number': 34,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P n n 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y+1/2,z-1/2)', '(x+1/2,-y+1/2,z-1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z-1/2)']},
        },
    },
    (34, 'cab'): {
        'IT_number': 34,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P 2 n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x+1/2,y+1/2,-z+1/2)', '(x+1/2,-y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x+1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x+1/2,1/2,1/2)']},
        },
    },
    (34, '-cba'): {
        'IT_number': 34,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P 2 n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x-1/2,-y+1/2,z+1/2)', '(x-1/2,y+1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x-1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x-1/2,1/2,1/2)']},
        },
    },
    (34, 'bca'): {
        'IT_number': 34,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P n 2 n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y+1/2,z+1/2)', '(x+1/2,y+1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(0,y+1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y+1/2,1/2)']},
        },
    },
    (34, 'a-cb'): {
        'IT_number': 34,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n 2 n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 4,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y-1/2,-z+1/2)', '(-x+1/2,y-1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y-1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y-1/2,1/2)']},
        },
    },
    (35, 'abc'): {
        'IT_number': 35,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z)', '(-x,y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (35, 'ba-c'): {
        'IT_number': 35,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z)', '(x,-y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (35, 'cab'): {
        'IT_number': 35,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z)', '(x,-y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x,1/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (35, '-cba'): {
        'IT_number': 35,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z)', '(x,y,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x,3/4,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (35, 'bca'): {
        'IT_number': 35,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z)', '(x,y,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,y,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (35, 'a-cb'): {
        'IT_number': 35,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z)', '(-x,y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,y,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (36, 'abc'): {
        'IT_number': 36,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m c 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z+1/2)', '(x,-y,z+1/2)', '(-x,y,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z+1/2)']},
        },
    },
    (36, 'ba-c'): {
        'IT_number': 36,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C c m 21',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z-1/2)', '(-x,y,z-1/2)', '(x,-y,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z-1/2)']},
        },
    },
    (36, 'cab'): {
        'IT_number': 36,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A 21 m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x+1/2,-y,-z)', '(x+1/2,y,-z)', '(x,-y,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x+1/2,0,-z)']},
        },
    },
    (36, '-cba'): {
        'IT_number': 36,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A 21 a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x-1/2,-y,-z)', '(x-1/2,-y,z)', '(x,y,-z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x-1/2,-y,0)']},
        },
    },
    (36, 'bca'): {
        'IT_number': 36,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B b 21 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y+1/2,-z)', '(-x,y+1/2,z)', '(x,y,-z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y+1/2,0)']},
        },
    },
    (36, 'a-cb'): {
        'IT_number': 36,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m 21 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y-1/2,-z)', '(x,y-1/2,-z)', '(-x,y,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y-1/2,-z)']},
        },
    },
    (37, 'abc'): {
        'IT_number': 37,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C c c 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z+1/2)', '(-x,y,z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,z+1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (37, 'ba-c'): {
        'IT_number': 37,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C c c 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z-1/2)', '(x,-y,z-1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,z-1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,z-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,0,z-1/2)']},
        },
    },
    (37, 'cab'): {
        'IT_number': 37,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A 2 a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x+1/2,y,-z)', '(x+1/2,-y,z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x+1/2,1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x+1/2,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x+1/2,0,0)']},
        },
    },
    (37, '-cba'): {
        'IT_number': 37,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A 2 a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x-1/2,-y,z)', '(x-1/2,y,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x-1/2,3/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x-1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x-1/2,0,0)']},
        },
    },
    (37, 'bca'): {
        'IT_number': 37,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B b 2 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y+1/2,z)', '(x,y+1/2,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,y+1/2,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y+1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y+1/2,0)']},
        },
    },
    (37, 'a-cb'): {
        'IT_number': 37,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B b 2 b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y-1/2,-z)', '(-x,y-1/2,z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,y-1/2,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(0,y-1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y-1/2,0)']},
        },
    },
    (38, 'abc'): {
        'IT_number': 38,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'A m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z)', '(-x,y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (38, 'ba-c'): {
        'IT_number': 38,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'B m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z)', '(x,-y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (38, 'cab'): {
        'IT_number': 38,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'B 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z)', '(x,-y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (38, '-cba'): {
        'IT_number': 38,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'C 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z)', '(x,y,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(x,-y,1/2)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (38, 'bca'): {
        'IT_number': 38,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'C m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z)', '(x,y,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/2)', '(-x,y,1/2)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (38, 'a-cb'): {
        'IT_number': 38,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'A m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z)', '(-x,y,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (39, 'abc'): {
        'IT_number': 39,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'A e m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y+1/2,z)', '(-x,y+1/2,z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,1/2,z)']},
        },
    },
    (39, 'ba-c'): {
        'IT_number': 39,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'B m e 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y,z)', '(x+1/2,-y,z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,1/2,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,0,z)']},
        },
    },
    (39, 'cab'): {
        'IT_number': 39,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'B 2 e m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z+1/2)', '(x,-y,z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,1/4)', '(x,-y,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,0,1/2)']},
        },
    },
    (39, '-cba'): {
        'IT_number': 39,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'C 2 m e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y+1/2,z)', '(x,y+1/2,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,1/4,z)', '(x,3/4,-z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,0)']},
        },
    },
    (39, 'bca'): {
        'IT_number': 39,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'C m 2 e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y,z)', '(x+1/2,y,-z)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(1/4,y,z)', '(3/4,y,-z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,0)']},
        },
    },
    (39, 'a-cb'): {
        'IT_number': 39,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'A e 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z+1/2)', '(-x,y,z+1/2)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,1/4)', '(-x,y,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(1/2,y,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y,1/2)']},
        },
    },
    (40, 'abc'): {
        'IT_number': 40,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'A m a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y,z)', '(-x+1/2,y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,0,z)']},
        },
    },
    (40, 'ba-c'): {
        'IT_number': 40,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'B b m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y+1/2,z)', '(x,-y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,1/2,z)']},
        },
    },
    (40, 'cab'): {
        'IT_number': 40,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'B 2 m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z)', '(x,-y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(x,3/4,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,0)']},
        },
    },
    (40, '-cba'): {
        'IT_number': 40,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'C 2 c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(x,-y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,0,1/2)']},
        },
    },
    (40, 'bca'): {
        'IT_number': 40,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'C c 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(-x,y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y,1/2)']},
        },
    },
    (40, 'a-cb'): {
        'IT_number': 40,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'A m 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z)', '(-x+1/2,y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,y,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,0)']},
        },
    },
    (41, 'abc'): {
        'IT_number': 41,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'A e a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y+1/2,z)', '(-x+1/2,y+1/2,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (41, 'ba-c'): {
        'IT_number': 41,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'B b e 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y+1/2,z)', '(x+1/2,-y+1/2,z)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (41, 'cab'): {
        'IT_number': 41,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'B 2 e b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z+1/2)', '(x,-y+1/2,z+1/2)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (41, '-cba'): {
        'IT_number': 41,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'C 2 c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y+1/2,z+1/2)', '(x,y+1/2,-z+1/2)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (41, 'bca'): {
        'IT_number': 41,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'C c 2 e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y,z+1/2)', '(x+1/2,y,-z+1/2)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (41, 'a-cb'): {
        'IT_number': 41,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'A e 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z+1/2)', '(-x+1/2,y,z+1/2)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (42, 'abc'): {
        'IT_number': 42,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'F m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z)', '(-x,y,z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (42, 'ba-c'): {
        'IT_number': 42,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'F m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z)', '(x,-y,z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (42, 'cab'): {
        'IT_number': 42,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'F 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z)', '(x,-y,z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x,1/4,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (42, '-cba'): {
        'IT_number': 42,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'F 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z)', '(x,y,-z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/4,1/4)', '(x,3/4,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (42, 'bca'): {
        'IT_number': 42,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'F m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z)', '(x,y,-z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,y,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (42, 'a-cb'): {
        'IT_number': 42,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'F m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 16, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z)', '(-x,y,z)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'c': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'b': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(1/4,y,1/4)', '(1/4,y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (43, 'abc'): {
        'IT_number': 43,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'F d d 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/4,-y+1/4,z+1/4)', '(-x+1/4,y+1/4,z+1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/4,1/4,z+1/4)']},
        },
    },
    (43, 'ba-c'): {
        'IT_number': 43,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'F d d 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/4,y+1/4,z-1/4)', '(x+1/4,-y+1/4,z-1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/4,1/4,z-1/4)']},
        },
    },
    (43, 'cab'): {
        'IT_number': 43,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'F 2 d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x+1/4,y+1/4,-z+1/4)', '(x+1/4,-y+1/4,z+1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x+1/4,1/4,1/4)']},
        },
    },
    (43, '-cba'): {
        'IT_number': 43,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'F 2 d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x-1/4,-y+1/4,z+1/4)', '(x-1/4,y+1/4,-z+1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x-1/4,1/4,1/4)']},
        },
    },
    (43, 'bca'): {
        'IT_number': 43,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'F d 2 d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/4,y+1/4,z+1/4)', '(x+1/4,y+1/4,-z+1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/4,y+1/4,1/4)']},
        },
    },
    (43, 'a-cb'): {
        'IT_number': 43,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'F d 2 d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/4,y-1/4,-z+1/4)', '(-x+1/4,y-1/4,z+1/4)'],
            },
            'a': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/4,y-1/4,1/4)']},
        },
    },
    (44, 'abc'): {
        'IT_number': 44,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x,-y,z)', '(-x,y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (44, 'ba-c'): {
        'IT_number': 44,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I m m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y,z)', '(x,-y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (44, 'cab'): {
        'IT_number': 44,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y,-z)', '(x,-y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (44, '-cba'): {
        'IT_number': 44,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I 2 m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z)', '(x,y,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)']},
        },
    },
    (44, 'bca'): {
        'IT_number': 44,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z)', '(x,y,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (44, 'a-cb'): {
        'IT_number': 44,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I m 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x,y,-z)', '(-x,y,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)']},
        },
    },
    (45, 'abc'): {
        'IT_number': 45,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I b a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y+1/2,z)', '(-x+1/2,y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (45, 'ba-c'): {
        'IT_number': 45,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I b a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x+1/2,y+1/2,z)', '(x+1/2,-y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (45, 'cab'): {
        'IT_number': 45,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I 2 c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z+1/2)', '(x,-y+1/2,z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,1/2)', '(x,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (45, '-cba'): {
        'IT_number': 45,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I 2 c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y+1/2,z+1/2)', '(x,y+1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,1/2,0)', '(x,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,1/2)']},
        },
    },
    (45, 'bca'): {
        'IT_number': 45,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I c 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x+1/2,y,z+1/2)', '(x+1/2,y,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(1/2,y,0)', '(0,y,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (45, 'a-cb'): {
        'IT_number': 45,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I c 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z+1/2)', '(-x+1/2,y,z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,1/2)', '(1/2,y,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,1/2)']},
        },
    },
    (46, 'abc'): {
        'IT_number': 46,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I m a 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(x+1/2,-y,z)', '(-x+1/2,y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,-y,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(1/2,0,z)']},
        },
    },
    (46, 'ba-c'): {
        'IT_number': 46,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I b m 2',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-x,y+1/2,z)', '(x,-y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(-x,3/4,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,0,z)', '(0,1/2,z)']},
        },
    },
    (46, 'cab'): {
        'IT_number': 46,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I 2 m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,y+1/2,-z)', '(x,-y+1/2,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,1/4,z)', '(x,3/4,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,1/2,0)']},
        },
    },
    (46, '-cba'): {
        'IT_number': 46,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I 2 c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(x,-y,-z)', '(x,-y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(x,-y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,0,0)', '(x,0,1/2)']},
        },
    },
    (46, 'bca'): {
        'IT_number': 46,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I c 2 m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(-x,y,z+1/2)', '(x,y,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,1/4)', '(-x,y,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(0,y,1/2)']},
        },
    },
    (46, 'a-cb'): {
        'IT_number': 46,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I m 2 a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,y,-z)', '(x+1/2,y,-z)', '(-x+1/2,y,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(1/4,y,z)', '(3/4,y,-z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(0,y,0)', '(1/2,y,0)']},
        },
    },
    (47, 'abc'): {
        'IT_number': 47,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,1/2)', '(-x,-y,1/2)', '(-x,y,1/2)', '(x,-y,1/2)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,0)', '(x,-y,0)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)', '(-x,1/2,-z)', '(x,1/2,-z)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(-x,0,-z)', '(x,0,-z)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z)', '(1/2,y,-z)', '(1/2,-y,-z)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,y,-z)', '(0,-y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (47, 'ba-c'): {
        'IT_number': 47,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,-1/2)', '(-x,-y,-1/2)', '(x,-y,-1/2)', '(-x,y,-1/2)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,0)', '(-x,y,0)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y,z)', '(1/2,-y,-z)', '(1/2,y,-z)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,-y,-z)', '(0,y,-z)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)', '(x,1/2,-z)', '(-x,1/2,-z)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(x,0,-z)', '(-x,0,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,-1/2)', '(-x,1/2,-1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,-1/2)', '(1/2,-y,-1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,-1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,-1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,-1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,-1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (47, 'cab'): {
        'IT_number': 47,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y,-z)', '(1/2,-y,z)', '(1/2,y,-z)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y,z)', '(0,y,-z)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/2)', '(x,-y,1/2)', '(-x,-y,1/2)', '(-x,y,1/2)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,-y,0)', '(-x,y,0)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z)', '(-x,1/2,z)', '(-x,1/2,-z)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,z)', '(-x,0,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (47, '-cba'): {
        'IT_number': 47,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(-1/2,y,z)', '(-1/2,-y,-z)', '(-1/2,y,-z)', '(-1/2,-y,z)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y,-z)', '(0,-y,z)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z)', '(-x,1/2,-z)', '(-x,1/2,z)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,-z)', '(-x,0,z)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/2)', '(x,-y,1/2)', '(-x,y,1/2)', '(-x,-y,1/2)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,y,0)', '(-x,-y,0)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(-1/2,y,1/2)', '(-1/2,-y,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(-1/2,1/2,z)', '(-1/2,1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (47, 'bca'): {
        'IT_number': 47,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,-z)', '(x,1/2,-z)', '(-x,1/2,z)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,0,-z)', '(-x,0,z)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z)', '(1/2,-y,-z)', '(1/2,-y,z)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,-z)', '(0,-y,z)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/2)', '(-x,y,1/2)', '(x,-y,1/2)', '(-x,-y,1/2)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(x,-y,0)', '(-x,-y,0)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (47, 'a-cb'): {
        'IT_number': 47,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'A': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                ],
            },
            'z': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,-1/2,z)', '(-x,-1/2,-z)', '(-x,-1/2,z)', '(x,-1/2,-z)'],
            },
            'y': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,0,z)', '(x,0,-z)']},
            'x': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/2)', '(-x,y,1/2)', '(-x,-y,1/2)', '(x,-y,1/2)'],
            },
            'w': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(-x,-y,0)', '(x,-y,0)']},
            'v': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z)', '(1/2,-y,z)', '(1/2,-y,-z)'],
            },
            'u': {'multiplicity': 4, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,z)', '(0,-y,-z)']},
            't': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y,1/2)']},
            's': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'r': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'q': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'p': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,-1/2,z)', '(1/2,-1/2,-z)']},
            'o': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'n': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'm': {'multiplicity': 2, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'l': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,-1/2,1/2)', '(-x,-1/2,1/2)']},
            'k': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'j': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,-1/2,1/2)']},
            'g': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,-1/2,1/2)']},
            'f': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,-1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,-1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (48, '1abc'): {
        'IT_number': 48,
        'setting': 6,
        'IT_coordinate_system_code': '1abc',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z+1/2)', '(1/2,0,z+1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)', '(0,-y+1/2,1/2)', '(0,y+1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(-x+1/2,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,3/4,3/4)', '(1/4,1/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (48, '2abc'): {
        'IT_number': 48,
        'setting': 12,
        'IT_coordinate_system_code': '2abc',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,3/4,z)', '(1/4,3/4,-z+1/2)', '(3/4,1/4,-z)', '(3/4,1/4,z+1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(3/4,3/4,z+1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(3/4,y,1/4)', '(3/4,-y+1/2,1/4)', '(1/4,-y,3/4)', '(1/4,y+1/2,3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,1/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,3/4)', '(-x+1/2,1/4,3/4)', '(-x,3/4,1/4)', '(x+1/2,3/4,1/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,1/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,3/4,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(0,0,1/2)', '(0,1/2,0)', '(1/2,0,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,1/4)', '(3/4,1/4,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,3/4,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (48, '1ba-c'): {
        'IT_number': 48,
        'setting': 7,
        'IT_coordinate_system_code': '1ba-c',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y+1/2,-z-1/2)',
                    '(x+1/2,y+1/2,-z-1/2)',
                    '(-x+1/2,y+1/2,z-1/2)',
                    '(x+1/2,-y+1/2,z-1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)', '(0,1/2,-z-1/2)', '(0,1/2,z-1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z-1/2)', '(1/2,1/2,z-1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(-x+1/2,0,-1/2)', '(x+1/2,0,-1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,-1/2)', '(x+1/2,1/2,-1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)', '(1/2,-y+1/2,0)', '(1/2,y+1/2,0)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,-1/2)', '(1/2,y+1/2,-1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,3/4,-3/4)', '(1/4,1/4,-3/4)', '(3/4,1/4,-1/4)', '(1/4,3/4,-1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,3/4,-1/4)', '(1/4,3/4,-3/4)', '(3/4,1/4,-3/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,-1/2)']},
        },
    },
    (48, '2ba-c'): {
        'IT_number': 48,
        'setting': 13,
        'IT_coordinate_system_code': '2ba-c',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(x,-y+1/2,-z-1/2)',
                    '(-x+1/2,y,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x,y+1/2,z-1/2)',
                    '(x+1/2,-y,z-1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,1/4,z)', '(3/4,1/4,-z-1/2)', '(1/4,3/4,-z)', '(1/4,3/4,z-1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z-1/2)', '(3/4,3/4,-z)', '(3/4,3/4,z-1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,3/4,-1/4)', '(-x+1/2,3/4,-1/4)', '(-x,1/4,-3/4)', '(x+1/2,1/4,-3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/4)', '(-x+1/2,1/4,-1/4)', '(-x,3/4,-3/4)', '(x+1/2,3/4,-3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-3/4)', '(1/4,-y+1/2,-3/4)', '(3/4,-y,-1/4)', '(3/4,y+1/2,-1/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-1/4)', '(1/4,-y+1/2,-1/4)', '(3/4,-y,-3/4)', '(3/4,y+1/2,-3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(0,1/2,-1/2)', '(1/2,0,-1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,-1/2)', '(0,0,-1/2)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,-1/4)', '(1/4,3/4,-3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-3/4)', '(3/4,3/4,-1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,-1/4)', '(3/4,1/4,-3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,3/4,-3/4)']},
        },
    },
    (48, '1cab'): {
        'IT_number': 48,
        'setting': 8,
        'IT_coordinate_system_code': '1cab',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(-x+1/2,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z+1/2)', '(1/2,0,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)', '(0,-y+1/2,1/2)', '(0,y+1/2,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,3/4,3/4)', '(3/4,1/4,1/4)', '(1/4,1/4,3/4)', '(1/4,3/4,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (48, '2cab'): {
        'IT_number': 48,
        'setting': 14,
        'IT_coordinate_system_code': '2cab',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,3/4)', '(-x+1/2,1/4,3/4)', '(-x,3/4,1/4)', '(x+1/2,3/4,1/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,1/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,3/4,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,3/4,z)', '(1/4,3/4,-z+1/2)', '(3/4,1/4,-z)', '(3/4,1/4,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(3/4,3/4,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(3/4,y,1/4)', '(3/4,-y+1/2,1/4)', '(1/4,-y,3/4)', '(1/4,y+1/2,3/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,1/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(1/2,0,0)', '(0,0,1/2)', '(0,1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,3/4,1/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,1/4)', '(3/4,1/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (48, '1-cba'): {
        'IT_number': 48,
        'setting': 9,
        'IT_coordinate_system_code': '1-cba',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x-1/2,-y+1/2,-z+1/2)',
                    '(-x-1/2,y+1/2,z+1/2)',
                    '(x-1/2,-y+1/2,z+1/2)',
                    '(x-1/2,y+1/2,-z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(-x-1/2,0,1/2)', '(x-1/2,0,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x-1/2,1/2,1/2)', '(x-1/2,1/2,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)', '(-1/2,-y+1/2,0)', '(-1/2,y+1/2,0)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(-1/2,-y+1/2,1/2)', '(-1/2,y+1/2,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)', '(0,1/2,-z+1/2)', '(0,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(-1/2,1/2,-z+1/2)', '(-1/2,1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-3/4,3/4,3/4)', '(-3/4,1/4,1/4)', '(-1/4,3/4,1/4)', '(-1/4,1/4,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,1/4,1/4)', '(-1/4,3/4,3/4)', '(-3/4,1/4,3/4)', '(-3/4,3/4,1/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(-1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(-1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,1/2)']},
        },
    },
    (48, '2-cba'): {
        'IT_number': 48,
        'setting': 15,
        'IT_coordinate_system_code': '2-cba',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x-1/2,y,-z+1/2)',
                    '(-x-1/2,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x-1/2,-y,z+1/2)',
                    '(x-1/2,y+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,3/4,1/4)', '(-x-1/2,3/4,1/4)', '(-x,1/4,3/4)', '(x-1/2,1/4,3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x-1/2,1/4,1/4)', '(-x,3/4,3/4)', '(x-1/2,3/4,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,3/4)', '(-1/4,-y+1/2,3/4)', '(-3/4,-y,1/4)', '(-3/4,y+1/2,1/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/4)', '(-1/4,-y+1/2,1/4)', '(-3/4,-y,3/4)', '(-3/4,y+1/2,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-3/4,1/4,z)', '(-3/4,1/4,-z+1/2)', '(-1/4,3/4,-z)', '(-1/4,3/4,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,1/4,z)', '(-1/4,1/4,-z+1/2)', '(-3/4,3/4,-z)', '(-3/4,3/4,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(-1/2,0,1/2)', '(-1/2,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,1/2,1/2)', '(-1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,3/4,1/4)', '(-3/4,1/4,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-3/4,1/4,1/4)', '(-1/4,3/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/4,3/4)', '(-3/4,3/4,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/4,1/4)', '(-3/4,3/4,3/4)']},
        },
    },
    (48, '1bca'): {
        'IT_number': 48,
        'setting': 10,
        'IT_coordinate_system_code': '1bca',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)', '(0,-y+1/2,1/2)', '(0,y+1/2,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(-x+1/2,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z+1/2)', '(1/2,0,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,3/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)', '(1/4,1/4,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (48, '2bca'): {
        'IT_number': 48,
        'setting': 16,
        'IT_coordinate_system_code': '2bca',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,y,1/4)', '(3/4,-y+1/2,1/4)', '(1/4,-y,3/4)', '(1/4,y+1/2,3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,1/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,3/4)', '(-x+1/2,1/4,3/4)', '(-x,3/4,1/4)', '(x+1/2,3/4,1/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,1/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,3/4,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,3/4,z)', '(1/4,3/4,-z+1/2)', '(3/4,1/4,-z)', '(3/4,1/4,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(3/4,3/4,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(0,1/2,0)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,1/4)', '(3/4,1/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,3/4,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (48, '2a-cb'): {
        'IT_number': 48,
        'setting': 17,
        'IT_coordinate_system_code': '2a-cb',
        'name_H-M_alt': 'P n n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x+1/2,-y-1/2,z)',
                    '(x,-y-1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(x+1/2,y-1/2,-z)',
                    '(-x,y-1/2,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,3/4)', '(1/4,-y-1/2,3/4)', '(3/4,-y,1/4)', '(3/4,y-1/2,1/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y-1/2,1/4)', '(3/4,-y,3/4)', '(3/4,y-1/2,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(3/4,-1/4,z)', '(3/4,-1/4,-z+1/2)', '(1/4,-3/4,-z)', '(1/4,-3/4,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/4,z)', '(1/4,-1/4,-z+1/2)', '(3/4,-3/4,-z)', '(3/4,-3/4,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-3/4,1/4)', '(-x+1/2,-3/4,1/4)', '(-x,-1/4,3/4)', '(x+1/2,-1/4,3/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,1/4)', '(-x+1/2,-1/4,1/4)', '(-x,-3/4,3/4)', '(x+1/2,-3/4,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(1/2,-1/2,0)', '(0,-1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,-1/2,1/2)', '(0,-1/2,0)', '(0,0,1/2)', '(1/2,0,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/4,3/4)', '(3/4,-3/4,1/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-3/4,1/4)', '(3/4,-1/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,-1/4,1/4)', '(1/4,-3/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/4,1/4)', '(3/4,-3/4,3/4)']},
        },
    },
    (49, 'abc'): {
        'IT_number': 49,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P c c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,1/2)', '(x,-y,1/2)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z+1/2)', '(1/2,0,-z)', '(1/2,0,z+1/2)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z+1/2)', '(0,1/2,-z)', '(0,1/2,z+1/2)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,-z)', '(1/2,1/2,z+1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y,1/4)', '(1/2,-y,3/4)', '(1/2,y,3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y,1/4)', '(0,-y,3/4)', '(0,y,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/2,1/4)', '(-x,1/2,1/4)', '(-x,1/2,3/4)', '(x,1/2,3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x,0,1/4)', '(-x,0,3/4)', '(x,0,3/4)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/4)', '(1/2,0,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (49, 'ba-c'): {
        'IT_number': 49,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z-1/2)',
                    '(-x,y,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z-1/2)',
                    '(x,-y,z-1/2)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,-1/2)', '(-x,y,-1/2)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z-1/2)', '(0,1/2,-z)', '(0,1/2,z-1/2)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z-1/2)', '(1/2,0,-z)', '(1/2,0,z-1/2)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z-1/2)', '(1/2,1/2,-z)', '(1/2,1/2,z-1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z-1/2)', '(0,0,-z)', '(0,0,z-1/2)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,-1/4)', '(-x,1/2,-1/4)', '(-x,1/2,-3/4)', '(x,1/2,-3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x,0,-1/4)', '(-x,0,-3/4)', '(x,0,-3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,-1/4)', '(1/2,-y,-1/4)', '(1/2,-y,-3/4)', '(1/2,y,-3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/4)', '(0,-y,-1/4)', '(0,-y,-3/4)', '(0,y,-3/4)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,-1/4)', '(1/2,1/2,-3/4)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,-1/4)', '(1/2,0,-3/4)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,-1/4)', '(0,1/2,-3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/4)', '(0,0,-3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,0,-1/2)']},
        },
    },
    (49, 'cab'): {
        'IT_number': 49,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P m a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x+1/2,y,-z)',
                    '(x+1/2,-y,z)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(1/2,-y,z)', '(1/2,y,-z)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x+1/2,1/2,0)', '(-x,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x+1/2,0,1/2)', '(-x,0,1/2)', '(x+1/2,0,1/2)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,1/2)', '(-x+1/2,1/2,1/2)', '(-x,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,0,0)', '(-x,0,0)', '(x+1/2,0,0)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/2,z)', '(1/4,1/2,-z)', '(3/4,1/2,-z)', '(3/4,1/2,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z)', '(3/4,0,-z)', '(3/4,0,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,1/2)', '(1/4,-y,1/2)', '(3/4,-y,1/2)', '(3/4,y,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y,0)', '(3/4,-y,0)', '(3/4,y,0)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/2,1/2)', '(3/4,1/2,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (49, '-cba'): {
        'IT_number': 49,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P m a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x-1/2,y,-z)',
                    '(-x-1/2,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x-1/2,-y,z)',
                    '(x-1/2,y,-z)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(-1/2,y,-z)', '(-1/2,-y,z)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x-1/2,0,1/2)', '(-x,0,1/2)', '(x-1/2,0,1/2)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x-1/2,1/2,0)', '(-x,1/2,0)', '(x-1/2,1/2,0)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,1/2)', '(-x-1/2,1/2,1/2)', '(-x,1/2,1/2)', '(x-1/2,1/2,1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x-1/2,0,0)', '(-x,0,0)', '(x-1/2,0,0)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/2)', '(-1/4,-y,1/2)', '(-3/4,-y,1/2)', '(-3/4,y,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-1/4,-y,0)', '(-3/4,-y,0)', '(-3/4,y,0)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,1/2,z)', '(-1/4,1/2,-z)', '(-3/4,1/2,-z)', '(-3/4,1/2,z)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,0,z)', '(-1/4,0,-z)', '(-3/4,0,-z)', '(-3/4,0,z)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/2,1/2)', '(-3/4,1/2,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/2,0)', '(-3/4,1/2,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,0,1/2)', '(-3/4,0,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,0,0)', '(-3/4,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(-1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,1/2)', '(-1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(-1/2,0,0)']},
        },
    },
    (49, 'bca'): {
        'IT_number': 49,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y+1/2,z)',
                    '(x,y+1/2,-z)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,1/2,-z)', '(-x,1/2,z)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(0,-y+1/2,1/2)', '(0,-y,1/2)', '(0,y+1/2,1/2)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y+1/2,0)', '(1/2,-y,0)', '(1/2,y+1/2,0)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y+1/2,1/2)', '(1/2,-y,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y+1/2,0)', '(0,-y,0)', '(0,y+1/2,0)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/2)', '(-x,1/4,1/2)', '(-x,3/4,1/2)', '(x,3/4,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,0)', '(-x,3/4,0)', '(x,3/4,0)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,1/4,z)', '(1/2,1/4,-z)', '(1/2,3/4,-z)', '(1/2,3/4,z)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z)', '(0,3/4,-z)', '(0,3/4,z)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/4,1/2)', '(1/2,3/4,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/4,0)', '(1/2,3/4,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,1/2)', '(0,3/4,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,0)', '(0,3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (49, 'a-cb'): {
        'IT_number': 49,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P b m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y-1/2,z)',
                    '(x,-y-1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y-1/2,-z)',
                    '(-x,y-1/2,z)',
                ],
            },
            'q': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,-1/2,z)', '(x,-1/2,-z)'],
            },
            'p': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y-1/2,0)', '(1/2,-y,0)', '(1/2,y-1/2,0)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(0,-y-1/2,1/2)', '(0,-y,1/2)', '(0,y-1/2,1/2)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,1/2)', '(1/2,-y-1/2,1/2)', '(1/2,-y,1/2)', '(1/2,y-1/2,1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y-1/2,0)', '(0,-y,0)', '(0,y-1/2,0)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,-1/4,z)', '(1/2,-1/4,-z)', '(1/2,-3/4,-z)', '(1/2,-3/4,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(0,-1/4,-z)', '(0,-3/4,-z)', '(0,-3/4,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,1/2)', '(-x,-1/4,1/2)', '(-x,-3/4,1/2)', '(x,-3/4,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,0)', '(-x,-1/4,0)', '(-x,-3/4,0)', '(x,-3/4,0)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/4,1/2)', '(1/2,-3/4,1/2)']},
            'g': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,1/2)', '(0,-3/4,1/2)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/4,0)', '(1/2,-3/4,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,0)', '(0,-3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(0,-1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,-1/2,0)']},
        },
    },
    (50, '1abc'): {
        'IT_number': 50,
        'setting': 6,
        'IT_coordinate_system_code': '1abc',
        'name_H-M_alt': 'P b a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z)', '(1/2,0,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z)', '(1/2,1/2,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)', '(1/2,-y+1/2,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,0)', '(1/2,y+1/2,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(-x+1/2,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)', '(3/4,1/4,1/2)', '(1/4,3/4,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(3/4,1/4,0)', '(1/4,3/4,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (50, '2abc'): {
        'IT_number': 50,
        'setting': 12,
        'IT_coordinate_system_code': '2abc',
        'name_H-M_alt': 'P b a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x+1/2,y,-z)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,z)',
                    '(-x,y+1/2,z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,3/4,z)', '(1/4,3/4,-z)', '(3/4,1/4,-z)', '(3/4,1/4,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z)', '(3/4,3/4,-z)', '(3/4,3/4,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/2)', '(1/4,-y+1/2,1/2)', '(3/4,-y,1/2)', '(3/4,y+1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y+1/2,0)', '(3/4,-y,0)', '(3/4,y+1/2,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/2)', '(-x+1/2,1/4,1/2)', '(-x,3/4,1/2)', '(x+1/2,3/4,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,1/4,0)', '(-x,3/4,0)', '(x+1/2,3/4,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,1/2)', '(1/4,3/4,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)']},
        },
    },
    (50, '1ba-c'): {
        'IT_number': 50,
        'setting': 7,
        'IT_coordinate_system_code': '1ba-c',
        'name_H-M_alt': 'P b a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)', '(0,1/2,-z)', '(0,1/2,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z)', '(1/2,1/2,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)', '(-x+1/2,1/2,-1/2)', '(x+1/2,1/2,-1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,1/2,0)', '(x+1/2,1/2,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)', '(1/2,-y+1/2,-1/2)', '(1/2,y+1/2,-1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,0)', '(1/2,y+1/2,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/2)', '(3/4,3/4,-1/2)', '(1/4,3/4,-1/2)', '(3/4,1/4,-1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(1/4,3/4,0)', '(3/4,1/4,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,-1/2)', '(1/2,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (50, '2ba-c'): {
        'IT_number': 50,
        'setting': 13,
        'IT_coordinate_system_code': '2ba-c',
        'name_H-M_alt': 'P b a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(x,-y+1/2,-z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x,y+1/2,z)',
                    '(x+1/2,-y,z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,1/4,z)', '(3/4,1/4,-z)', '(1/4,3/4,-z)', '(1/4,3/4,z)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z)', '(3/4,3/4,-z)', '(3/4,3/4,z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/2)', '(-x+1/2,1/4,-1/2)', '(-x,3/4,-1/2)', '(x+1/2,3/4,-1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,1/4,0)', '(-x,3/4,0)', '(x+1/2,3/4,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-1/2)', '(1/4,-y+1/2,-1/2)', '(3/4,-y,-1/2)', '(3/4,y+1/2,-1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y+1/2,0)', '(3/4,-y,0)', '(3/4,y+1/2,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)', '(0,1/2,-1/2)', '(1/2,0,-1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-1/2)', '(3/4,3/4,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,-1/2)', '(3/4,1/4,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,0)', '(3/4,1/4,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)']},
        },
    },
    (50, '1cab'): {
        'IT_number': 50,
        'setting': 8,
        'IT_coordinate_system_code': '1cab',
        'name_H-M_alt': 'P n c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y+1/2,-z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(-x,1/2,0)', '(x,1/2,0)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x,1/2,1/2)', '(x,1/2,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,1/2,-z+1/2)', '(0,1/2,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)', '(1/2,-y+1/2,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(0,-y+1/2,1/2)', '(0,y+1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,3/4)', '(1/2,3/4,1/4)', '(1/2,1/4,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)', '(0,3/4,1/4)', '(0,1/4,3/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (50, '2cab'): {
        'IT_number': 50,
        'setting': 14,
        'IT_coordinate_system_code': '2cab',
        'name_H-M_alt': 'P n c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y+1/2,z)',
                    '(-x,y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,y+1/2,-z)',
                    '(x,-y,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,3/4)', '(-x,1/4,3/4)', '(-x,3/4,1/4)', '(x,3/4,1/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,1/4)', '(-x,3/4,3/4)', '(x,3/4,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,1/4,z)', '(1/2,1/4,-z+1/2)', '(1/2,3/4,-z)', '(1/2,3/4,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z+1/2)', '(0,3/4,-z)', '(0,3/4,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y+1/2,1/4)', '(1/2,-y,3/4)', '(1/2,y+1/2,3/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,1/4)', '(0,-y+1/2,1/4)', '(0,-y,3/4)', '(0,y+1/2,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(0,1/2,0)', '(0,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,3/4,1/4)', '(1/2,1/4,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,3/4,1/4)', '(0,1/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)']},
        },
    },
    (50, '1-cba'): {
        'IT_number': 50,
        'setting': 9,
        'IT_coordinate_system_code': '1-cba',
        'name_H-M_alt': 'P n c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y+1/2,-z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(-x,0,1/2)', '(x,0,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x,1/2,1/2)', '(x,1/2,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)', '(-1/2,-y+1/2,1/2)', '(-1/2,y+1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(0,-y+1/2,1/2)', '(0,y+1/2,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)', '(-1/2,1/2,-z+1/2)', '(-1/2,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,1/2,-z+1/2)', '(0,1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,3/4,3/4)', '(-1/2,1/4,3/4)', '(-1/2,3/4,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)', '(0,1/4,3/4)', '(0,3/4,1/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,1/2)', '(-1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (50, '2-cba'): {
        'IT_number': 50,
        'setting': 15,
        'IT_coordinate_system_code': '2-cba',
        'name_H-M_alt': 'P n c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(-x,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,-y,z+1/2)',
                    '(x,y+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,3/4,1/4)', '(-x,3/4,1/4)', '(-x,1/4,3/4)', '(x,1/4,3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,1/4)', '(-x,3/4,3/4)', '(x,3/4,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/2,y,1/4)', '(-1/2,-y+1/2,1/4)', '(-1/2,-y,3/4)', '(-1/2,y+1/2,3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y+1/2,1/4)', '(0,-y,3/4)', '(0,y+1/2,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/2,1/4,z)', '(-1/2,1/4,-z+1/2)', '(-1/2,3/4,-z)', '(-1/2,3/4,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z+1/2)', '(0,3/4,-z)', '(0,3/4,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)', '(-1/2,0,1/2)', '(-1/2,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(0,0,1/2)', '(0,1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,3/4,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,1/4,3/4)', '(-1/2,3/4,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,3/4)', '(0,3/4,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)']},
        },
    },
    (50, '1bca'): {
        'IT_number': 50,
        'setting': 10,
        'IT_coordinate_system_code': '1bca',
        'name_H-M_alt': 'P c n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x+1/2,-y,-z+1/2)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)', '(0,-y,1/2)', '(0,y,1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y,1/2)', '(1/2,y,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(-x+1/2,1/2,1/2)', '(x+1/2,1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,0,1/2)', '(x+1/2,0,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,0,-z+1/2)', '(1/2,0,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/2,1/4)', '(3/4,1/2,3/4)', '(1/4,1/2,3/4)', '(3/4,1/2,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,3/4)', '(1/4,0,3/4)', '(3/4,0,1/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (50, '2bca'): {
        'IT_number': 50,
        'setting': 16,
        'IT_coordinate_system_code': '2bca',
        'name_H-M_alt': 'P c n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(-x+1/2,-y,z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(x+1/2,y,-z)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,y,1/4)', '(3/4,-y,1/4)', '(1/4,-y,3/4)', '(1/4,y,3/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,1/4)', '(3/4,-y,3/4)', '(3/4,y,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/4)', '(-x+1/2,1/2,1/4)', '(-x,1/2,3/4)', '(x+1/2,1/2,3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,1/4)', '(-x,0,3/4)', '(x+1/2,0,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,1/2,z)', '(1/4,1/2,-z+1/2)', '(3/4,1/2,-z)', '(3/4,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z+1/2)', '(3/4,0,-z)', '(3/4,0,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,0,1/2)', '(1/2,0,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/2,1/4)', '(3/4,1/2,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/2,3/4)', '(3/4,1/2,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,3/4)', '(3/4,0,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,3/4)']},
        },
    },
    (50, '2a-cb'): {
        'IT_number': 50,
        'setting': 17,
        'IT_coordinate_system_code': '2a-cb',
        'name_H-M_alt': 'P c n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x+1/2,-y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(x+1/2,y,-z)',
                    '(-x,y,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,3/4)', '(1/4,-y,3/4)', '(3/4,-y,1/4)', '(3/4,y,1/4)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,1/4)', '(3/4,-y,3/4)', '(3/4,y,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/2,z)', '(1/4,-1/2,-z+1/2)', '(3/4,-1/2,-z)', '(3/4,-1/2,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z+1/2)', '(3/4,0,-z)', '(3/4,0,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/2,1/4)', '(-x+1/2,-1/2,1/4)', '(-x,-1/2,3/4)', '(x+1/2,-1/2,3/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,1/4)', '(-x,0,3/4)', '(x+1/2,0,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,1/2)', '(1/2,-1/2,0)', '(0,-1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/2,1/4)', '(3/4,-1/2,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,-1/2,1/4)', '(1/4,-1/2,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(3/4,0,1/4)', '(1/4,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,3/4)']},
        },
    },
    (51, 'abc'): {
        'IT_number': 51,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(x,-y,z)',
                    '(-x+1/2,y,z)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/4,y,z)', '(1/4,-y,z)', '(3/4,y,-z)', '(3/4,-y,-z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(-x+1/2,1/2,z)', '(-x,1/2,-z)', '(x+1/2,1/2,-z)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(-x+1/2,0,z)', '(-x,0,-z)', '(x+1/2,0,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/2)', '(1/2,-y,1/2)', '(0,-y,1/2)', '(1/2,y,1/2)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)', '(0,-y,0)', '(1/2,y,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,1/2,z)', '(3/4,1/2,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (51, 'ba-c'): {
        'IT_number': 51,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P m m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(x,-y,-z)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(-x,y,z)',
                    '(x,-y+1/2,z)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/4,z)', '(-x,1/4,z)', '(x,3/4,-z)', '(-x,3/4,-z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y+1/2,z)', '(1/2,-y,-z)', '(1/2,y+1/2,-z)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(0,-y+1/2,z)', '(0,-y,-z)', '(0,y+1/2,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/2)', '(-x,1/2,-1/2)', '(-x,0,-1/2)', '(x,1/2,-1/2)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,1/2,0)', '(-x,0,0)', '(x,1/2,0)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,1/4,z)', '(1/2,3/4,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,0,-1/2)', '(1/2,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,-1/2)', '(0,1/2,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (51, 'cab'): {
        'IT_number': 51,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x,y,-z)',
                    '(x,-y+1/2,z)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/4,z)', '(x,1/4,-z)', '(-x,3/4,z)', '(-x,3/4,-z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/2)', '(x,-y+1/2,1/2)', '(-x,-y,1/2)', '(-x,y+1/2,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,0)', '(x,-y+1/2,0)', '(-x,-y,0)', '(-x,y+1/2,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,-z)', '(1/2,0,-z)', '(1/2,1/2,z)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)', '(0,0,-z)', '(0,1/2,z)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,1/2)', '(-x,3/4,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (51, '-cba'): {
        'IT_number': 51,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x,-y,z)',
                    '(x,y,-z+1/2)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(x,-y,1/4)', '(-x,y,3/4)', '(-x,-y,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(x,1/2,-z+1/2)', '(-x,1/2,-z)', '(-x,1/2,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(x,0,-z+1/2)', '(-x,0,-z)', '(-x,0,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,1/2)', '(-1/2,-y,0)', '(-1/2,y,1/2)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,y,0)', '(0,-y,1/2)', '(0,-y,0)', '(0,y,1/2)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,1/4)', '(-x,1/2,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/4)', '(-x,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-1/2,1/2,0)', '(-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (51, 'bca'): {
        'IT_number': 51,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P m c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z)',
                    '(x,y,-z+1/2)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(-x,y,1/4)', '(x,-y,3/4)', '(-x,-y,3/4)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/2,y,z)', '(1/2,y,-z+1/2)', '(1/2,-y,-z)', '(1/2,-y,z+1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(0,y,-z+1/2)', '(0,-y,-z)', '(0,-y,z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,1/2)', '(-x,1/2,0)', '(x,1/2,1/2)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)', '(-x,0,0)', '(x,0,1/2)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (51, 'a-cb'): {
        'IT_number': 51,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y,z)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(x,y,-z)',
                    '(-x+1/2,y,z)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/4,y,z)', '(1/4,y,-z)', '(3/4,-y,z)', '(3/4,-y,-z)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/2)', '(-x+1/2,y,1/2)', '(-x,-y,1/2)', '(x+1/2,-y,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,0)', '(-x+1/2,y,0)', '(-x,-y,0)', '(x+1/2,-y,0)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/2,z)', '(1/2,-1/2,-z)', '(0,-1/2,-z)', '(1/2,-1/2,z)'],
            },
            'g': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(0,0,z)', '(1/2,0,-z)', '(0,0,-z)', '(1/2,0,z)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,1/2)', '(3/4,-y,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,0)', '(3/4,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,-1/2,1/2)', '(1/2,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (52, 'abc'): {
        'IT_number': 52,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,3/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,1/4,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(1/4,1/2,-z+1/2)', '(3/4,0,-z)', '(3/4,1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(1/2,1/2,1/2)', '(0,1/2,1/2)'],
            },
        },
    },
    (52, 'ba-c'): {
        'IT_number': 52,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P n n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(x+1/2,-y+1/2,-z-1/2)',
                    '(-x+1/2,y,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(-x+1/2,y+1/2,z-1/2)',
                    '(x+1/2,-y,z-1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-1/4)', '(3/4,-y+1/2,-1/4)', '(3/4,-y,-3/4)', '(1/4,y+1/2,-3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(1/2,1/4,-z-1/2)', '(0,3/4,-z)', '(1/2,3/4,z-1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(0,1/2,-1/2)', '(1/2,1/2,0)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(1/2,1/2,-1/2)', '(1/2,0,-1/2)'],
            },
        },
    },
    (52, 'cab'): {
        'IT_number': 52,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,3/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,1/4,1/2)', '(-x,3/4,0)', '(x+1/2,3/4,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)', '(0,1/2,1/2)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(1/2,1/2,1/2)', '(1/2,0,1/2)'],
            },
        },
    },
    (52, '-cba'): {
        'IT_number': 52,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x-1/2,y+1/2,-z+1/2)',
                    '(-x-1/2,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x-1/2,-y+1/2,z+1/2)',
                    '(x-1/2,y+1/2,-z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,1/4,z)', '(-1/4,3/4,-z+1/2)', '(-3/4,3/4,-z)', '(-3/4,1/4,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x-1/2,1/2,1/4)', '(-x,0,3/4)', '(x-1/2,1/2,3/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(-1/2,0,1/2)', '(0,1/2,1/2)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(-1/2,1/2,1/2)', '(-1/2,1/2,0)'],
            },
        },
    },
    (52, 'bca'): {
        'IT_number': 52,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P n c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,3/4,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y+1/2,1/4)', '(0,-y,3/4)', '(1/2,y+1/2,3/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (52, 'a-cb'): {
        'IT_number': 52,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x+1/2,-y-1/2,z+1/2)',
                    '(x,-y-1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(x+1/2,y-1/2,-z+1/2)',
                    '(-x,y-1/2,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,1/4)', '(-x+1/2,-1/4,3/4)', '(-x,-3/4,3/4)', '(x+1/2,-3/4,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y-1/2,1/2)', '(3/4,-y,0)', '(3/4,y-1/2,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,0)', '(1/2,0,1/2)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(1/2,-1/2,1/2)', '(0,-1/2,1/2)'],
            },
        },
    },
    (53, 'abc'): {
        'IT_number': 53,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P m n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(1/2,-y,z+1/2)', '(1/2,y,-z+1/2)', '(0,-y,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)', '(3/4,-y,3/4)', '(3/4,y,1/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/2,0)', '(-x+1/2,1/2,1/2)', '(-x,1/2,0)', '(x+1/2,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,0,1/2)', '(-x,0,0)', '(x+1/2,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,1/2,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (53, 'ba-c'): {
        'IT_number': 53,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P n m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z-1/2)',
                    '(x,-y+1/2,-z-1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z-1/2)',
                    '(-x,y+1/2,z-1/2)',
                    '(x,-y,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x,1/2,z-1/2)', '(x,1/2,-z-1/2)', '(-x,0,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/4)', '(-x,1/4,-3/4)', '(-x,3/4,-3/4)', '(x,3/4,-1/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y+1/2,-1/2)', '(1/2,-y,0)', '(1/2,y+1/2,-1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y+1/2,-1/2)', '(0,-y,0)', '(0,y+1/2,-1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,0,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(0,0,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,-1/2)']},
        },
    },
    (53, 'cab'): {
        'IT_number': 53,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x,-y,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x+1/2,1/2,-z)', '(-x+1/2,1/2,z)', '(-x,0,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)', '(3/4,3/4,-z)', '(1/4,3/4,z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,1/2)', '(1/2,-y+1/2,1/2)', '(0,-y,1/2)', '(1/2,y+1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(1/2,-y+1/2,0)', '(0,-y,0)', '(1/2,y+1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (53, '-cba'): {
        'IT_number': 53,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z+1/2)',
                    '(-x-1/2,y,-z+1/2)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z+1/2)',
                    '(x-1/2,-y,z+1/2)',
                    '(x,y,-z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x-1/2,-y,1/2)', '(-x-1/2,y,1/2)', '(-x,-y,0)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/4)', '(-3/4,-y,1/4)', '(-3/4,-y,3/4)', '(-1/4,y,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(-1/2,1/2,-z+1/2)', '(0,1/2,-z)', '(-1/2,1/2,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(-1/2,0,-z+1/2)', '(0,0,-z)', '(-1/2,0,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,1/2)', '(-1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(-1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(-1/2,0,1/2)']},
        },
    },
    (53, 'bca'): {
        'IT_number': 53,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P n c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,y,-z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x,y+1/2,1/2)', '(x,-y+1/2,1/2)', '(-x,-y,0)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(-x,3/4,3/4)', '(x,1/4,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,0,z)', '(1/2,1/2,-z+1/2)', '(1/2,0,-z)', '(1/2,1/2,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,1/2,-z+1/2)', '(0,0,-z)', '(0,1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (53, 'a-cb'): {
        'IT_number': 53,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P m a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y-1/2,-z)',
                    '(-x+1/2,-y-1/2,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y-1/2,z)',
                    '(x+1/2,y-1/2,-z)',
                    '(-x,y,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(1/2,y-1/2,-z)', '(1/2,-y-1/2,z)', '(0,-y,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/4,z)', '(1/4,-3/4,-z)', '(3/4,-3/4,-z)', '(3/4,-1/4,z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/2)', '(-x+1/2,-1/2,1/2)', '(-x,0,1/2)', '(x+1/2,-1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,-1/2,0)', '(-x,0,0)', '(x+1/2,-1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,-1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,1/2)', '(0,-1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(0,-1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,-1/2,0)']},
        },
    },
    (54, 'abc'): {
        'IT_number': 54,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P c c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(-x,y,-z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/2,z)', '(3/4,1/2,-z+1/2)', '(3/4,1/2,-z)', '(1/4,1/2,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z+1/2)', '(3/4,0,-z)', '(1/4,0,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y,1/4)', '(0,-y,3/4)', '(1/2,y,3/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)', '(0,1/2,1/2)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(0,0,1/2)', '(1/2,0,1/2)'],
            },
        },
    },
    (54, 'ba-c'): {
        'IT_number': 54,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(x,-y,-z-1/2)',
                    '(-x,y+1/2,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(-x,y,z-1/2)',
                    '(x,-y+1/2,z-1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,1/4,z)', '(1/2,3/4,-z-1/2)', '(1/2,3/4,-z)', '(1/2,1/4,z-1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z-1/2)', '(0,3/4,-z)', '(0,1/4,z-1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x,1/2,-1/4)', '(-x,0,-3/4)', '(x,1/2,-3/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)', '(1/2,0,-1/2)', '(1/2,1/2,-1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(0,0,-1/2)', '(0,1/2,-1/2)'],
            },
        },
    },
    (54, 'cab'): {
        'IT_number': 54,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x+1/2,y,-z)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/2)', '(-x+1/2,3/4,1/2)', '(-x,3/4,1/2)', '(x+1/2,1/4,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,3/4,0)', '(-x,3/4,0)', '(x+1/2,1/4,0)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,1/2,-z)', '(3/4,0,-z)', '(3/4,1/2,z)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(1/2,0,0)', '(1/2,1/2,0)'],
            },
        },
    },
    (54, '-cba'): {
        'IT_number': 54,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x-1/2,y,-z)',
                    '(-x-1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x-1/2,-y,z)',
                    '(x-1/2,y,-z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,1/4)', '(-x-1/2,1/2,3/4)', '(-x,1/2,3/4)', '(x-1/2,1/2,1/4)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x-1/2,0,3/4)', '(-x,0,3/4)', '(x-1/2,0,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-1/4,-y,1/2)', '(-3/4,-y,0)', '(-3/4,y,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)', '(-1/2,1/2,0)', '(-1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(-1/2,0,0)', '(-1/2,0,1/2)'],
            },
        },
    },
    (54, 'bca'): {
        'IT_number': 54,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y+1/2,3/4)', '(1/2,-y,3/4)', '(1/2,y+1/2,1/4)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(0,-y+1/2,3/4)', '(0,-y,3/4)', '(0,y+1/2,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,1/2)', '(-x,3/4,0)', '(x,3/4,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(0,1/2,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (54, 'a-cb'): {
        'IT_number': 54,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P b a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y-1/2,z)',
                    '(x+1/2,-y-1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(x,y-1/2,-z)',
                    '(-x+1/2,y-1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/2)', '(3/4,-y-1/2,1/2)', '(3/4,-y,1/2)', '(1/4,y-1/2,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y-1/2,0)', '(3/4,-y,0)', '(1/4,y-1/2,0)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(1/2,-1/4,-z)', '(0,-3/4,-z)', '(1/2,-3/4,z)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)', '(0,-1/2,1/2)', '(1/2,-1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(0,-1/2,0)', '(1/2,-1/2,0)'],
            },
        },
    },
    (55, 'abc'): {
        'IT_number': 55,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P b a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,1/2)', '(-x,-y,1/2)', '(-x+1/2,y+1/2,1/2)', '(x+1/2,-y+1/2,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x+1/2,y+1/2,0)', '(x+1/2,-y+1/2,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,-z)', '(1/2,0,z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (55, 'ba-c'): {
        'IT_number': 55,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P b a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,-1/2)', '(-x,-y,-1/2)', '(x+1/2,-y+1/2,-1/2)', '(-x+1/2,y+1/2,-1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x+1/2,-y+1/2,0)', '(-x+1/2,y+1/2,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)', '(0,1/2,z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,-1/2)', '(0,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (55, 'cab'): {
        'IT_number': 55,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P m c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y,-z)', '(1/2,-y+1/2,z+1/2)', '(1/2,y+1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y+1/2,z+1/2)', '(0,y+1/2,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x,1/2,0)', '(-x,0,1/2)', '(x,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)', '(-x,0,0)', '(x,1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,1/2)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (55, '-cba'): {
        'IT_number': 55,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P m c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y+1/2,z+1/2)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(-1/2,y,z)', '(-1/2,-y,-z)', '(-1/2,y+1/2,-z+1/2)', '(-1/2,-y+1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y+1/2,-z+1/2)', '(0,-y+1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x,0,1/2)', '(-x,1/2,0)', '(x,0,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)', '(-x,0,0)', '(x,1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(-1/2,1/2,0)', '(-1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (55, 'bca'): {
        'IT_number': 55,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P c m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x+1/2,y,z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,-z)', '(x+1/2,1/2,-z+1/2)', '(-x+1/2,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x+1/2,0,-z+1/2)', '(-x+1/2,0,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(0,-y,1/2)', '(1/2,-y,0)', '(0,y,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)', '(0,-y,0)', '(1/2,y,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,1/2,0)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (55, 'a-cb'): {
        'IT_number': 55,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P c m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,-1/2,z)', '(-x,-1/2,-z)', '(-x+1/2,-1/2,z+1/2)', '(x+1/2,-1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x+1/2,0,z+1/2)', '(x+1/2,0,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(1/2,-y,0)', '(0,-y,1/2)', '(1/2,y,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)', '(0,-y,0)', '(1/2,y,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,-1/2,1/2)', '(1/2,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (56, 'abc'): {
        'IT_number': 56,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P c c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,3/4,z)', '(3/4,1/4,-z+1/2)', '(3/4,1/4,-z)', '(1/4,3/4,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,1/4,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(0,1/2,0)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)'],
            },
        },
    },
    (56, 'ba-c'): {
        'IT_number': 56,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(x+1/2,-y,-z-1/2)',
                    '(-x,y+1/2,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x+1/2,y,z-1/2)',
                    '(x,-y+1/2,z-1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,-z-1/2)', '(1/4,3/4,-z)', '(3/4,1/4,z-1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z-1/2)', '(3/4,3/4,-z)', '(1/4,1/4,z-1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,-1/2)', '(0,1/2,-1/2)'],
            },
        },
    },
    (56, 'cab'): {
        'IT_number': 56,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P n a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,3/4)', '(-x+1/2,3/4,1/4)', '(-x,3/4,1/4)', '(x+1/2,1/4,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,3/4,3/4)', '(-x,3/4,3/4)', '(x+1/2,1/4,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)', '(0,0,1/2)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (56, '-cba'): {
        'IT_number': 56,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P n a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x-1/2,y+1/2,-z)',
                    '(-x-1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x-1/2,-y+1/2,z)',
                    '(x-1/2,y,-z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,3/4,1/4)', '(-x-1/2,1/4,3/4)', '(-x,1/4,3/4)', '(x-1/2,3/4,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x-1/2,3/4,3/4)', '(-x,3/4,3/4)', '(x-1/2,1/4,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)', '(0,1/2,0)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(-1/2,1/2,0)', '(-1/2,0,1/2)'],
            },
        },
    },
    (56, 'bca'): {
        'IT_number': 56,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(3/4,y,1/4)', '(1/4,-y+1/2,3/4)', '(1/4,-y,3/4)', '(3/4,y+1/2,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y+1/2,3/4)', '(3/4,-y,3/4)', '(1/4,y+1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (56, 'a-cb'): {
        'IT_number': 56,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P b n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x,-y-1/2,z+1/2)',
                    '(x+1/2,-y-1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(x,y-1/2,-z+1/2)',
                    '(-x+1/2,y-1/2,z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,3/4)', '(3/4,-y-1/2,1/4)', '(3/4,-y,1/4)', '(1/4,y-1/2,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y-1/2,3/4)', '(3/4,-y,3/4)', '(1/4,y-1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,1/2)', '(0,0,1/2)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,-1/2,1/2)', '(1/2,-1/2,0)'],
            },
        },
    },
    (57, 'abc'): {
        'IT_number': 57,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P b c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,1/4)', '(-x,-y,3/4)', '(-x,y+1/2,1/4)', '(x,-y+1/2,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,0)', '(-x,3/4,1/2)', '(-x,3/4,0)', '(x,1/4,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)', '(1/2,1/2,1/2)', '(1/2,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(0,1/2,1/2)', '(0,1/2,0)'],
            },
        },
    },
    (57, 'ba-c'): {
        'IT_number': 57,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z-1/2)',
                    '(x+1/2,-y,-z-1/2)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z-1/2)',
                    '(-x+1/2,y,z-1/2)',
                    '(x+1/2,-y,z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,-1/4)', '(-x,-y,-3/4)', '(x+1/2,-y,-1/4)', '(-x+1/2,y,-3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y,-1/2)', '(3/4,-y,0)', '(1/4,y,-1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,-1/2)', '(1/2,1/2,-1/2)', '(1/2,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,-1/2)', '(1/2,0,-1/2)', '(1/2,0,0)'],
            },
        },
    },
    (57, 'cab'): {
        'IT_number': 57,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P m c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(1/4,y,z)', '(3/4,-y,-z)', '(1/4,-y,z+1/2)', '(3/4,y,-z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y,3/4)', '(0,-y,3/4)', '(1/2,y,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)', '(1/2,1/2,1/2)', '(0,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(1/2,0,1/2)', '(0,0,1/2)'],
            },
        },
    },
    (57, '-cba'): {
        'IT_number': 57,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P m a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z)',
                    '(-x-1/2,y+1/2,-z)',
                    '(-x,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z)',
                    '(x-1/2,-y+1/2,z)',
                    '(x,y+1/2,-z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(-1/4,y,z)', '(-3/4,-y,-z)', '(-1/4,y+1/2,-z)', '(-3/4,-y+1/2,z)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(-1/2,3/4,-z)', '(0,3/4,-z)', '(-1/2,1/4,z)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(-1/2,0,1/2)', '(-1/2,1/2,1/2)', '(0,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(-1/2,0,0)', '(-1/2,1/2,0)', '(0,1/2,0)'],
            },
        },
    },
    (57, 'bca'): {
        'IT_number': 57,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,1/4,z)', '(-x,3/4,-z)', '(x+1/2,1/4,-z)', '(-x+1/2,3/4,z)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,0,z)', '(3/4,1/2,-z)', '(3/4,0,-z)', '(1/4,1/2,z)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)', '(1/2,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(1/2,1/2,0)', '(1/2,0,0)'],
            },
        },
    },
    (57, 'a-cb'): {
        'IT_number': 57,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P c m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y-1/2,-z)',
                    '(-x,-y-1/2,z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y-1/2,z)',
                    '(x,y-1/2,-z+1/2)',
                    '(-x,y,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,-1/4,z)', '(-x,-3/4,-z)', '(-x,-1/4,z+1/2)', '(x,-3/4,-z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x,-1/2,3/4)', '(-x,0,3/4)', '(x,-1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,-1/2,0)', '(1/2,-1/2,1/2)', '(1/2,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,-1/2,0)', '(0,-1/2,1/2)', '(0,0,1/2)'],
            },
        },
    },
    (58, 'abc'): {
        'IT_number': 58,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x+1/2,y+1/2,1/2)', '(x+1/2,-y+1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z+1/2)', '(0,1/2,-z)', '(1/2,0,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z+1/2)', '(0,0,-z)', '(1/2,1/2,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (58, 'ba-c'): {
        'IT_number': 58,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P n n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x+1/2,-y+1/2,-z-1/2)',
                    '(-x+1/2,y+1/2,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x+1/2,y+1/2,z-1/2)',
                    '(x+1/2,-y+1/2,z-1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x+1/2,-y+1/2,-1/2)', '(-x+1/2,y+1/2,-1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,-z-1/2)', '(1/2,0,-z)', '(0,1/2,z-1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z-1/2)', '(0,0,-z)', '(1/2,1/2,z-1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,-1/2)', '(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,-1/2)']},
        },
    },
    (58, 'cab'): {
        'IT_number': 58,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P m n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(1/2,-y+1/2,z+1/2)', '(1/2,y+1/2,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x+1/2,1/2,0)', '(-x,0,1/2)', '(x+1/2,1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,1/2,1/2)', '(-x,0,0)', '(x+1/2,1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (58, '-cba'): {
        'IT_number': 58,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P m n n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x-1/2,y+1/2,-z+1/2)',
                    '(-x-1/2,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x-1/2,-y+1/2,z+1/2)',
                    '(x-1/2,y+1/2,-z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(-1/2,y+1/2,-z+1/2)', '(-1/2,-y+1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x-1/2,0,1/2)', '(-x,1/2,0)', '(x-1/2,0,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x-1/2,1/2,1/2)', '(-x,0,0)', '(x-1/2,1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(-1/2,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(-1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(-1/2,0,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,1/2)']},
        },
    },
    (58, 'bca'): {
        'IT_number': 58,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P n m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x+1/2,1/2,-z+1/2)', '(-x+1/2,1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(0,-y+1/2,1/2)', '(1/2,-y,0)', '(0,y+1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y+1/2,1/2)', '(0,-y,0)', '(1/2,y+1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (58, 'a-cb'): {
        'IT_number': 58,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y-1/2,z+1/2)',
                    '(x+1/2,-y-1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x+1/2,y-1/2,-z+1/2)',
                    '(-x+1/2,y-1/2,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x+1/2,-1/2,z+1/2)', '(x+1/2,-1/2,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(1/2,-y-1/2,0)', '(0,-y,1/2)', '(1/2,y-1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y-1/2,1/2)', '(0,-y,0)', '(1/2,y-1/2,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,-1/2,1/2)', '(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,-1/2,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,-1/2,1/2)']},
        },
    },
    (59, '1abc'): {
        'IT_number': 59,
        'setting': 6,
        'IT_coordinate_system_code': '1abc',
        'name_H-M_alt': 'P m m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(-x+1/2,1/2,-z)', '(x+1/2,1/2,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(1/2,y+1/2,-z)', '(1/2,-y+1/2,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)', '(1/4,3/4,1/2)', '(3/4,1/4,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(1/4,3/4,0)', '(3/4,1/4,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)']},
        },
    },
    (59, '2abc'): {
        'IT_number': 59,
        'setting': 12,
        'IT_coordinate_system_code': '2abc',
        'name_H-M_alt': 'P m m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,y+1/2,-z)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x,-y+1/2,z)',
                    '(-x+1/2,y,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(-x+1/2,1/4,z)', '(-x,3/4,-z)', '(x+1/2,3/4,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/4,y,z)', '(1/4,-y+1/2,z)', '(3/4,y+1/2,-z)', '(3/4,-y,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(0,1/2,1/2)', '(1/2,0,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,3/4,z)', '(3/4,1/4,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z)']},
        },
    },
    (59, '1ba-c'): {
        'IT_number': 59,
        'setting': 7,
        'IT_coordinate_system_code': '1ba-c',
        'name_H-M_alt': 'P m m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(1/2,-y+1/2,-z)', '(1/2,y+1/2,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(x+1/2,1/2,-z)', '(-x+1/2,1/2,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/2)', '(3/4,3/4,-1/2)', '(3/4,1/4,-1/2)', '(1/4,3/4,-1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(3/4,1/4,0)', '(1/4,3/4,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)']},
        },
    },
    (59, '2ba-c'): {
        'IT_number': 59,
        'setting': 13,
        'IT_coordinate_system_code': '2ba-c',
        'name_H-M_alt': 'P m m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(x+1/2,-y,-z)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(-x+1/2,y,z)',
                    '(x,-y+1/2,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,-y+1/2,z)', '(3/4,-y,-z)', '(3/4,y+1/2,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/4,z)', '(-x+1/2,1/4,z)', '(x+1/2,3/4,-z)', '(-x,3/4,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(1/2,1/2,-1/2)', '(1/2,0,-1/2)', '(0,1/2,-1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,-z)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z)']},
        },
    },
    (59, '1cab'): {
        'IT_number': 59,
        'setting': 8,
        'IT_coordinate_system_code': '1cab',
        'name_H-M_alt': 'P n m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y+1/2,-z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,-y+1/2,1/2)', '(-x,y+1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,1/2,z+1/2)', '(-x,1/2,-z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,3/4)', '(1/2,1/4,3/4)', '(1/2,3/4,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)', '(0,1/4,3/4)', '(0,3/4,1/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)', '(-x,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)']},
        },
    },
    (59, '2cab'): {
        'IT_number': 59,
        'setting': 14,
        'IT_coordinate_system_code': '2cab',
        'name_H-M_alt': 'P n m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(x,-y+1/2,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(x,-y+1/2,1/4)', '(-x,-y,3/4)', '(-x,y+1/2,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,1/4,z)', '(x,1/4,-z+1/2)', '(-x,3/4,z+1/2)', '(-x,3/4,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(0,0,1/2)', '(0,1/2,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,3/4)', '(-x,3/4,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,3/4)']},
        },
    },
    (59, '1-cba'): {
        'IT_number': 59,
        'setting': 9,
        'IT_coordinate_system_code': '1-cba',
        'name_H-M_alt': 'P n m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y+1/2,-z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,1/2,-z+1/2)', '(-x,1/2,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,y+1/2,1/2)', '(-x,-y+1/2,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,3/4,3/4)', '(-1/2,3/4,1/4)', '(-1/2,1/4,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)', '(0,3/4,1/4)', '(0,1/4,3/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)', '(-x,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)']},
        },
    },
    (59, '2-cba'): {
        'IT_number': 59,
        'setting': 15,
        'IT_coordinate_system_code': '2-cba',
        'name_H-M_alt': 'P n m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z+1/2)',
                    '(x,-y+1/2,z)',
                    '(x,y,-z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(x,1/4,-z+1/2)', '(-x,3/4,-z)', '(-x,3/4,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(x,-y+1/2,1/4)', '(-x,y+1/2,3/4)', '(-x,-y,3/4)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,1/2)', '(-1/2,1/2,0)', '(-1/2,0,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(0,1/2,0)', '(0,0,1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,3/4,1/4)', '(-x,1/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,3/4)']},
        },
    },
    (59, '1bca'): {
        'IT_number': 59,
        'setting': 10,
        'IT_coordinate_system_code': '1bca',
        'name_H-M_alt': 'P m n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x+1/2,-y,-z+1/2)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(1/2,-y,-z+1/2)', '(1/2,-y,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(x+1/2,-y,1/2)', '(-x+1/2,-y,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/2,1/4)', '(3/4,1/2,3/4)', '(3/4,1/2,1/4)', '(1/4,1/2,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,3/4)', '(3/4,0,1/4)', '(1/4,0,3/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)', '(0,-y,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)']},
        },
    },
    (59, '2bca'): {
        'IT_number': 59,
        'setting': 16,
        'IT_coordinate_system_code': '2bca',
        'name_H-M_alt': 'P m n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x+1/2,y,z)',
                    '(x,y,-z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,y,-z+1/2)', '(3/4,-y,-z)', '(3/4,-y,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(-x+1/2,y,1/4)', '(x+1/2,-y,3/4)', '(-x,-y,3/4)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)', '(1/2,1/2,0)', '(0,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(3/4,y,1/4)', '(1/4,-y,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,3/4)']},
        },
    },
    (59, '2a-cb'): {
        'IT_number': 59,
        'setting': 17,
        'IT_coordinate_system_code': '2a-cb',
        'name_H-M_alt': 'P m n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(-x+1/2,y,z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(-x+1/2,y,1/4)', '(-x,-y,3/4)', '(x+1/2,-y,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': 'm..',
                'coords_xyz': ['(1/4,y,z)', '(1/4,y,-z+1/2)', '(3/4,-y,z+1/2)', '(3/4,-y,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,-1/2,1/2)', '(0,-1/2,1/2)', '(1/2,-1/2,0)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,0,1/2)', '(1/2,0,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,3/4)', '(3/4,-y,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,3/4)']},
        },
    },
    (60, 'abc'): {
        'IT_number': 60,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P b c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x,-y,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y+1/2,3/4)', '(0,-y,3/4)', '(1/2,y+1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)', '(0,0,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (60, 'ba-c'): {
        'IT_number': 60,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c a n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z-1/2)',
                    '(x,-y,-z-1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z-1/2)',
                    '(-x,y,z-1/2)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x+1/2,1/2,-3/4)', '(-x,0,-3/4)', '(x+1/2,1/2,-1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,-1/2)', '(1/2,0,-1/2)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,-1/2)', '(0,0,-1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (60, 'cab'): {
        'IT_number': 60,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P n c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-x+1/2,-y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(x+1/2,y,-z)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(3/4,1/2,-z+1/2)', '(3/4,0,-z)', '(1/4,1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)', '(1/2,0,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (60, '-cba'): {
        'IT_number': 60,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P n a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y+1/2,-z+1/2)',
                    '(-x-1/2,y,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y+1/2,z+1/2)',
                    '(x-1/2,-y,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y+1/2,1/2)', '(-3/4,-y,0)', '(-1/4,y+1/2,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(-1/2,0,1/2)', '(-1/2,1/2,0)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(-1/2,1/2,1/2)', '(-1/2,0,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (60, 'bca'): {
        'IT_number': 60,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b n a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x,-y+1/2,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,3/4,1/2)', '(-x,3/4,0)', '(x+1/2,1/4,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/2)', '(1/2,1/2,0)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)', '(0,1/2,0)', '(1/2,0,1/2)'],
            },
        },
    },
    (60, 'a-cb'): {
        'IT_number': 60,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P c n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y-1/2,-z+1/2)',
                    '(-x,-y-1/2,z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y-1/2,z+1/2)',
                    '(x,y-1/2,-z)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(1/2,-3/4,-z+1/2)', '(0,-3/4,-z)', '(1/2,-1/4,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,-1/2,0)', '(0,-1/2,1/2)', '(1/2,0,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,-1/2,1/2)', '(0,-1/2,0)', '(1/2,0,1/2)'],
            },
        },
    },
    (61, 'abc'): {
        'IT_number': 61,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (61, 'ba-c'): {
        'IT_number': 61,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z-1/2)',
                    '(x+1/2,-y,-z-1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z-1/2)',
                    '(-x+1/2,y,z-1/2)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(0,1/2,0)', '(1/2,0,0)', '(1/2,1/2,-1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,-1/2)', '(1/2,0,-1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (61, 'cab'): {
        'IT_number': 61,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
        },
    },
    (61, '-cba'): {
        'IT_number': 61,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z+1/2)',
                    '(-x-1/2,y+1/2,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z+1/2)',
                    '(x-1/2,-y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(0,0,1/2)', '(0,1/2,0)', '(-1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(-1/2,0,1/2)', '(-1/2,1/2,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (61, 'bca'): {
        'IT_number': 61,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)', '(1/2,0,0)', '(1/2,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)'],
            },
        },
    },
    (61, 'a-cb'): {
        'IT_number': 61,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y-1/2,-z)',
                    '(-x,-y-1/2,z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y-1/2,z)',
                    '(x,y-1/2,-z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,0,0)', '(0,0,1/2)', '(1/2,-1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,-1/2,0)', '(0,-1/2,1/2)', '(1/2,0,1/2)'],
            },
        },
    },
    (62, 'abc'): {
        'IT_number': 62,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'P n m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(-x+1/2,3/4,z+1/2)', '(-x,3/4,-z)', '(x+1/2,1/4,-z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,1/2,0)', '(1/2,1/2,1/2)'],
            },
        },
    },
    (62, 'ba-c'): {
        'IT_number': 62,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'P m n b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z-1/2)',
                    '(x+1/2,-y,-z)',
                    '(-x+1/2,y+1/2,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z-1/2)',
                    '(-x+1/2,y,z)',
                    '(x+1/2,-y+1/2,z-1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(3/4,-y+1/2,z-1/2)', '(3/4,-y,-z)', '(1/4,y+1/2,-z-1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,-1/2)', '(0,1/2,0)', '(1/2,0,-1/2)', '(1/2,1/2,0)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,-1/2)', '(1/2,0,0)', '(1/2,1/2,-1/2)'],
            },
        },
    },
    (62, 'cab'): {
        'IT_number': 62,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'P b n m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,z+1/2)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x,y,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(x+1/2,-y+1/2,3/4)', '(-x,-y,3/4)', '(-x+1/2,y+1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(0,0,1/2)', '(1/2,1/2,1/2)'],
            },
        },
    },
    (62, '-cba'): {
        'IT_number': 62,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'P c m n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z+1/2)',
                    '(-x,y+1/2,-z)',
                    '(-x-1/2,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z+1/2)',
                    '(x,-y+1/2,z)',
                    '(x-1/2,y+1/2,-z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(x-1/2,3/4,-z+1/2)', '(-x,3/4,-z)', '(-x-1/2,1/4,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,0,0)', '(0,0,1/2)', '(-1/2,1/2,0)', '(0,1/2,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(-1/2,0,1/2)', '(0,1/2,0)', '(-1/2,1/2,1/2)'],
            },
        },
    },
    (62, 'bca'): {
        'IT_number': 62,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'P m c n',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y,-z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y,z)',
                    '(x+1/2,y+1/2,-z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(3/4,y+1/2,-z+1/2)', '(3/4,-y,-z)', '(1/4,-y+1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(1/2,0,0)', '(1/2,1/2,1/2)'],
            },
        },
    },
    (62, 'a-cb'): {
        'IT_number': 62,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'P n a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y-1/2,-z)',
                    '(-x,-y,z+1/2)',
                    '(x+1/2,-y-1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y-1/2,z)',
                    '(x,y,-z+1/2)',
                    '(-x+1/2,y-1/2,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(-x+1/2,y-1/2,3/4)', '(-x,-y,3/4)', '(x+1/2,-y-1/2,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,-1/2,0)', '(1/2,0,0)', '(0,-1/2,1/2)', '(1/2,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,-1/2,0)', '(0,0,1/2)', '(1/2,-1/2,1/2)'],
            },
        },
    },
    (63, 'abc'): {
        'IT_number': 63,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z+1/2)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,1/4)', '(-x,-y,3/4)', '(-x,y,1/4)', '(x,-y,3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,-y,z+1/2)', '(0,y,-z+1/2)', '(0,-y,-z)'],
            },
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)', '(-x,0,0)', '(x,0,1/2)']},
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,1/2)', '(3/4,1/4,1/2)', '(1/4,3/4,0)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (63, 'ba-c'): {
        'IT_number': 63,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C c m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z-1/2)',
                    '(x,-y,-z-1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z-1/2)',
                    '(-x,y,z-1/2)',
                    '(x,-y,z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,-1/4)', '(-x,-y,-3/4)', '(x,-y,-1/4)', '(-x,y,-3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x,0,z-1/2)', '(x,0,-z-1/2)', '(-x,0,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,-1/2)', '(0,-y,0)', '(0,y,-1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,-1/2)', '(1/4,3/4,-1/2)', '(3/4,1/4,0)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,-1/4)', '(-x,0,-3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,-1/2)']},
        },
    },
    (63, 'cab'): {
        'IT_number': 63,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A m m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y,z)',
                    '(x+1/2,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(1/4,y,z)', '(3/4,-y,-z)', '(1/4,-y,z)', '(3/4,y,-z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x+1/2,0,-z)', '(-x+1/2,0,z)', '(-x,0,-z)'],
            },
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)', '(0,-y,0)', '(1/2,y,0)']},
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(1/2,3/4,3/4)', '(1/2,3/4,1/4)', '(0,1/4,3/4)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (63, '-cba'): {
        'IT_number': 63,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A m a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z)',
                    '(-x-1/2,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z)',
                    '(x-1/2,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(-1/4,y,z)', '(-3/4,-y,-z)', '(-1/4,y,-z)', '(-3/4,-y,z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x-1/2,-y,0)', '(-x-1/2,y,0)', '(-x,-y,0)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(-1/2,0,-z)', '(0,0,-z)', '(-1/2,0,z)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(-1/2,3/4,3/4)', '(-1/2,1/4,3/4)', '(0,3/4,1/4)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(-1/4,y,0)', '(-3/4,-y,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(-1/2,0,0)']},
        },
    },
    (63, 'bca'): {
        'IT_number': 63,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B b m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z)',
                    '(-x,y+1/2,z)',
                    '(x,y,-z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,1/4,z)', '(-x,3/4,-z)', '(x,1/4,-z)', '(-x,3/4,z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x,y+1/2,0)', '(x,-y+1/2,0)', '(-x,-y,0)'],
            },
            'e': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)', '(0,0,-z)', '(0,1/2,z)']},
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(3/4,1/2,3/4)', '(1/4,1/2,3/4)', '(3/4,0,1/4)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (63, 'a-cb'): {
        'IT_number': 63,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y-1/2,-z)',
                    '(-x,-y-1/2,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y-1/2,z)',
                    '(x,y-1/2,-z)',
                    '(-x,y,z)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,-1/4,z)', '(-x,-3/4,-z)', '(-x,-1/4,z)', '(x,-3/4,-z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,y-1/2,-z)', '(0,-y-1/2,z)', '(0,-y,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,-1/2,0)', '(-x,0,0)', '(x,-1/2,0)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(3/4,-1/2,3/4)', '(3/4,-1/2,1/4)', '(1/4,0,3/4)'],
            },
            'c': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,-1/4,z)', '(0,-3/4,-z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(0,-1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,-1/2,0)']},
        },
    },
    (64, 'abc'): {
        'IT_number': 64,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,-y+1/2,z+1/2)', '(0,y+1/2,-z+1/2)', '(0,-y,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y+1/2,3/4)', '(3/4,-y,3/4)', '(1/4,y+1/2,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)', '(-x,0,0)', '(x,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,1/2)', '(3/4,3/4,1/2)', '(1/4,3/4,0)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (64, 'ba-c'): {
        'IT_number': 64,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C c m e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z-1/2)',
                    '(x+1/2,-y,-z-1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z-1/2)',
                    '(-x+1/2,y,z-1/2)',
                    '(x,-y,z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x+1/2,0,z-1/2)', '(x+1/2,0,-z-1/2)', '(-x,0,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/4)', '(-x+1/2,3/4,-3/4)', '(-x,3/4,-3/4)', '(x+1/2,1/4,-1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,-1/2)', '(0,-y,0)', '(1/2,y,-1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,-1/2)', '(3/4,3/4,-1/2)', '(3/4,1/4,0)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,-1/2)']},
        },
    },
    (64, 'cab'): {
        'IT_number': 64,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A e m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y,z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y,z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x+1/2,0,-z+1/2)', '(-x+1/2,0,z+1/2)', '(-x,0,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,1/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)', '(0,-y,0)', '(1/2,y,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(1/2,3/4,1/4)', '(1/2,3/4,3/4)', '(0,1/4,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (64, '-cba'): {
        'IT_number': 64,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A e a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y+1/2,-z)',
                    '(-x-1/2,y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y+1/2,z)',
                    '(x-1/2,-y+1/2,z)',
                    '(x,y,-z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x-1/2,-y+1/2,0)', '(-x-1/2,y+1/2,0)', '(-x,-y,0)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/4)', '(-3/4,-y+1/2,3/4)', '(-3/4,-y,3/4)', '(-1/4,y+1/2,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(-1/2,1/2,-z)', '(0,0,-z)', '(-1/2,1/2,z)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(-1/2,1/4,3/4)', '(-1/2,3/4,3/4)', '(0,3/4,1/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(-1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,0)']},
        },
    },
    (64, 'bca'): {
        'IT_number': 64,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B b e m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x,y,-z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x+1/2,y+1/2,0)', '(x+1/2,-y+1/2,0)', '(-x,-y,0)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,3/4,3/4)', '(-x,3/4,3/4)', '(x+1/2,1/4,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(1/4,1/2,3/4)', '(3/4,1/2,3/4)', '(3/4,0,1/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (64, 'a-cb'): {
        'IT_number': 64,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m e b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y-1/2,-z+1/2)',
                    '(-x,-y-1/2,z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y-1/2,z+1/2)',
                    '(x,y-1/2,-z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,y-1/2,-z+1/2)', '(0,-y-1/2,z+1/2)', '(0,-y,-z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/4,z)', '(3/4,-3/4,-z+1/2)', '(3/4,-3/4,-z)', '(1/4,-1/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,-1/2,1/2)', '(-x,0,0)', '(x,-1/2,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(3/4,-1/2,1/4)', '(3/4,-1/2,3/4)', '(1/4,0,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,-1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,-1/2,1/2)']},
        },
    },
    (65, 'abc'): {
        'IT_number': 65,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,1/2)', '(-x,-y,1/2)', '(-x,y,1/2)', '(x,-y,1/2)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,0)', '(x,-y,0)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(-x,0,-z)', '(x,0,-z)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,y,-z)', '(0,-y,-z)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)', '(3/4,3/4,-z)', '(1/4,3/4,z)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,1/4,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (65, 'ba-c'): {
        'IT_number': 65,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,-1/2)', '(-x,-y,-1/2)', '(x,-y,-1/2)', '(-x,y,-1/2)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,0)', '(-x,y,0)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,-y,-z)', '(0,y,-z)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(x,0,-z)', '(-x,0,-z)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)', '(3/4,3/4,-z)', '(3/4,1/4,z)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,-1/2)', '(0,-y,-1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,-1/2)', '(1/4,3/4,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,-1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (65, 'cab'): {
        'IT_number': 65,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(1/2,y,z)', '(1/2,-y,-z)', '(1/2,-y,z)', '(1/2,y,-z)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y,z)', '(0,y,-z)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,-y,0)', '(-x,y,0)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,z)', '(-x,0,-z)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(-x,3/4,3/4)', '(x,1/4,3/4)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (65, '-cba'): {
        'IT_number': 65,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(-1/2,y,z)', '(-1/2,-y,-z)', '(-1/2,y,-z)', '(-1/2,-y,z)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y,-z)', '(0,-y,z)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,-z)', '(-x,0,z)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,y,0)', '(-x,-y,0)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)', '(-x,3/4,3/4)', '(x,3/4,1/4)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(-1/2,0,z)', '(-1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,1/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(0,1/4,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (65, 'bca'): {
        'IT_number': 65,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,-z)', '(x,1/2,-z)', '(-x,1/2,z)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,0,-z)', '(-x,0,z)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,-z)', '(0,-y,z)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(x,-y,0)', '(-x,-y,0)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)', '(3/4,-y,3/4)', '(3/4,y,1/4)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/2,1/4)', '(1/4,1/2,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (65, 'a-cb'): {
        'IT_number': 65,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,-1/2,z)', '(-x,-1/2,-z)', '(-x,-1/2,z)', '(x,-1/2,-z)'],
            },
            'p': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,0,z)', '(x,0,-z)']},
            'o': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(-x,-y,0)', '(x,-y,0)']},
            'n': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,z)', '(0,-y,-z)']},
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)', '(3/4,-y,3/4)', '(1/4,y,3/4)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'k': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,-1/2,1/4)', '(3/4,-1/2,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,1/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,-1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (66, 'abc'): {
        'IT_number': 66,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C c c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,1/2)', '(x,-y,1/2)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,3/4,z+1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z+1/2)', '(0,1/2,-z)', '(0,1/2,z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y,1/4)', '(0,-y,3/4)', '(0,y,3/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x,0,1/4)', '(-x,0,3/4)', '(x,0,3/4)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,3/4,0)', '(3/4,3/4,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,1/2)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (66, 'ba-c'): {
        'IT_number': 66,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C c c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z-1/2)',
                    '(-x,y,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z-1/2)',
                    '(x,-y,z-1/2)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,-1/2)', '(-x,y,-1/2)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z-1/2)', '(3/4,3/4,-z)', '(3/4,1/4,z-1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z-1/2)', '(1/2,0,-z)', '(1/2,0,z-1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z-1/2)', '(0,0,-z)', '(0,0,z-1/2)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x,0,-1/4)', '(-x,0,-3/4)', '(x,0,-3/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/4)', '(0,-y,-1/4)', '(0,-y,-3/4)', '(0,y,-3/4)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(3/4,1/4,0)', '(3/4,3/4,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,-1/2)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,-1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,0,-1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,-1/4)', '(1/2,0,-3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/4)', '(0,0,-3/4)']},
        },
    },
    (66, 'cab'): {
        'IT_number': 66,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A m a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x+1/2,y,-z)',
                    '(x+1/2,-y,z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(1/2,-y,z)', '(1/2,y,-z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,3/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,1/4,3/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x+1/2,0,1/2)', '(-x,0,1/2)', '(x+1/2,0,1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,0,0)', '(-x,0,0)', '(x+1/2,0,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z)', '(3/4,0,-z)', '(3/4,0,z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y,0)', '(3/4,-y,0)', '(3/4,y,0)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,3/4)', '(1/2,3/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(1/2,3/4,1/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)']},
        },
    },
    (66, '-cba'): {
        'IT_number': 66,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A m a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x-1/2,y,-z)',
                    '(-x-1/2,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x-1/2,-y,z)',
                    '(x-1/2,y,-z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(-1/2,y,-z)', '(-1/2,-y,z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x-1/2,1/4,3/4)', '(-x,3/4,3/4)', '(x-1/2,3/4,1/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x-1/2,1/2,0)', '(-x,1/2,0)', '(x-1/2,1/2,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x-1/2,0,0)', '(-x,0,0)', '(x-1/2,0,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-1/4,-y,0)', '(-3/4,-y,0)', '(-3/4,y,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,0,z)', '(-1/4,0,-z)', '(-3/4,0,-z)', '(-3/4,0,z)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,3/4,1/4)', '(-1/2,3/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(-1/2,1/4,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(-1/2,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(-1/2,0,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/2,0)', '(-3/4,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,0,0)', '(-3/4,0,0)']},
        },
    },
    (66, 'bca'): {
        'IT_number': 66,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B b m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y+1/2,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y+1/2,z)',
                    '(x,y+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,1/2,-z)', '(-x,1/2,z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,3/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,1/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y+1/2,0)', '(1/2,-y,0)', '(1/2,y+1/2,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y+1/2,0)', '(0,-y,0)', '(0,y+1/2,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,0)', '(-x,3/4,0)', '(x,3/4,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z)', '(0,3/4,-z)', '(0,3/4,z)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(3/4,0,1/4)', '(3/4,1/2,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,1/2,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/4,0)', '(1/2,3/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,0)', '(0,3/4,0)']},
        },
    },
    (66, 'a-cb'): {
        'IT_number': 66,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B b m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y-1/2,z)',
                    '(x,-y-1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y-1/2,-z)',
                    '(-x,y-1/2,z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,-1/2,z)', '(x,-1/2,-z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y-1/2,1/4)', '(3/4,-y,3/4)', '(1/4,y-1/2,3/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(0,-y-1/2,1/2)', '(0,-y,1/2)', '(0,y-1/2,1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y-1/2,0)', '(0,-y,0)', '(0,y-1/2,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(0,-1/4,-z)', '(0,-3/4,-z)', '(0,-3/4,z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,0)', '(-x,-1/4,0)', '(-x,-3/4,0)', '(x,-3/4,0)'],
            },
            'f': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,3/4)', '(3/4,-1/2,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,-1/2,1/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(0,-1/2,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,-1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,1/2)', '(0,-3/4,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,0)', '(0,-3/4,0)']},
        },
    },
    (67, 'abc'): {
        'IT_number': 67,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'C m m e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(-x,y+1/2,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(x,-y+1/2,z)',
                    '(-x,y,z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(-x,1/4,z)', '(-x,3/4,-z)', '(x,3/4,-z)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,-y+1/2,z)', '(0,y+1/2,-z)', '(0,-y,-z)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(3/4,1/2,-z)', '(3/4,0,-z)', '(1/4,1/2,z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/2)', '(3/4,-y+1/2,1/2)', '(3/4,-y,1/2)', '(1/4,y+1/2,1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y+1/2,0)', '(3/4,-y,0)', '(1/4,y+1/2,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/2)', '(-x,1/2,1/2)', '(-x,0,1/2)', '(x,1/2,1/2)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,1/2,0)', '(-x,0,0)', '(x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,1/4,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)']},
        },
    },
    (67, 'ba-c'): {
        'IT_number': 67,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'C m m e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(x+1/2,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(-x+1/2,y,z)',
                    '(x,-y,z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,-y,z)', '(3/4,-y,-z)', '(3/4,y,-z)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x+1/2,0,z)', '(x+1/2,0,-z)', '(-x,0,-z)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(1/2,3/4,-z)', '(0,3/4,-z)', '(1/2,1/4,z)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/2)', '(-x+1/2,3/4,-1/2)', '(-x,3/4,-1/2)', '(x+1/2,1/4,-1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,3/4,0)', '(-x,3/4,0)', '(x+1/2,1/4,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/2)', '(1/2,-y,-1/2)', '(0,-y,-1/2)', '(1/2,y,-1/2)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)', '(0,-y,0)', '(1/2,y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,-1/2)', '(1/4,3/4,-1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,-1/2)', '(1/2,0,-1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,-1/2)', '(0,3/4,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,0)', '(0,3/4,0)']},
        },
    },
    (67, 'cab'): {
        'IT_number': 67,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'A e m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(x,-y,z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(x,-y,1/4)', '(-x,-y,3/4)', '(-x,y,3/4)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x,0,-z+1/2)', '(-x,0,z+1/2)', '(-x,0,-z)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x,3/4,1/2)', '(-x,3/4,0)', '(x,1/4,1/2)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,1/4,z)', '(1/2,3/4,-z+1/2)', '(1/2,3/4,-z)', '(1/2,1/4,z+1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z+1/2)', '(0,3/4,-z)', '(0,1/4,z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,1/2)', '(1/2,-y,0)', '(1/2,y,1/2)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,1/2)', '(0,-y,0)', '(0,y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/4)', '(-x,0,3/4)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/2,1/4,1/4)', '(1/2,3/4,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/4,0)', '(1/2,3/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,0)', '(0,3/4,0)']},
        },
    },
    (67, '-cba'): {
        'IT_number': 67,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'A e m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x,-y+1/2,z)',
                    '(x,y,-z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(x,1/4,-z)', '(-x,3/4,-z)', '(-x,3/4,z)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x,-y+1/2,0)', '(-x,y+1/2,0)', '(-x,-y,0)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x,1/2,3/4)', '(-x,0,3/4)', '(x,1/2,1/4)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/2,y,1/4)', '(-1/2,-y+1/2,3/4)', '(-1/2,-y,3/4)', '(-1/2,y+1/2,1/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y+1/2,3/4)', '(0,-y,3/4)', '(0,y+1/2,1/4)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/2,0,z)', '(-1/2,1/2,-z)', '(-1/2,0,-z)', '(-1/2,1/2,z)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)', '(0,0,-z)', '(0,1/2,z)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-1/2,1/4,1/4)', '(-1/2,1/4,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/4,1/4)', '(0,1/4,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,1/4)', '(-1/2,0,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (67, 'bca'): {
        'IT_number': 67,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'B m e m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(-x+1/2,y,z)',
                    '(x,y,-z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,y,-z)', '(3/4,-y,-z)', '(3/4,-y,z)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x+1/2,y,0)', '(x+1/2,-y,0)', '(-x,-y,0)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y,3/4)', '(0,-y,3/4)', '(1/2,y,1/4)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/4)', '(-x+1/2,1/2,3/4)', '(-x,1/2,3/4)', '(x+1/2,1/2,1/4)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)', '(-x,0,3/4)', '(x+1/2,0,1/4)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,1/2,-z)', '(0,1/2,-z)', '(1/2,1/2,z)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(1/2,0,-z)', '(0,0,-z)', '(1/2,0,z)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,0)', '(3/4,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/2,1/4)', '(1/4,1/2,3/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,0,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (67, 'a-cb'): {
        'IT_number': 67,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'B m e m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(-x,y,1/4)', '(-x,-y,3/4)', '(x,-y,3/4)'],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,y,-z+1/2)', '(0,-y,z+1/2)', '(0,-y,-z)'],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y,1/2)', '(3/4,-y,0)', '(1/4,y,1/2)'],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/2,z)', '(3/4,-1/2,-z+1/2)', '(3/4,-1/2,-z)', '(1/4,-1/2,z+1/2)'],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z+1/2)', '(3/4,0,-z)', '(1/4,0,z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/2,0)', '(-x,-1/2,1/2)', '(-x,-1/2,0)', '(x,-1/2,1/2)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)', '(-x,0,0)', '(x,0,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'f': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,-1/2,1/4)', '(3/4,-1/2,1/4)']},
            'e': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,1/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,-1/2,0)', '(0,-1/2,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/2,0)', '(3/4,-1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)']},
        },
    },
    (68, '1abc'): {
        'IT_number': 68,
        'setting': 6,
        'IT_coordinate_system_code': '1abc',
        'name_H-M_alt': 'C c c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y+1/2,-z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)', '(3/4,1/4,-z+1/2)', '(1/4,1/4,z+1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,1/2,-z+1/2)', '(0,1/2,z+1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(1/2,-y+1/2,0)', '(0,-y+1/2,1/2)', '(1/2,y,1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,1/2,0)', '(-x,1/2,1/2)', '(x+1/2,0,1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(1/2,1/4,1/4)', '(0,1/4,3/4)', '(1/2,1/4,3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(1/4,1/2,1/4)', '(3/4,0,3/4)', '(3/4,1/2,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
        },
    },
    (68, '2abc'): {
        'IT_number': 68,
        'setting': 12,
        'IT_coordinate_system_code': '2abc',
        'name_H-M_alt': 'C c c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(-x,y,-z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z+1/2)', '(3/4,0,-z)', '(1/4,0,z+1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z+1/2)', '(0,3/4,-z)', '(0,3/4,z+1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(1/2,-y,1/4)', '(0,-y,3/4)', '(1/2,y,3/4)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,3/4,1/4)', '(-x,3/4,3/4)', '(x+1/2,1/4,3/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(0,0,1/2)', '(1/2,0,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,3/4,0)', '(1/4,1/4,0)', '(3/4,3/4,1/2)', '(3/4,1/4,1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,3/4)', '(0,3/4,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,3/4)']},
        },
    },
    (68, '1ba-c'): {
        'IT_number': 68,
        'setting': 7,
        'IT_coordinate_system_code': '1ba-c',
        'name_H-M_alt': 'C c c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(x,-y,-z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x+1/2,-y,-z-1/2)',
                    '(x,y+1/2,-z-1/2)',
                    '(-x+1/2,y,z-1/2)',
                    '(x,-y+1/2,z-1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)', '(1/4,3/4,-z-1/2)', '(1/4,1/4,z-1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,0,-z-1/2)', '(1/2,0,z-1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,1/2,0)', '(-x+1/2,0,-1/2)', '(x,1/2,-1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(1/2,-y+1/2,0)', '(1/2,-y,-1/2)', '(0,y+1/2,-1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,-1/4)', '(1/4,1/2,-1/4)', '(1/4,0,-3/4)', '(1/4,1/2,-3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,-1/4)', '(1/2,1/4,-1/4)', '(0,3/4,-3/4)', '(1/2,3/4,-3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)', '(1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,0,-1/2)']},
        },
    },
    (68, '2ba-c'): {
        'IT_number': 68,
        'setting': 13,
        'IT_coordinate_system_code': '2ba-c',
        'name_H-M_alt': 'C c c e',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(x,-y,-z-1/2)',
                    '(-x,y+1/2,-z-1/2)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(-x,y,z-1/2)',
                    '(x,-y+1/2,z-1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z-1/2)', '(0,3/4,-z)', '(0,1/4,z-1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z-1/2)', '(3/4,0,-z)', '(3/4,0,z-1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x,1/2,-1/4)', '(-x,0,-3/4)', '(x,1/2,-3/4)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-1/4)', '(3/4,-y+1/2,-1/4)', '(3/4,-y,-3/4)', '(1/4,y+1/2,-3/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(0,0,-1/2)', '(0,1/2,-1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,1/4,0)', '(1/4,1/4,0)', '(3/4,3/4,-1/2)', '(1/4,3/4,-1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,-3/4)', '(3/4,0,-1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,-1/4)', '(3/4,0,-3/4)']},
        },
    },
    (68, '1cab'): {
        'IT_number': 68,
        'setting': 8,
        'IT_coordinate_system_code': '1cab',
        'name_H-M_alt': 'A e a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,-y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x+1/2,-y,-z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(-x+1/2,3/4,1/4)', '(x+1/2,1/4,1/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/2,0,1/2)', '(x+1/2,0,1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,0,z)', '(0,1/2,-z+1/2)', '(1/2,0,-z+1/2)', '(1/2,1/2,z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y+1/2,1/2)', '(1/2,-y,1/2)', '(1/2,y+1/2,0)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,1/4)', '(1/4,1/2,1/4)', '(3/4,0,1/4)', '(3/4,1/2,1/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(1/4,1/4,1/2)', '(3/4,3/4,0)', '(3/4,3/4,1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
        },
    },
    (68, '2cab'): {
        'IT_number': 68,
        'setting': 14,
        'IT_coordinate_system_code': '2cab',
        'name_H-M_alt': 'A e a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x+1/2,-y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x+1/2,y,-z)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x+1/2,3/4,0)', '(-x,3/4,0)', '(x+1/2,1/4,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,1/4)', '(-x,0,3/4)', '(x+1/2,0,3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,1/2,-z)', '(3/4,0,-z)', '(3/4,1/2,z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y+1/2,3/4)', '(3/4,-y,3/4)', '(3/4,y+1/2,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,0)', '(1/2,0,0)', '(1/2,1/2,0)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,3/4)', '(0,1/4,1/4)', '(1/2,3/4,3/4)', '(1/2,3/4,1/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(3/4,0,1/4)', '(1/4,0,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,3/4)']},
        },
    },
    (68, '1-cba'): {
        'IT_number': 68,
        'setting': 9,
        'IT_coordinate_system_code': '1-cba',
        'name_H-M_alt': 'A e a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z+1/2)',
                    '(-x,y,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x-1/2,-y+1/2,-z)',
                    '(-x-1/2,y,z+1/2)',
                    '(x-1/2,-y+1/2,z)',
                    '(x-1/2,y,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)', '(-x-1/2,1/4,3/4)', '(x-1/2,1/4,1/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x-1/2,1/2,0)', '(x-1/2,1/2,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y+1/2,1/2)', '(-1/2,-y+1/2,0)', '(-1/2,y,1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,1/2,-z+1/2)', '(-1/2,1/2,-z)', '(-1/2,0,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,1/4,0)', '(-1/4,1/4,1/2)', '(-3/4,1/4,0)', '(-3/4,1/4,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,0,1/4)', '(-1/4,1/2,1/4)', '(-3/4,0,3/4)', '(-3/4,1/2,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)', '(0,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(-1/2,1/2,0)']},
        },
    },
    (68, '2-cba'): {
        'IT_number': 68,
        'setting': 15,
        'IT_coordinate_system_code': '2-cba',
        'name_H-M_alt': 'A e a a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x-1/2,y,-z)',
                    '(-x-1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x-1/2,-y,z)',
                    '(x-1/2,y,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x-1/2,0,3/4)', '(-x,0,3/4)', '(x-1/2,0,1/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x-1/2,1/4,0)', '(-x,3/4,0)', '(x-1/2,3/4,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-1/4,-y,1/2)', '(-3/4,-y,0)', '(-3/4,y,1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,1/4,z)', '(-1/4,3/4,-z+1/2)', '(-3/4,3/4,-z)', '(-3/4,1/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(-1/2,0,0)', '(-1/2,0,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,3/4,1/4)', '(0,1/4,1/4)', '(-1/2,3/4,3/4)', '(-1/2,1/4,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-3/4,1/4,0)', '(-1/4,3/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/4,0)', '(-3/4,3/4,0)']},
        },
    },
    (68, '1bca'): {
        'IT_number': 68,
        'setting': 10,
        'IT_coordinate_system_code': '1bca',
        'name_H-M_alt': 'B b e b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)', '(1/4,-y+1/2,3/4)', '(1/4,y+1/2,1/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/2,-y+1/2,0)', '(1/2,y+1/2,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x+1/2,0,1/2)', '(-x+1/2,1/2,0)', '(x,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(1/2,0,-z+1/2)', '(1/2,1/2,-z)', '(0,1/2,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,0)', '(1/4,1/4,1/2)', '(1/4,3/4,0)', '(1/4,3/4,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/4)', '(1/2,1/4,1/4)', '(0,3/4,3/4)', '(1/2,3/4,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (68, '2bca'): {
        'IT_number': 68,
        'setting': 16,
        'IT_coordinate_system_code': '2bca',
        'name_H-M_alt': 'B b e b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y+1/2,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(0,-y+1/2,3/4)', '(0,-y,3/4)', '(0,y+1/2,1/4)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y+1/2,0)', '(3/4,-y,0)', '(3/4,y+1/2,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,1/2)', '(-x,3/4,0)', '(x,3/4,1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,3/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(0,1/2,0)', '(0,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(3/4,0,1/4)', '(1/4,0,1/4)', '(3/4,1/2,3/4)', '(1/4,1/2,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,3/4,0)', '(3/4,1/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)']},
        },
    },
    (68, '2a-cb'): {
        'IT_number': 68,
        'setting': 17,
        'IT_coordinate_system_code': '2a-cb',
        'name_H-M_alt': 'B b e b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(-x,-y-1/2,z)',
                    '(x+1/2,-y-1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(x,y-1/2,-z)',
                    '(-x+1/2,y-1/2,z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y-1/2,0)', '(3/4,-y,0)', '(1/4,y-1/2,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(0,-y-1/2,1/4)', '(0,-y,3/4)', '(0,y-1/2,3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(1/2,-1/4,-z)', '(0,-3/4,-z)', '(1/2,-3/4,z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,1/4)', '(-x+1/2,-1/4,3/4)', '(-x,-3/4,3/4)', '(x+1/2,-3/4,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,0)', '(0,-1/2,0)', '(1/2,-1/2,0)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,0,3/4)', '(1/4,0,1/4)', '(3/4,-1/2,3/4)', '(3/4,-1/2,1/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-3/4,1/4)', '(0,-1/4,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,1/4)', '(0,-3/4,3/4)']},
        },
    },
    (69, 'abc'): {
        'IT_number': 69,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,0)', '(x,-y,0)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(-x,0,-z)', '(x,0,-z)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,y,-z)', '(0,-y,-z)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(-x,3/4,3/4)', '(x,1/4,3/4)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)', '(3/4,-y,3/4)', '(1/4,y,3/4)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)', '(3/4,3/4,-z)', '(1/4,3/4,z)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,0)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,1/4)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (69, 'ba-c'): {
        'IT_number': 69,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,0)', '(-x,y,0)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,-y,-z)', '(0,y,-z)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(x,0,-z)', '(-x,0,-z)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,-1/4)', '(3/4,-y,-1/4)', '(3/4,-y,-3/4)', '(1/4,y,-3/4)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/4)', '(-x,3/4,-1/4)', '(-x,3/4,-3/4)', '(x,1/4,-3/4)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)', '(3/4,3/4,-z)', '(3/4,1/4,z)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,3/4,-3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,0)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/4,-1/4)', '(0,3/4,-1/4)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/4,0,-1/4)', '(3/4,0,-1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (69, 'cab'): {
        'IT_number': 69,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y,z)', '(0,y,-z)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,-y,0)', '(-x,y,0)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,z)', '(-x,0,-z)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)', '(3/4,-y,3/4)', '(3/4,y,1/4)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z)', '(3/4,3/4,-z)', '(3/4,1/4,z)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(-x,3/4,3/4)', '(x,1/4,3/4)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,0)', '(1/4,3/4,0)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,0,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (69, '-cba'): {
        'IT_number': 69,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y,-z)', '(0,-y,z)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,-z)', '(-x,0,z)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,y,0)', '(-x,-y,0)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,1/4,z)', '(-1/4,3/4,-z)', '(-3/4,3/4,-z)', '(-3/4,1/4,z)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/4)', '(-1/4,-y,3/4)', '(-3/4,-y,3/4)', '(-3/4,y,1/4)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)', '(-x,3/4,3/4)', '(x,3/4,1/4)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,1/4,1/4)', '(-3/4,3/4,3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/4,1/4)', '(0,1/4,3/4)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-1/4,0,1/4)', '(-1/4,0,3/4)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(-1/4,1/4,0)', '(-1/4,3/4,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (69, 'bca'): {
        'IT_number': 69,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,0,-z)', '(-x,0,z)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,-z)', '(0,-y,z)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(x,-y,0)', '(-x,-y,0)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,1/4,-z)', '(3/4,3/4,-z)', '(1/4,3/4,z)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,1/4,3/4)', '(-x,3/4,3/4)', '(x,3/4,1/4)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(1/4,-y,3/4)', '(3/4,-y,3/4)', '(3/4,y,1/4)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(1/4,0,3/4)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(0,1/4,1/4)', '(0,1/4,3/4)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,1/4,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (69, 'a-cb'): {
        'IT_number': 69,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'F m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                ],
            },
            'o': {'multiplicity': 16, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,0,z)', '(x,0,-z)']},
            'n': {'multiplicity': 16, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(-x,-y,0)', '(x,-y,0)']},
            'm': {'multiplicity': 16, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,z)', '(0,-y,-z)']},
            'l': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,1/4)', '(-x,-1/4,3/4)', '(-x,-3/4,3/4)', '(x,-3/4,1/4)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/4,z)', '(3/4,-1/4,-z)', '(3/4,-3/4,-z)', '(1/4,-3/4,z)'],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y,1/4)', '(3/4,-y,3/4)', '(1/4,y,3/4)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'g': {'multiplicity': 8, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/4,-1/4,1/4)', '(3/4,-3/4,3/4)']},
            'e': {'multiplicity': 8, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/4,0,1/4)', '(3/4,0,1/4)']},
            'd': {'multiplicity': 8, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,-1/4,0)', '(3/4,-1/4,0)']},
            'c': {'multiplicity': 8, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,-1/4,1/4)', '(0,-1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,-1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (70, '1abc'): {
        'IT_number': 70,
        'setting': 6,
        'IT_coordinate_system_code': '1abc',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x+1/4,-y+1/4,-z+1/4)',
                    '(x+1/4,y+1/4,-z+1/4)',
                    '(x+1/4,-y+1/4,z+1/4)',
                    '(-x+1/4,y+1/4,z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/4,1/4,-z+1/4)', '(1/4,1/4,z+1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/4,-y+1/4,1/4)', '(1/4,y+1/4,1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/4,1/4,1/4)', '(x+1/4,1/4,1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(5/8,5/8,5/8)', '(3/8,3/8,5/8)', '(3/8,5/8,3/8)', '(5/8,3/8,3/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,1/8)', '(7/8,1/8,7/8)', '(1/8,7/8,7/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(1/4,1/4,3/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/4,1/4,1/4)']},
        },
    },
    (70, '2abc'): {
        'IT_number': 70,
        'setting': 12,
        'IT_coordinate_system_code': '2abc',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+3/4,-y+3/4,z)',
                    '(-x+3/4,y,-z+3/4)',
                    '(x,-y+3/4,-z+3/4)',
                    '(-x,-y,-z)',
                    '(x+1/4,y+1/4,-z)',
                    '(x+1/4,-y,z+1/4)',
                    '(-x,y+1/4,z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/8,1/8,z)', '(5/8,1/8,-z+3/4)', '(7/8,7/8,-z)', '(3/8,7/8,z+1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/8,y,1/8)', '(5/8,-y+3/4,1/8)', '(7/8,-y,7/8)', '(3/8,y+1/4,7/8)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/8,1/8)', '(-x+3/4,5/8,1/8)', '(-x,7/8,7/8)', '(x+1/4,3/8,7/8)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(1/4,1/4,1/2)', '(1/4,1/2,1/4)', '(1/2,1/4,1/4)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(3/4,3/4,0)', '(3/4,0,3/4)', '(0,3/4,3/4)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,5/8)', '(7/8,7/8,3/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,7/8)']},
        },
    },
    (70, '1ba-c'): {
        'IT_number': 70,
        'setting': 7,
        'IT_coordinate_system_code': '1ba-c',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x+1/4,-y+1/4,-z-1/4)',
                    '(x+1/4,y+1/4,-z-1/4)',
                    '(-x+1/4,y+1/4,z-1/4)',
                    '(x+1/4,-y+1/4,z-1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/4,1/4,-z-1/4)', '(1/4,1/4,z-1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/4,1/4,-1/4)', '(x+1/4,1/4,-1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/4,-y+1/4,-1/4)', '(1/4,y+1/4,-1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(5/8,5/8,-5/8)', '(3/8,3/8,-5/8)', '(5/8,3/8,-3/8)', '(3/8,5/8,-3/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/8,1/8,-1/8)', '(7/8,7/8,-1/8)', '(1/8,7/8,-7/8)', '(7/8,1/8,-7/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/2)', '(1/4,1/4,-3/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/4,1/4,-1/4)']},
        },
    },
    (70, '2ba-c'): {
        'IT_number': 70,
        'setting': 13,
        'IT_coordinate_system_code': '2ba-c',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+3/4,-y+3/4,z)',
                    '(x,-y+3/4,-z-3/4)',
                    '(-x+3/4,y,-z-3/4)',
                    '(-x,-y,-z)',
                    '(x+1/4,y+1/4,-z)',
                    '(-x,y+1/4,z-1/4)',
                    '(x+1/4,-y,z-1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/8,1/8,z)', '(1/8,5/8,-z-3/4)', '(7/8,7/8,-z)', '(7/8,3/8,z-1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/8,-1/8)', '(-x+3/4,5/8,-1/8)', '(-x,7/8,-7/8)', '(x+1/4,3/8,-7/8)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/8,y,-1/8)', '(5/8,-y+3/4,-1/8)', '(7/8,-y,-7/8)', '(3/8,y+1/4,-7/8)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,-1/2)', '(1/4,1/4,-1/2)', '(1/2,1/4,-1/4)', '(1/4,1/2,-1/4)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(3/4,3/4,0)', '(0,3/4,-3/4)', '(3/4,0,-3/4)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,-5/8)', '(7/8,7/8,-3/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,-1/8)', '(7/8,7/8,-7/8)']},
        },
    },
    (70, '1cab'): {
        'IT_number': 70,
        'setting': 8,
        'IT_coordinate_system_code': '1cab',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x+1/4,-y+1/4,-z+1/4)',
                    '(-x+1/4,y+1/4,z+1/4)',
                    '(x+1/4,y+1/4,-z+1/4)',
                    '(x+1/4,-y+1/4,z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/4,1/4,1/4)', '(x+1/4,1/4,1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/4,1/4,-z+1/4)', '(1/4,1/4,z+1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/4,-y+1/4,1/4)', '(1/4,y+1/4,1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(5/8,5/8,5/8)', '(5/8,3/8,3/8)', '(3/8,3/8,5/8)', '(3/8,5/8,3/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/8,1/8,1/8)', '(1/8,7/8,7/8)', '(7/8,7/8,1/8)', '(7/8,1/8,7/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(3/4,1/4,1/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/4,1/4,1/4)']},
        },
    },
    (70, '2cab'): {
        'IT_number': 70,
        'setting': 14,
        'IT_coordinate_system_code': '2cab',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+3/4,-z+3/4)',
                    '(-x+3/4,-y+3/4,z)',
                    '(-x+3/4,y,-z+3/4)',
                    '(-x,-y,-z)',
                    '(-x,y+1/4,z+1/4)',
                    '(x+1/4,y+1/4,-z)',
                    '(x+1/4,-y,z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/8,1/8)', '(-x+3/4,5/8,1/8)', '(-x,7/8,7/8)', '(x+1/4,3/8,7/8)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/8,1/8,z)', '(1/8,5/8,-z+3/4)', '(7/8,7/8,-z)', '(7/8,3/8,z+1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/8,y,1/8)', '(1/8,-y+3/4,5/8)', '(7/8,-y,7/8)', '(7/8,y+1/4,3/8)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(1/2,1/4,1/4)', '(1/4,1/4,1/2)', '(1/4,1/2,1/4)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,3/4,3/4)', '(3/4,3/4,0)', '(3/4,0,3/4)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(5/8,1/8,1/8)', '(3/8,7/8,7/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,7/8)']},
        },
    },
    (70, '1-cba'): {
        'IT_number': 70,
        'setting': 9,
        'IT_coordinate_system_code': '1-cba',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x-1/4,-y+1/4,-z+1/4)',
                    '(-x-1/4,y+1/4,z+1/4)',
                    '(x-1/4,-y+1/4,z+1/4)',
                    '(x-1/4,y+1/4,-z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x-1/4,1/4,1/4)', '(x-1/4,1/4,1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(-1/4,-y+1/4,1/4)', '(-1/4,y+1/4,1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(-1/4,1/4,-z+1/4)', '(-1/4,1/4,z+1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(-5/8,5/8,5/8)', '(-5/8,3/8,3/8)', '(-3/8,5/8,3/8)', '(-3/8,3/8,5/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/8,1/8,1/8)', '(-1/8,7/8,7/8)', '(-7/8,1/8,7/8)', '(-7/8,7/8,1/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(-1/2,0,0)', '(-3/4,1/4,1/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(-1/4,1/4,1/4)']},
        },
    },
    (70, '2-cba'): {
        'IT_number': 70,
        'setting': 15,
        'IT_coordinate_system_code': '2-cba',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+3/4,-z+3/4)',
                    '(-x-3/4,y,-z+3/4)',
                    '(-x-3/4,-y+3/4,z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/4,z+1/4)',
                    '(x-1/4,-y,z+1/4)',
                    '(x-1/4,y+1/4,-z)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/8,1/8)', '(-x-3/4,1/8,5/8)', '(-x,7/8,7/8)', '(x-1/4,7/8,3/8)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/8,y,1/8)', '(-1/8,-y+3/4,5/8)', '(-7/8,-y,7/8)', '(-7/8,y+1/4,3/8)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/8,1/8,z)', '(-1/8,5/8,-z+3/4)', '(-7/8,7/8,-z)', '(-7/8,3/8,z+1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/2,1/2,1/2)', '(-1/2,1/4,1/4)', '(-1/4,1/2,1/4)', '(-1/4,1/4,1/2)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,3/4,3/4)', '(-3/4,0,3/4)', '(-3/4,3/4,0)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(-5/8,1/8,1/8)', '(-3/8,7/8,7/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(-1/8,1/8,1/8)', '(-7/8,7/8,7/8)']},
        },
    },
    (70, '1bca'): {
        'IT_number': 70,
        'setting': 10,
        'IT_coordinate_system_code': '1bca',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x+1/4,-y+1/4,-z+1/4)',
                    '(x+1/4,-y+1/4,z+1/4)',
                    '(-x+1/4,y+1/4,z+1/4)',
                    '(x+1/4,y+1/4,-z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(0,-y,0)', '(1/4,-y+1/4,1/4)', '(1/4,y+1/4,1/4)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(-x+1/4,1/4,1/4)', '(x+1/4,1/4,1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/4,1/4,-z+1/4)', '(1/4,1/4,z+1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(5/8,5/8,5/8)', '(3/8,5/8,3/8)', '(5/8,3/8,3/8)', '(3/8,3/8,5/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,1/8,7/8)', '(1/8,7/8,7/8)', '(7/8,7/8,1/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/4,3/4,1/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(1/4,1/4,1/4)']},
        },
    },
    (70, '2bca'): {
        'IT_number': 70,
        'setting': 16,
        'IT_coordinate_system_code': '2bca',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+3/4,y,-z+3/4)',
                    '(x,-y+3/4,-z+3/4)',
                    '(-x+3/4,-y+3/4,z)',
                    '(-x,-y,-z)',
                    '(x+1/4,-y,z+1/4)',
                    '(-x,y+1/4,z+1/4)',
                    '(x+1/4,y+1/4,-z)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/8,y,1/8)', '(1/8,-y+3/4,5/8)', '(7/8,-y,7/8)', '(7/8,y+1/4,3/8)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/8,1/8)', '(-x+3/4,1/8,5/8)', '(-x,7/8,7/8)', '(x+1/4,7/8,3/8)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/8,1/8,z)', '(5/8,1/8,-z+3/4)', '(7/8,7/8,-z)', '(3/8,7/8,z+1/4)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,1/2,1/2)', '(1/4,1/2,1/4)', '(1/2,1/4,1/4)', '(1/4,1/4,1/2)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(3/4,0,3/4)', '(0,3/4,3/4)', '(3/4,3/4,0)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,5/8,1/8)', '(7/8,3/8,7/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,7/8)']},
        },
    },
    (70, '2a-cb'): {
        'IT_number': 70,
        'setting': 17,
        'IT_coordinate_system_code': '2a-cb',
        'name_H-M_alt': 'F d d d',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+3/4,y,-z+3/4)',
                    '(-x+3/4,-y-3/4,z)',
                    '(x,-y-3/4,-z+3/4)',
                    '(-x,-y,-z)',
                    '(x+1/4,-y,z+1/4)',
                    '(x+1/4,y-1/4,-z)',
                    '(-x,y-1/4,z+1/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/8,y,1/8)', '(5/8,-y-3/4,1/8)', '(7/8,-y,7/8)', '(3/8,y-1/4,7/8)'],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/8,-1/8,z)', '(5/8,-1/8,-z+3/4)', '(7/8,-7/8,-z)', '(3/8,-7/8,z+1/4)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/8,1/8)', '(-x+3/4,-1/8,5/8)', '(-x,-7/8,7/8)', '(x+1/4,-7/8,3/8)'],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,-1/2,1/2)', '(1/4,-1/2,1/4)', '(1/4,-1/4,1/2)', '(1/2,-1/4,1/4)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(3/4,0,3/4)', '(3/4,-3/4,0)', '(0,-3/4,3/4)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,-5/8,1/8)', '(7/8,-3/8,7/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '222', 'coords_xyz': ['(1/8,-1/8,1/8)', '(7/8,-7/8,7/8)']},
        },
    },
    (71, 'abc'): {
        'IT_number': 71,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x,y,0)', '(x,-y,0)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(-x,0,-z)', '(x,0,-z)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,y,-z)', '(0,-y,-z)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (71, 'ba-c'): {
        'IT_number': 71,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x,-y,0)', '(-x,y,0)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(0,-y,-z)', '(0,y,-z)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(x,0,-z)', '(-x,0,-z)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,3/4,-1/4)', '(1/4,3/4,-3/4)', '(3/4,1/4,-3/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,-1/2)', '(-x,0,-1/2)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,-1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,-1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (71, 'cab'): {
        'IT_number': 71,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y,z)', '(0,y,-z)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,-y,0)', '(-x,y,0)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,z)', '(-x,0,-z)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (71, '-cba'): {
        'IT_number': 71,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y,-z)', '(0,-y,z)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(x,0,-z)', '(-x,0,-z)', '(-x,0,z)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(x,-y,0)', '(-x,y,0)', '(-x,-y,0)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,1/4,1/4)', '(-1/4,3/4,3/4)', '(-3/4,1/4,3/4)', '(-3/4,3/4,1/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(-1/2,y,0)', '(-1/2,-y,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(0,1/2,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(-1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (71, 'bca'): {
        'IT_number': 71,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(x,y,-z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x,0,-z)', '(-x,0,z)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,-z)', '(0,-y,z)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(x,-y,0)', '(-x,-y,0)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/2)', '(0,-y,1/2)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,0,z)', '(1/2,0,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (71, 'a-cb'): {
        'IT_number': 71,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I m m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x,-y,z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x,y,-z)',
                    '(-x,y,z)',
                ],
            },
            'n': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x,0,z)', '(x,0,-z)']},
            'm': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,y,0)', '(-x,y,0)', '(-x,-y,0)', '(x,-y,0)']},
            'l': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(0,y,z)', '(0,y,-z)', '(0,-y,z)', '(0,-y,-z)']},
            'k': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,-1/4,1/4)', '(3/4,-1/4,3/4)', '(3/4,-3/4,1/4)', '(1/4,-3/4,3/4)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/2,y,0)', '(1/2,-y,0)']},
            'i': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,0)', '(0,-y,0)']},
            'h': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,-1/2,z)', '(0,-1/2,-z)']},
            'g': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(x,0,0)', '(-x,0,0)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,-1/2,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,-1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (72, 'abc'): {
        'IT_number': 72,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I b a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-x+1/2,y+1/2,0)', '(x+1/2,-y+1/2,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,-z)', '(1/2,0,z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y,1/4)', '(0,-y,3/4)', '(0,y,3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x,0,1/4)', '(-x,0,3/4)', '(x,0,3/4)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,3/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/4)', '(1/2,0,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (72, 'ba-c'): {
        'IT_number': 72,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I b a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(x+1/2,-y+1/2,0)', '(-x+1/2,y+1/2,0)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)', '(0,1/2,z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,-1/4)', '(-x,0,-1/4)', '(-x,0,-3/4)', '(x,0,-3/4)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/4)', '(0,-y,-1/4)', '(0,-y,-3/4)', '(0,y,-3/4)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,3/4,-1/4)', '(3/4,1/4,-3/4)', '(1/4,3/4,-3/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,-1/4)', '(0,1/2,-3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,0,-1/4)', '(0,0,-3/4)']},
        },
    },
    (72, 'cab'): {
        'IT_number': 72,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I m c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,y+1/2,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,-y+1/2,z+1/2)', '(0,y+1/2,-z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/2)', '(-x,1/2,0)', '(-x,0,1/2)', '(x,1/2,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)', '(-x,0,0)', '(x,1/2,1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,0,-z)', '(3/4,0,-z)', '(3/4,0,z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y,0)', '(3/4,-y,0)', '(3/4,y,0)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)']},
        },
    },
    (72, '-cba'): {
        'IT_number': 72,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I m c b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x,y,z)',
                    '(x,-y+1/2,z+1/2)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(0,y,z)', '(0,-y,-z)', '(0,y+1/2,-z+1/2)', '(0,-y+1/2,z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/2,0)', '(-x,0,1/2)', '(-x,1/2,0)', '(x,0,1/2)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,0)', '(-x,1/2,1/2)', '(-x,0,0)', '(x,1/2,1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,0)', '(-1/4,-y,0)', '(-3/4,-y,0)', '(-3/4,y,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,0,z)', '(-1/4,0,-z)', '(-3/4,0,-z)', '(-3/4,0,z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,1/4,1/4)', '(-1/4,3/4,3/4)', '(-3/4,3/4,1/4)', '(-3/4,1/4,3/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,0,1/2)', '(-3/4,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(-1/4,0,0)', '(-3/4,0,0)']},
        },
    },
    (72, 'bca'): {
        'IT_number': 72,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I c m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(-x+1/2,y,z+1/2)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(x+1/2,0,-z+1/2)', '(-x+1/2,0,z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/2,y,0)', '(0,-y,1/2)', '(1/2,-y,0)', '(0,y,1/2)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)', '(0,-y,0)', '(1/2,y,1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,0)', '(-x,3/4,0)', '(x,3/4,0)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(0,1/4,-z)', '(0,3/4,-z)', '(0,3/4,z)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,1/4,3/4)', '(3/4,3/4,1/4)', '(1/4,3/4,3/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,1/2)', '(0,3/4,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/4,0)', '(0,3/4,0)']},
        },
    },
    (72, 'a-cb'): {
        'IT_number': 72,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I c m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(-x,0,-z)', '(-x+1/2,0,z+1/2)', '(x+1/2,0,-z+1/2)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/2)', '(1/2,-y,0)', '(0,-y,1/2)', '(1/2,y,0)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,0)', '(1/2,-y,1/2)', '(0,-y,0)', '(1/2,y,1/2)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,-1/4,z)', '(0,-1/4,-z)', '(0,-3/4,-z)', '(0,-3/4,z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,0)', '(-x,-1/4,0)', '(-x,-3/4,0)', '(x,-3/4,0)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,-1/4,1/4)', '(3/4,-1/4,3/4)', '(1/4,-3/4,3/4)', '(3/4,-3/4,1/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(1/2,0,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 4, 'site_symmetry': '..2/m', 'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(1/2,-1/4,0)', '(1/2,-3/4,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,-1/4,0)', '(0,-3/4,0)']},
        },
    },
    (73, 'abc'): {
        'IT_number': 73,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z+1/2)', '(0,3/4,-z)', '(0,1/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,0)', '(1/4,-y,1/2)', '(3/4,-y,0)', '(3/4,y,1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)', '(-x,0,3/4)', '(x+1/2,0,1/4)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (73, 'ba-c'): {
        'IT_number': 73,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z-1/2)',
                    '(x+1/2,-y,-z-1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z-1/2)',
                    '(-x+1/2,y,z-1/2)',
                    '(x+1/2,-y+1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z-1/2)', '(3/4,0,-z)', '(1/4,0,z-1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,0)', '(-x,1/4,-1/2)', '(-x,3/4,0)', '(x,3/4,-1/2)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,y,-1/4)', '(0,-y+1/2,-3/4)', '(0,-y,-3/4)', '(0,y+1/2,-1/4)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,-1/4)', '(3/4,1/4,-3/4)', '(3/4,3/4,-1/4)', '(1/4,3/4,-3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,-1/2)', '(1/2,0,-1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (73, 'cab'): {
        'IT_number': 73,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)', '(-x,0,3/4)', '(x+1/2,0,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,1/4,z)', '(1/2,1/4,-z)', '(0,3/4,-z)', '(1/2,3/4,z)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y+1/2,0)', '(3/4,-y,0)', '(1/4,y+1/2,0)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
        },
    },
    (73, '-cba'): {
        'IT_number': 73,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x-1/2,-y,-z+1/2)',
                    '(-x-1/2,y+1/2,-z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x,-y,-z)',
                    '(-x-1/2,y,z+1/2)',
                    '(x-1/2,-y+1/2,z)',
                    '(x,y+1/2,-z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,1/4,0)', '(-x-1/2,3/4,0)', '(-x,3/4,0)', '(x-1/2,1/4,0)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(-1/2,-y,1/4)', '(0,-y,3/4)', '(-1/2,y,3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(-1/4,0,z)', '(-3/4,0,-z+1/2)', '(-3/4,0,-z)', '(-1/4,0,z+1/2)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(-1/4,1/4,1/4)', '(-3/4,3/4,1/4)', '(-1/4,3/4,3/4)', '(-3/4,1/4,3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(-1/2,0,1/2)', '(-1/2,1/2,0)', '(0,1/2,1/2)'],
            },
        },
    },
    (73, 'bca'): {
        'IT_number': 73,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I b c a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,-y,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(x+1/2,y,-z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(1/4,y,0)', '(3/4,-y+1/2,0)', '(3/4,-y,0)', '(1/4,y+1/2,0)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/4)', '(-x,1/2,1/4)', '(-x,0,3/4)', '(x,1/2,3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z+1/2)', '(0,3/4,-z)', '(0,1/4,z+1/2)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)'],
            },
        },
    },
    (73, 'a-cb'): {
        'IT_number': 73,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I c a b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y-1/2,-z)',
                    '(-x,-y-1/2,z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y-1/2,z)',
                    '(x,y-1/2,-z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(0,y,1/4)', '(0,-y-1/2,3/4)', '(0,-y,3/4)', '(0,y-1/2,1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,0,z)', '(1/4,-1/2,-z)', '(3/4,0,-z)', '(3/4,-1/2,z)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,-1/4,0)', '(-x+1/2,-3/4,0)', '(-x,-3/4,0)', '(x+1/2,-1/4,0)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,-1/4,1/4)', '(1/4,-3/4,3/4)', '(3/4,-1/4,3/4)', '(3/4,-3/4,1/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,-1/2,0)', '(0,-1/2,1/2)', '(1/2,0,1/2)'],
            },
        },
    },
    (74, 'abc'): {
        'IT_number': 74,
        'setting': 0,
        'IT_coordinate_system_code': 'abc',
        'name_H-M_alt': 'I m m a',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z)',
                    '(-x,y+1/2,-z)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,y+1/2,-z)',
                    '(x,-y+1/2,z)',
                    '(-x,y,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(-x,1/4,z)', '(-x,3/4,-z)', '(x,3/4,-z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,-y+1/2,z)', '(0,y+1/2,-z)', '(0,-y,-z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,y,1/4)', '(3/4,-y+1/2,1/4)', '(3/4,-y,3/4)', '(1/4,y+1/2,3/4)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,1/2,0)', '(-x,0,0)', '(x,1/2,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,1/4,z)', '(0,3/4,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,1/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (74, 'ba-c'): {
        'IT_number': 74,
        'setting': 1,
        'IT_coordinate_system_code': 'ba-c',
        'name_H-M_alt': 'I m m b',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z)',
                    '(x+1/2,-y,-z)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z)',
                    '(-x+1/2,y,z)',
                    '(x,-y,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,-y,z)', '(3/4,-y,-z)', '(3/4,y,-z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(-x+1/2,0,z)', '(x+1/2,0,-z)', '(-x,0,-z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,-1/4)', '(-x+1/2,3/4,-1/4)', '(-x,3/4,-3/4)', '(x+1/2,1/4,-3/4)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(1/2,-y,0)', '(0,-y,0)', '(1/2,y,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,0,z)', '(3/4,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,-3/4)', '(1/4,3/4,-3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,-1/4)', '(1/4,3/4,-1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,-1/2)', '(1/2,0,-1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (74, 'cab'): {
        'IT_number': 74,
        'setting': 2,
        'IT_coordinate_system_code': 'cab',
        'name_H-M_alt': 'I b m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(-x,y,-z)',
                    '(-x,-y,-z)',
                    '(-x,y,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(x,-y,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(x,-y,1/4)', '(-x,-y,3/4)', '(-x,y,3/4)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,0,z)', '(x,0,-z+1/2)', '(-x,0,z+1/2)', '(-x,0,-z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,3/4,-z+1/2)', '(3/4,3/4,-z)', '(3/4,1/4,z+1/2)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,y,0)', '(0,-y,1/2)', '(0,-y,0)', '(0,y,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,0,1/4)', '(-x,0,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(3/4,1/4,1/4)', '(3/4,3/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(1/2,0,0)', '(1/2,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (74, '-cba'): {
        'IT_number': 74,
        'setting': 3,
        'IT_coordinate_system_code': '-cba',
        'name_H-M_alt': 'I c m m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(x,-y+1/2,-z)',
                    '(-x,y+1/2,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(-x,y+1/2,z)',
                    '(x,-y+1/2,z)',
                    '(x,y,-z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/4,z)', '(x,1/4,-z)', '(-x,3/4,-z)', '(-x,3/4,z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(x,-y+1/2,0)', '(-x,y+1/2,0)', '(-x,-y,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(-1/4,y,1/4)', '(-1/4,-y+1/2,3/4)', '(-3/4,-y,3/4)', '(-3/4,y+1/2,1/4)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,-z)', '(0,0,-z)', '(0,1/2,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,1/4,0)', '(-x,3/4,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-3/4,1/4,1/4)', '(-3/4,1/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(-1/4,1/4,1/4)', '(-1/4,1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(-1/2,0,0)', '(-1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,1/2,0)']},
        },
    },
    (74, 'bca'): {
        'IT_number': 74,
        'setting': 4,
        'IT_coordinate_system_code': 'bca',
        'name_H-M_alt': 'I m c m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,y,-z)',
                    '(x+1/2,-y,-z)',
                    '(-x,-y,z)',
                    '(-x,-y,-z)',
                    '(x+1/2,-y,z)',
                    '(-x+1/2,y,z)',
                    '(x,y,-z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(1/4,y,z)', '(1/4,y,-z)', '(3/4,-y,-z)', '(3/4,-y,z)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x+1/2,y,0)', '(x+1/2,-y,0)', '(-x,-y,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/4)', '(-x+1/2,1/4,3/4)', '(-x,3/4,3/4)', '(x+1/2,3/4,1/4)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(1/2,0,-z)', '(0,0,-z)', '(1/2,0,z)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(1/4,y,0)', '(3/4,-y,0)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,3/4,1/4)', '(1/4,3/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(1/2,0,0)']},
        },
    },
    (74, 'a-cb'): {
        'IT_number': 74,
        'setting': 5,
        'IT_coordinate_system_code': 'a-cb',
        'name_H-M_alt': 'I m a m',
        'crystal_system': 'orthorhombic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,y,-z+1/2)',
                    '(-x,-y,z+1/2)',
                    '(x,-y,-z)',
                    '(-x,-y,-z)',
                    '(x,-y,z+1/2)',
                    '(x,y,-z+1/2)',
                    '(-x,y,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,y,1/4)', '(-x,y,1/4)', '(-x,-y,3/4)', '(x,-y,3/4)'],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(0,y,z)', '(0,y,-z+1/2)', '(0,-y,z+1/2)', '(0,-y,-z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/4,-1/4,z)', '(3/4,-1/4,-z+1/2)', '(3/4,-3/4,-z)', '(1/4,-3/4,z+1/2)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '2..', 'coords_xyz': ['(x,0,0)', '(-x,0,1/2)', '(-x,0,0)', '(x,0,1/2)']},
            'e': {'multiplicity': 4, 'site_symmetry': 'mm2', 'coords_xyz': ['(0,y,1/4)', '(0,-y,3/4)']},
            'd': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,-3/4,1/4)', '(3/4,-3/4,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '.2/m.', 'coords_xyz': ['(1/4,-1/4,1/4)', '(3/4,-1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,-1/2,0)', '(0,-1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (79, '1'): {
        'IT_number': 79,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'c': {'multiplicity': 8, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-y,x,z)', '(y,-x,z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (80, '1'): {
        'IT_number': 80,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x+1/2,-y+1/2,z+1/2)', '(-y,x+1/2,z+1/4)', '(y+1/2,-x,z+3/4)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '2..', 'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)']},
        },
    },
    (87, '1'): {
        'IT_number': 87,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                ],
            },
            'h': {'multiplicity': 8, 'site_symmetry': 'm..', 'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-y,x,0)', '(y,-x,0)']},
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,1/4)', '(1/4,3/4,1/4)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '2/m..', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (88, '1'): {
        'IT_number': 88,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41/a',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(-x,-y+1/2,-z+1/4)',
                    '(x+1/2,y,-z+3/4)',
                    '(y,-x,-z)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)', '(0,1/2,-z+1/4)', '(0,0,-z)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,5/8)', '(1/2,1/4,1/8)', '(3/4,1/2,7/8)', '(3/4,0,3/8)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,1/4,1/8)', '(1/2,1/4,5/8)', '(3/4,1/2,3/8)', '(3/4,0,7/8)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/4)']},
        },
    },
    (88, '2'): {
        'IT_number': 88,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'I 41/a',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-y+3/4,x+1/4,z+1/4)',
                    '(y+3/4,-x+3/4,z+3/4)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(y+1/4,-x+3/4,-z+3/4)',
                    '(-y+1/4,x+1/4,-z+1/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/4,z)', '(1/2,1/4,z+1/4)', '(0,3/4,-z)', '(1/2,3/4,-z+3/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)', '(3/4,1/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(3/4,1/4,1/4)', '(3/4,3/4,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,1/4,5/8)', '(1/2,1/4,7/8)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,1/4,1/8)', '(1/2,1/4,3/8)']},
        },
    },
    (89, '1'): {
        'IT_number': 89,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,x,0)', '(1/2,-x,0)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,x,1/2)', '(0,-x,1/2)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,1/2)', '(1/2,-x,1/2)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)']},
            'k': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(-x,x,1/2)', '(x,-x,1/2)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x,x,0)', '(x,-x,0)']},
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '422', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '422', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '422', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (90, '1'): {
        'IT_number': 90,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 21 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z)',
                    '(y+1/2,-x+1/2,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(-x+1/2,x+1/2,1/2)', '(x+1/2,-x+1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x+1/2,x+1/2,0)', '(x+1/2,-x+1/2,0)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)', '(1/2,1/2,-z)', '(0,0,-z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (91, '1'): {
        'IT_number': 91,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 41 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-y,x,z+1/4)',
                    '(y,-x,z+3/4)',
                    '(-x,y,-z)',
                    '(x,-y,-z+1/2)',
                    '(y,x,-z+3/4)',
                    '(-y,-x,-z+1/4)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,3/8)', '(-x,-x,7/8)', '(-x,x,5/8)', '(x,-x,1/8)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,1/2)', '(-y,1/2,1/4)', '(y,1/2,3/4)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,1/2)', '(-y,0,1/4)', '(y,0,3/4)'],
            },
        },
    },
    (92, '1'): {
        'IT_number': 92,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 41 21 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-y+1/2,x+1/2,z+1/4)',
                    '(y+1/2,-x+1/2,z+3/4)',
                    '(-x+1/2,y+1/2,-z+1/4)',
                    '(x+1/2,-y+1/2,-z+3/4)',
                    '(y,x,-z)',
                    '(-y,-x,-z+1/2)',
                ],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,1/2)', '(-x+1/2,x+1/2,1/4)', '(x+1/2,-x+1/2,3/4)'],
            },
        },
    },
    (93, '1'): {
        'IT_number': 93,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                ],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,3/4)', '(-x,-x,3/4)', '(-x,x,1/4)', '(x,-x,1/4)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/4)', '(-x,-x,1/4)', '(-x,x,3/4)', '(x,-x,3/4)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,x,1/2)', '(1/2,-x,1/2)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,x,0)', '(0,-x,0)']},
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,0)', '(1/2,-x,0)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,1/2)', '(0,-x,1/2)']},
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)', '(0,1/2,-z)', '(1/2,0,-z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z)', '(1/2,1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z)', '(0,0,-z+1/2)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (94, '1'): {
        'IT_number': 94,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 21 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(-x+1/2,x+1/2,0)', '(x+1/2,-x+1/2,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x+1/2,x+1/2,1/2)', '(x+1/2,-x+1/2,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)', '(1/2,0,-z+1/2)', '(1/2,0,-z)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)', '(0,0,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (95, '1'): {
        'IT_number': 95,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 43 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-y,x,z+3/4)',
                    '(y,-x,z+1/4)',
                    '(-x,y,-z)',
                    '(x,-y,-z+1/2)',
                    '(y,x,-z+1/4)',
                    '(-y,-x,-z+3/4)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,5/8)', '(-x,-x,1/8)', '(-x,x,3/8)', '(x,-x,7/8)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,y,0)', '(1/2,-y,1/2)', '(-y,1/2,3/4)', '(y,1/2,1/4)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,0)', '(0,-y,1/2)', '(-y,0,3/4)', '(y,0,1/4)'],
            },
        },
    },
    (96, '1'): {
        'IT_number': 96,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 43 21 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z+1/2)',
                    '(-y+1/2,x+1/2,z+3/4)',
                    '(y+1/2,-x+1/2,z+1/4)',
                    '(-x+1/2,y+1/2,-z+3/4)',
                    '(x+1/2,-y+1/2,-z+1/4)',
                    '(y,x,-z)',
                    '(-y,-x,-z+1/2)',
                ],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,1/2)', '(-x+1/2,x+1/2,3/4)', '(x+1/2,-x+1/2,1/4)'],
            },
        },
    },
    (97, '1'): {
        'IT_number': 97,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,1/4)', '(-x,-x+1/2,1/4)', '(-x+1/2,x,1/4)', '(x+1/2,-x,1/4)'],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,x,1/2)', '(0,-x,1/2)'],
            },
            'h': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)']},
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x,x,0)', '(x,-x,0)']},
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (98, '1'): {
        'IT_number': 98,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41 2 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(-x+1/2,y,-z+3/4)',
                    '(x,-y+1/2,-z+1/4)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y,-x,-z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/8)', '(-x+1/2,1/4,5/8)', '(3/4,x+1/2,3/8)', '(3/4,-x,7/8)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,-x,0)', '(-x+1/2,x+1/2,1/2)', '(x,x+1/2,1/4)', '(-x+1/2,-x,3/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,0)', '(-x+1/2,-x+1/2,1/2)', '(-x,x+1/2,1/4)', '(x+1/2,-x,3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)', '(1/2,0,-z+3/4)', '(1/2,1/2,-z+1/2)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/4)']},
        },
    },
    (99, '1'): {
        'IT_number': 99,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 m m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-y,x,z)', '(y,-x,z)', '(x,-y,z)', '(-x,y,z)', '(-y,-x,z)', '(y,x,z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)', '(1/2,x,z)', '(1/2,-x,z)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,x,z)', '(0,-x,z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(-x,x,z)', '(x,-x,z)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)']},
            'b': {'multiplicity': 1, 'site_symmetry': '4mm', 'coords_xyz': ['(1/2,1/2,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': '4mm', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (100, '1'): {
        'IT_number': 100,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 b m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,x+1/2,z)', '(-x,-x+1/2,z)', '(-x+1/2,x,z)', '(x+1/2,-x,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)']},
        },
    },
    (101, '1'): {
        'IT_number': 101,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 c m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(-x,x,z+1/2)', '(x,-x,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)', '(0,1/2,z+1/2)', '(1/2,0,z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (102, '1'): {
        'IT_number': 102,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 n m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(-x+1/2,x+1/2,z+1/2)', '(x+1/2,-x+1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)', '(1/2,0,z+1/2)', '(1/2,0,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)']},
        },
    },
    (103, '1'): {
        'IT_number': 103,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 c c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,z+1/2)', '(1/2,0,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (104, '1'): {
        'IT_number': 104,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 n c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(1/2,0,z+1/2)', '(0,1/2,z+1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)']},
        },
    },
    (105, '1'): {
        'IT_number': 105,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 m c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)', '(1/2,x,z+1/2)', '(1/2,-x,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,x,z+1/2)', '(0,-x,z+1/2)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (106, '1'): {
        'IT_number': 106,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 b c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)', '(1/2,0,z)', '(0,1/2,z+1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(1/2,1/2,z)', '(1/2,1/2,z+1/2)'],
            },
        },
    },
    (107, '1'): {
        'IT_number': 107,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4 m m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-x,-y,z)', '(-y,x,z)', '(y,-x,z)', '(x,-y,z)', '(-x,y,z)', '(-y,-x,z)', '(y,x,z)'],
            },
            'd': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,x,z)', '(0,-x,z)']},
            'c': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(-x,x,z)', '(x,-x,z)']},
            'b': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4mm', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (108, '1'): {
        'IT_number': 108,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4 c e',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,x+1/2,z)', '(-x,-x+1/2,z)', '(-x+1/2,x,z)', '(x+1/2,-x,z)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '2.m', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)']},
            'a': {'multiplicity': 4, 'site_symmetry': '4..', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (109, '1'): {
        'IT_number': 109,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41 m d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(x,-y,z)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y,-x+1/2,z+1/4)',
                    '(y+1/2,x,z+3/4)',
                ],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(1/2,-y+1/2,z+1/2)', '(-y,1/2,z+1/4)', '(y+1/2,0,z+3/4)'],
            },
            'a': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)']},
        },
    },
    (110, '1'): {
        'IT_number': 110,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41 c d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(x,-y,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y,-x+1/2,z+3/4)',
                    '(y+1/2,x,z+1/4)',
                ],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)', '(0,0,z+1/2)', '(0,1/2,z+3/4)'],
            },
        },
    },
    (111, '1'): {
        'IT_number': 111,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 2 m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'n': {'multiplicity': 4, 'site_symmetry': '..m', 'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(x,-x,-z)', '(-x,x,-z)']},
            'm': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,-z)', '(1/2,0,z)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,-x,0)', '(1/2,x,0)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,-x,1/2)', '(0,x,1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,-x,1/2)', '(1/2,x,1/2)'],
            },
            'i': {'multiplicity': 4, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,-x,0)', '(0,x,0)']},
            'h': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '-42m', 'coords_xyz': ['(1/2,1/2,0)']},
            'c': {'multiplicity': 1, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-42m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (112, '1'): {
        'IT_number': 112,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 2 c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,-z+1/2)', '(1/2,0,z+1/2)'],
            },
            'l': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,0,-z+1/2)', '(0,0,z+1/2)'],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(0,y,1/4)', '(0,-y,1/4)', '(y,0,3/4)', '(-y,0,3/4)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/2,1/4)', '(-x,1/2,1/4)', '(1/2,-x,3/4)', '(1/2,x,3/4)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(1/2,y,1/4)', '(1/2,-y,1/4)', '(y,1/2,3/4)', '(-y,1/2,3/4)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/4)', '(-x,0,1/4)', '(0,-x,3/4)', '(0,x,3/4)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'e': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'd': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/4)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (113, '1'): {
        'IT_number': 113,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 21 m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,x+1/2,z)', '(-x,-x+1/2,z)', '(x+1/2,-x,-z)', '(-x+1/2,x,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z)', '(1/2,1/2,z)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': '2.m', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (114, '1'): {
        'IT_number': 114,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 21 c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(1/2,0,-z+1/2)', '(0,1/2,z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (115, '1'): {
        'IT_number': 115,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 m 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'k': {
                'multiplicity': 4,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,1/2,z)', '(-x,1/2,z)', '(1/2,-x,-z)', '(1/2,x,-z)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,-x,-z)', '(0,x,-z)']},
            'i': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(x,-x,1/2)', '(-x,x,1/2)'],
            },
            'h': {'multiplicity': 4, 'site_symmetry': '..2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(x,-x,0)', '(-x,x,0)']},
            'g': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'e': {'multiplicity': 2, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 1, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '-4m2', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-4m2', 'coords_xyz': ['(1/2,1/2,0)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (116, '1'): {
        'IT_number': 116,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 c 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                ],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,z+1/2)', '(1/2,0,-z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,0,z+1/2)', '(0,0,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,3/4)', '(-x,-x,3/4)', '(x,-x,1/4)', '(-x,x,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/4)', '(-x,-x,1/4)', '(x,-x,3/4)', '(-x,x,3/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (117, '1'): {
        'IT_number': 117,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 b 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y+1/2,-x+1/2,-z)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,1/2)', '(-x,-x+1/2,1/2)', '(x+1/2,-x,1/2)', '(-x+1/2,x,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,0)', '(-x,-x+1/2,0)', '(x+1/2,-x,0)', '(-x+1/2,x,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(1/2,0,z)', '(0,1/2,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,z)', '(1/2,1/2,-z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (118, '1'): {
        'IT_number': 118,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 n 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 8,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(1/2,0,z+1/2)', '(0,1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,1/4)', '(-x,-x+1/2,1/4)', '(x+1/2,-x,3/4)', '(-x+1/2,x,3/4)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,-x+1/2,1/4)', '(-x,x+1/2,1/4)', '(-x+1/2,-x,3/4)', '(x+1/2,x,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,3/4)', '(1/2,0,1/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (119, '1'): {
        'IT_number': 119,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 m 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                ],
            },
            'i': {'multiplicity': 8, 'site_symmetry': '.m.', 'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,-x,-z)', '(0,x,-z)']},
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,1/4)', '(-x,-x+1/2,1/4)', '(x+1/2,-x,3/4)', '(-x+1/2,x,3/4)'],
            },
            'g': {'multiplicity': 8, 'site_symmetry': '..2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(x,-x,0)', '(-x,x,0)']},
            'f': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,1/2,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,1/2,1/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (120, '1'): {
        'IT_number': 120,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 c 2',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x+1/2,0)', '(-x,-x+1/2,0)', '(x+1/2,-x,0)', '(-x+1/2,x,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,z+1/2)', '(1/2,0,-z+1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(0,0,z+1/2)', '(0,0,-z+1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,x,1/4)', '(-x,-x,1/4)', '(x,-x,3/4)', '(-x,x,3/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '2.2', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '2.2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (121, '1'): {
        'IT_number': 121,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 2 m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'i': {'multiplicity': 8, 'site_symmetry': '..m', 'coords_xyz': ['(x,x,z)', '(-x,-x,z)', '(x,-x,-z)', '(-x,x,-z)']},
            'h': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)', '(0,1/2,-z)', '(1/2,0,z)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,-x,1/2)', '(0,x,1/2)'],
            },
            'f': {'multiplicity': 8, 'site_symmetry': '.2.', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,-x,0)', '(0,x,0)']},
            'e': {'multiplicity': 4, 'site_symmetry': '2.m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (122, '1'): {
        'IT_number': 122,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 2 d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(-x+1/2,y,-z+3/4)',
                    '(x+1/2,-y,-z+3/4)',
                    '(-y+1/2,-x,z+3/4)',
                    '(y+1/2,x,z+3/4)',
                ],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,1/4,1/8)', '(-x,3/4,1/8)', '(1/4,-x,7/8)', '(3/4,x,7/8)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,0,-z+3/4)', '(1/2,0,z+3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,1/2)', '(1/2,0,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-4..', 'coords_xyz': ['(0,0,0)', '(1/2,0,3/4)']},
        },
    },
    (123, '1'): {
        'IT_number': 123,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/m 2/m 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'u': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            't': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(x,1/2,z)',
                    '(-x,1/2,z)',
                    '(1/2,x,z)',
                    '(1/2,-x,z)',
                    '(-x,1/2,-z)',
                    '(x,1/2,-z)',
                    '(1/2,x,-z)',
                    '(1/2,-x,-z)',
                ],
            },
            's': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,0,z)', '(-x,0,z)', '(0,x,z)', '(0,-x,z)', '(-x,0,-z)', '(x,0,-z)', '(0,x,-z)', '(0,-x,-z)'],
            },
            'r': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,z)',
                    '(x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,1/2)',
                    '(-x,-y,1/2)',
                    '(-y,x,1/2)',
                    '(y,-x,1/2)',
                    '(-x,y,1/2)',
                    '(x,-y,1/2)',
                    '(y,x,1/2)',
                    '(-y,-x,1/2)',
                ],
            },
            'p': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-y,x,0)', '(y,-x,0)', '(-x,y,0)', '(x,-y,0)', '(y,x,0)', '(-y,-x,0)'],
            },
            'o': {
                'multiplicity': 4,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,1/2)', '(1/2,-x,1/2)'],
            },
            'n': {
                'multiplicity': 4,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,x,0)', '(1/2,-x,0)'],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,x,1/2)', '(0,-x,1/2)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)']},
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(-x,x,1/2)', '(x,-x,1/2)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'm.2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x,x,0)', '(x,-x,0)']},
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'h': {'multiplicity': 2, 'site_symmetry': '4mm', 'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': '4mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'd': {'multiplicity': 1, 'site_symmetry': '4/mmm', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '4/mmm', 'coords_xyz': ['(1/2,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '4/mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '4/mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (124, '1'): {
        'IT_number': 124,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/m 2/c 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,0)',
                    '(y,-x,0)',
                    '(-x,y,1/2)',
                    '(x,-y,1/2)',
                    '(y,x,1/2)',
                    '(-y,-x,1/2)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/2,1/4)',
                    '(-x,1/2,1/4)',
                    '(1/2,x,1/4)',
                    '(1/2,-x,1/4)',
                    '(-x,1/2,3/4)',
                    '(x,1/2,3/4)',
                    '(1/2,-x,3/4)',
                    '(1/2,x,3/4)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x,0,1/4)',
                    '(0,x,1/4)',
                    '(0,-x,1/4)',
                    '(-x,0,3/4)',
                    '(x,0,3/4)',
                    '(0,-x,3/4)',
                    '(0,x,3/4)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x,x,1/4)',
                    '(x,-x,1/4)',
                    '(-x,-x,3/4)',
                    '(x,x,3/4)',
                    '(x,-x,3/4)',
                    '(-x,x,3/4)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(1/2,0,z)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,-z+1/2)',
                    '(0,1/2,-z)',
                    '(1/2,0,-z)',
                    '(0,1/2,z+1/2)',
                    '(1/2,0,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,-z)', '(1/2,1/2,z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)', '(0,1/2,3/4)', '(1/2,0,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)', '(0,1/2,1/2)', '(1/2,0,1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (125, '1'): {
        'IT_number': 125,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/n 2/b 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x+1/2,-z)',
                    '(-y+1/2,x+1/2,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x+1/2,z)',
                    '(-x,-x+1/2,z)',
                    '(-x+1/2,x,z)',
                    '(x+1/2,-x,z)',
                    '(-x,x+1/2,-z)',
                    '(x,-x+1/2,-z)',
                    '(x+1/2,x,-z)',
                    '(-x+1/2,-x,-z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(1/2,x+1/2,1/2)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(-x+1/2,1/2,0)',
                    '(x+1/2,1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(1/2,x+1/2,0)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/2)',
                    '(-x,-x,1/2)',
                    '(-x,x,1/2)',
                    '(x,-x,1/2)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,x+1/2,1/2)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x,-x,0)',
                    '(-x,x,0)',
                    '(x,-x,0)',
                    '(-x+1/2,-x+1/2,0)',
                    '(x+1/2,x+1/2,0)',
                    '(x+1/2,-x+1/2,0)',
                    '(-x+1/2,x+1/2,0)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z)', '(1/2,1/2,z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)', '(3/4,1/4,1/2)', '(1/4,3/4,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(3/4,1/4,0)', '(1/4,3/4,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (125, '2'): {
        'IT_number': 125,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 4/n 2/b 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z)',
                    '(y,-x+1/2,z)',
                    '(-x+1/2,y,-z)',
                    '(x,-y+1/2,-z)',
                    '(y,x,-z)',
                    '(-y+1/2,-x+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z)',
                    '(-y,x+1/2,-z)',
                    '(x+1/2,-y,z)',
                    '(-x,y+1/2,z)',
                    '(-y,-x,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,-x,z)',
                    '(-x+1/2,x+1/2,z)',
                    '(x+1/2,x,z)',
                    '(-x,-x+1/2,z)',
                    '(-x+1/2,-x,-z)',
                    '(x,x+1/2,-z)',
                    '(-x,x,-z)',
                    '(x+1/2,-x+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,1/2)',
                    '(-x+1/2,1/4,1/2)',
                    '(1/4,x,1/2)',
                    '(1/4,-x+1/2,1/2)',
                    '(-x,3/4,1/2)',
                    '(x+1/2,3/4,1/2)',
                    '(3/4,-x,1/2)',
                    '(3/4,x+1/2,1/2)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,0)',
                    '(-x+1/2,1/4,0)',
                    '(1/4,x,0)',
                    '(1/4,-x+1/2,0)',
                    '(-x,3/4,0)',
                    '(x+1/2,3/4,0)',
                    '(3/4,-x,0)',
                    '(3/4,x+1/2,0)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/2)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,x,1/2)',
                    '(x,-x+1/2,1/2)',
                    '(-x,-x,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x,1/2)',
                    '(-x,x+1/2,1/2)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x+1/2,-x+1/2,0)',
                    '(-x+1/2,x,0)',
                    '(x,-x+1/2,0)',
                    '(-x,-x,0)',
                    '(x+1/2,x+1/2,0)',
                    '(x+1/2,-x,0)',
                    '(-x,x+1/2,0)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,z)', '(3/4,1/4,-z)', '(1/4,3/4,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z)', '(3/4,3/4,-z)', '(3/4,3/4,z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(3/4,1/4,1/2)', '(1/4,3/4,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)']},
        },
    },
    (126, '1'): {
        'IT_number': 126,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/n 2/n 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(-x+1/2,1/2,0)',
                    '(x+1/2,1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(1/2,x+1/2,0)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(-x+1/2,1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(1/2,x+1/2,1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x,-x,0)',
                    '(-x,x,0)',
                    '(x,-x,0)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/2,0,z)',
                    '(0,1/2,z)',
                    '(1/2,0,-z)',
                    '(0,1/2,-z)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,-z+1/2)',
                    '(0,1/2,z+1/2)',
                    '(1/2,0,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(1/4,1/4,1/4)',
                    '(3/4,3/4,1/4)',
                    '(3/4,1/4,1/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,1/4,3/4)',
                    '(1/4,3/4,3/4)',
                    '(1/4,1/4,3/4)',
                    '(3/4,3/4,3/4)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/2,0,1/4)', '(0,1/2,1/4)', '(1/2,0,3/4)', '(0,1/2,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (126, '2'): {
        'IT_number': 126,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 4/n 2/n 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z)',
                    '(y,-x+1/2,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z)',
                    '(-y,x+1/2,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,3/4,1/4)',
                    '(-x+1/2,3/4,1/4)',
                    '(3/4,x,1/4)',
                    '(3/4,-x+1/2,1/4)',
                    '(-x,1/4,3/4)',
                    '(x+1/2,1/4,3/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,x+1/2,3/4)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x+1/2,1/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x+1/2,1/4)',
                    '(-x,3/4,3/4)',
                    '(x+1/2,3/4,3/4)',
                    '(3/4,-x,3/4)',
                    '(3/4,x+1/2,3/4)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x+1/2,-x+1/2,1/4)',
                    '(-x+1/2,x,1/4)',
                    '(x,-x+1/2,1/4)',
                    '(-x,-x,3/4)',
                    '(x+1/2,x+1/2,3/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x,x+1/2,3/4)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/4,3/4,z)',
                    '(3/4,1/4,z)',
                    '(1/4,3/4,-z+1/2)',
                    '(3/4,1/4,-z+1/2)',
                    '(3/4,1/4,-z)',
                    '(1/4,3/4,-z)',
                    '(3/4,1/4,z+1/2)',
                    '(1/4,3/4,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,1/2,0)',
                    '(1/2,0,0)',
                    '(0,1/2,0)',
                    '(1/2,0,1/2)',
                    '(0,1/2,1/2)',
                    '(0,0,1/2)',
                    '(1/2,1/2,1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,-z+1/2)', '(3/4,3/4,-z)', '(3/4,3/4,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/4,3/4,0)', '(3/4,1/4,0)', '(1/4,3/4,1/2)', '(3/4,1/4,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(1/4,3/4,3/4)', '(3/4,1/4,3/4)', '(3/4,1/4,1/4)', '(1/4,3/4,1/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,3/4,1/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '422', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (127, '1'): {
        'IT_number': 127,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/m 21/b 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y+1/2,-x+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x+1/2,z)',
                    '(-x,-x+1/2,z)',
                    '(-x+1/2,x,z)',
                    '(x+1/2,-x,z)',
                    '(-x+1/2,x,-z)',
                    '(x+1/2,-x,-z)',
                    '(x,x+1/2,-z)',
                    '(-x,-x+1/2,-z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,1/2)',
                    '(-x,-y,1/2)',
                    '(-y,x,1/2)',
                    '(y,-x,1/2)',
                    '(-x+1/2,y+1/2,1/2)',
                    '(x+1/2,-y+1/2,1/2)',
                    '(y+1/2,x+1/2,1/2)',
                    '(-y+1/2,-x+1/2,1/2)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,0)',
                    '(y,-x,0)',
                    '(-x+1/2,y+1/2,0)',
                    '(x+1/2,-y+1/2,0)',
                    '(y+1/2,x+1/2,0)',
                    '(-y+1/2,-x+1/2,0)',
                ],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x+1/2,1/2)', '(-x,-x+1/2,1/2)', '(-x+1/2,x,1/2)', '(x+1/2,-x,1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x+1/2,0)', '(-x,-x+1/2,0)', '(-x+1/2,x,0)', '(x+1/2,-x,0)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(1/2,0,-z)', '(0,1/2,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z)', '(0,0,-z)', '(1/2,1/2,z)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (128, '1'): {
        'IT_number': 128,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/m 21/n 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,0)',
                    '(y,-x,0)',
                    '(-x+1/2,y+1/2,1/2)',
                    '(x+1/2,-y+1/2,1/2)',
                    '(y+1/2,x+1/2,1/2)',
                    '(-y+1/2,-x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,1/4)',
                    '(-x,-x+1/2,1/4)',
                    '(-x+1/2,x,1/4)',
                    '(x+1/2,-x,1/4)',
                    '(-x,-x+1/2,3/4)',
                    '(x,x+1/2,3/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x+1/2,x,3/4)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(1/2,0,z)',
                    '(1/2,0,-z+1/2)',
                    '(0,1/2,-z+1/2)',
                    '(0,1/2,-z)',
                    '(1/2,0,-z)',
                    '(1/2,0,z+1/2)',
                    '(0,1/2,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,-z+1/2)', '(0,0,-z)', '(1/2,1/2,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)', '(0,1/2,3/4)', '(1/2,0,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (129, '1'): {
        'IT_number': 129,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/n 21/m 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z)',
                    '(y+1/2,-x+1/2,z)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x+1/2,z)',
                    '(-x,-x+1/2,z)',
                    '(-x,x+1/2,z)',
                    '(x,-x+1/2,z)',
                    '(-x+1/2,x,-z)',
                    '(x+1/2,-x,-z)',
                    '(x+1/2,x,-z)',
                    '(-x+1/2,-x,-z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(-y+1/2,1/2,z)',
                    '(y+1/2,1/2,z)',
                    '(1/2,y+1/2,-z)',
                    '(1/2,-y+1/2,-z)',
                    '(y,0,-z)',
                    '(-y,0,-z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/2)',
                    '(-x,-x,1/2)',
                    '(-x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x,-x,1/2)',
                    '(-x,x,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x,-x,0)',
                    '(-x+1/2,x+1/2,0)',
                    '(x+1/2,-x+1/2,0)',
                    '(-x+1/2,-x+1/2,0)',
                    '(x+1/2,x+1/2,0)',
                    '(x,-x,0)',
                    '(-x,x,0)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z)', '(1/2,1/2,-z)', '(0,0,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/2)', '(3/4,3/4,1/2)', '(1/4,3/4,1/2)', '(3/4,1/4,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,0)', '(3/4,3/4,0)', '(1/4,3/4,0)', '(3/4,1/4,0)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': '4mm', 'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)']},
        },
    },
    (129, '2'): {
        'IT_number': 129,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 4/n 21/m 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z)',
                    '(y,-x+1/2,z)',
                    '(-x,y+1/2,-z)',
                    '(x+1/2,-y,-z)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z)',
                    '(-y,x+1/2,-z)',
                    '(x,-y+1/2,z)',
                    '(-x+1/2,y,z)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y,x,z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x+1/2,-x+1/2,z)',
                    '(-x+1/2,x,z)',
                    '(x,-x+1/2,z)',
                    '(-x,x+1/2,-z)',
                    '(x+1/2,-x,-z)',
                    '(x+1/2,x+1/2,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(1/4,y,z)',
                    '(1/4,-y+1/2,z)',
                    '(-y+1/2,1/4,z)',
                    '(y,1/4,z)',
                    '(3/4,y+1/2,-z)',
                    '(3/4,-y,-z)',
                    '(y+1/2,3/4,-z)',
                    '(-y,3/4,-z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,1/2)',
                    '(-x+1/2,x+1/2,1/2)',
                    '(x+1/2,x,1/2)',
                    '(-x,-x+1/2,1/2)',
                    '(-x,x,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,-x,1/2)',
                    '(x,x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,0)',
                    '(-x+1/2,x+1/2,0)',
                    '(x+1/2,x,0)',
                    '(-x,-x+1/2,0)',
                    '(-x,x,0)',
                    '(x+1/2,-x+1/2,0)',
                    '(-x+1/2,-x,0)',
                    '(x,x+1/2,0)',
                ],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,z)', '(1/4,3/4,-z)', '(3/4,1/4,-z)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'c': {'multiplicity': 2, 'site_symmetry': '4mm', 'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(3/4,1/4,1/2)', '(1/4,3/4,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,0)']},
        },
    },
    (130, '1'): {
        'IT_number': 130,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/n 21/c 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z)',
                    '(y+1/2,-x+1/2,z)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x+1/2,-y+1/2,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x+1/2,x+1/2,1/4)',
                    '(x+1/2,-x+1/2,1/4)',
                    '(-x+1/2,-x+1/2,3/4)',
                    '(x+1/2,x+1/2,3/4)',
                    '(x,-x,3/4)',
                    '(-x,x,3/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,0,z)',
                    '(1/2,1/2,z)',
                    '(1/2,1/2,-z+1/2)',
                    '(0,0,-z+1/2)',
                    '(1/2,1/2,-z)',
                    '(0,0,-z)',
                    '(0,0,z+1/2)',
                    '(1/2,1/2,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(1/4,1/4,0)',
                    '(3/4,3/4,0)',
                    '(1/4,3/4,0)',
                    '(3/4,1/4,0)',
                    '(1/4,3/4,1/2)',
                    '(3/4,1/4,1/2)',
                    '(1/4,1/4,1/2)',
                    '(3/4,3/4,1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,-z+1/2)', '(1/2,0,-z)', '(0,1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,1/2,1/2)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,0,1/4)', '(1/2,1/2,1/4)', '(1/2,1/2,3/4)', '(0,0,3/4)'],
            },
        },
    },
    (130, '2'): {
        'IT_number': 130,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 4/n 21/c 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z)',
                    '(y,-x+1/2,z)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z)',
                    '(-y,x+1/2,-z)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,1/4)',
                    '(-x+1/2,x+1/2,1/4)',
                    '(x+1/2,x,1/4)',
                    '(-x,-x+1/2,1/4)',
                    '(-x,x,3/4)',
                    '(x+1/2,-x+1/2,3/4)',
                    '(-x+1/2,-x,3/4)',
                    '(x,x+1/2,3/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(3/4,1/4,z)',
                    '(1/4,3/4,z)',
                    '(1/4,3/4,-z+1/2)',
                    '(3/4,1/4,-z+1/2)',
                    '(1/4,3/4,-z)',
                    '(3/4,1/4,-z)',
                    '(3/4,1/4,z+1/2)',
                    '(1/4,3/4,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,1/2,0)',
                    '(1/2,0,0)',
                    '(0,1/2,0)',
                    '(0,1/2,1/2)',
                    '(1/2,0,1/2)',
                    '(1/2,1/2,1/2)',
                    '(0,0,1/2)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '4..',
                'coords_xyz': ['(1/4,1/4,z)', '(3/4,3/4,-z+1/2)', '(3/4,3/4,-z)', '(1/4,1/4,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,0)', '(1/4,3/4,1/2)', '(3/4,1/4,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,3/4)'],
            },
        },
    },
    (131, '1'): {
        'IT_number': 131,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/m 2/m 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z+1/2)',
                    '(-y,x,-z+1/2)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'q': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,1/2)',
                    '(y,-x,1/2)',
                    '(-x,y,0)',
                    '(x,-y,0)',
                    '(y,x,1/2)',
                    '(-y,-x,1/2)',
                ],
            },
            'p': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(1/2,y,z)',
                    '(1/2,-y,z)',
                    '(-y,1/2,z+1/2)',
                    '(y,1/2,z+1/2)',
                    '(1/2,y,-z)',
                    '(1/2,-y,-z)',
                    '(y,1/2,-z+1/2)',
                    '(-y,1/2,-z+1/2)',
                ],
            },
            'o': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(-y,0,z+1/2)',
                    '(y,0,z+1/2)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(y,0,-z+1/2)',
                    '(-y,0,-z+1/2)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x,x,3/4)',
                    '(x,-x,3/4)',
                    '(-x,-x,3/4)',
                    '(x,x,3/4)',
                    '(x,-x,1/4)',
                    '(-x,x,1/4)',
                ],
            },
            'm': {
                'multiplicity': 4,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,x,1/2)', '(1/2,-x,1/2)'],
            },
            'l': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(0,x,0)', '(0,-x,0)']},
            'k': {
                'multiplicity': 4,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,0)', '(1/2,-x,0)'],
            },
            'j': {'multiplicity': 4, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,1/2)', '(0,-x,1/2)']},
            'i': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z+1/2)', '(0,1/2,-z)', '(1/2,0,-z+1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z)', '(1/2,1/2,-z+1/2)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z)', '(0,0,-z+1/2)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'd': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (132, '1'): {
        'IT_number': 132,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/m 2/c 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'p': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z+1/2)',
                    '(-y,x,-z+1/2)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'o': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,z+1/2)',
                    '(x,-x,z+1/2)',
                    '(-x,x,-z+1/2)',
                    '(x,-x,-z+1/2)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'n': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,1/2)',
                    '(y,-x,1/2)',
                    '(-x,y,1/2)',
                    '(x,-y,1/2)',
                    '(y,x,0)',
                    '(-y,-x,0)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/2,1/4)',
                    '(-x,1/2,1/4)',
                    '(1/2,x,3/4)',
                    '(1/2,-x,3/4)',
                    '(-x,1/2,3/4)',
                    '(x,1/2,3/4)',
                    '(1/2,-x,1/4)',
                    '(1/2,x,1/4)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x,0,1/4)',
                    '(0,x,3/4)',
                    '(0,-x,3/4)',
                    '(-x,0,3/4)',
                    '(x,0,3/4)',
                    '(0,-x,1/4)',
                    '(0,x,1/4)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(1/2,0,z+1/2)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,-z)',
                    '(0,1/2,-z)',
                    '(1/2,0,-z+1/2)',
                    '(0,1/2,z+1/2)',
                    '(1/2,0,z)',
                ],
            },
            'j': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x,1/2)', '(-x,-x,1/2)', '(-x,x,0)', '(x,-x,0)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x,x,1/2)', '(x,-x,1/2)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(1/2,1/2,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)', '(1/2,1/2,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z+1/2)', '(0,0,-z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,0,0)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,3/4)', '(0,1/2,3/4)', '(1/2,0,1/4)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(1/2,1/2,1/4)', '(1/2,1/2,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(1/2,1/2,0)', '(1/2,1/2,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (133, '1'): {
        'IT_number': 133,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/n 2/b 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y+1/2,-x+1/2,-z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,0)',
                    '(-x,-x+1/2,0)',
                    '(-x,x+1/2,1/2)',
                    '(x,-x+1/2,1/2)',
                    '(-x+1/2,-x,1/2)',
                    '(x+1/2,x,1/2)',
                    '(x+1/2,-x,0)',
                    '(-x+1/2,x,0)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,3/4)',
                    '(-x,0,3/4)',
                    '(1/2,x+1/2,1/4)',
                    '(1/2,-x+1/2,1/4)',
                    '(-x+1/2,1/2,3/4)',
                    '(x+1/2,1/2,3/4)',
                    '(0,-x,1/4)',
                    '(0,x,1/4)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x,0,1/4)',
                    '(1/2,x+1/2,3/4)',
                    '(1/2,-x+1/2,3/4)',
                    '(-x+1/2,1/2,1/4)',
                    '(x+1/2,1/2,1/4)',
                    '(0,-x,3/4)',
                    '(0,x,3/4)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,0,z)',
                    '(1/2,1/2,z+1/2)',
                    '(0,0,-z+1/2)',
                    '(1/2,1/2,-z)',
                    '(1/2,1/2,-z+1/2)',
                    '(0,0,-z)',
                    '(1/2,1/2,z)',
                    '(0,0,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(0,1/2,z+1/2)',
                    '(0,1/2,-z+1/2)',
                    '(0,1/2,-z)',
                    '(1/2,0,-z+1/2)',
                    '(1/2,0,-z)',
                    '(1/2,0,z)',
                    '(1/2,0,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(1/4,1/4,1/4)',
                    '(3/4,3/4,1/4)',
                    '(1/4,3/4,3/4)',
                    '(3/4,1/4,3/4)',
                    '(3/4,1/4,1/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,3/4,3/4)',
                    '(1/4,1/4,3/4)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)', '(0,0,1/2)', '(1/2,1/2,0)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,0,0)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(0,0,1/4)', '(1/2,1/2,3/4)', '(1/2,1/2,1/4)', '(0,0,3/4)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
        },
    },
    (133, '2'): {
        'IT_number': 133,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 42/n 2/b 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z+1/2)',
                    '(y,-x+1/2,z+1/2)',
                    '(-x+1/2,y,-z)',
                    '(x,-y+1/2,-z)',
                    '(y,x,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z+1/2)',
                    '(-y,x+1/2,-z+1/2)',
                    '(x+1/2,-y,z)',
                    '(-x,y+1/2,z)',
                    '(-y,-x,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x+1/2,-x+1/2,1/4)',
                    '(-x+1/2,x,3/4)',
                    '(x,-x+1/2,3/4)',
                    '(-x,-x,3/4)',
                    '(x+1/2,x+1/2,3/4)',
                    '(x+1/2,-x,1/4)',
                    '(-x,x+1/2,1/4)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,1/2)',
                    '(-x+1/2,1/4,1/2)',
                    '(1/4,x,0)',
                    '(1/4,-x+1/2,0)',
                    '(-x,3/4,1/2)',
                    '(x+1/2,3/4,1/2)',
                    '(3/4,-x,0)',
                    '(3/4,x+1/2,0)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,0)',
                    '(-x+1/2,1/4,0)',
                    '(1/4,x,1/2)',
                    '(1/4,-x+1/2,1/2)',
                    '(-x,3/4,0)',
                    '(x+1/2,3/4,0)',
                    '(3/4,-x,1/2)',
                    '(3/4,x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(3/4,1/4,z)',
                    '(1/4,3/4,z+1/2)',
                    '(3/4,1/4,-z)',
                    '(1/4,3/4,-z+1/2)',
                    '(1/4,3/4,-z)',
                    '(3/4,1/4,-z+1/2)',
                    '(1/4,3/4,z)',
                    '(3/4,1/4,z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/4,1/4,z)',
                    '(1/4,1/4,z+1/2)',
                    '(1/4,1/4,-z)',
                    '(1/4,1/4,-z+1/2)',
                    '(3/4,3/4,-z)',
                    '(3/4,3/4,-z+1/2)',
                    '(3/4,3/4,z)',
                    '(3/4,3/4,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,1/2,0)',
                    '(1/2,0,1/2)',
                    '(0,1/2,1/2)',
                    '(1/2,0,0)',
                    '(0,1/2,0)',
                    '(0,0,1/2)',
                    '(1/2,1/2,1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(3/4,1/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)', '(1/4,3/4,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,1/4,3/4)', '(3/4,3/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,1/2)', '(1/4,3/4,0)', '(3/4,1/4,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(1/4,1/4,0)', '(1/4,1/4,1/2)', '(3/4,3/4,0)', '(3/4,3/4,1/2)'],
            },
        },
    },
    (134, '1'): {
        'IT_number': 134,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/n 2/n 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x+1/2,x+1/2,z+1/2)',
                    '(x+1/2,-x+1/2,z+1/2)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(x+1/2,x+1/2,-z+1/2)',
                    '(-x+1/2,-x+1/2,-z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,3/4)',
                    '(-x,-x+1/2,3/4)',
                    '(-x,x+1/2,1/4)',
                    '(x,-x+1/2,1/4)',
                    '(-x+1/2,-x,3/4)',
                    '(x+1/2,x,3/4)',
                    '(x+1/2,-x,1/4)',
                    '(-x+1/2,x,1/4)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,1/4)',
                    '(-x,-x+1/2,1/4)',
                    '(-x,x+1/2,3/4)',
                    '(x,-x+1/2,3/4)',
                    '(-x+1/2,-x,1/4)',
                    '(x+1/2,x,1/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x+1/2,x,3/4)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x+1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(-x+1/2,1/2,0)',
                    '(x+1/2,1/2,0)',
                    '(0,-x,1/2)',
                    '(0,x,1/2)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(0,-x,0)',
                    '(0,x,0)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(0,1/2,z+1/2)',
                    '(0,1/2,-z)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,-z+1/2)',
                    '(1/2,0,-z)',
                    '(1/2,0,z+1/2)',
                    '(1/2,0,z)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)', '(0,0,-z)', '(1/2,1/2,-z+1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(3/4,3/4,3/4)', '(1/4,1/4,3/4)', '(3/4,1/4,1/4)', '(1/4,3/4,1/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,3/4)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,0,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (134, '2'): {
        'IT_number': 134,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 42/n 2/n 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z+1/2)',
                    '(y,-x+1/2,z+1/2)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(y,x,-z)',
                    '(-y+1/2,-x+1/2,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z+1/2)',
                    '(-y,x+1/2,-z+1/2)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(-y,-x,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'm': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,-x,z)',
                    '(-x+1/2,x+1/2,z)',
                    '(x+1/2,x,z+1/2)',
                    '(-x,-x+1/2,z+1/2)',
                    '(-x+1/2,-x,-z+1/2)',
                    '(x,x+1/2,-z+1/2)',
                    '(-x,x,-z)',
                    '(x+1/2,-x+1/2,-z)',
                ],
            },
            'l': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/2)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,x,0)',
                    '(x,-x+1/2,0)',
                    '(-x,-x,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x,0)',
                    '(-x,x+1/2,0)',
                ],
            },
            'k': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x+1/2,-x+1/2,0)',
                    '(-x+1/2,x,1/2)',
                    '(x,-x+1/2,1/2)',
                    '(-x,-x,0)',
                    '(x+1/2,x+1/2,0)',
                    '(x+1/2,-x,1/2)',
                    '(-x,x+1/2,1/2)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x+1/2,1/4,1/4)',
                    '(1/4,x,3/4)',
                    '(1/4,-x+1/2,3/4)',
                    '(-x,3/4,3/4)',
                    '(x+1/2,3/4,3/4)',
                    '(3/4,-x,1/4)',
                    '(3/4,x+1/2,1/4)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,3/4)',
                    '(-x+1/2,1/4,3/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x+1/2,1/4)',
                    '(-x,3/4,1/4)',
                    '(x+1/2,3/4,1/4)',
                    '(3/4,-x,3/4)',
                    '(3/4,x+1/2,3/4)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/4,1/4,z)',
                    '(1/4,1/4,z+1/2)',
                    '(1/4,1/4,-z+1/2)',
                    '(1/4,1/4,-z)',
                    '(3/4,3/4,-z)',
                    '(3/4,3/4,-z+1/2)',
                    '(3/4,3/4,z+1/2)',
                    '(3/4,3/4,z)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,z+1/2)', '(3/4,1/4,-z+1/2)', '(1/4,3/4,-z)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/4,1/4,0)', '(1/4,1/4,1/2)', '(3/4,3/4,0)', '(3/4,3/4,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '222',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,1/4,3/4)', '(3/4,3/4,3/4)', '(3/4,3/4,1/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-42m', 'coords_xyz': ['(1/4,3/4,1/4)', '(3/4,1/4,3/4)']},
        },
    },
    (135, '1'): {
        'IT_number': 135,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/m 21/b 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z+1/2)',
                    '(y,-x,z+1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z+1/2)',
                    '(-y,x,-z+1/2)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x+1/2,y+1/2,z)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,1/2)',
                    '(y,-x,1/2)',
                    '(-x+1/2,y+1/2,0)',
                    '(x+1/2,-y+1/2,0)',
                    '(y+1/2,x+1/2,1/2)',
                    '(-y+1/2,-x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,1/4)',
                    '(-x,-x+1/2,1/4)',
                    '(-x+1/2,x,3/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x,-x+1/2,3/4)',
                    '(x,x+1/2,3/4)',
                    '(x+1/2,-x,1/4)',
                    '(-x+1/2,x,1/4)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(1/2,0,z+1/2)',
                    '(1/2,0,-z)',
                    '(0,1/2,-z+1/2)',
                    '(0,1/2,-z)',
                    '(1/2,0,-z+1/2)',
                    '(1/2,0,z)',
                    '(0,1/2,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,0,z)',
                    '(0,0,z+1/2)',
                    '(1/2,1/2,-z)',
                    '(1/2,1/2,-z+1/2)',
                    '(0,0,-z)',
                    '(0,0,-z+1/2)',
                    '(1/2,1/2,z)',
                    '(1/2,1/2,z+1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,3/4)', '(0,1/2,3/4)', '(1/2,0,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/2,0)', '(1/2,0,1/2)', '(1/2,0,0)', '(0,1/2,1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)', '(1/2,1/2,3/4)', '(1/2,1/2,1/4)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,0,0)', '(0,0,1/2)', '(1/2,1/2,0)', '(1/2,1/2,1/2)'],
            },
        },
    },
    (136, '1'): {
        'IT_number': 136,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/m 21/n 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x+1/2,x+1/2,z+1/2)',
                    '(x+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,-x+1/2,-z+1/2)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y+1/2,x+1/2,1/2)',
                    '(y+1/2,-x+1/2,1/2)',
                    '(-x+1/2,y+1/2,1/2)',
                    '(x+1/2,-y+1/2,1/2)',
                    '(y,x,0)',
                    '(-y,-x,0)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/2,z)',
                    '(0,1/2,z+1/2)',
                    '(1/2,0,-z+1/2)',
                    '(1/2,0,-z)',
                    '(0,1/2,-z)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,z+1/2)',
                    '(1/2,0,z)',
                ],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,-x,0)', '(-x,x,0)', '(x+1/2,x+1/2,1/2)', '(-x+1/2,-x+1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x+1/2,x+1/2,1/2)', '(x+1/2,-x+1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)', '(0,0,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,1/2,1/4)', '(0,1/2,3/4)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,0,0)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (137, '1'): {
        'IT_number': 137,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/n 21/m 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z+1/2)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(-y+1/2,1/2,z+1/2)',
                    '(y+1/2,1/2,z+1/2)',
                    '(1/2,y+1/2,-z+1/2)',
                    '(1/2,-y+1/2,-z+1/2)',
                    '(y,0,-z)',
                    '(-y,0,-z)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x,-x,0)',
                    '(-x+1/2,x+1/2,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(x+1/2,x+1/2,1/2)',
                    '(x,-x,0)',
                    '(-x,x,0)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(1/4,1/4,1/4)',
                    '(3/4,3/4,1/4)',
                    '(1/4,3/4,3/4)',
                    '(3/4,1/4,3/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,1/4,1/4)',
                    '(1/4,1/4,3/4)',
                    '(3/4,3/4,3/4)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)', '(1/2,0,-z+1/2)', '(1/2,0,-z)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,0,z)', '(1/2,1/2,z+1/2)', '(1/2,1/2,-z+1/2)', '(0,0,-z)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (137, '2'): {
        'IT_number': 137,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 42/n 21/m 2/c',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z+1/2)',
                    '(y,-x+1/2,z+1/2)',
                    '(-x,y+1/2,-z)',
                    '(x+1/2,-y,-z)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z+1/2)',
                    '(-y,x+1/2,-z+1/2)',
                    '(x,-y+1/2,z)',
                    '(-x+1/2,y,z)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(1/4,y,z)',
                    '(1/4,-y+1/2,z)',
                    '(-y+1/2,1/4,z+1/2)',
                    '(y,1/4,z+1/2)',
                    '(3/4,y+1/2,-z)',
                    '(3/4,-y,-z)',
                    '(y+1/2,3/4,-z+1/2)',
                    '(-y,3/4,-z+1/2)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,1/4)',
                    '(-x+1/2,x+1/2,1/4)',
                    '(x+1/2,x,3/4)',
                    '(-x,-x+1/2,3/4)',
                    '(-x,x,3/4)',
                    '(x+1/2,-x+1/2,3/4)',
                    '(-x+1/2,-x,1/4)',
                    '(x,x+1/2,1/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,1/2,0)',
                    '(1/2,0,1/2)',
                    '(0,1/2,1/2)',
                    '(0,1/2,0)',
                    '(1/2,0,0)',
                    '(1/2,1/2,1/2)',
                    '(0,0,1/2)',
                ],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,z+1/2)', '(3/4,3/4,-z)', '(3/4,3/4,-z+1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '2mm',
                'coords_xyz': ['(3/4,1/4,z)', '(1/4,3/4,z+1/2)', '(1/4,3/4,-z)', '(3/4,1/4,-z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(3/4,1/4,1/4)', '(1/4,3/4,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-4m2', 'coords_xyz': ['(3/4,1/4,3/4)', '(1/4,3/4,1/4)']},
        },
    },
    (138, '1'): {
        'IT_number': 138,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/n 21/c 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y+1/2,-z)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y+1/2,x+1/2,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x+1/2,z)',
                    '(-x,-x+1/2,z)',
                    '(-x,x+1/2,z+1/2)',
                    '(x,-x+1/2,z+1/2)',
                    '(-x+1/2,x,-z)',
                    '(x+1/2,-x,-z)',
                    '(x+1/2,x,-z+1/2)',
                    '(-x+1/2,-x,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,3/4)',
                    '(-x,-x,3/4)',
                    '(-x+1/2,x+1/2,1/4)',
                    '(x+1/2,-x+1/2,1/4)',
                    '(-x+1/2,-x+1/2,3/4)',
                    '(x+1/2,x+1/2,3/4)',
                    '(x,-x,1/4)',
                    '(-x,x,1/4)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x+1/2,x+1/2,3/4)',
                    '(x+1/2,-x+1/2,3/4)',
                    '(-x+1/2,-x+1/2,1/4)',
                    '(x+1/2,x+1/2,1/4)',
                    '(x,-x,3/4)',
                    '(-x,x,3/4)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,0,z)',
                    '(1/2,1/2,z+1/2)',
                    '(1/2,1/2,-z)',
                    '(0,0,-z+1/2)',
                    '(1/2,1/2,-z+1/2)',
                    '(0,0,-z)',
                    '(0,0,z+1/2)',
                    '(1/2,1/2,z)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,1/2,z)', '(0,1/2,z+1/2)', '(1/2,0,-z)', '(1/2,0,-z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,3/4)', '(3/4,3/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,3/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)', '(1/2,1/2,0)', '(0,0,1/2)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,0,1/4)', '(1/2,1/2,3/4)', '(1/2,1/2,1/4)', '(0,0,3/4)'],
            },
        },
    },
    (138, '2'): {
        'IT_number': 138,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 42/n 21/c 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 16,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-y+1/2,x,z+1/2)',
                    '(y,-x+1/2,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y,-z+1/2)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(y+1/2,-x,-z+1/2)',
                    '(-y,x+1/2,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y,z+1/2)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y,x,z)',
                ],
            },
            'i': {
                'multiplicity': 8,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x+1/2,-x+1/2,z)',
                    '(-x+1/2,x,z+1/2)',
                    '(x,-x+1/2,z+1/2)',
                    '(-x,x+1/2,-z+1/2)',
                    '(x+1/2,-x,-z+1/2)',
                    '(x+1/2,x+1/2,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,0)',
                    '(-x+1/2,x+1/2,0)',
                    '(x+1/2,x,1/2)',
                    '(-x,-x+1/2,1/2)',
                    '(-x,x,0)',
                    '(x+1/2,-x+1/2,0)',
                    '(-x+1/2,-x,1/2)',
                    '(x,x+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,-x,1/2)',
                    '(-x+1/2,x+1/2,1/2)',
                    '(x+1/2,x,0)',
                    '(-x,-x+1/2,0)',
                    '(-x,x,1/2)',
                    '(x+1/2,-x+1/2,1/2)',
                    '(-x+1/2,-x,0)',
                    '(x,x+1/2,0)',
                ],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(3/4,1/4,z)',
                    '(1/4,3/4,z+1/2)',
                    '(1/4,3/4,-z+1/2)',
                    '(3/4,1/4,-z)',
                    '(1/4,3/4,-z)',
                    '(3/4,1/4,-z+1/2)',
                    '(3/4,1/4,z+1/2)',
                    '(1/4,3/4,z)',
                ],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '2.m',
                'coords_xyz': ['(1/4,1/4,z)', '(1/4,1/4,z+1/2)', '(3/4,3/4,-z+1/2)', '(3/4,3/4,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(0,0,1/2)', '(1/2,1/2,1/2)', '(1/2,0,0)', '(0,1/2,0)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '-4..',
                'coords_xyz': ['(3/4,1/4,3/4)', '(1/4,3/4,1/4)', '(1/4,3/4,3/4)', '(3/4,1/4,1/4)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '2.2',
                'coords_xyz': ['(3/4,1/4,0)', '(1/4,3/4,1/2)', '(1/4,3/4,0)', '(3/4,1/4,1/2)'],
            },
        },
    },
    (139, '1'): {
        'IT_number': 139,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4/m 21/m 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                ],
            },
            'n': {
                'multiplicity': 16,
                'site_symmetry': '.m.',
                'coords_xyz': ['(0,y,z)', '(0,-y,z)', '(-y,0,z)', '(y,0,z)', '(0,y,-z)', '(0,-y,-z)', '(y,0,-z)', '(-y,0,-z)'],
            },
            'm': {
                'multiplicity': 16,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,z)',
                    '(x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                ],
            },
            'l': {
                'multiplicity': 16,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-x,-y,0)', '(-y,x,0)', '(y,-x,0)', '(-x,y,0)', '(x,-y,0)', '(y,x,0)', '(-y,-x,0)'],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/2,1/4)',
                    '(-x,-x+1/2,1/4)',
                    '(-x+1/2,x,1/4)',
                    '(x+1/2,-x,1/4)',
                    '(-x,-x+1/2,3/4)',
                    '(x,x+1/2,3/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x+1/2,x,3/4)',
                ],
            },
            'j': {
                'multiplicity': 8,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(1/2,x,0)', '(1/2,-x,0)'],
            },
            'i': {'multiplicity': 8, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)']},
            'h': {'multiplicity': 8, 'site_symmetry': 'm.2', 'coords_xyz': ['(x,x,0)', '(-x,-x,0)', '(-x,x,0)', '(x,-x,0)']},
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z)', '(1/2,0,-z)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,1/4)', '(1/4,3/4,1/4)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '4mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 4, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'b': {'multiplicity': 2, 'site_symmetry': '4/mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '4/mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (140, '1'): {
        'IT_number': 140,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4/m 2/c 2/m',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-y,x,z)',
                    '(y,-x,z)',
                    '(-x,y,-z+1/2)',
                    '(x,-y,-z+1/2)',
                    '(y,x,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,-y,z+1/2)',
                    '(-x,y,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(y,x,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 16,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x+1/2,z)',
                    '(-x,-x+1/2,z)',
                    '(-x+1/2,x,z)',
                    '(x+1/2,-x,z)',
                    '(-x,x+1/2,-z+1/2)',
                    '(x,-x+1/2,-z+1/2)',
                    '(x+1/2,x,-z+1/2)',
                    '(-x+1/2,-x,-z+1/2)',
                ],
            },
            'k': {
                'multiplicity': 16,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-x,-y,0)',
                    '(-y,x,0)',
                    '(y,-x,0)',
                    '(-x,y,1/2)',
                    '(x,-y,1/2)',
                    '(y,x,1/2)',
                    '(-y,-x,1/2)',
                ],
            },
            'j': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x,0,1/4)',
                    '(0,x,1/4)',
                    '(0,-x,1/4)',
                    '(-x,0,3/4)',
                    '(x,0,3/4)',
                    '(0,-x,3/4)',
                    '(0,x,3/4)',
                ],
            },
            'i': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x,x,1/4)',
                    '(x,-x,1/4)',
                    '(-x,-x,3/4)',
                    '(x,x,3/4)',
                    '(x,-x,3/4)',
                    '(-x,x,3/4)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': 'm.2',
                'coords_xyz': ['(x,x+1/2,0)', '(-x,-x+1/2,0)', '(-x+1/2,x,0)', '(x+1/2,-x,0)'],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '2.m',
                'coords_xyz': ['(0,1/2,z)', '(1/2,0,z)', '(0,1/2,-z+1/2)', '(1/2,0,-z+1/2)'],
            },
            'f': {
                'multiplicity': 8,
                'site_symmetry': '4..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,1/4)', '(1/4,3/4,1/4)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': 'm.m', 'coords_xyz': ['(0,1/2,0)', '(1/2,0,0)']},
            'c': {'multiplicity': 4, 'site_symmetry': '4/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-42m', 'coords_xyz': ['(0,1/2,1/4)', '(1/2,0,1/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '422', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (141, '1'): {
        'IT_number': 141,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41/a 2/m 2/d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(-x+1/2,y,-z+3/4)',
                    '(x,-y+1/2,-z+1/4)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y,-x,-z)',
                    '(-x,-y+1/2,-z+1/4)',
                    '(x+1/2,y,-z+3/4)',
                    '(y,-x,-z)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x,y,z)',
                    '(-y+1/2,-x,z+3/4)',
                    '(y,x+1/2,z+1/4)',
                ],
            },
            'h': {
                'multiplicity': 16,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(0,y,z)',
                    '(1/2,-y+1/2,z+1/2)',
                    '(-y,1/2,z+1/4)',
                    '(y+1/2,0,z+3/4)',
                    '(1/2,y,-z+3/4)',
                    '(0,-y+1/2,-z+1/4)',
                    '(y+1/2,1/2,-z+1/2)',
                    '(-y,0,-z)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,0)',
                    '(-x+1/2,-x+1/2,1/2)',
                    '(-x,x+1/2,1/4)',
                    '(x+1/2,-x,3/4)',
                    '(-x,-x+1/2,1/4)',
                    '(x+1/2,x,3/4)',
                    '(x,-x,0)',
                    '(-x+1/2,x+1/2,1/2)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,1/4,1/8)',
                    '(-x+1/2,1/4,5/8)',
                    '(3/4,x+1/2,3/8)',
                    '(3/4,-x,7/8)',
                    '(-x,1/4,1/8)',
                    '(x+1/2,1/4,5/8)',
                    '(1/4,-x,7/8)',
                    '(1/4,x+1/2,3/8)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,0,z)', '(0,1/2,z+1/4)', '(1/2,0,-z+3/4)', '(1/2,1/2,-z+1/2)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2/m.',
                'coords_xyz': ['(0,1/4,5/8)', '(1/2,1/4,1/8)', '(3/4,1/2,7/8)', '(3/4,0,3/8)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.2/m.',
                'coords_xyz': ['(0,1/4,1/8)', '(1/2,1/4,5/8)', '(3/4,1/2,3/8)', '(3/4,0,7/8)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,1/2)', '(0,1/2,3/4)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,0,0)', '(0,1/2,1/4)']},
        },
    },
    (141, '2'): {
        'IT_number': 141,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'I 41/a 2/m 2/d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-y+1/4,x+3/4,z+1/4)',
                    '(y+1/4,-x+1/4,z+3/4)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y,-z)',
                    '(y+1/4,x+3/4,-z+1/4)',
                    '(-y+1/4,-x+1/4,-z+3/4)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(y+3/4,-x+1/4,-z+3/4)',
                    '(-y+3/4,x+3/4,-z+1/4)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y,z)',
                    '(-y+3/4,-x+1/4,z+3/4)',
                    '(y+3/4,x+3/4,z+1/4)',
                ],
            },
            'h': {
                'multiplicity': 16,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(0,y,z)',
                    '(1/2,-y,z+1/2)',
                    '(-y+1/4,3/4,z+1/4)',
                    '(y+1/4,1/4,z+3/4)',
                    '(1/2,y,-z+1/2)',
                    '(0,-y,-z)',
                    '(y+1/4,3/4,-z+1/4)',
                    '(-y+1/4,1/4,-z+3/4)',
                ],
            },
            'g': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/4,7/8)',
                    '(-x+1/2,-x+3/4,3/8)',
                    '(-x,x+3/4,1/8)',
                    '(x+1/2,-x+1/4,5/8)',
                    '(-x,-x+3/4,1/8)',
                    '(x+1/2,x+1/4,5/8)',
                    '(x,-x+1/4,7/8)',
                    '(-x+1/2,x+3/4,3/8)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x+1/2,0,1/2)',
                    '(1/4,x+3/4,1/4)',
                    '(1/4,-x+1/4,3/4)',
                    '(-x,0,0)',
                    '(x+1/2,0,1/2)',
                    '(3/4,-x+1/4,3/4)',
                    '(3/4,x+3/4,1/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '2mm',
                'coords_xyz': ['(0,1/4,z)', '(0,3/4,z+1/4)', '(1/2,1/4,-z+1/2)', '(1/2,3/4,-z+1/4)'],
            },
            'd': {
                'multiplicity': 8,
                'site_symmetry': '.2/m.',
                'coords_xyz': ['(0,0,1/2)', '(1/2,0,0)', '(1/4,3/4,3/4)', '(1/4,1/4,1/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.2/m.',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(1/4,3/4,1/4)', '(1/4,1/4,3/4)'],
            },
            'b': {'multiplicity': 4, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,1/4,3/8)', '(0,3/4,5/8)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-4m2', 'coords_xyz': ['(0,3/4,1/8)', '(1/2,3/4,3/8)']},
        },
    },
    (142, '1'): {
        'IT_number': 142,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41/a 2/c 2/d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z+1/2)',
                    '(-y,x+1/2,z+1/4)',
                    '(y+1/2,-x,z+3/4)',
                    '(-x+1/2,y,-z+1/4)',
                    '(x,-y+1/2,-z+3/4)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y,-x,-z+1/2)',
                    '(-x,-y+1/2,-z+1/4)',
                    '(x+1/2,y,-z+3/4)',
                    '(y,-x,-z)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z)',
                    '(-x,y,z+1/2)',
                    '(-y+1/2,-x,z+1/4)',
                    '(y,x+1/2,z+3/4)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x,1/4)',
                    '(-x+1/2,-x+1/2,3/4)',
                    '(-x,x+1/2,1/2)',
                    '(x+1/2,-x,0)',
                    '(-x,-x+1/2,0)',
                    '(x+1/2,x,1/2)',
                    '(x,-x,3/4)',
                    '(-x+1/2,x+1/2,1/4)',
                ],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(1/4,y,1/8)',
                    '(1/4,-y+1/2,5/8)',
                    '(-y,3/4,3/8)',
                    '(y+1/2,3/4,7/8)',
                    '(3/4,-y+1/2,1/8)',
                    '(3/4,y,5/8)',
                    '(y,3/4,7/8)',
                    '(-y+1/2,3/4,3/8)',
                ],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,0,z)',
                    '(0,1/2,z+1/4)',
                    '(1/2,0,-z+1/4)',
                    '(1/2,1/2,-z)',
                    '(0,1/2,-z+1/4)',
                    '(0,0,-z)',
                    '(1/2,1/2,z)',
                    '(1/2,0,z+1/4)',
                ],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,1/4,1/8)',
                    '(1/2,1/4,5/8)',
                    '(3/4,1/2,3/8)',
                    '(3/4,0,7/8)',
                    '(1/2,1/4,1/8)',
                    '(0,1/4,5/8)',
                    '(3/4,1/2,7/8)',
                    '(3/4,0,3/8)',
                ],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,0,1/4)', '(0,1/2,1/2)', '(0,1/2,0)', '(0,0,3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,0,0)', '(0,1/2,1/4)', '(1/2,0,1/4)', '(1/2,1/2,0)'],
            },
        },
    },
    (142, '2'): {
        'IT_number': 142,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'I 41/a 2/c 2/d',
        'crystal_system': 'tetragonal',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 32,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-y+1/4,x+3/4,z+1/4)',
                    '(y+1/4,-x+1/4,z+3/4)',
                    '(-x+1/2,y,-z)',
                    '(x,-y,-z+1/2)',
                    '(y+1/4,x+3/4,-z+3/4)',
                    '(-y+1/4,-x+1/4,-z+1/4)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(y+3/4,-x+1/4,-z+3/4)',
                    '(-y+3/4,x+3/4,-z+1/4)',
                    '(x+1/2,-y,z)',
                    '(-x,y,z+1/2)',
                    '(-y+3/4,-x+1/4,z+1/4)',
                    '(y+3/4,x+3/4,z+3/4)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,x+1/4,1/8)',
                    '(-x+1/2,-x+3/4,5/8)',
                    '(-x,x+3/4,3/8)',
                    '(x+1/2,-x+1/4,7/8)',
                    '(-x,-x+3/4,7/8)',
                    '(x+1/2,x+1/4,3/8)',
                    '(x,-x+1/4,5/8)',
                    '(-x+1/2,x+3/4,1/8)',
                ],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x+1/2,0,3/4)',
                    '(1/4,x+3/4,1/2)',
                    '(1/4,-x+1/4,0)',
                    '(-x,0,3/4)',
                    '(x+1/2,0,1/4)',
                    '(3/4,-x+1/4,1/2)',
                    '(3/4,x+3/4,0)',
                ],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(0,1/4,z)',
                    '(0,3/4,z+1/4)',
                    '(1/2,1/4,-z)',
                    '(1/2,3/4,-z+3/4)',
                    '(0,3/4,-z)',
                    '(0,1/4,-z+3/4)',
                    '(1/2,3/4,z)',
                    '(1/2,1/4,z+1/4)',
                ],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '-1',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,0,1/2)',
                    '(1/4,3/4,1/4)',
                    '(1/4,1/4,3/4)',
                    '(1/2,0,0)',
                    '(0,0,1/2)',
                    '(1/4,3/4,3/4)',
                    '(1/4,1/4,1/4)',
                ],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/4,1/8)', '(0,3/4,3/8)', '(0,3/4,7/8)', '(0,1/4,5/8)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,1/4,3/8)', '(0,3/4,5/8)', '(1/2,1/4,5/8)', '(1/2,3/4,3/8)'],
            },
        },
    },
    (146, 'r'): {
        'IT_number': 146,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R 3',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'b': {'multiplicity': 3, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(z,x,y)', '(y,z,x)']},
            'a': {'multiplicity': 1, 'site_symmetry': '3.', 'coords_xyz': ['(x,x,x)']},
        },
    },
    (146, 'h'): {
        'IT_number': 146,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R 3',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'b': {'multiplicity': 9, 'site_symmetry': '1', 'coords_xyz': ['(x,y,z)', '(-y,x-y,z)', '(-x+y,-x,z)']},
            'a': {'multiplicity': 3, 'site_symmetry': '3.', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (148, 'r'): {
        'IT_number': 148,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R -3',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 6,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(z,x,y)', '(y,z,x)', '(-x,-y,-z)', '(-z,-x,-y)', '(-y,-z,-x)'],
            },
            'e': {'multiplicity': 3, 'site_symmetry': '-1', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'd': {'multiplicity': 3, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3.', 'coords_xyz': ['(x,x,x)', '(-x,-x,-x)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-3.', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-3.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (148, 'h'): {
        'IT_number': 148,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R -3',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 18,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-y,x-y,z)', '(-x+y,-x,z)', '(-x,-y,-z)', '(y,-x+y,-z)', '(x-y,x,-z)'],
            },
            'e': {'multiplicity': 9, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)']},
            'd': {'multiplicity': 9, 'site_symmetry': '-1', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 6, 'site_symmetry': '3.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'b': {'multiplicity': 3, 'site_symmetry': '-3.', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 3, 'site_symmetry': '-3.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (155, 'r'): {
        'IT_number': 155,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R 3 2',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 6,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(z,x,y)', '(y,z,x)', '(-z,-y,-x)', '(-y,-x,-z)', '(-x,-z,-y)'],
            },
            'e': {'multiplicity': 3, 'site_symmetry': '.2', 'coords_xyz': ['(1/2,y,-y)', '(-y,1/2,y)', '(y,-y,1/2)']},
            'd': {'multiplicity': 3, 'site_symmetry': '.2', 'coords_xyz': ['(0,y,-y)', '(-y,0,y)', '(y,-y,0)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3.', 'coords_xyz': ['(x,x,x)', '(-x,-x,-x)']},
            'b': {'multiplicity': 1, 'site_symmetry': '32', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '32', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (155, 'h'): {
        'IT_number': 155,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R 3 2',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 18,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-y,x-y,z)', '(-x+y,-x,z)', '(y,x,-z)', '(x-y,-y,-z)', '(-x,-x+y,-z)'],
            },
            'e': {'multiplicity': 9, 'site_symmetry': '.2', 'coords_xyz': ['(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)']},
            'd': {'multiplicity': 9, 'site_symmetry': '.2', 'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)']},
            'c': {'multiplicity': 6, 'site_symmetry': '3.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'b': {'multiplicity': 3, 'site_symmetry': '32', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 3, 'site_symmetry': '32', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (160, 'r'): {
        'IT_number': 160,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R 3 m',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 6,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(z,x,y)', '(y,z,x)', '(z,y,x)', '(y,x,z)', '(x,z,y)'],
            },
            'b': {'multiplicity': 3, 'site_symmetry': '.m', 'coords_xyz': ['(x,x,z)', '(z,x,x)', '(x,z,x)']},
            'a': {'multiplicity': 1, 'site_symmetry': '3m', 'coords_xyz': ['(x,x,x)']},
        },
    },
    (160, 'h'): {
        'IT_number': 160,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R 3 m',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 18,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-y,x-y,z)', '(-x+y,-x,z)', '(-y,-x,z)', '(-x+y,y,z)', '(x,x-y,z)'],
            },
            'b': {'multiplicity': 9, 'site_symmetry': '.m', 'coords_xyz': ['(x,-x,z)', '(x,2x,z)', '(-2x,-x,z)']},
            'a': {'multiplicity': 3, 'site_symmetry': '3m', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (161, 'r'): {
        'IT_number': 161,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R 3 c',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 6,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(z,x,y)',
                    '(y,z,x)',
                    '(z+1/2,y+1/2,x+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                ],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '3.', 'coords_xyz': ['(x,x,x)', '(x+1/2,x+1/2,x+1/2)']},
        },
    },
    (161, 'h'): {
        'IT_number': 161,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R 3 c',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'b': {
                'multiplicity': 18,
                'site_symmetry': '1',
                'coords_xyz': ['(x,y,z)', '(-y,x-y,z)', '(-x+y,-x,z)', '(-y,-x,z+1/2)', '(-x+y,y,z+1/2)', '(x,x-y,z+1/2)'],
            },
            'a': {'multiplicity': 6, 'site_symmetry': '3.', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (166, 'r'): {
        'IT_number': 166,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R -3 2/m',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(z,x,y)',
                    '(y,z,x)',
                    '(-z,-y,-x)',
                    '(-y,-x,-z)',
                    '(-x,-z,-y)',
                    '(-x,-y,-z)',
                    '(-z,-x,-y)',
                    '(-y,-z,-x)',
                    '(z,y,x)',
                    '(y,x,z)',
                    '(x,z,y)',
                ],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': '.m',
                'coords_xyz': ['(x,x,z)', '(z,x,x)', '(x,z,x)', '(-z,-x,-x)', '(-x,-x,-z)', '(-x,-z,-x)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2',
                'coords_xyz': ['(x,-x,1/2)', '(1/2,x,-x)', '(-x,1/2,x)', '(-x,x,1/2)', '(1/2,-x,x)', '(x,1/2,-x)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '.2',
                'coords_xyz': ['(x,-x,0)', '(0,x,-x)', '(-x,0,x)', '(-x,x,0)', '(0,-x,x)', '(x,0,-x)'],
            },
            'e': {'multiplicity': 3, 'site_symmetry': '.2/m', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'd': {'multiplicity': 3, 'site_symmetry': '.2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3m', 'coords_xyz': ['(x,x,x)', '(-x,-x,-x)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-3m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-3m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (166, 'h'): {
        'IT_number': 166,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R -3 2/m',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 36,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                ],
            },
            'h': {
                'multiplicity': 18,
                'site_symmetry': '.m',
                'coords_xyz': ['(x,-x,z)', '(x,2x,z)', '(-2x,-x,z)', '(-x,x,-z)', '(2x,x,-z)', '(-x,-2x,-z)'],
            },
            'g': {
                'multiplicity': 18,
                'site_symmetry': '.2',
                'coords_xyz': ['(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)', '(-x,0,1/2)', '(0,-x,1/2)', '(x,x,1/2)'],
            },
            'f': {
                'multiplicity': 18,
                'site_symmetry': '.2',
                'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)', '(-x,0,0)', '(0,-x,0)', '(x,x,0)'],
            },
            'e': {'multiplicity': 9, 'site_symmetry': '.2/m', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)']},
            'd': {'multiplicity': 9, 'site_symmetry': '.2/m', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'c': {'multiplicity': 6, 'site_symmetry': '3m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'b': {'multiplicity': 3, 'site_symmetry': '-3m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 3, 'site_symmetry': '-3m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (167, 'r'): {
        'IT_number': 167,
        'setting': 1,
        'IT_coordinate_system_code': 'r',
        'name_H-M_alt': 'R -3 2/c',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(z,x,y)',
                    '(y,z,x)',
                    '(-z+1/2,-y+1/2,-x+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(-x+1/2,-z+1/2,-y+1/2)',
                    '(-x,-y,-z)',
                    '(-z,-x,-y)',
                    '(-y,-z,-x)',
                    '(z+1/2,y+1/2,x+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                ],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '.2',
                'coords_xyz': [
                    '(x,-x+1/2,1/4)',
                    '(1/4,x,-x+1/2)',
                    '(-x+1/2,1/4,x)',
                    '(-x,x+1/2,3/4)',
                    '(3/4,-x,x+1/2)',
                    '(x+1/2,3/4,-x)',
                ],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '3.',
                'coords_xyz': ['(x,x,x)', '(-x+1/2,-x+1/2,-x+1/2)', '(-x,-x,-x)', '(x+1/2,x+1/2,x+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-3.', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '32', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (167, 'h'): {
        'IT_number': 167,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'R -3 2/c',
        'crystal_system': 'trigonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 36,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(y,x,-z+1/2)',
                    '(x-y,-y,-z+1/2)',
                    '(-x,-x+y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                ],
            },
            'e': {
                'multiplicity': 18,
                'site_symmetry': '.2',
                'coords_xyz': ['(x,0,1/4)', '(0,x,1/4)', '(-x,-x,1/4)', '(-x,0,3/4)', '(0,-x,3/4)', '(x,x,3/4)'],
            },
            'd': {
                'multiplicity': 18,
                'site_symmetry': '-1',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,1/2)'],
            },
            'c': {
                'multiplicity': 12,
                'site_symmetry': '3.',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'b': {'multiplicity': 6, 'site_symmetry': '-3.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 6, 'site_symmetry': '32', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (177, 'h'): {
        'IT_number': 177,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 6 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z)',
                    '(y,-x+y,z)',
                    '(x-y,x,z)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(-y,-x,-z)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z)',
                ],
            },
            'm': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,-x,1/2)', '(x,2x,1/2)', '(-2x,-x,1/2)', '(-x,x,1/2)', '(-x,-2x,1/2)', '(2x,x,1/2)'],
            },
            'l': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,-x,0)', '(x,2x,0)', '(-2x,-x,0)', '(-x,x,0)', '(-x,-2x,0)', '(2x,x,0)'],
            },
            'k': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)', '(-x,0,1/2)', '(0,-x,1/2)', '(x,x,1/2)'],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)', '(-x,0,0)', '(0,-x,0)', '(x,x,0)'],
            },
            'i': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)', '(1/2,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z)', '(1/2,1/2,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z)', '(2/3,1/3,-z)', '(1/3,2/3,-z)'],
            },
            'g': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'f': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': '6..', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(1/3,2/3,1/2)', '(2/3,1/3,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(1/3,2/3,0)', '(2/3,1/3,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '622', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '622', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (178, 'h'): {
        'IT_number': 178,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 61 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z+1/3)',
                    '(-x+y,-x,z+2/3)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+5/6)',
                    '(x-y,x,z+1/6)',
                    '(y,x,-z+1/3)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z+2/3)',
                    '(-y,-x,-z+5/6)',
                    '(-x+y,y,-z+1/2)',
                    '(x,x-y,-z+1/6)',
                ],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,1/4)', '(-2x,-x,4/7)', '(x,-x,9/10)', '(-x,-2x,3/4)', '(2x,x,1/10)', '(-x,x,3/7)'],
            },
            'a': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,1/3)', '(-x,-x,2/3)', '(-x,0,1/2)', '(0,-x,5/6)', '(x,x,1/6)'],
            },
        },
    },
    (179, 'h'): {
        'IT_number': 179,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 65 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z+2/3)',
                    '(-x+y,-x,z+1/3)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/6)',
                    '(x-y,x,z+5/6)',
                    '(y,x,-z+2/3)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z+1/3)',
                    '(-y,-x,-z+1/6)',
                    '(-x+y,y,-z+1/2)',
                    '(x,x-y,-z+5/6)',
                ],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,3/4)', '(-2x,-x,3/7)', '(x,-x,1/10)', '(-x,-2x,1/4)', '(2x,x,9/10)', '(-x,x,4/7)'],
            },
            'a': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,2/3)', '(-x,-x,1/3)', '(-x,0,1/2)', '(0,-x,1/6)', '(x,x,5/6)'],
            },
        },
    },
    (180, 'h'): {
        'IT_number': 180,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 62 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z+2/3)',
                    '(-x+y,-x,z+1/3)',
                    '(-x,-y,z)',
                    '(y,-x+y,z+2/3)',
                    '(x-y,x,z+1/3)',
                    '(y,x,-z+2/3)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z+1/3)',
                    '(-y,-x,-z+2/3)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z+1/3)',
                ],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,1/2)', '(-2x,-x,1/6)', '(x,-x,5/6)', '(-x,-2x,1/2)', '(2x,x,1/6)', '(-x,x,5/6)'],
            },
            'i': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,0)', '(-2x,-x,2/3)', '(x,-x,1/3)', '(-x,-2x,0)', '(2x,x,2/3)', '(-x,x,1/3)'],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(0,x,1/6)', '(-x,-x,5/6)', '(-x,0,1/2)', '(0,-x,1/6)', '(x,x,5/6)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,2/3)', '(-x,-x,1/3)', '(-x,0,0)', '(0,-x,2/3)', '(x,x,1/3)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/2,0,z)',
                    '(0,1/2,z+2/3)',
                    '(1/2,1/2,z+1/3)',
                    '(0,1/2,-z+2/3)',
                    '(1/2,0,-z)',
                    '(1/2,1/2,-z+1/3)',
                ],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,z+2/3)', '(0,0,z+1/3)', '(0,0,-z+2/3)', '(0,0,-z)', '(0,0,-z+1/3)'],
            },
            'd': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/6)', '(1/2,1/2,5/6)']},
            'c': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,2/3)', '(1/2,1/2,1/3)']},
            'b': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(0,0,1/6)', '(0,0,5/6)']},
            'a': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,0,2/3)', '(0,0,1/3)']},
        },
    },
    (181, 'h'): {
        'IT_number': 181,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 64 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z+1/3)',
                    '(-x+y,-x,z+2/3)',
                    '(-x,-y,z)',
                    '(y,-x+y,z+1/3)',
                    '(x-y,x,z+2/3)',
                    '(y,x,-z+1/3)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z+2/3)',
                    '(-y,-x,-z+1/3)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z+2/3)',
                ],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,1/2)', '(-2x,-x,5/6)', '(x,-x,1/6)', '(-x,-2x,1/2)', '(2x,x,5/6)', '(-x,x,1/6)'],
            },
            'i': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,0)', '(-2x,-x,1/3)', '(x,-x,2/3)', '(-x,-2x,0)', '(2x,x,1/3)', '(-x,x,2/3)'],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,1/2)', '(0,x,5/6)', '(-x,-x,1/6)', '(-x,0,1/2)', '(0,-x,5/6)', '(x,x,1/6)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,1/3)', '(-x,-x,2/3)', '(-x,0,0)', '(0,-x,1/3)', '(x,x,2/3)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/2,0,z)',
                    '(0,1/2,z+1/3)',
                    '(1/2,1/2,z+2/3)',
                    '(0,1/2,-z+1/3)',
                    '(1/2,0,-z)',
                    '(1/2,1/2,-z+2/3)',
                ],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/3)', '(0,0,z+2/3)', '(0,0,-z+1/3)', '(0,0,-z)', '(0,0,-z+2/3)'],
            },
            'd': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,5/6)', '(1/2,1/2,1/6)']},
            'c': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,1/3)', '(1/2,1/2,2/3)']},
            'b': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(0,0,1/2)', '(0,0,5/6)', '(0,0,1/6)']},
            'a': {'multiplicity': 3, 'site_symmetry': '222', 'coords_xyz': ['(0,0,0)', '(0,0,1/3)', '(0,0,2/3)']},
        },
    },
    (182, 'h'): {
        'IT_number': 182,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 63 2 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/2)',
                    '(x-y,x,z+1/2)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(-y,-x,-z+1/2)',
                    '(-x+y,y,-z+1/2)',
                    '(x,x-y,-z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,2x,1/4)', '(-2x,-x,1/4)', '(x,-x,1/4)', '(-x,-2x,3/4)', '(2x,x,3/4)', '(-x,x,3/4)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)', '(-x,0,1/2)', '(0,-x,1/2)', '(x,x,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z+1/2)', '(2/3,1/3,-z)', '(1/3,2/3,-z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z)', '(0,0,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(1/3,2/3,3/4)', '(2/3,1/3,1/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(1/3,2/3,1/4)', '(2/3,1/3,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '32.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (183, 'h'): {
        'IT_number': 183,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 6 m m',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z)',
                    '(y,-x+y,z)',
                    '(x-y,x,z)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                    '(y,x,z)',
                    '(x-y,-y,z)',
                    '(-x,-x+y,z)',
                ],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,-x,z)', '(x,2x,z)', '(-2x,-x,z)', '(-x,x,z)', '(-x,-2x,z)', '(2x,x,z)'],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(0,x,z)', '(-x,-x,z)', '(-x,0,z)', '(0,-x,z)', '(x,x,z)'],
            },
            'c': {'multiplicity': 3, 'site_symmetry': '2mm', 'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)', '(1/2,1/2,z)']},
            'b': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z)']},
            'a': {'multiplicity': 1, 'site_symmetry': '6mm', 'coords_xyz': ['(0,0,z)']},
        },
    },
    (184, 'h'): {
        'IT_number': 184,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 6 c c',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z)',
                    '(y,-x+y,z)',
                    '(x-y,x,z)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                    '(y,x,z+1/2)',
                    '(x-y,-y,z+1/2)',
                    '(-x,-x+y,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 6,
                'site_symmetry': '2..',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)', '(1/2,1/2,z)', '(0,1/2,z+1/2)', '(1/2,0,z+1/2)', '(1/2,1/2,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z)', '(1/3,2/3,z+1/2)', '(2/3,1/3,z+1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '6..', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (185, 'h'): {
        'IT_number': 185,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 63 c m',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/2)',
                    '(x-y,x,z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                    '(y,x,z)',
                    '(x-y,-y,z)',
                    '(-x,-x+y,z)',
                ],
            },
            'c': {
                'multiplicity': 6,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(0,x,z)', '(-x,-x,z)', '(-x,0,z+1/2)', '(0,-x,z+1/2)', '(x,x,z+1/2)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z+1/2)', '(1/3,2/3,z+1/2)', '(2/3,1/3,z)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '3.m', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (186, 'h'): {
        'IT_number': 186,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 63 m c',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'd': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/2)',
                    '(x-y,x,z+1/2)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                    '(y,x,z+1/2)',
                    '(x-y,-y,z+1/2)',
                    '(-x,-x+y,z+1/2)',
                ],
            },
            'c': {
                'multiplicity': 6,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,-x,z)', '(x,2x,z)', '(-2x,-x,z)', '(-x,x,z+1/2)', '(-x,-2x,z+1/2)', '(2x,x,z+1/2)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z+1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)']},
        },
    },
    (187, 'h'): {
        'IT_number': 187,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P -6 m 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'o': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(x,y,-z)',
                    '(-y,x-y,-z)',
                    '(-x+y,-x,-z)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                    '(-y,-x,-z)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z)',
                ],
            },
            'n': {
                'multiplicity': 6,
                'site_symmetry': '.m.',
                'coords_xyz': ['(x,-x,z)', '(x,2x,z)', '(-2x,-x,z)', '(x,-x,-z)', '(x,2x,-z)', '(-2x,-x,-z)'],
            },
            'm': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/2)', '(-y,x-y,1/2)', '(-x+y,-x,1/2)', '(-y,-x,1/2)', '(-x+y,y,1/2)', '(x,x-y,1/2)'],
            },
            'l': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-y,x-y,0)', '(-x+y,-x,0)', '(-y,-x,0)', '(-x+y,y,0)', '(x,x-y,0)'],
            },
            'k': {'multiplicity': 3, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,-x,1/2)', '(x,2x,1/2)', '(-2x,-x,1/2)']},
            'j': {'multiplicity': 3, 'site_symmetry': 'mm2', 'coords_xyz': ['(x,-x,0)', '(x,2x,0)', '(-2x,-x,0)']},
            'i': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(2/3,1/3,z)', '(2/3,1/3,-z)']},
            'h': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(1/3,2/3,z)', '(1/3,2/3,-z)']},
            'g': {'multiplicity': 2, 'site_symmetry': '3m.', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'f': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(2/3,1/3,1/2)']},
            'e': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(2/3,1/3,0)']},
            'd': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,1/2)']},
            'c': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-6m2', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (188, 'h'): {
        'IT_number': 188,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P -6 c 2',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(x,y,-z+1/2)',
                    '(-y,x-y,-z+1/2)',
                    '(-x+y,-x,-z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                    '(-y,-x,-z)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z)',
                ],
            },
            'k': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(-y,x-y,1/4)', '(-x+y,-x,1/4)', '(-y,-x,3/4)', '(-x+y,y,3/4)', '(x,x-y,3/4)'],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': '..2',
                'coords_xyz': ['(x,-x,0)', '(x,2x,0)', '(-2x,-x,0)', '(x,-x,1/2)', '(x,2x,1/2)', '(-2x,-x,1/2)'],
            },
            'i': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(2/3,1/3,z)', '(2/3,1/3,-z+1/2)', '(2/3,1/3,z+1/2)', '(2/3,1/3,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(1/3,2/3,-z+1/2)', '(1/3,2/3,z+1/2)', '(1/3,2/3,-z)'],
            },
            'g': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,z+1/2)', '(0,0,-z)'],
            },
            'f': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(2/3,1/3,1/4)', '(2/3,1/3,3/4)']},
            'e': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(2/3,1/3,0)', '(2/3,1/3,1/2)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(1/3,2/3,1/4)', '(1/3,2/3,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(1/3,2/3,0)', '(1/3,2/3,1/2)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '3.2', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (189, 'h'): {
        'IT_number': 189,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P -6 2 m',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(x,y,-z)',
                    '(-y,x-y,-z)',
                    '(-x+y,-x,-z)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(y,x,z)',
                    '(x-y,-y,z)',
                    '(-x,-x+y,z)',
                ],
            },
            'k': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/2)', '(-y,x-y,1/2)', '(-x+y,-x,1/2)', '(y,x,1/2)', '(x-y,-y,1/2)', '(-x,-x+y,1/2)'],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,0)', '(-y,x-y,0)', '(-x+y,-x,0)', '(y,x,0)', '(x-y,-y,0)', '(-x,-x+y,0)'],
            },
            'i': {
                'multiplicity': 6,
                'site_symmetry': '..m',
                'coords_xyz': ['(x,0,z)', '(0,x,z)', '(-x,-x,z)', '(x,0,-z)', '(0,x,-z)', '(-x,-x,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(1/3,2/3,-z)', '(2/3,1/3,-z)', '(2/3,1/3,z)'],
            },
            'g': {'multiplicity': 3, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)']},
            'f': {'multiplicity': 3, 'site_symmetry': 'm2m', 'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': '3.m', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(1/3,2/3,1/2)', '(2/3,1/3,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(1/3,2/3,0)', '(2/3,1/3,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-62m', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-62m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (190, 'h'): {
        'IT_number': 190,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P -6 2 c',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 12,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(x,y,-z+1/2)',
                    '(-y,x-y,-z+1/2)',
                    '(-x+y,-x,-z+1/2)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(y,x,z+1/2)',
                    '(x-y,-y,z+1/2)',
                    '(-x,-x+y,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': 'm..',
                'coords_xyz': ['(x,y,1/4)', '(-y,x-y,1/4)', '(-x+y,-x,1/4)', '(y,x,3/4)', '(x-y,-y,3/4)', '(-x,-x+y,3/4)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2.',
                'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)', '(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(1/3,2/3,z)', '(1/3,2/3,-z+1/2)', '(2/3,1/3,-z)', '(2/3,1/3,z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '3..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(2/3,1/3,1/4)', '(1/3,2/3,3/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(1/3,2/3,1/4)', '(2/3,1/3,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-6..', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '32.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (191, 'h'): {
        'IT_number': 191,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 6/m 2/m 2/m',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'r': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z)',
                    '(y,-x+y,z)',
                    '(x-y,x,z)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(-y,-x,-z)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(x,y,-z)',
                    '(-y,x-y,-z)',
                    '(-x+y,-x,-z)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                    '(y,x,z)',
                    '(x-y,-y,z)',
                    '(-x,-x+y,z)',
                ],
            },
            'q': {
                'multiplicity': 12,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,1/2)',
                    '(-y,x-y,1/2)',
                    '(-x+y,-x,1/2)',
                    '(-x,-y,1/2)',
                    '(y,-x+y,1/2)',
                    '(x-y,x,1/2)',
                    '(y,x,1/2)',
                    '(x-y,-y,1/2)',
                    '(-x,-x+y,1/2)',
                    '(-y,-x,1/2)',
                    '(-x+y,y,1/2)',
                    '(x,x-y,1/2)',
                ],
            },
            'p': {
                'multiplicity': 12,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-y,x-y,0)',
                    '(-x+y,-x,0)',
                    '(-x,-y,0)',
                    '(y,-x+y,0)',
                    '(x-y,x,0)',
                    '(y,x,0)',
                    '(x-y,-y,0)',
                    '(-x,-x+y,0)',
                    '(-y,-x,0)',
                    '(-x+y,y,0)',
                    '(x,x-y,0)',
                ],
            },
            'o': {
                'multiplicity': 12,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(x,2x,z)',
                    '(-2x,-x,z)',
                    '(x,-x,z)',
                    '(-x,-2x,z)',
                    '(2x,x,z)',
                    '(-x,x,z)',
                    '(2x,x,-z)',
                    '(-x,-2x,-z)',
                    '(-x,x,-z)',
                    '(-2x,-x,-z)',
                    '(x,2x,-z)',
                    '(x,-x,-z)',
                ],
            },
            'n': {
                'multiplicity': 12,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,0,z)',
                    '(0,x,z)',
                    '(-x,-x,z)',
                    '(-x,0,z)',
                    '(0,-x,z)',
                    '(x,x,z)',
                    '(0,x,-z)',
                    '(x,0,-z)',
                    '(-x,-x,-z)',
                    '(0,-x,-z)',
                    '(-x,0,-z)',
                    '(x,x,-z)',
                ],
            },
            'm': {
                'multiplicity': 6,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,2x,1/2)', '(-2x,-x,1/2)', '(x,-x,1/2)', '(-x,-2x,1/2)', '(2x,x,1/2)', '(-x,x,1/2)'],
            },
            'l': {
                'multiplicity': 6,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,2x,0)', '(-2x,-x,0)', '(x,-x,0)', '(-x,-2x,0)', '(2x,x,0)', '(-x,x,0)'],
            },
            'k': {
                'multiplicity': 6,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,0,1/2)', '(0,x,1/2)', '(-x,-x,1/2)', '(-x,0,1/2)', '(0,-x,1/2)', '(x,x,1/2)'],
            },
            'j': {
                'multiplicity': 6,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,0,0)', '(0,x,0)', '(-x,-x,0)', '(-x,0,0)', '(0,-x,0)', '(x,x,0)'],
            },
            'i': {
                'multiplicity': 6,
                'site_symmetry': '2mm',
                'coords_xyz': ['(1/2,0,z)', '(0,1/2,z)', '(1/2,1/2,z)', '(0,1/2,-z)', '(1/2,0,-z)', '(1/2,1/2,-z)'],
            },
            'h': {
                'multiplicity': 4,
                'site_symmetry': '3m.',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z)', '(2/3,1/3,-z)', '(1/3,2/3,-z)'],
            },
            'g': {'multiplicity': 3, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)']},
            'f': {'multiplicity': 3, 'site_symmetry': 'mmm', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)']},
            'e': {'multiplicity': 2, 'site_symmetry': '6mm', 'coords_xyz': ['(0,0,z)', '(0,0,-z)']},
            'd': {'multiplicity': 2, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,1/2)', '(2/3,1/3,1/2)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,0)', '(2/3,1/3,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '6/mmm', 'coords_xyz': ['(0,0,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '6/mmm', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (192, 'h'): {
        'IT_number': 192,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 6/m 2/c 2/c',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z)',
                    '(y,-x+y,z)',
                    '(x-y,x,z)',
                    '(y,x,-z+1/2)',
                    '(x-y,-y,-z+1/2)',
                    '(-x,-x+y,-z+1/2)',
                    '(-y,-x,-z+1/2)',
                    '(-x+y,y,-z+1/2)',
                    '(x,x-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(x,y,-z)',
                    '(-y,x-y,-z)',
                    '(-x+y,-x,-z)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                    '(y,x,z+1/2)',
                    '(x-y,-y,z+1/2)',
                    '(-x,-x+y,z+1/2)',
                ],
            },
            'l': {
                'multiplicity': 12,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,0)',
                    '(-y,x-y,0)',
                    '(-x+y,-x,0)',
                    '(-x,-y,0)',
                    '(y,-x+y,0)',
                    '(x-y,x,0)',
                    '(y,x,1/2)',
                    '(x-y,-y,1/2)',
                    '(-x,-x+y,1/2)',
                    '(-y,-x,1/2)',
                    '(-x+y,y,1/2)',
                    '(x,x-y,1/2)',
                ],
            },
            'k': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,2x,1/4)',
                    '(-2x,-x,1/4)',
                    '(x,-x,1/4)',
                    '(-x,-2x,1/4)',
                    '(2x,x,1/4)',
                    '(-x,x,1/4)',
                    '(-x,-2x,3/4)',
                    '(2x,x,3/4)',
                    '(-x,x,3/4)',
                    '(x,2x,3/4)',
                    '(-2x,-x,3/4)',
                    '(x,-x,3/4)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(0,x,1/4)',
                    '(-x,-x,1/4)',
                    '(-x,0,1/4)',
                    '(0,-x,1/4)',
                    '(x,x,1/4)',
                    '(-x,0,3/4)',
                    '(0,-x,3/4)',
                    '(x,x,3/4)',
                    '(x,0,3/4)',
                    '(0,x,3/4)',
                    '(-x,-x,3/4)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(1/2,0,z)',
                    '(0,1/2,z)',
                    '(1/2,1/2,z)',
                    '(0,1/2,-z+1/2)',
                    '(1/2,0,-z+1/2)',
                    '(1/2,1/2,-z+1/2)',
                    '(1/2,0,-z)',
                    '(0,1/2,-z)',
                    '(1/2,1/2,-z)',
                    '(0,1/2,z+1/2)',
                    '(1/2,0,z+1/2)',
                    '(1/2,1/2,z+1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '3..',
                'coords_xyz': [
                    '(1/3,2/3,z)',
                    '(2/3,1/3,z)',
                    '(2/3,1/3,-z+1/2)',
                    '(1/3,2/3,-z+1/2)',
                    '(2/3,1/3,-z)',
                    '(1/3,2/3,-z)',
                    '(1/3,2/3,z+1/2)',
                    '(2/3,1/3,z+1/2)',
                ],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)', '(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,1/2)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '222',
                'coords_xyz': ['(1/2,0,1/4)', '(0,1/2,1/4)', '(1/2,1/2,1/4)', '(1/2,0,3/4)', '(0,1/2,3/4)', '(1/2,1/2,3/4)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '6..',
                'coords_xyz': ['(0,0,z)', '(0,0,-z+1/2)', '(0,0,-z)', '(0,0,z+1/2)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '-6..',
                'coords_xyz': ['(1/3,2/3,0)', '(2/3,1/3,0)', '(2/3,1/3,1/2)', '(1/3,2/3,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '3.2',
                'coords_xyz': ['(1/3,2/3,1/4)', '(2/3,1/3,1/4)', '(2/3,1/3,3/4)', '(1/3,2/3,3/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '6/m..', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '622', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (193, 'h'): {
        'IT_number': 193,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 63/m 2/c 2/m',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/2)',
                    '(x-y,x,z+1/2)',
                    '(y,x,-z+1/2)',
                    '(x-y,-y,-z+1/2)',
                    '(-x,-x+y,-z+1/2)',
                    '(-y,-x,-z)',
                    '(-x+y,y,-z)',
                    '(x,x-y,-z)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(x,y,-z+1/2)',
                    '(-y,x-y,-z+1/2)',
                    '(-x+y,-x,-z+1/2)',
                    '(-y,-x,z+1/2)',
                    '(-x+y,y,z+1/2)',
                    '(x,x-y,z+1/2)',
                    '(y,x,z)',
                    '(x-y,-y,z)',
                    '(-x,-x+y,z)',
                ],
            },
            'k': {
                'multiplicity': 12,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,0,z)',
                    '(0,x,z)',
                    '(-x,-x,z)',
                    '(-x,0,z+1/2)',
                    '(0,-x,z+1/2)',
                    '(x,x,z+1/2)',
                    '(0,x,-z+1/2)',
                    '(x,0,-z+1/2)',
                    '(-x,-x,-z+1/2)',
                    '(0,-x,-z)',
                    '(-x,0,-z)',
                    '(x,x,-z)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,1/4)',
                    '(-y,x-y,1/4)',
                    '(-x+y,-x,1/4)',
                    '(-x,-y,3/4)',
                    '(y,-x+y,3/4)',
                    '(x-y,x,3/4)',
                    '(y,x,1/4)',
                    '(x-y,-y,1/4)',
                    '(-x,-x+y,1/4)',
                    '(-y,-x,3/4)',
                    '(-x+y,y,3/4)',
                    '(x,x-y,3/4)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(x,2x,0)',
                    '(-2x,-x,0)',
                    '(x,-x,0)',
                    '(-x,-2x,1/2)',
                    '(2x,x,1/2)',
                    '(-x,x,1/2)',
                    '(-x,-2x,0)',
                    '(2x,x,0)',
                    '(-x,x,0)',
                    '(x,2x,1/2)',
                    '(-2x,-x,1/2)',
                    '(x,-x,1/2)',
                ],
            },
            'h': {
                'multiplicity': 8,
                'site_symmetry': '3..',
                'coords_xyz': [
                    '(1/3,2/3,z)',
                    '(2/3,1/3,z+1/2)',
                    '(2/3,1/3,-z+1/2)',
                    '(1/3,2/3,-z)',
                    '(2/3,1/3,-z)',
                    '(1/3,2/3,-z+1/2)',
                    '(1/3,2/3,z+1/2)',
                    '(2/3,1/3,z)',
                ],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': 'm2m',
                'coords_xyz': ['(x,0,1/4)', '(0,x,1/4)', '(-x,-x,1/4)', '(-x,0,3/4)', '(0,-x,3/4)', '(x,x,3/4)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '..2/m',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '3.m',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z+1/2)', '(0,0,-z)'],
            },
            'd': {
                'multiplicity': 4,
                'site_symmetry': '3.2',
                'coords_xyz': ['(1/3,2/3,0)', '(2/3,1/3,1/2)', '(2/3,1/3,0)', '(1/3,2/3,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '-6..',
                'coords_xyz': ['(1/3,2/3,1/4)', '(2/3,1/3,3/4)', '(2/3,1/3,1/4)', '(1/3,2/3,3/4)'],
            },
            'b': {'multiplicity': 2, 'site_symmetry': '-3.m', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-62m', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
        },
    },
    (194, 'h'): {
        'IT_number': 194,
        'setting': 0,
        'IT_coordinate_system_code': 'h',
        'name_H-M_alt': 'P 63/m 2/m 2/c',
        'crystal_system': 'hexagonal',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-y,x-y,z)',
                    '(-x+y,-x,z)',
                    '(-x,-y,z+1/2)',
                    '(y,-x+y,z+1/2)',
                    '(x-y,x,z+1/2)',
                    '(y,x,-z)',
                    '(x-y,-y,-z)',
                    '(-x,-x+y,-z)',
                    '(-y,-x,-z+1/2)',
                    '(-x+y,y,-z+1/2)',
                    '(x,x-y,-z+1/2)',
                    '(-x,-y,-z)',
                    '(y,-x+y,-z)',
                    '(x-y,x,-z)',
                    '(x,y,-z+1/2)',
                    '(-y,x-y,-z+1/2)',
                    '(-x+y,-x,-z+1/2)',
                    '(-y,-x,z)',
                    '(-x+y,y,z)',
                    '(x,x-y,z)',
                    '(y,x,z+1/2)',
                    '(x-y,-y,z+1/2)',
                    '(-x,-x+y,z+1/2)',
                ],
            },
            'k': {
                'multiplicity': 12,
                'site_symmetry': '.m.',
                'coords_xyz': [
                    '(x,2x,z)',
                    '(-2x,-x,z)',
                    '(x,-x,z)',
                    '(-x,-2x,z+1/2)',
                    '(2x,x,z+1/2)',
                    '(-x,x,z+1/2)',
                    '(2x,x,-z)',
                    '(-x,-2x,-z)',
                    '(-x,x,-z)',
                    '(-2x,-x,-z+1/2)',
                    '(x,2x,-z+1/2)',
                    '(x,-x,-z+1/2)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(x,y,1/4)',
                    '(-y,x-y,1/4)',
                    '(-x+y,-x,1/4)',
                    '(-x,-y,3/4)',
                    '(y,-x+y,3/4)',
                    '(x-y,x,3/4)',
                    '(y,x,3/4)',
                    '(x-y,-y,3/4)',
                    '(-x,-x+y,3/4)',
                    '(-y,-x,1/4)',
                    '(-x+y,y,1/4)',
                    '(x,x-y,1/4)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '.2.',
                'coords_xyz': [
                    '(x,0,0)',
                    '(0,x,0)',
                    '(-x,-x,0)',
                    '(-x,0,1/2)',
                    '(0,-x,1/2)',
                    '(x,x,1/2)',
                    '(-x,0,0)',
                    '(0,-x,0)',
                    '(x,x,0)',
                    '(x,0,1/2)',
                    '(0,x,1/2)',
                    '(-x,-x,1/2)',
                ],
            },
            'h': {
                'multiplicity': 6,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,2x,1/4)', '(-2x,-x,1/4)', '(x,-x,1/4)', '(-x,-2x,3/4)', '(2x,x,3/4)', '(-x,x,3/4)'],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '.2/m.',
                'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,1/2)'],
            },
            'f': {
                'multiplicity': 4,
                'site_symmetry': '3m.',
                'coords_xyz': ['(1/3,2/3,z)', '(2/3,1/3,z+1/2)', '(2/3,1/3,-z)', '(1/3,2/3,-z+1/2)'],
            },
            'e': {
                'multiplicity': 4,
                'site_symmetry': '3m.',
                'coords_xyz': ['(0,0,z)', '(0,0,z+1/2)', '(0,0,-z)', '(0,0,-z+1/2)'],
            },
            'd': {'multiplicity': 2, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,3/4)', '(2/3,1/3,1/4)']},
            'c': {'multiplicity': 2, 'site_symmetry': '-6m2', 'coords_xyz': ['(1/3,2/3,1/4)', '(2/3,1/3,3/4)']},
            'b': {'multiplicity': 2, 'site_symmetry': '-6m2', 'coords_xyz': ['(0,0,1/4)', '(0,0,3/4)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-3m.', 'coords_xyz': ['(0,0,0)', '(0,0,1/2)']},
        },
    },
    (196, '1'): {
        'IT_number': 196,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 2 3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(1/4,x,1/4)', '(1/4,-x,3/4)', '(1/4,1/4,x)', '(3/4,1/4,-x)'],
            },
            'f': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': ['(x,x,x)', '(-x,-x,x)', '(-x,x,-x)', '(x,-x,-x)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '23.', 'coords_xyz': ['(3/4,3/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '23.', 'coords_xyz': ['(1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '23.', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (197, '1'): {
        'IT_number': 197,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 2 3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'f': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,1/2,0)', '(-x,1/2,0)', '(0,x,1/2)', '(0,-x,1/2)', '(1/2,0,x)', '(1/2,0,-x)'],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'c': {'multiplicity': 8, 'site_symmetry': '.3.', 'coords_xyz': ['(x,x,x)', '(-x,-x,x)', '(-x,x,-x)', '(x,-x,-x)']},
            'b': {'multiplicity': 6, 'site_symmetry': '222', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (199, '1'): {
        'IT_number': 199,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 21 3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'c': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                ],
            },
            'b': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': ['(x,0,1/4)', '(-x+1/2,0,3/4)', '(1/4,x,0)', '(3/4,-x+1/2,0)', '(0,1/4,x)', '(0,3/4,-x+1/2)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': ['(x,x,x)', '(-x+1/2,-x,x+1/2)', '(-x,x+1/2,-x+1/2)', '(x+1/2,-x+1/2,-x)'],
            },
        },
    },
    (202, '1'): {
        'IT_number': 202,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 2/m -3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-z,-x,-y)',
                    '(-z,x,y)',
                    '(z,x,-y)',
                    '(z,-x,y)',
                    '(-y,-z,-x)',
                    '(y,-z,x)',
                    '(-y,z,x)',
                    '(y,z,-x)',
                ],
            },
            'h': {
                'multiplicity': 48,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(z,0,y)',
                    '(z,0,-y)',
                    '(-z,0,y)',
                    '(-z,0,-y)',
                    '(y,z,0)',
                    '(-y,z,0)',
                    '(y,-z,0)',
                    '(-y,-z,0)',
                ],
            },
            'g': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x,3/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,1/4,x)',
                    '(3/4,1/4,-x)',
                    '(-x,3/4,3/4)',
                    '(x,1/4,3/4)',
                    '(3/4,-x,3/4)',
                    '(3/4,x,1/4)',
                    '(3/4,3/4,-x)',
                    '(1/4,3/4,x)',
                ],
            },
            'f': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(-x,-x,-x)',
                    '(x,x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'e': {
                'multiplicity': 24,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {
                'multiplicity': 24,
                'site_symmetry': '2/m..',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)', '(1/4,0,1/4)', '(1/4,0,3/4)', '(1/4,1/4,0)', '(3/4,1/4,0)'],
            },
            'c': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': 'm-3.', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': 'm-3.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (203, '1'): {
        'IT_number': 203,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 2/d -3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(-x+1/4,-y+1/4,-z+1/4)',
                    '(x+1/4,y+1/4,-z+1/4)',
                    '(x+1/4,-y+1/4,z+1/4)',
                    '(-x+1/4,y+1/4,z+1/4)',
                    '(-z+1/4,-x+1/4,-y+1/4)',
                    '(-z+1/4,x+1/4,y+1/4)',
                    '(z+1/4,x+1/4,-y+1/4)',
                    '(z+1/4,-x+1/4,y+1/4)',
                    '(-y+1/4,-z+1/4,-x+1/4)',
                    '(y+1/4,-z+1/4,x+1/4)',
                    '(-y+1/4,z+1/4,x+1/4)',
                    '(y+1/4,z+1/4,-x+1/4)',
                ],
            },
            'f': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(-x+1/4,1/4,1/4)',
                    '(x+1/4,1/4,1/4)',
                    '(1/4,-x+1/4,1/4)',
                    '(1/4,x+1/4,1/4)',
                    '(1/4,1/4,-x+1/4)',
                    '(1/4,1/4,x+1/4)',
                ],
            },
            'e': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(-x+1/4,-x+1/4,-x+1/4)',
                    '(x+1/4,x+1/4,-x+1/4)',
                    '(x+1/4,-x+1/4,x+1/4)',
                    '(-x+1/4,x+1/4,x+1/4)',
                ],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(5/8,5/8,5/8)', '(3/8,3/8,5/8)', '(3/8,5/8,3/8)', '(5/8,3/8,3/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,1/8)', '(7/8,1/8,7/8)', '(1/8,7/8,7/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/2,1/2,1/2)', '(3/4,3/4,3/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)', '(1/4,1/4,1/4)']},
        },
    },
    (203, '2'): {
        'IT_number': 203,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'F 2/d -3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'g': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+3/4,-y+3/4,z)',
                    '(-x+3/4,y,-z+3/4)',
                    '(x,-y+3/4,-z+3/4)',
                    '(z,x,y)',
                    '(z,-x+3/4,-y+3/4)',
                    '(-z+3/4,-x+3/4,y)',
                    '(-z+3/4,x,-y+3/4)',
                    '(y,z,x)',
                    '(-y+3/4,z,-x+3/4)',
                    '(y,-z+3/4,-x+3/4)',
                    '(-y+3/4,-z+3/4,x)',
                    '(-x,-y,-z)',
                    '(x+1/4,y+1/4,-z)',
                    '(x+1/4,-y,z+1/4)',
                    '(-x,y+1/4,z+1/4)',
                    '(-z,-x,-y)',
                    '(-z,x+1/4,y+1/4)',
                    '(z+1/4,x+1/4,-y)',
                    '(z+1/4,-x,y+1/4)',
                    '(-y,-z,-x)',
                    '(y+1/4,-z,x+1/4)',
                    '(-y,z+1/4,x+1/4)',
                    '(y+1/4,z+1/4,-x)',
                ],
            },
            'f': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/8,1/8)',
                    '(-x+3/4,5/8,1/8)',
                    '(1/8,x,1/8)',
                    '(1/8,-x+3/4,5/8)',
                    '(1/8,1/8,x)',
                    '(5/8,1/8,-x+3/4)',
                    '(-x,7/8,7/8)',
                    '(x+1/4,3/8,7/8)',
                    '(7/8,-x,7/8)',
                    '(7/8,x+1/4,3/8)',
                    '(7/8,7/8,-x)',
                    '(3/8,7/8,x+1/4)',
                ],
            },
            'e': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+3/4,-x+3/4,x)',
                    '(-x+3/4,x,-x+3/4)',
                    '(x,-x+3/4,-x+3/4)',
                    '(-x,-x,-x)',
                    '(x+1/4,x+1/4,-x)',
                    '(x+1/4,-x,x+1/4)',
                    '(-x,x+1/4,x+1/4)',
                ],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(1/2,1/2,1/2)', '(1/4,1/4,1/2)', '(1/4,1/2,1/4)', '(1/2,1/4,1/4)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(0,0,0)', '(3/4,3/4,0)', '(3/4,0,3/4)', '(0,3/4,3/4)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(5/8,5/8,5/8)', '(3/8,3/8,3/8)']},
            'a': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,7/8,7/8)']},
        },
    },
    (204, '1'): {
        'IT_number': 204,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 2/m -3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-z,-x,-y)',
                    '(-z,x,y)',
                    '(z,x,-y)',
                    '(z,-x,y)',
                    '(-y,-z,-x)',
                    '(y,-z,x)',
                    '(-y,z,x)',
                    '(y,z,-x)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(z,0,y)',
                    '(z,0,-y)',
                    '(-z,0,y)',
                    '(-z,0,-y)',
                    '(y,z,0)',
                    '(-y,z,0)',
                    '(y,-z,0)',
                    '(-y,-z,0)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(-x,-x,-x)',
                    '(x,x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,0,1/2)', '(-x,0,1/2)', '(1/2,x,0)', '(1/2,-x,0)', '(0,1/2,x)', '(0,1/2,-x)'],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'b': {'multiplicity': 6, 'site_symmetry': 'mmm', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': 'm-3.', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (206, '1'): {
        'IT_number': 206,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 21/a -3',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z)',
                    '(-z,-x,-y)',
                    '(-z+1/2,x+1/2,y)',
                    '(z+1/2,x,-y+1/2)',
                    '(z,-x+1/2,y+1/2)',
                    '(-y,-z,-x)',
                    '(y,-z+1/2,x+1/2)',
                    '(-y+1/2,z+1/2,x)',
                    '(y+1/2,z,-x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x+1/2,0,3/4)',
                    '(1/4,x,0)',
                    '(3/4,-x+1/2,0)',
                    '(0,1/4,x)',
                    '(0,3/4,-x+1/2)',
                    '(-x,0,3/4)',
                    '(x+1/2,0,1/4)',
                    '(3/4,-x,0)',
                    '(1/4,x+1/2,0)',
                    '(0,3/4,-x)',
                    '(0,1/4,x+1/2)',
                ],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x)',
                    '(-x,-x,-x)',
                    '(x+1/2,x,-x+1/2)',
                    '(x,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,x)',
                ],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,3/4,3/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '.-3.',
                'coords_xyz': ['(0,0,0)', '(1/2,0,1/2)', '(0,1/2,1/2)', '(1/2,1/2,0)'],
            },
        },
    },
    (207, '1'): {
        'IT_number': 207,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'k': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/2,y,y)',
                    '(1/2,-y,y)',
                    '(1/2,y,-y)',
                    '(1/2,-y,-y)',
                    '(y,1/2,y)',
                    '(y,1/2,-y)',
                    '(-y,1/2,y)',
                    '(-y,1/2,-y)',
                    '(y,y,1/2)',
                    '(-y,y,1/2)',
                    '(y,-y,1/2)',
                    '(-y,-y,1/2)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,1/2,-x)',
                    '(0,1/2,x)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x,x,-x)',
                    '(-x,-x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '4..',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,1/2)', '(1/2,-x,1/2)', '(1/2,1/2,x)', '(1/2,1/2,-x)'],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '4..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {'multiplicity': 3, 'site_symmetry': '42.', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 3, 'site_symmetry': '42.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '432', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '432', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (208, '1'): {
        'IT_number': 208,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'm': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-y+1/2)',
                    '(-x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,-z+1/2,-y+1/2)',
                    '(x+1/2,-z+1/2,y+1/2)',
                    '(z+1/2,y+1/2,-x+1/2)',
                    '(z+1/2,-y+1/2,x+1/2)',
                    '(-z+1/2,y+1/2,x+1/2)',
                    '(-z+1/2,-y+1/2,-x+1/2)',
                ],
            },
            'l': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,y+1/2)',
                    '(3/4,-y,y+1/2)',
                    '(3/4,y,-y+1/2)',
                    '(1/4,-y,-y+1/2)',
                    '(y+1/2,1/4,y)',
                    '(y+1/2,3/4,-y)',
                    '(-y+1/2,3/4,y)',
                    '(-y+1/2,1/4,-y)',
                    '(y,y+1/2,1/4)',
                    '(-y,y+1/2,3/4)',
                    '(y,-y+1/2,3/4)',
                    '(-y,-y+1/2,1/4)',
                ],
            },
            'k': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,-y+1/2)',
                    '(3/4,-y,-y+1/2)',
                    '(3/4,y,y+1/2)',
                    '(1/4,-y,y+1/2)',
                    '(-y+1/2,1/4,y)',
                    '(-y+1/2,3/4,-y)',
                    '(y+1/2,3/4,y)',
                    '(y+1/2,1/4,-y)',
                    '(y,-y+1/2,1/4)',
                    '(-y,-y+1/2,3/4)',
                    '(y,y+1/2,3/4)',
                    '(-y,y+1/2,1/4)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(0,x+1/2,1/2)',
                    '(0,-x+1/2,1/2)',
                    '(x+1/2,1/2,0)',
                    '(-x+1/2,1/2,0)',
                    '(1/2,0,-x+1/2)',
                    '(1/2,0,x+1/2)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                    '(1/2,x+1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(x+1/2,0,1/2)',
                    '(-x+1/2,0,1/2)',
                    '(0,1/2,-x+1/2)',
                    '(0,1/2,x+1/2)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(1/2,1/2,-x+1/2)',
                    '(1/2,1/2,x+1/2)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x+1/2,x+1/2,-x+1/2)',
                    '(-x+1/2,-x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)', '(0,1/4,1/2)', '(0,3/4,1/2)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)', '(1/2,1/4,0)', '(1/2,3/4,0)', '(0,1/2,1/4)', '(0,1/2,3/4)'],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(3/4,3/4,3/4)', '(1/4,1/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (209, '1'): {
        'IT_number': 209,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 4 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                ],
            },
            'i': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x,3/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,1/4,x)',
                    '(3/4,1/4,-x)',
                    '(1/4,x,3/4)',
                    '(3/4,-x,3/4)',
                    '(x,1/4,3/4)',
                    '(-x,1/4,1/4)',
                    '(1/4,1/4,-x)',
                    '(1/4,3/4,x)',
                ],
            },
            'h': {
                'multiplicity': 48,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/2,y,y)',
                    '(1/2,-y,y)',
                    '(1/2,y,-y)',
                    '(1/2,-y,-y)',
                    '(y,1/2,y)',
                    '(y,1/2,-y)',
                    '(-y,1/2,y)',
                    '(-y,1/2,-y)',
                    '(y,y,1/2)',
                    '(-y,y,1/2)',
                    '(y,-y,1/2)',
                    '(-y,-y,1/2)',
                ],
            },
            'g': {
                'multiplicity': 48,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                ],
            },
            'f': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x,x,-x)',
                    '(-x,-x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'e': {
                'multiplicity': 24,
                'site_symmetry': '4..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {
                'multiplicity': 24,
                'site_symmetry': '2.2',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)', '(1/4,0,1/4)', '(1/4,0,3/4)', '(1/4,1/4,0)', '(3/4,1/4,0)'],
            },
            'c': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/4,1/4,1/4)', '(1/4,1/4,3/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '432', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '432', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (210, '1'): {
        'IT_number': 210,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 41 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,-z+1/2)',
                    '(z,x,y)',
                    '(z+1/2,-x,-y+1/2)',
                    '(-z,-x+1/2,y+1/2)',
                    '(-z+1/2,x+1/2,-y)',
                    '(y,z,x)',
                    '(-y+1/2,z+1/2,-x)',
                    '(y+1/2,-z,-x+1/2)',
                    '(-y,-z+1/2,x+1/2)',
                    '(y+3/4,x+1/4,-z+3/4)',
                    '(-y+1/4,-x+1/4,-z+1/4)',
                    '(y+1/4,-x+3/4,z+3/4)',
                    '(-y+3/4,x+3/4,z+1/4)',
                    '(x+3/4,z+1/4,-y+3/4)',
                    '(-x+3/4,z+3/4,y+1/4)',
                    '(-x+1/4,-z+1/4,-y+1/4)',
                    '(x+1/4,-z+3/4,y+3/4)',
                    '(z+3/4,y+1/4,-x+3/4)',
                    '(z+1/4,-y+3/4,x+3/4)',
                    '(-z+3/4,y+3/4,x+1/4)',
                    '(-z+1/4,-y+1/4,-x+1/4)',
                ],
            },
            'g': {
                'multiplicity': 48,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/8,y,-y+1/4)',
                    '(7/8,-y+1/2,-y+3/4)',
                    '(3/8,y+1/2,y+3/4)',
                    '(5/8,-y,y+1/4)',
                    '(-y+1/4,1/8,y)',
                    '(-y+3/4,7/8,-y+1/2)',
                    '(y+3/4,3/8,y+1/2)',
                    '(y+1/4,5/8,-y)',
                    '(y,-y+1/4,1/8)',
                    '(-y+1/2,-y+3/4,7/8)',
                    '(y+1/2,y+3/4,3/8)',
                    '(-y,y+1/4,5/8)',
                ],
            },
            'f': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,1/2,1/2)',
                    '(0,x,0)',
                    '(1/2,-x,1/2)',
                    '(0,0,x)',
                    '(1/2,1/2,-x)',
                    '(3/4,x+1/4,3/4)',
                    '(1/4,-x+1/4,1/4)',
                    '(x+3/4,1/4,3/4)',
                    '(-x+3/4,3/4,1/4)',
                    '(3/4,1/4,-x+3/4)',
                    '(1/4,3/4,x+3/4)',
                ],
            },
            'e': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,-x)',
                    '(x+1/2,-x,-x+1/2)',
                    '(x+3/4,x+1/4,-x+3/4)',
                    '(-x+1/4,-x+1/4,-x+1/4)',
                    '(x+1/4,-x+3/4,x+3/4)',
                    '(-x+3/4,x+3/4,x+1/4)',
                ],
            },
            'd': {
                'multiplicity': 16,
                'site_symmetry': '.32',
                'coords_xyz': ['(5/8,5/8,5/8)', '(3/8,7/8,1/8)', '(7/8,1/8,3/8)', '(1/8,3/8,7/8)'],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '.32',
                'coords_xyz': ['(1/8,1/8,1/8)', '(7/8,3/8,5/8)', '(3/8,5/8,7/8)', '(5/8,7/8,3/8)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/2,1/2,1/2)', '(1/4,3/4,1/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)', '(3/4,1/4,3/4)']},
        },
    },
    (211, '1'): {
        'IT_number': 211,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 4 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                ],
            },
            'i': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,-y+1/2)',
                    '(3/4,-y,-y+1/2)',
                    '(3/4,y,y+1/2)',
                    '(1/4,-y,y+1/2)',
                    '(-y+1/2,1/4,y)',
                    '(-y+1/2,3/4,-y)',
                    '(y+1/2,3/4,y)',
                    '(y+1/2,1/4,-y)',
                    '(y,-y+1/2,1/4)',
                    '(-y,-y+1/2,3/4)',
                    '(y,y+1/2,3/4)',
                    '(-y,y+1/2,1/4)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,1/2,-x)',
                    '(0,1/2,x)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x,x,-x)',
                    '(-x,-x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': '4..',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)', '(0,1/4,1/2)', '(0,3/4,1/2)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.32',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'b': {'multiplicity': 6, 'site_symmetry': '42.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '432', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (212, '1'): {
        'IT_number': 212,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 43 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                    '(y+1/4,x+3/4,-z+3/4)',
                    '(-y+1/4,-x+1/4,-z+1/4)',
                    '(y+3/4,-x+3/4,z+1/4)',
                    '(-y+3/4,x+1/4,z+3/4)',
                    '(x+1/4,z+3/4,-y+3/4)',
                    '(-x+3/4,z+1/4,y+3/4)',
                    '(-x+1/4,-z+1/4,-y+1/4)',
                    '(x+3/4,-z+3/4,y+1/4)',
                    '(z+1/4,y+3/4,-x+3/4)',
                    '(z+3/4,-y+3/4,x+1/4)',
                    '(-z+3/4,y+1/4,x+3/4)',
                    '(-z+1/4,-y+1/4,-x+1/4)',
                ],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/8,y,-y+1/4)',
                    '(3/8,-y,-y+3/4)',
                    '(7/8,y+1/2,y+1/4)',
                    '(5/8,-y+1/2,y+3/4)',
                    '(-y+1/4,1/8,y)',
                    '(-y+3/4,3/8,-y)',
                    '(y+1/4,7/8,y+1/2)',
                    '(y+3/4,5/8,-y+1/2)',
                    '(y,-y+1/4,1/8)',
                    '(-y,-y+3/4,3/8)',
                    '(y+1/2,y+1/4,7/8)',
                    '(-y+1/2,y+3/4,5/8)',
                ],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x)',
                    '(x+1/4,x+3/4,-x+3/4)',
                    '(-x+1/4,-x+1/4,-x+1/4)',
                    '(x+3/4,-x+3/4,x+1/4)',
                    '(-x+3/4,x+1/4,x+3/4)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(5/8,5/8,5/8)', '(7/8,3/8,1/8)', '(3/8,1/8,7/8)', '(1/8,7/8,3/8)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(1/8,1/8,1/8)', '(3/8,7/8,5/8)', '(7/8,5/8,3/8)', '(5/8,3/8,7/8)'],
            },
        },
    },
    (213, '1'): {
        'IT_number': 213,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 41 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                    '(y+3/4,x+1/4,-z+1/4)',
                    '(-y+3/4,-x+3/4,-z+3/4)',
                    '(y+1/4,-x+1/4,z+3/4)',
                    '(-y+1/4,x+3/4,z+1/4)',
                    '(x+3/4,z+1/4,-y+1/4)',
                    '(-x+1/4,z+3/4,y+1/4)',
                    '(-x+3/4,-z+3/4,-y+3/4)',
                    '(x+1/4,-z+1/4,y+3/4)',
                    '(z+3/4,y+1/4,-x+1/4)',
                    '(z+1/4,-y+1/4,x+3/4)',
                    '(-z+1/4,y+3/4,x+1/4)',
                    '(-z+3/4,-y+3/4,-x+3/4)',
                ],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/8,y,y+1/4)',
                    '(3/8,-y,y+3/4)',
                    '(7/8,y+1/2,-y+1/4)',
                    '(5/8,-y+1/2,-y+3/4)',
                    '(y+1/4,1/8,y)',
                    '(y+3/4,3/8,-y)',
                    '(-y+1/4,7/8,y+1/2)',
                    '(-y+3/4,5/8,-y+1/2)',
                    '(y,y+1/4,1/8)',
                    '(-y,y+3/4,3/8)',
                    '(y+1/2,-y+1/4,7/8)',
                    '(-y+1/2,-y+3/4,5/8)',
                ],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x)',
                    '(x+3/4,x+1/4,-x+1/4)',
                    '(-x+3/4,-x+3/4,-x+3/4)',
                    '(x+1/4,-x+1/4,x+3/4)',
                    '(-x+1/4,x+3/4,x+1/4)',
                ],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(7/8,7/8,7/8)', '(5/8,1/8,3/8)', '(1/8,3/8,5/8)', '(3/8,5/8,1/8)'],
            },
            'a': {
                'multiplicity': 4,
                'site_symmetry': '.32',
                'coords_xyz': ['(3/8,3/8,3/8)', '(1/8,5/8,7/8)', '(5/8,7/8,1/8)', '(7/8,1/8,5/8)'],
            },
        },
    },
    (214, '1'): {
        'IT_number': 214,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I 41 3 2',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                    '(y+3/4,x+1/4,-z+1/4)',
                    '(-y+3/4,-x+3/4,-z+3/4)',
                    '(y+1/4,-x+1/4,z+3/4)',
                    '(-y+1/4,x+3/4,z+1/4)',
                    '(x+3/4,z+1/4,-y+1/4)',
                    '(-x+1/4,z+3/4,y+1/4)',
                    '(-x+3/4,-z+3/4,-y+3/4)',
                    '(x+1/4,-z+1/4,y+3/4)',
                    '(z+3/4,y+1/4,-x+1/4)',
                    '(z+1/4,-y+1/4,x+3/4)',
                    '(-z+1/4,y+3/4,x+1/4)',
                    '(-z+3/4,-y+3/4,-x+3/4)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/8,y,-y+1/4)',
                    '(3/8,-y,-y+3/4)',
                    '(7/8,y+1/2,y+1/4)',
                    '(5/8,-y+1/2,y+3/4)',
                    '(-y+1/4,1/8,y)',
                    '(-y+3/4,3/8,-y)',
                    '(y+1/4,7/8,y+1/2)',
                    '(y+3/4,5/8,-y+1/2)',
                    '(y,-y+1/4,1/8)',
                    '(-y,-y+3/4,3/8)',
                    '(y+1/2,y+1/4,7/8)',
                    '(-y+1/2,y+3/4,5/8)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/8,y,y+1/4)',
                    '(3/8,-y,y+3/4)',
                    '(7/8,y+1/2,-y+1/4)',
                    '(5/8,-y+1/2,-y+3/4)',
                    '(y+1/4,1/8,y)',
                    '(y+3/4,3/8,-y)',
                    '(-y+1/4,7/8,y+1/2)',
                    '(-y+3/4,5/8,-y+1/2)',
                    '(y,y+1/4,1/8)',
                    '(-y,y+3/4,3/8)',
                    '(y+1/2,-y+1/4,7/8)',
                    '(-y+1/2,-y+3/4,5/8)',
                ],
            },
            'f': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x+1/2,0,3/4)',
                    '(1/4,x,0)',
                    '(3/4,-x+1/2,0)',
                    '(0,1/4,x)',
                    '(0,3/4,-x+1/2)',
                    '(3/4,x+1/4,0)',
                    '(3/4,-x+3/4,1/2)',
                    '(x+3/4,1/2,1/4)',
                    '(-x+1/4,0,1/4)',
                    '(0,1/4,-x+1/4)',
                    '(1/2,1/4,x+3/4)',
                ],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x)',
                    '(x+3/4,x+1/4,-x+1/4)',
                    '(-x+3/4,-x+3/4,-x+3/4)',
                    '(x+1/4,-x+1/4,x+3/4)',
                    '(-x+1/4,x+3/4,x+1/4)',
                ],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '2.2',
                'coords_xyz': ['(5/8,0,1/4)', '(7/8,0,3/4)', '(1/4,5/8,0)', '(3/4,7/8,0)', '(0,1/4,5/8)', '(0,3/4,7/8)'],
            },
            'c': {
                'multiplicity': 12,
                'site_symmetry': '2.2',
                'coords_xyz': ['(1/8,0,1/4)', '(3/8,0,3/4)', '(1/4,1/8,0)', '(3/4,3/8,0)', '(0,1/4,1/8)', '(0,3/4,3/8)'],
            },
            'b': {
                'multiplicity': 8,
                'site_symmetry': '.32',
                'coords_xyz': ['(7/8,7/8,7/8)', '(5/8,1/8,3/8)', '(1/8,3/8,5/8)', '(3/8,5/8,1/8)'],
            },
            'a': {
                'multiplicity': 8,
                'site_symmetry': '.32',
                'coords_xyz': ['(1/8,1/8,1/8)', '(3/8,7/8,5/8)', '(7/8,5/8,3/8)', '(5/8,3/8,7/8)'],
            },
        },
    },
    (215, '1'): {
        'IT_number': 215,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 3 m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'j': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,z)',
                    '(-y,-x,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(z,y,x)',
                    '(z,-y,-x)',
                    '(-z,y,-x)',
                    '(-z,-y,x)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                ],
            },
            'g': {
                'multiplicity': 6,
                'site_symmetry': '2.m',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,1/2)', '(1/2,-x,1/2)', '(1/2,1/2,x)', '(1/2,1/2,-x)'],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '2.m',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'e': {'multiplicity': 4, 'site_symmetry': '.3m', 'coords_xyz': ['(x,x,x)', '(-x,-x,x)', '(-x,x,-x)', '(x,-x,-x)']},
            'd': {'multiplicity': 3, 'site_symmetry': '-42.', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 3, 'site_symmetry': '-42.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': '-43m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': '-43m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (216, '1'): {
        'IT_number': 216,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F -4 3 m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,z)',
                    '(-y,-x,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(z,y,x)',
                    '(z,-y,-x)',
                    '(-z,y,-x)',
                    '(-z,-y,x)',
                ],
            },
            'h': {
                'multiplicity': 48,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '2.m',
                'coords_xyz': ['(x,1/4,1/4)', '(-x,3/4,1/4)', '(1/4,x,1/4)', '(1/4,-x,3/4)', '(1/4,1/4,x)', '(3/4,1/4,-x)'],
            },
            'f': {
                'multiplicity': 24,
                'site_symmetry': '2.m',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'e': {
                'multiplicity': 16,
                'site_symmetry': '.3m',
                'coords_xyz': ['(x,x,x)', '(-x,-x,x)', '(-x,x,-x)', '(x,-x,-x)'],
            },
            'd': {'multiplicity': 4, 'site_symmetry': '-43m', 'coords_xyz': ['(3/4,3/4,3/4)']},
            'c': {'multiplicity': 4, 'site_symmetry': '-43m', 'coords_xyz': ['(1/4,1/4,1/4)']},
            'b': {'multiplicity': 4, 'site_symmetry': '-43m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 4, 'site_symmetry': '-43m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (217, '1'): {
        'IT_number': 217,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 3 m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,z)',
                    '(-y,-x,z)',
                    '(y,-x,-z)',
                    '(-y,x,-z)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(z,y,x)',
                    '(z,-y,-x)',
                    '(-z,y,-x)',
                    '(-z,-y,x)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                ],
            },
            'f': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': '2.m',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)', '(0,1/4,1/2)', '(0,3/4,1/2)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'c': {'multiplicity': 8, 'site_symmetry': '.3m', 'coords_xyz': ['(x,x,x)', '(-x,-x,x)', '(-x,x,-x)', '(x,-x,-x)']},
            'b': {'multiplicity': 6, 'site_symmetry': '-42.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'a': {'multiplicity': 2, 'site_symmetry': '-43m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (218, '1'): {
        'IT_number': 218,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P -4 3 n',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 24,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,z+1/2,-y+1/2)',
                    '(-x+1/2,-z+1/2,y+1/2)',
                    '(x+1/2,-z+1/2,-y+1/2)',
                    '(z+1/2,y+1/2,x+1/2)',
                    '(z+1/2,-y+1/2,-x+1/2)',
                    '(-z+1/2,y+1/2,-x+1/2)',
                    '(-z+1/2,-y+1/2,x+1/2)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                    '(1/2,x+1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(x+1/2,0,1/2)',
                    '(-x+1/2,0,1/2)',
                    '(0,1/2,x+1/2)',
                    '(0,1/2,-x+1/2)',
                ],
            },
            'g': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(0,x+1/2,1/2)',
                    '(0,-x+1/2,1/2)',
                    '(x+1/2,1/2,0)',
                    '(-x+1/2,1/2,0)',
                    '(1/2,0,x+1/2)',
                    '(1/2,0,-x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 12,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(1/2,1/2,x+1/2)',
                    '(1/2,1/2,-x+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x+1/2,x+1/2,x+1/2)',
                    '(-x+1/2,-x+1/2,x+1/2)',
                    '(x+1/2,-x+1/2,-x+1/2)',
                    '(-x+1/2,x+1/2,-x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)', '(1/2,1/4,0)', '(1/2,3/4,0)', '(0,1/2,1/4)', '(0,1/2,3/4)'],
            },
            'c': {
                'multiplicity': 6,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)', '(0,1/4,1/2)', '(0,3/4,1/2)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': '222',
                'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (219, '1'): {
        'IT_number': 219,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F -4 3 c',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'h': {
                'multiplicity': 96,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,z+1/2,-y+1/2)',
                    '(-x+1/2,-z+1/2,y+1/2)',
                    '(x+1/2,-z+1/2,-y+1/2)',
                    '(z+1/2,y+1/2,x+1/2)',
                    '(z+1/2,-y+1/2,-x+1/2)',
                    '(-z+1/2,y+1/2,-x+1/2)',
                    '(-z+1/2,-y+1/2,x+1/2)',
                ],
            },
            'g': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x,3/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,1/4,x)',
                    '(3/4,1/4,-x)',
                    '(3/4,x+1/2,3/4)',
                    '(1/4,-x+1/2,3/4)',
                    '(x+1/2,3/4,3/4)',
                    '(-x+1/2,3/4,1/4)',
                    '(3/4,3/4,x+1/2)',
                    '(3/4,1/4,-x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 48,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(1/2,1/2,x+1/2)',
                    '(1/2,1/2,-x+1/2)',
                ],
            },
            'e': {
                'multiplicity': 32,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x+1/2,x+1/2,x+1/2)',
                    '(-x+1/2,-x+1/2,x+1/2)',
                    '(x+1/2,-x+1/2,-x+1/2)',
                    '(-x+1/2,x+1/2,-x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 24,
                'site_symmetry': '-4..',
                'coords_xyz': ['(1/4,0,0)', '(3/4,0,0)', '(0,1/4,0)', '(0,3/4,0)', '(0,0,1/4)', '(0,0,3/4)'],
            },
            'c': {
                'multiplicity': 24,
                'site_symmetry': '-4..',
                'coords_xyz': ['(0,1/4,1/4)', '(0,3/4,1/4)', '(1/4,0,1/4)', '(1/4,0,3/4)', '(1/4,1/4,0)', '(3/4,1/4,0)'],
            },
            'b': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
            'a': {'multiplicity': 8, 'site_symmetry': '23.', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (220, '1'): {
        'IT_number': 220,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'I -4 3 d',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'e': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,-z)',
                    '(z,x,y)',
                    '(z+1/2,-x+1/2,-y)',
                    '(-z+1/2,-x,y+1/2)',
                    '(-z,x+1/2,-y+1/2)',
                    '(y,z,x)',
                    '(-y,z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,-x)',
                    '(-y+1/2,-z,x+1/2)',
                    '(y+1/4,x+1/4,z+1/4)',
                    '(-y+1/4,-x+3/4,z+3/4)',
                    '(y+3/4,-x+1/4,-z+3/4)',
                    '(-y+3/4,x+3/4,-z+1/4)',
                    '(x+1/4,z+1/4,y+1/4)',
                    '(-x+3/4,z+3/4,-y+1/4)',
                    '(-x+1/4,-z+3/4,y+3/4)',
                    '(x+3/4,-z+1/4,-y+3/4)',
                    '(z+1/4,y+1/4,x+1/4)',
                    '(z+3/4,-y+1/4,-x+3/4)',
                    '(-z+3/4,y+3/4,-x+1/4)',
                    '(-z+1/4,-y+3/4,x+3/4)',
                ],
            },
            'd': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/4)',
                    '(-x+1/2,0,3/4)',
                    '(1/4,x,0)',
                    '(3/4,-x+1/2,0)',
                    '(0,1/4,x)',
                    '(0,3/4,-x+1/2)',
                    '(1/4,x+1/4,1/2)',
                    '(1/4,-x+3/4,0)',
                    '(x+1/4,1/2,1/4)',
                    '(-x+3/4,0,1/4)',
                    '(1/2,1/4,x+1/4)',
                    '(0,1/4,-x+3/4)',
                ],
            },
            'c': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x)',
                    '(x+1/4,x+1/4,x+1/4)',
                    '(-x+1/4,-x+3/4,x+3/4)',
                    '(x+3/4,-x+1/4,-x+3/4)',
                    '(-x+3/4,x+3/4,-x+1/4)',
                ],
            },
            'b': {
                'multiplicity': 12,
                'site_symmetry': '-4..',
                'coords_xyz': ['(7/8,0,1/4)', '(5/8,0,3/4)', '(1/4,7/8,0)', '(3/4,5/8,0)', '(0,1/4,7/8)', '(0,3/4,5/8)'],
            },
            'a': {
                'multiplicity': 12,
                'site_symmetry': '-4..',
                'coords_xyz': ['(3/8,0,1/4)', '(1/8,0,3/4)', '(1/4,3/8,0)', '(3/4,1/8,0)', '(0,1/4,3/8)', '(0,3/4,1/8)'],
            },
        },
    },
    (221, '1'): {
        'IT_number': 221,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/m -3 2/m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'n': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-z,-x,-y)',
                    '(-z,x,y)',
                    '(z,x,-y)',
                    '(z,-x,y)',
                    '(-y,-z,-x)',
                    '(y,-z,x)',
                    '(-y,z,x)',
                    '(y,z,-x)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                    '(-y,x,-z)',
                    '(y,-x,-z)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-z,-y,x)',
                    '(-z,y,-x)',
                    '(z,-y,-x)',
                    '(z,y,x)',
                ],
            },
            'm': {
                'multiplicity': 24,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                    '(x,-x,z)',
                    '(-x,x,z)',
                    '(x,z,-x)',
                    '(-x,z,x)',
                    '(-x,-z,-x)',
                    '(x,-z,x)',
                    '(z,x,-x)',
                    '(z,-x,x)',
                    '(-z,x,x)',
                    '(-z,-x,-x)',
                ],
            },
            'l': {
                'multiplicity': 24,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(1/2,y,z)',
                    '(1/2,-y,z)',
                    '(1/2,y,-z)',
                    '(1/2,-y,-z)',
                    '(z,1/2,y)',
                    '(z,1/2,-y)',
                    '(-z,1/2,y)',
                    '(-z,1/2,-y)',
                    '(y,z,1/2)',
                    '(-y,z,1/2)',
                    '(y,-z,1/2)',
                    '(-y,-z,1/2)',
                    '(y,1/2,-z)',
                    '(-y,1/2,-z)',
                    '(y,1/2,z)',
                    '(-y,1/2,z)',
                    '(1/2,z,-y)',
                    '(1/2,z,y)',
                    '(1/2,-z,-y)',
                    '(1/2,-z,y)',
                    '(z,y,1/2)',
                    '(z,-y,1/2)',
                    '(-z,y,1/2)',
                    '(-z,-y,1/2)',
                ],
            },
            'k': {
                'multiplicity': 24,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(z,0,y)',
                    '(z,0,-y)',
                    '(-z,0,y)',
                    '(-z,0,-y)',
                    '(y,z,0)',
                    '(-y,z,0)',
                    '(y,-z,0)',
                    '(-y,-z,0)',
                    '(y,0,-z)',
                    '(-y,0,-z)',
                    '(y,0,z)',
                    '(-y,0,z)',
                    '(0,z,-y)',
                    '(0,z,y)',
                    '(0,-z,-y)',
                    '(0,-z,y)',
                    '(z,y,0)',
                    '(z,-y,0)',
                    '(-z,y,0)',
                    '(-z,-y,0)',
                ],
            },
            'j': {
                'multiplicity': 12,
                'site_symmetry': 'm.m',
                'coords_xyz': [
                    '(1/2,y,y)',
                    '(1/2,-y,y)',
                    '(1/2,y,-y)',
                    '(1/2,-y,-y)',
                    '(y,1/2,y)',
                    '(y,1/2,-y)',
                    '(-y,1/2,y)',
                    '(-y,1/2,-y)',
                    '(y,y,1/2)',
                    '(-y,y,1/2)',
                    '(y,-y,1/2)',
                    '(-y,-y,1/2)',
                ],
            },
            'i': {
                'multiplicity': 12,
                'site_symmetry': 'm.m',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(0,1/2,-x)',
                    '(0,1/2,x)',
                ],
            },
            'g': {
                'multiplicity': 8,
                'site_symmetry': '.3m',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x,x,-x)',
                    '(-x,-x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                ],
            },
            'f': {
                'multiplicity': 6,
                'site_symmetry': '4m.',
                'coords_xyz': ['(x,1/2,1/2)', '(-x,1/2,1/2)', '(1/2,x,1/2)', '(1/2,-x,1/2)', '(1/2,1/2,x)', '(1/2,1/2,-x)'],
            },
            'e': {
                'multiplicity': 6,
                'site_symmetry': '4m.',
                'coords_xyz': ['(x,0,0)', '(-x,0,0)', '(0,x,0)', '(0,-x,0)', '(0,0,x)', '(0,0,-x)'],
            },
            'd': {'multiplicity': 3, 'site_symmetry': '4/mm.', 'coords_xyz': ['(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)']},
            'c': {'multiplicity': 3, 'site_symmetry': '4/mm.', 'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)']},
            'b': {'multiplicity': 1, 'site_symmetry': 'm-3m', 'coords_xyz': ['(1/2,1/2,1/2)']},
            'a': {'multiplicity': 1, 'site_symmetry': 'm-3m', 'coords_xyz': ['(0,0,0)']},
        },
    },
    (222, '1'): {
        'IT_number': 222,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 4/n -3 2/n',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-z+1/2,-x+1/2,-y+1/2)',
                    '(-z+1/2,x+1/2,y+1/2)',
                    '(z+1/2,x+1/2,-y+1/2)',
                    '(z+1/2,-x+1/2,y+1/2)',
                    '(-y+1/2,-z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,x+1/2)',
                    '(-y+1/2,z+1/2,x+1/2)',
                    '(y+1/2,z+1/2,-x+1/2)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-x+1/2,-z+1/2,y+1/2)',
                    '(x+1/2,-z+1/2,-y+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,z+1/2,-y+1/2)',
                    '(-z+1/2,-y+1/2,x+1/2)',
                    '(-z+1/2,y+1/2,-x+1/2)',
                    '(z+1/2,-y+1/2,-x+1/2)',
                    '(z+1/2,y+1/2,x+1/2)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                    '(1/2,-y+1/2,-y+1/2)',
                    '(1/2,y+1/2,-y+1/2)',
                    '(1/2,-y+1/2,y+1/2)',
                    '(1/2,y+1/2,y+1/2)',
                    '(-y+1/2,1/2,-y+1/2)',
                    '(-y+1/2,1/2,y+1/2)',
                    '(y+1/2,1/2,-y+1/2)',
                    '(y+1/2,1/2,y+1/2)',
                    '(-y+1/2,-y+1/2,1/2)',
                    '(y+1/2,-y+1/2,1/2)',
                    '(-y+1/2,y+1/2,1/2)',
                    '(y+1/2,y+1/2,1/2)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(1/2,0,-x)',
                    '(1/2,0,x)',
                    '(-x+1/2,1/2,0)',
                    '(x+1/2,1/2,0)',
                    '(0,-x+1/2,1/2)',
                    '(0,x+1/2,1/2)',
                    '(1/2,0,-x+1/2)',
                    '(1/2,0,x+1/2)',
                    '(1/2,-x+1/2,0)',
                    '(1/2,x+1/2,0)',
                    '(-x+1/2,0,1/2)',
                    '(x+1/2,0,1/2)',
                    '(0,1/2,x+1/2)',
                    '(0,1/2,-x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x,x,-x)',
                    '(-x,-x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                    '(-x+1/2,-x+1/2,-x+1/2)',
                    '(x+1/2,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,x+1/2)',
                    '(-x+1/2,-x+1/2,x+1/2)',
                    '(x+1/2,x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x+1/2)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': '4..',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(-x+1/2,1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,1/2,-x+1/2)',
                    '(1/2,1/2,x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '-4..',
                'coords_xyz': [
                    '(1/4,0,1/2)',
                    '(3/4,0,1/2)',
                    '(1/2,1/4,0)',
                    '(1/2,3/4,0)',
                    '(0,1/2,1/4)',
                    '(0,1/2,3/4)',
                    '(0,1/4,1/2)',
                    '(0,3/4,1/2)',
                    '(1/4,1/2,0)',
                    '(3/4,1/2,0)',
                    '(1/2,0,3/4)',
                    '(1/2,0,1/4)',
                ],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.-3.',
                'coords_xyz': [
                    '(1/4,1/4,1/4)',
                    '(3/4,3/4,1/4)',
                    '(3/4,1/4,3/4)',
                    '(1/4,3/4,3/4)',
                    '(1/4,1/4,3/4)',
                    '(3/4,3/4,3/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,1/4,1/4)',
                ],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': '42.',
                'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(1/2,0,0)', '(0,1/2,0)', '(0,0,1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '432', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (222, '2'): {
        'IT_number': 222,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 4/n -3 2/n',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'i': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(z,x,y)',
                    '(z,-x+1/2,-y+1/2)',
                    '(-z+1/2,-x+1/2,y)',
                    '(-z+1/2,x,-y+1/2)',
                    '(y,z,x)',
                    '(-y+1/2,z,-x+1/2)',
                    '(y,-z+1/2,-x+1/2)',
                    '(-y+1/2,-z+1/2,x)',
                    '(y,x,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(y,-x+1/2,z)',
                    '(-y+1/2,x,z)',
                    '(x,z,-y+1/2)',
                    '(-x+1/2,z,y)',
                    '(-x+1/2,-z+1/2,-y+1/2)',
                    '(x,-z+1/2,y)',
                    '(z,y,-x+1/2)',
                    '(z,-y+1/2,x)',
                    '(-z+1/2,y,x)',
                    '(-z+1/2,-y+1/2,-x+1/2)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(-z,-x,-y)',
                    '(-z,x+1/2,y+1/2)',
                    '(z+1/2,x+1/2,-y)',
                    '(z+1/2,-x,y+1/2)',
                    '(-y,-z,-x)',
                    '(y+1/2,-z,x+1/2)',
                    '(-y,z+1/2,x+1/2)',
                    '(y+1/2,z+1/2,-x)',
                    '(-y,-x,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(-y,x+1/2,-z)',
                    '(y+1/2,-x,-z)',
                    '(-x,-z,y+1/2)',
                    '(x+1/2,-z,-y)',
                    '(x+1/2,z+1/2,y+1/2)',
                    '(-x,z+1/2,-y)',
                    '(-z,-y,x+1/2)',
                    '(-z,y+1/2,-x)',
                    '(z+1/2,-y,-x)',
                    '(z+1/2,y+1/2,x+1/2)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,y)',
                    '(1/4,-y+1/2,y)',
                    '(1/4,y,-y+1/2)',
                    '(1/4,-y+1/2,-y+1/2)',
                    '(y,1/4,y)',
                    '(y,1/4,-y+1/2)',
                    '(-y+1/2,1/4,y)',
                    '(-y+1/2,1/4,-y+1/2)',
                    '(y,y,1/4)',
                    '(-y+1/2,y,1/4)',
                    '(y,-y+1/2,1/4)',
                    '(-y+1/2,-y+1/2,1/4)',
                    '(3/4,-y,-y)',
                    '(3/4,y+1/2,-y)',
                    '(3/4,-y,y+1/2)',
                    '(3/4,y+1/2,y+1/2)',
                    '(-y,3/4,-y)',
                    '(-y,3/4,y+1/2)',
                    '(y+1/2,3/4,-y)',
                    '(y+1/2,3/4,y+1/2)',
                    '(-y,-y,3/4)',
                    '(y+1/2,-y,3/4)',
                    '(-y,y+1/2,3/4)',
                    '(y+1/2,y+1/2,3/4)',
                ],
            },
            'g': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,3/4,1/4)',
                    '(-x+1/2,3/4,1/4)',
                    '(1/4,x,3/4)',
                    '(1/4,-x+1/2,3/4)',
                    '(3/4,1/4,x)',
                    '(3/4,1/4,-x+1/2)',
                    '(3/4,x,1/4)',
                    '(3/4,-x+1/2,1/4)',
                    '(x,1/4,3/4)',
                    '(-x+1/2,1/4,3/4)',
                    '(1/4,3/4,-x+1/2)',
                    '(1/4,3/4,x)',
                    '(-x,1/4,3/4)',
                    '(x+1/2,1/4,3/4)',
                    '(3/4,-x,1/4)',
                    '(3/4,x+1/2,1/4)',
                    '(1/4,3/4,-x)',
                    '(1/4,3/4,x+1/2)',
                    '(1/4,-x,3/4)',
                    '(1/4,x+1/2,3/4)',
                    '(-x,3/4,1/4)',
                    '(x+1/2,3/4,1/4)',
                    '(3/4,1/4,x+1/2)',
                    '(3/4,1/4,-x)',
                ],
            },
            'f': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x+1/2,x)',
                    '(-x+1/2,x,-x+1/2)',
                    '(x,-x+1/2,-x+1/2)',
                    '(x,x,-x+1/2)',
                    '(-x+1/2,-x+1/2,-x+1/2)',
                    '(x,-x+1/2,x)',
                    '(-x+1/2,x,x)',
                    '(-x,-x,-x)',
                    '(x+1/2,x+1/2,-x)',
                    '(x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,x+1/2)',
                    '(-x,-x,x+1/2)',
                    '(x+1/2,x+1/2,x+1/2)',
                    '(-x,x+1/2,-x)',
                    '(x+1/2,-x,-x)',
                ],
            },
            'e': {
                'multiplicity': 12,
                'site_symmetry': '4..',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x+1/2,1/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x+1/2,1/4)',
                    '(1/4,1/4,x)',
                    '(1/4,1/4,-x+1/2)',
                    '(-x,3/4,3/4)',
                    '(x+1/2,3/4,3/4)',
                    '(3/4,-x,3/4)',
                    '(3/4,x+1/2,3/4)',
                    '(3/4,3/4,-x)',
                    '(3/4,3/4,x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 12,
                'site_symmetry': '-4..',
                'coords_xyz': [
                    '(0,3/4,1/4)',
                    '(1/2,3/4,1/4)',
                    '(1/4,0,3/4)',
                    '(1/4,1/2,3/4)',
                    '(3/4,1/4,0)',
                    '(3/4,1/4,1/2)',
                    '(3/4,0,1/4)',
                    '(3/4,1/2,1/4)',
                    '(0,1/4,3/4)',
                    '(1/2,1/4,3/4)',
                    '(1/4,3/4,1/2)',
                    '(1/4,3/4,0)',
                ],
            },
            'c': {
                'multiplicity': 8,
                'site_symmetry': '.-3.',
                'coords_xyz': [
                    '(0,0,0)',
                    '(1/2,1/2,0)',
                    '(1/2,0,1/2)',
                    '(0,1/2,1/2)',
                    '(0,0,1/2)',
                    '(1/2,1/2,1/2)',
                    '(0,1/2,0)',
                    '(1/2,0,0)',
                ],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': '42.',
                'coords_xyz': [
                    '(3/4,1/4,1/4)',
                    '(1/4,3/4,1/4)',
                    '(1/4,1/4,3/4)',
                    '(1/4,3/4,3/4)',
                    '(3/4,1/4,3/4)',
                    '(3/4,3/4,1/4)',
                ],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '432', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (223, '1'): {
        'IT_number': 223,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/m -3 2/n',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-y+1/2)',
                    '(-x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,-z+1/2,-y+1/2)',
                    '(x+1/2,-z+1/2,y+1/2)',
                    '(z+1/2,y+1/2,-x+1/2)',
                    '(z+1/2,-y+1/2,x+1/2)',
                    '(-z+1/2,y+1/2,x+1/2)',
                    '(-z+1/2,-y+1/2,-x+1/2)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-z,-x,-y)',
                    '(-z,x,y)',
                    '(z,x,-y)',
                    '(z,-x,y)',
                    '(-y,-z,-x)',
                    '(y,-z,x)',
                    '(-y,z,x)',
                    '(y,z,-x)',
                    '(-y+1/2,-x+1/2,z+1/2)',
                    '(y+1/2,x+1/2,z+1/2)',
                    '(-y+1/2,x+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,-z+1/2)',
                    '(-x+1/2,-z+1/2,y+1/2)',
                    '(x+1/2,-z+1/2,-y+1/2)',
                    '(x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,z+1/2,-y+1/2)',
                    '(-z+1/2,-y+1/2,x+1/2)',
                    '(-z+1/2,y+1/2,-x+1/2)',
                    '(z+1/2,-y+1/2,-x+1/2)',
                    '(z+1/2,y+1/2,x+1/2)',
                ],
            },
            'k': {
                'multiplicity': 24,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(z,0,y)',
                    '(z,0,-y)',
                    '(-z,0,y)',
                    '(-z,0,-y)',
                    '(y,z,0)',
                    '(-y,z,0)',
                    '(y,-z,0)',
                    '(-y,-z,0)',
                    '(y+1/2,1/2,-z+1/2)',
                    '(-y+1/2,1/2,-z+1/2)',
                    '(y+1/2,1/2,z+1/2)',
                    '(-y+1/2,1/2,z+1/2)',
                    '(1/2,z+1/2,-y+1/2)',
                    '(1/2,z+1/2,y+1/2)',
                    '(1/2,-z+1/2,-y+1/2)',
                    '(1/2,-z+1/2,y+1/2)',
                    '(z+1/2,y+1/2,1/2)',
                    '(z+1/2,-y+1/2,1/2)',
                    '(-z+1/2,y+1/2,1/2)',
                    '(-z+1/2,-y+1/2,1/2)',
                ],
            },
            'j': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,y+1/2)',
                    '(3/4,-y,y+1/2)',
                    '(3/4,y,-y+1/2)',
                    '(1/4,-y,-y+1/2)',
                    '(y+1/2,1/4,y)',
                    '(y+1/2,3/4,-y)',
                    '(-y+1/2,3/4,y)',
                    '(-y+1/2,1/4,-y)',
                    '(y,y+1/2,1/4)',
                    '(-y,y+1/2,3/4)',
                    '(y,-y+1/2,3/4)',
                    '(-y,-y+1/2,1/4)',
                    '(3/4,-y,-y+1/2)',
                    '(1/4,y,-y+1/2)',
                    '(1/4,-y,y+1/2)',
                    '(3/4,y,y+1/2)',
                    '(-y+1/2,3/4,-y)',
                    '(-y+1/2,1/4,y)',
                    '(y+1/2,1/4,-y)',
                    '(y+1/2,3/4,y)',
                    '(-y,-y+1/2,3/4)',
                    '(y,-y+1/2,1/4)',
                    '(-y,y+1/2,1/4)',
                    '(y,y+1/2,3/4)',
                ],
            },
            'i': {
                'multiplicity': 16,
                'site_symmetry': '.3.',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x+1/2,x+1/2,-x+1/2)',
                    '(-x+1/2,-x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,x+1/2)',
                    '(-x,-x,-x)',
                    '(x,x,-x)',
                    '(x,-x,x)',
                    '(-x,x,x)',
                    '(-x+1/2,-x+1/2,x+1/2)',
                    '(x+1/2,x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,-x+1/2)',
                ],
            },
            'h': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': [
                    '(x,1/2,0)',
                    '(-x,1/2,0)',
                    '(0,x,1/2)',
                    '(0,-x,1/2)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                    '(0,x+1/2,1/2)',
                    '(0,-x+1/2,1/2)',
                    '(x+1/2,1/2,0)',
                    '(-x+1/2,1/2,0)',
                    '(1/2,0,-x+1/2)',
                    '(1/2,0,x+1/2)',
                ],
            },
            'g': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                    '(1/2,x+1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(x+1/2,0,1/2)',
                    '(-x+1/2,0,1/2)',
                    '(0,1/2,-x+1/2)',
                    '(0,1/2,x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 12,
                'site_symmetry': 'mm2',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(1/2,1/2,-x+1/2)',
                    '(1/2,1/2,x+1/2)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.32',
                'coords_xyz': [
                    '(1/4,1/4,1/4)',
                    '(3/4,3/4,1/4)',
                    '(3/4,1/4,3/4)',
                    '(1/4,3/4,3/4)',
                    '(3/4,3/4,3/4)',
                    '(1/4,1/4,3/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,1/4,1/4)',
                ],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '-4m.',
                'coords_xyz': ['(1/4,1/2,0)', '(3/4,1/2,0)', '(0,1/4,1/2)', '(0,3/4,1/2)', '(1/2,0,1/4)', '(1/2,0,3/4)'],
            },
            'c': {
                'multiplicity': 6,
                'site_symmetry': '-4m.',
                'coords_xyz': ['(1/4,0,1/2)', '(3/4,0,1/2)', '(1/2,1/4,0)', '(1/2,3/4,0)', '(0,1/2,1/4)', '(0,1/2,3/4)'],
            },
            'b': {
                'multiplicity': 6,
                'site_symmetry': 'mmm',
                'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': 'm-3.', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (224, '1'): {
        'IT_number': 224,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'P 42/n -3 2/m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y+1/2,x+1/2,-z+1/2)',
                    '(-y+1/2,-x+1/2,-z+1/2)',
                    '(y+1/2,-x+1/2,z+1/2)',
                    '(-y+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-y+1/2)',
                    '(-x+1/2,z+1/2,y+1/2)',
                    '(-x+1/2,-z+1/2,-y+1/2)',
                    '(x+1/2,-z+1/2,y+1/2)',
                    '(z+1/2,y+1/2,-x+1/2)',
                    '(z+1/2,-y+1/2,x+1/2)',
                    '(-z+1/2,y+1/2,x+1/2)',
                    '(-z+1/2,-y+1/2,-x+1/2)',
                    '(-x+1/2,-y+1/2,-z+1/2)',
                    '(x+1/2,y+1/2,-z+1/2)',
                    '(x+1/2,-y+1/2,z+1/2)',
                    '(-x+1/2,y+1/2,z+1/2)',
                    '(-z+1/2,-x+1/2,-y+1/2)',
                    '(-z+1/2,x+1/2,y+1/2)',
                    '(z+1/2,x+1/2,-y+1/2)',
                    '(z+1/2,-x+1/2,y+1/2)',
                    '(-y+1/2,-z+1/2,-x+1/2)',
                    '(y+1/2,-z+1/2,x+1/2)',
                    '(-y+1/2,z+1/2,x+1/2)',
                    '(y+1/2,z+1/2,-x+1/2)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                    '(-y,x,-z)',
                    '(y,-x,-z)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-z,-y,x)',
                    '(-z,y,-x)',
                    '(z,-y,-x)',
                    '(z,y,x)',
                ],
            },
            'k': {
                'multiplicity': 24,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                    '(x+1/2,x+1/2,-z+1/2)',
                    '(-x+1/2,-x+1/2,-z+1/2)',
                    '(x+1/2,-x+1/2,z+1/2)',
                    '(-x+1/2,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-x+1/2)',
                    '(-x+1/2,z+1/2,x+1/2)',
                    '(-x+1/2,-z+1/2,-x+1/2)',
                    '(x+1/2,-z+1/2,x+1/2)',
                    '(z+1/2,x+1/2,-x+1/2)',
                    '(z+1/2,-x+1/2,x+1/2)',
                    '(-z+1/2,x+1/2,x+1/2)',
                    '(-z+1/2,-x+1/2,-x+1/2)',
                ],
            },
            'j': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,y+1/2)',
                    '(3/4,-y,y+1/2)',
                    '(3/4,y,-y+1/2)',
                    '(1/4,-y,-y+1/2)',
                    '(y+1/2,1/4,y)',
                    '(y+1/2,3/4,-y)',
                    '(-y+1/2,3/4,y)',
                    '(-y+1/2,1/4,-y)',
                    '(y,y+1/2,1/4)',
                    '(-y,y+1/2,3/4)',
                    '(y,-y+1/2,3/4)',
                    '(-y,-y+1/2,1/4)',
                    '(1/4,-y+1/2,-y)',
                    '(3/4,y+1/2,-y)',
                    '(3/4,-y+1/2,y)',
                    '(1/4,y+1/2,y)',
                    '(-y,1/4,-y+1/2)',
                    '(-y,3/4,y+1/2)',
                    '(y,3/4,-y+1/2)',
                    '(y,1/4,y+1/2)',
                    '(-y+1/2,-y,1/4)',
                    '(y+1/2,-y,3/4)',
                    '(-y+1/2,y,3/4)',
                    '(y+1/2,y,1/4)',
                ],
            },
            'i': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/4,y,-y+1/2)',
                    '(3/4,-y,-y+1/2)',
                    '(3/4,y,y+1/2)',
                    '(1/4,-y,y+1/2)',
                    '(-y+1/2,1/4,y)',
                    '(-y+1/2,3/4,-y)',
                    '(y+1/2,3/4,y)',
                    '(y+1/2,1/4,-y)',
                    '(y,-y+1/2,1/4)',
                    '(-y,-y+1/2,3/4)',
                    '(y,y+1/2,3/4)',
                    '(-y,y+1/2,1/4)',
                    '(1/4,-y+1/2,y)',
                    '(3/4,y+1/2,y)',
                    '(3/4,-y+1/2,-y)',
                    '(1/4,y+1/2,-y)',
                    '(y,1/4,-y+1/2)',
                    '(y,3/4,y+1/2)',
                    '(-y,3/4,-y+1/2)',
                    '(-y,1/4,y+1/2)',
                    '(-y+1/2,y,1/4)',
                    '(y+1/2,y,3/4)',
                    '(-y+1/2,-y,3/4)',
                    '(y+1/2,-y,1/4)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,0,1/2)',
                    '(-x,0,1/2)',
                    '(1/2,x,0)',
                    '(1/2,-x,0)',
                    '(0,1/2,x)',
                    '(0,1/2,-x)',
                    '(1/2,x+1/2,0)',
                    '(1/2,-x+1/2,0)',
                    '(x+1/2,0,1/2)',
                    '(-x+1/2,0,1/2)',
                    '(0,1/2,-x+1/2)',
                    '(0,1/2,x+1/2)',
                    '(-x+1/2,1/2,0)',
                    '(x+1/2,1/2,0)',
                    '(0,-x+1/2,1/2)',
                    '(0,x+1/2,1/2)',
                    '(1/2,0,-x+1/2)',
                    '(1/2,0,x+1/2)',
                    '(0,-x,1/2)',
                    '(0,x,1/2)',
                    '(-x,1/2,0)',
                    '(x,1/2,0)',
                    '(1/2,0,x)',
                    '(1/2,0,-x)',
                ],
            },
            'g': {
                'multiplicity': 12,
                'site_symmetry': '2.m',
                'coords_xyz': [
                    '(x,0,0)',
                    '(-x,0,0)',
                    '(0,x,0)',
                    '(0,-x,0)',
                    '(0,0,x)',
                    '(0,0,-x)',
                    '(1/2,x+1/2,1/2)',
                    '(1/2,-x+1/2,1/2)',
                    '(x+1/2,1/2,1/2)',
                    '(-x+1/2,1/2,1/2)',
                    '(1/2,1/2,-x+1/2)',
                    '(1/2,1/2,x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 12,
                'site_symmetry': '2.2',
                'coords_xyz': [
                    '(1/4,0,1/2)',
                    '(3/4,0,1/2)',
                    '(1/2,1/4,0)',
                    '(1/2,3/4,0)',
                    '(0,1/2,1/4)',
                    '(0,1/2,3/4)',
                    '(1/4,1/2,0)',
                    '(3/4,1/2,0)',
                    '(0,1/4,1/2)',
                    '(0,3/4,1/2)',
                    '(1/2,0,1/4)',
                    '(1/2,0,3/4)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.3m',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x,-x,x)',
                    '(-x,x,-x)',
                    '(x,-x,-x)',
                    '(x+1/2,x+1/2,-x+1/2)',
                    '(-x+1/2,-x+1/2,-x+1/2)',
                    '(x+1/2,-x+1/2,x+1/2)',
                    '(-x+1/2,x+1/2,x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '-42.',
                'coords_xyz': ['(0,1/2,1/2)', '(1/2,0,1/2)', '(1/2,1/2,0)', '(0,1/2,0)', '(1/2,0,0)', '(0,0,1/2)'],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.-3m',
                'coords_xyz': ['(3/4,3/4,3/4)', '(1/4,1/4,3/4)', '(1/4,3/4,1/4)', '(3/4,1/4,1/4)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.-3m',
                'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,1/4)', '(3/4,1/4,3/4)', '(1/4,3/4,3/4)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '-43m', 'coords_xyz': ['(0,0,0)', '(1/2,1/2,1/2)']},
        },
    },
    (224, '2'): {
        'IT_number': 224,
        'setting': 1,
        'IT_coordinate_system_code': '2',
        'name_H-M_alt': 'P 42/n -3 2/m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 48,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x+1/2,-y+1/2,z)',
                    '(-x+1/2,y,-z+1/2)',
                    '(x,-y+1/2,-z+1/2)',
                    '(z,x,y)',
                    '(z,-x+1/2,-y+1/2)',
                    '(-z+1/2,-x+1/2,y)',
                    '(-z+1/2,x,-y+1/2)',
                    '(y,z,x)',
                    '(-y+1/2,z,-x+1/2)',
                    '(y,-z+1/2,-x+1/2)',
                    '(-y+1/2,-z+1/2,x)',
                    '(y+1/2,x+1/2,-z)',
                    '(-y,-x,-z)',
                    '(y+1/2,-x,z+1/2)',
                    '(-y,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-y)',
                    '(-x,z+1/2,y+1/2)',
                    '(-x,-z,-y)',
                    '(x+1/2,-z,y+1/2)',
                    '(z+1/2,y+1/2,-x)',
                    '(z+1/2,-y,x+1/2)',
                    '(-z,y+1/2,x+1/2)',
                    '(-z,-y,-x)',
                    '(-x,-y,-z)',
                    '(x+1/2,y+1/2,-z)',
                    '(x+1/2,-y,z+1/2)',
                    '(-x,y+1/2,z+1/2)',
                    '(-z,-x,-y)',
                    '(-z,x+1/2,y+1/2)',
                    '(z+1/2,x+1/2,-y)',
                    '(z+1/2,-x,y+1/2)',
                    '(-y,-z,-x)',
                    '(y+1/2,-z,x+1/2)',
                    '(-y,z+1/2,x+1/2)',
                    '(y+1/2,z+1/2,-x)',
                    '(-y+1/2,-x+1/2,z)',
                    '(y,x,z)',
                    '(-y+1/2,x,-z+1/2)',
                    '(y,-x+1/2,-z+1/2)',
                    '(-x+1/2,-z+1/2,y)',
                    '(x,-z+1/2,-y+1/2)',
                    '(x,z,y)',
                    '(-x+1/2,z,-y+1/2)',
                    '(-z+1/2,-y+1/2,x)',
                    '(-z+1/2,y,-x+1/2)',
                    '(z,-y+1/2,-x+1/2)',
                    '(z,y,x)',
                ],
            },
            'k': {
                'multiplicity': 24,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x+1/2,-x+1/2,z)',
                    '(-x+1/2,x,-z+1/2)',
                    '(x,-x+1/2,-z+1/2)',
                    '(z,x,x)',
                    '(z,-x+1/2,-x+1/2)',
                    '(-z+1/2,-x+1/2,x)',
                    '(-z+1/2,x,-x+1/2)',
                    '(x,z,x)',
                    '(-x+1/2,z,-x+1/2)',
                    '(x,-z+1/2,-x+1/2)',
                    '(-x+1/2,-z+1/2,x)',
                    '(x+1/2,x+1/2,-z)',
                    '(-x,-x,-z)',
                    '(x+1/2,-x,z+1/2)',
                    '(-x,x+1/2,z+1/2)',
                    '(x+1/2,z+1/2,-x)',
                    '(-x,z+1/2,x+1/2)',
                    '(-x,-z,-x)',
                    '(x+1/2,-z,x+1/2)',
                    '(z+1/2,x+1/2,-x)',
                    '(z+1/2,-x,x+1/2)',
                    '(-z,x+1/2,x+1/2)',
                    '(-z,-x,-x)',
                ],
            },
            'j': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/2,y,-y)',
                    '(0,-y+1/2,-y)',
                    '(0,y,y+1/2)',
                    '(1/2,-y+1/2,y+1/2)',
                    '(-y,1/2,y)',
                    '(-y,0,-y+1/2)',
                    '(y+1/2,0,y)',
                    '(y+1/2,1/2,-y+1/2)',
                    '(y,-y,1/2)',
                    '(-y+1/2,-y,0)',
                    '(y,y+1/2,0)',
                    '(-y+1/2,y+1/2,1/2)',
                    '(1/2,-y,y)',
                    '(0,y+1/2,y)',
                    '(0,-y,-y+1/2)',
                    '(1/2,y+1/2,-y+1/2)',
                    '(y,1/2,-y)',
                    '(y,0,y+1/2)',
                    '(-y+1/2,0,-y)',
                    '(-y+1/2,1/2,y+1/2)',
                    '(-y,y,1/2)',
                    '(y+1/2,y,0)',
                    '(-y,-y+1/2,0)',
                    '(y+1/2,-y+1/2,1/2)',
                ],
            },
            'i': {
                'multiplicity': 24,
                'site_symmetry': '..2',
                'coords_xyz': [
                    '(1/2,y,y+1/2)',
                    '(0,-y+1/2,y+1/2)',
                    '(0,y,-y)',
                    '(1/2,-y+1/2,-y)',
                    '(y+1/2,1/2,y)',
                    '(y+1/2,0,-y+1/2)',
                    '(-y,0,y)',
                    '(-y,1/2,-y+1/2)',
                    '(y,y+1/2,1/2)',
                    '(-y+1/2,y+1/2,0)',
                    '(y,-y,0)',
                    '(-y+1/2,-y,1/2)',
                    '(1/2,-y,-y+1/2)',
                    '(0,y+1/2,-y+1/2)',
                    '(0,-y,y)',
                    '(1/2,y+1/2,y)',
                    '(-y+1/2,1/2,-y)',
                    '(-y+1/2,0,y+1/2)',
                    '(y,0,-y)',
                    '(y,1/2,y+1/2)',
                    '(-y,-y+1/2,1/2)',
                    '(y+1/2,-y+1/2,0)',
                    '(-y,y,0)',
                    '(y+1/2,y,1/2)',
                ],
            },
            'h': {
                'multiplicity': 24,
                'site_symmetry': '2..',
                'coords_xyz': [
                    '(x,1/4,3/4)',
                    '(-x+1/2,1/4,3/4)',
                    '(3/4,x,1/4)',
                    '(3/4,-x+1/2,1/4)',
                    '(1/4,3/4,x)',
                    '(1/4,3/4,-x+1/2)',
                    '(3/4,x+1/2,1/4)',
                    '(3/4,-x,1/4)',
                    '(x+1/2,1/4,3/4)',
                    '(-x,1/4,3/4)',
                    '(1/4,3/4,-x)',
                    '(1/4,3/4,x+1/2)',
                    '(-x,3/4,1/4)',
                    '(x+1/2,3/4,1/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,x+1/2,3/4)',
                    '(3/4,1/4,-x)',
                    '(3/4,1/4,x+1/2)',
                    '(1/4,-x+1/2,3/4)',
                    '(1/4,x,3/4)',
                    '(-x+1/2,3/4,1/4)',
                    '(x,3/4,1/4)',
                    '(3/4,1/4,x)',
                    '(3/4,1/4,-x+1/2)',
                ],
            },
            'g': {
                'multiplicity': 12,
                'site_symmetry': '2.m',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x+1/2,1/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x+1/2,1/4)',
                    '(1/4,1/4,x)',
                    '(1/4,1/4,-x+1/2)',
                    '(3/4,x+1/2,3/4)',
                    '(3/4,-x,3/4)',
                    '(x+1/2,3/4,3/4)',
                    '(-x,3/4,3/4)',
                    '(3/4,3/4,-x)',
                    '(3/4,3/4,x+1/2)',
                ],
            },
            'f': {
                'multiplicity': 12,
                'site_symmetry': '2.2',
                'coords_xyz': [
                    '(1/2,1/4,3/4)',
                    '(0,1/4,3/4)',
                    '(3/4,1/2,1/4)',
                    '(3/4,0,1/4)',
                    '(1/4,3/4,1/2)',
                    '(1/4,3/4,0)',
                    '(1/2,3/4,1/4)',
                    '(0,3/4,1/4)',
                    '(1/4,1/2,3/4)',
                    '(1/4,0,3/4)',
                    '(3/4,1/4,1/2)',
                    '(3/4,1/4,0)',
                ],
            },
            'e': {
                'multiplicity': 8,
                'site_symmetry': '.3m',
                'coords_xyz': [
                    '(x,x,x)',
                    '(-x+1/2,-x+1/2,x)',
                    '(-x+1/2,x,-x+1/2)',
                    '(x,-x+1/2,-x+1/2)',
                    '(x+1/2,x+1/2,-x)',
                    '(-x,-x,-x)',
                    '(x+1/2,-x,x+1/2)',
                    '(-x,x+1/2,x+1/2)',
                ],
            },
            'd': {
                'multiplicity': 6,
                'site_symmetry': '-42.',
                'coords_xyz': [
                    '(1/4,3/4,3/4)',
                    '(3/4,1/4,3/4)',
                    '(3/4,3/4,1/4)',
                    '(1/4,3/4,1/4)',
                    '(3/4,1/4,1/4)',
                    '(1/4,1/4,3/4)',
                ],
            },
            'c': {
                'multiplicity': 4,
                'site_symmetry': '.-3m',
                'coords_xyz': ['(1/2,1/2,1/2)', '(0,0,1/2)', '(0,1/2,0)', '(1/2,0,0)'],
            },
            'b': {
                'multiplicity': 4,
                'site_symmetry': '.-3m',
                'coords_xyz': ['(0,0,0)', '(1/2,1/2,0)', '(1/2,0,1/2)', '(0,1/2,1/2)'],
            },
            'a': {'multiplicity': 2, 'site_symmetry': '-43m', 'coords_xyz': ['(1/4,1/4,1/4)', '(3/4,3/4,3/4)']},
        },
    },
    (225, '1'): {
        'IT_number': 225,
        'setting': 0,
        'IT_coordinate_system_code': '1',
        'name_H-M_alt': 'F 4/m -3 2/m',
        'crystal_system': 'cubic',
        'Wyckoff_positions': {
            'l': {
                'multiplicity': 192,
                'site_symmetry': '1',
                'coords_xyz': [
                    '(x,y,z)',
                    '(-x,-y,z)',
                    '(-x,y,-z)',
                    '(x,-y,-z)',
                    '(z,x,y)',
                    '(z,-x,-y)',
                    '(-z,-x,y)',
                    '(-z,x,-y)',
                    '(y,z,x)',
                    '(-y,z,-x)',
                    '(y,-z,-x)',
                    '(-y,-z,x)',
                    '(y,x,-z)',
                    '(-y,-x,-z)',
                    '(y,-x,z)',
                    '(-y,x,z)',
                    '(x,z,-y)',
                    '(-x,z,y)',
                    '(-x,-z,-y)',
                    '(x,-z,y)',
                    '(z,y,-x)',
                    '(z,-y,x)',
                    '(-z,y,x)',
                    '(-z,-y,-x)',
                    '(-x,-y,-z)',
                    '(x,y,-z)',
                    '(x,-y,z)',
                    '(-x,y,z)',
                    '(-z,-x,-y)',
                    '(-z,x,y)',
                    '(z,x,-y)',
                    '(z,-x,y)',
                    '(-y,-z,-x)',
                    '(y,-z,x)',
                    '(-y,z,x)',
                    '(y,z,-x)',
                    '(-y,-x,z)',
                    '(y,x,z)',
                    '(-y,x,-z)',
                    '(y,-x,-z)',
                    '(-x,-z,y)',
                    '(x,-z,-y)',
                    '(x,z,y)',
                    '(-x,z,-y)',
                    '(-z,-y,x)',
                    '(-z,y,-x)',
                    '(z,-y,-x)',
                    '(z,y,x)',
                ],
            },
            'k': {
                'multiplicity': 96,
                'site_symmetry': '..m',
                'coords_xyz': [
                    '(x,x,z)',
                    '(-x,-x,z)',
                    '(-x,x,-z)',
                    '(x,-x,-z)',
                    '(z,x,x)',
                    '(z,-x,-x)',
                    '(-z,-x,x)',
                    '(-z,x,-x)',
                    '(x,z,x)',
                    '(-x,z,-x)',
                    '(x,-z,-x)',
                    '(-x,-z,x)',
                    '(x,x,-z)',
                    '(-x,-x,-z)',
                    '(x,-x,z)',
                    '(-x,x,z)',
                    '(x,z,-x)',
                    '(-x,z,x)',
                    '(-x,-z,-x)',
                    '(x,-z,x)',
                    '(z,x,-x)',
                    '(z,-x,x)',
                    '(-z,x,x)',
                    '(-z,-x,-x)',
                ],
            },
            'j': {
                'multiplicity': 96,
                'site_symmetry': 'm..',
                'coords_xyz': [
                    '(0,y,z)',
                    '(0,-y,z)',
                    '(0,y,-z)',
                    '(0,-y,-z)',
                    '(z,0,y)',
                    '(z,0,-y)',
                    '(-z,0,y)',
                    '(-z,0,-y)',
                    '(y,z,0)',
                    '(-y,z,0)',
                    '(y,-z,0)',
                    '(-y,-z,0)',
                    '(y,0,-z)',
                    '(-y,0,-z)',
                    '(y,0,z)',
                    '(-y,0,z)',
                    '(0,z,-y)',
                    '(0,z,y)',
                    '(0,-z,-y)',
                    '(0,-z,y)',
                    '(z,y,0)',
                    '(z,-y,0)',
                    '(-z,y,0)',
                    '(-z,-y,0)',
                ],
            },
            'i': {
                'multiplicity': 48,
                'site_symmetry': 'm.m',
                'coords_xyz': [
                    '(1/2,y,y)',
                    '(1/2,-y,y)',
                    '(1/2,y,-y)',
                    '(1/2,-y,-y)',
                    '(y,1/2,y)',
                    '(y,1/2,-y)',
                    '(-y,1/2,y)',
                    '(-y,1/2,-y)',
                    '(y,y,1/2)',
                    '(-y,y,1/2)',
                    '(y,-y,1/2)',
                    '(-y,-y,1/2)',
                ],
            },
            'h': {
                'multiplicity': 48,
                'site_symmetry': 'm.m',
                'coords_xyz': [
                    '(0,y,y)',
                    '(0,-y,y)',
                    '(0,y,-y)',
                    '(0,-y,-y)',
                    '(y,0,y)',
                    '(y,0,-y)',
                    '(-y,0,y)',
                    '(-y,0,-y)',
                    '(y,y,0)',
                    '(-y,y,0)',
                    '(y,-y,0)',
                    '(-y,-y,0)',
                ],
            },
            'g': {
                'multiplicity': 48,
                'site_symmetry': '2.m',
                'coords_xyz': [
                    '(x,1/4,1/4)',
                    '(-x,3/4,1/4)',
                    '(1/4,x,1/4)',
                    '(1/4,-x,3/4)',
                    '(1/4,1/4,x)',
                    '(3/4,1/4,-x)',
                    '(1/4,x,3/4)',
                    '(3/4,-x,3/4)',
                    '(x,1/4,3/4)',
                    '(-x,1/4,1/4)',
                    '(1/4,1/4,-x)',
                    '(1/4,3/4,x)',
                ],
            },
            'f': {
                'multiplicity': 32,
                'site_