from __future__ import annotations

from typing import NamedTuple
from typing import TypedDict

import numpy as np

# generated by df2class


class PepXMLRow(NamedTuple):
    run: str
    peptide: str
    calc_neutral_pep_mass: float
    assumed_charge: int
    modcol: str
    precursor_neutral_mass: float
    retention_time_sec: float
    num_missed_cleavages: int
    proteins: np.ndarray  # item: str
    peptideprophet_probability: float
    is_decoy: bool
    agg_count: int
    is_rejected: bool
    mz: float
    observed_mz: float


class PepXMLRunRow(NamedTuple):
    peptide: str
    assumed_charge: int
    mz: float
    observed_mz: float
    labelledElementCount: int
    maxIso: int
    mzranges: np.ndarray  # item: float32
    isLabelledRun: bool


class PepXMLRunRowRT(PepXMLRunRow):
    rtmin: float
    rtmax: float


class PepXMLDict(TypedDict):
    run: str
    peptide: str
    calc_neutral_pep_mass: float
    assumed_charge: int
    modcol: str
    observed_mz: float
    precursor_neutral_mass: float
    retention_time_sec: float
    num_missed_cleavages: int
    proteins: np.ndarray  # item: str
    peptideprophet_probability: float
    is_decoy: bool
    agg_count: int
    is_rejected: bool
    mz: float

    labelledElementCount: int
    maxIso: int
    mzranges: np.ndarray  # item: float32
    isLabelledRun: bool


class PepXMLJob(NamedTuple):
    run: str
    peptide: str
    assumed_charge: int
    modcol: str
    calc_neutral_pep_mass: float
    precursor_neutral_mass: float
    mz: float
    observed_mz: float
    rt: float
    num_missed_cleavages: int
    proteins: np.ndarray  # item: str
    peptideprophet_probability: float
    is_decoy: bool
    agg_count: int
    is_rejected: bool
    protein_descr: np.ndarray  # item: str
    modifications: np.ndarray
    # prStr: str
    # prGroup: int
    labelledElementCount: int
    maxIso: int
    mzranges: np.ndarray  # item: float32
    isLabelledRun: bool
