from __future__ import annotations

from dataclasses import dataclass
from typing import TypedDict

import numpy as np

# generated by df2class


@dataclass
class TurnoverRow:
    fraction: str
    peptide: str
    run: str
    mz: float
    theoreticalMass: float
    observedMass: float
    charge: int
    retentionTime: float
    missedCleavages: int
    proteins: np.ndarray  # item: str
    modifications: np.ndarray
    peptideprophet_probability: float
    probability: float
    searchEngineScore: float
    searchEngineName: str
    description: str
    isLabelledRun: bool
    maxIso: int
    labelledElementCount: int
    adjustedRsq: np.ndarray  # item: float32
    isotopeEnvelopes: np.ndarray  # item: float64
    monoFitParams: np.ndarray  # item: float32

    # heavyDistribution: np.ndarray  # item: float64
    # heavyFitParams: np.ndarray  # item: float32

    heavyCor: float
    labelledEnvelopes: np.ndarray  # item: float64
    relativeIsotopeAbundance: float
    enrichment: float
    theoreticalDist: np.ndarray

    # eics_idx: str
    eics: np.ndarray  # item: float32
    mzranges: np.ndarray  # item: float32
    eics_shape: np.ndarray  # item: int64
    modcol: str
    fdr: float
    maxPeakArea: float


class TurnoverDict(TypedDict):
    fraction: str
    peptide: str
    run: str
    mz: float
    theoreticalMass: float
    observedMass: float
    charge: int
    retentionTime: float
    missedCleavages: int
    proteins: np.ndarray  # item: str
    modifications: np.ndarray
    peptideprophet_probability: float
    searchEngineScore: float
    searchEngineName: str
    description: str
    isLabelledRun: bool
    maxIso: int
    labelledElementCount: int
    adjustedRsq: np.ndarray  # item: float32
    isotopeEnvelopes: np.ndarray  # item: float64
    monoFitParams: np.ndarray  # item: float32
    # heavyDistribution: np.ndarray  # item: float64
    # heavyFitParams: np.ndarray  # item: float32
    labelledEnvelopes: np.ndarray  # item: float64
    relativeIsotopeAbundance: float

    enrichment: float
    # labelEnrichment2: float
    heavyCor: float
    heavyCor2: float
    totalNNLSWeight: float
    totalIntensityWeight: float
    nnls_residual: float
    theoreticalDist: np.ndarray  # item: float32
    # idx: int
    # prStr: str
    # prGroup: int
    # eics_idx: str
    eics: np.ndarray  # item: float32
    mzranges: np.ndarray  # item: float32
    eics_shape: np.ndarray  # item: int64
    modcol: str
    fdr: float
