"""
Constants for Whoop data, including sport type mappings.
"""

# Complete mapping of Whoop sport IDs to sport names
# Retrieved from /activities-service/v1/sports/history endpoint
SPORT_IDS = {
    -1: 'Activity',
    0: 'Running',
    1: 'Cycling',
    16: 'Baseball',
    17: 'Basketball',
    18: 'Rowing',
    19: 'Fencing',
    20: 'Field Hockey',
    21: 'Football',
    22: 'Golf',
    24: 'Ice Hockey',
    25: 'Lacrosse',
    27: 'Rugby',
    28: 'Sailing',
    29: 'Skiing',
    30: 'Soccer',
    31: 'Softball',
    32: 'Squash',
    33: 'Swimming',
    34: 'Tennis',
    35: 'Track & Field',
    36: 'Volleyball',
    37: 'Water Polo',
    38: 'Wrestling',
    39: 'Boxing',
    42: 'Dance',
    43: 'Pilates',
    44: 'Yoga',
    45: 'Weightlifting',
    46: 'Canoeing',
    47: 'Cross Country Skiing',
    48: 'Functional Fitness',
    49: 'Duathlon',
    50: 'Machine Workout',
    51: 'Gymnastics',
    52: 'Hiking',
    53: 'Horseback Riding',
    54: 'Jogging',
    55: 'Kayaking',
    56: 'Martial Arts',
    57: 'Mountain Biking',
    58: 'Obstacle Racing',
    59: 'Powerlifting',
    60: 'Rock Climbing',
    61: 'Paddleboarding',
    62: 'Triathlon',
    63: 'Walking',
    64: 'Surfing',
    65: 'Elliptical',
    66: 'Stairmaster',
    67: 'Plyometrics',
    68: 'Spinning',
    69: 'Sex',
    70: 'Meditation',
    71: 'Other',
    72: 'Pit Practice',
    73: 'Diving',
    74: 'Operations - Tactical',
    75: 'Operations - Medical',
    76: 'Operations - Flying',
    77: 'Operations - Water',
    82: 'Ultimate',
    83: 'Climber',
    84: 'Jumping Rope',
    85: 'Australian Rules Football',
    86: 'Skateboarding',
    87: 'Coaching',
    88: 'Ice Bath',
    89: 'Commuting',
    90: 'Gaming',
    91: 'Snowboarding',
    92: 'Motocross',
    93: 'Caddying',
    94: 'Obstacle Course Racing',
    95: 'Motor Racing',
    96: 'HIIT',
    97: 'Spin',
    98: 'Jiu Jitsu',
    99: 'Manual Labor',
    100: 'Cricket',
    101: 'Pickleball',
    102: 'Inline Skating',
    103: 'Box Fitness',
    104: 'Spikeball',
    105: 'Wheelchair Pushing',
    106: 'Paddle Tennis',
    107: 'Barre',
    108: 'Stage Performance',
    109: 'High Stress Work',
    110: 'Parkour',
    111: 'Gaelic Football',
    112: 'Hurling/Camogie',
    113: 'Circus Arts',
    116: 'Resonance Frequency Breathing',
    121: 'Massage Therapy',
    123: 'Strength Trainer',
    125: 'Watching Sports',
    126: 'Assault Bike',
    127: 'Kickboxing',
    128: 'Stretching',
    131: 'Other - Recovery',
    230: 'Table Tennis/Ping Pong',
    231: 'Badminton',
    232: 'Netball',
    233: 'Sauna',
    234: 'Disc Golf',
    235: 'Yard Work/Gardening',
    236: 'Air Compression',
    237: 'Percussive Massage',
    238: 'Paintball',
    239: 'Ice Skating',
    240: 'Handball',
    241: 'Percussive Massage (Hypervolt)',
    242: 'Air Compression (Normatec)',
    243: 'Increase Relaxation',
    244: 'Increase Alertness',
    245: 'Breathwork',
    246: 'Non-Sleep Deep Rest',
    247: 'Steam Room',
    248: 'F45 Training',
    249: 'Padel',
    250: "Barry's",
    251: 'Dedicated Parenting',
    252: 'Stroller Walking',
    253: 'Stroller Jogging',
    254: 'Toddlerwearing',
    255: 'Babywearing',
    256: 'Playing with Child',
    257: 'Cuddling with Child',
    258: 'Barre3',
    259: 'Hot Yoga',
    261: 'Stadium Steps',
    262: 'Polo',
    263: 'Musical Performance',
    264: 'Kite Boarding',
    265: 'Restorative Yoga',
    266: 'Dog Walking',
    267: 'Water Skiing',
    268: 'Wakeboarding',
    269: 'Cooking',
    270: 'Cleaning',
    271: 'Warm Bath',
    272: 'Public Speaking',
    274: 'Race Walking',
    275: 'Driving',
    276: 'solidcore',
    277: 'Refereeing',
    278: 'Rucking',
    279: 'Whoop Labs',
    280: 'Cheerleading',
    281: 'Scootering',
    282: 'Foam Rolling',
    283: 'Fishing',
    284: 'Thrill Ride',
    285: 'Bowling',
    286: 'Knitting',
    287: 'Curling',
    288: 'Tai Chi',
    289: 'QiGong',
    290: 'Reformer Pilates',
    291: 'Sculpt Yoga',
    292: 'Breakdancing',
    293: 'Snow Shoveling',
    294: 'Trail Running',
    295: 'Winter Biathlon',
    296: 'Nordic Walking',
    297: 'Ski Touring',
    298: 'Darts',
    299: 'Chess',
    300: 'Acupuncture',
    301: 'Mountaineering',
    302: 'Muay Thai',
    303: 'Taekwondo',
    304: 'Judo',
    305: 'Roller Hockey',
    306: 'Bartending',
    307: 'Chiropractor',
    308: 'Bodybuilding',
    309: 'Sprint Training',
    310: 'Freediving',
    311: 'Sound Healing',
    312: 'Nursing a Baby',
    313: 'Pumping',
    314: 'Hot Dog Challenge',
    315: 'DJ',
}


def get_sport_name(sport_id):
    """
    Get the sport name for a given sport ID.
    
    Args:
        sport_id: The sport ID from workout data
        
    Returns:
        str: The sport name, or "Unknown Sport (ID: X)" if not found
    """
    return SPORT_IDS.get(sport_id, f"Unknown Sport (ID: {sport_id})")

