# iparapheur-provisioning
iparapheur v5.x main core application.

The main link between every sub-services, integrating business code logic.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: DEVELOP
- Package version: 1.7.7
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://libriciel.fr](https://libriciel.fr)

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import iparapheur_provisioning
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import iparapheur_provisioning
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import iparapheur_provisioning
from pprint import pprint
from iparapheur_provisioning.apis.tags import admin_all_users_api
from iparapheur_provisioning.model.error_response import ErrorResponse
from iparapheur_provisioning.model.page_user_representation import PageUserRepresentation
from iparapheur_provisioning.model.user_dto import UserDto
# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = iparapheur_provisioning.Configuration(
    host = "http://localhost:8080"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: spring_oauth
configuration = iparapheur_provisioning.Configuration(
    host = "http://localhost:8080",
    access_token = 'YOUR_ACCESS_TOKEN'
)

# Enter a context with an instance of the API client
with iparapheur_provisioning.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = admin_all_users_api.AdminAllUsersApi(api_client)
    user_id = "userId_example" # str | User id

    try:
        # Delete a user
        api_instance.delete_user_as_super_admin(user_id)
    except iparapheur_provisioning.ApiException as e:
        print("Exception when calling AdminAllUsersApi->delete_user_as_super_admin: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminAllUsersApi* | [**delete_user_as_super_admin**](docs/apis/tags/AdminAllUsersApi.md#delete_user_as_super_admin) | **delete** /api/provisioning/v1/admin/user/{userId} | Delete a user
*AdminAllUsersApi* | [**get_user_as_super_admin**](docs/apis/tags/AdminAllUsersApi.md#get_user_as_super_admin) | **get** /api/provisioning/v1/admin/user/{userId} | Get a full user representation
*AdminAllUsersApi* | [**list_users_as_super_admin**](docs/apis/tags/AdminAllUsersApi.md#list_users_as_super_admin) | **get** /api/provisioning/v1/admin/user | List all users on the instance
*AdminAllUsersApi* | [**update_user_as_super_admin**](docs/apis/tags/AdminAllUsersApi.md#update_user_as_super_admin) | **put** /api/provisioning/v1/admin/user/{userId} | Edit a user
*AdminDeskApi* | [**create_desk**](docs/apis/tags/AdminDeskApi.md#create_desk) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/desk | Create a desk
*AdminDeskApi* | [**delete_desk**](docs/apis/tags/AdminDeskApi.md#delete_desk) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/desk/{deskId} | Delete a desk
*AdminDeskApi* | [**edit_desk**](docs/apis/tags/AdminDeskApi.md#edit_desk) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/desk/{deskId} | Edit a desk
*AdminDeskApi* | [**get_desk_as_admin**](docs/apis/tags/AdminDeskApi.md#get_desk_as_admin) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/desk/{deskId} | Get a full desk description
*AdminDeskApi* | [**list_desks**](docs/apis/tags/AdminDeskApi.md#list_desks) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/desk | List desks
*AdminMetadataApi* | [**create_metadata**](docs/apis/tags/AdminMetadataApi.md#create_metadata) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/metadata | Create a metadata
*AdminMetadataApi* | [**delete_metadata**](docs/apis/tags/AdminMetadataApi.md#delete_metadata) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/metadata/{metadataId} | Delete a metadata
*AdminMetadataApi* | [**get_metadata**](docs/apis/tags/AdminMetadataApi.md#get_metadata) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/metadata/{metadataId} | Get a full metadata description
*AdminMetadataApi* | [**list_metadata**](docs/apis/tags/AdminMetadataApi.md#list_metadata) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/metadata | List all metadata associated with the tenant
*AdminMetadataApi* | [**update_metadata**](docs/apis/tags/AdminMetadataApi.md#update_metadata) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/metadata/{metadataId} | Edit a metadata
*AdminSealCertificateApi* | [**create_seal_certificate**](docs/apis/tags/AdminSealCertificateApi.md#create_seal_certificate) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/sealCertificate | Create a seal certificate
*AdminSealCertificateApi* | [**delete_seal_certificate**](docs/apis/tags/AdminSealCertificateApi.md#delete_seal_certificate) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/sealCertificate/{sealCertificateId} | Delete a stored seal certificate
*AdminSealCertificateApi* | [**get_seal_certificate**](docs/apis/tags/AdminSealCertificateApi.md#get_seal_certificate) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/sealCertificate/{sealCertificateId} | Get a seal certificate with every information set
*AdminSealCertificateApi* | [**list_seal_certificate**](docs/apis/tags/AdminSealCertificateApi.md#list_seal_certificate) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/sealCertificate | List seal certificates
*AdminSealCertificateApi* | [**update_seal_certificate**](docs/apis/tags/AdminSealCertificateApi.md#update_seal_certificate) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/sealCertificate/{sealCertificateId} | Edit a seal certificate
*AdminTemplateApi* | [**create_custom_template**](docs/apis/tags/AdminTemplateApi.md#create_custom_template) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/templates/{templateType} | Create a custom template
*AdminTemplateApi* | [**delete_custom_template**](docs/apis/tags/AdminTemplateApi.md#delete_custom_template) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/templates/{templateType} | Delete a custom template
*AdminTemplateApi* | [**get_custom_template**](docs/apis/tags/AdminTemplateApi.md#get_custom_template) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/templates/{templateType} | Get a custom template
*AdminTemplateApi* | [**update_custom_template**](docs/apis/tags/AdminTemplateApi.md#update_custom_template) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/templates/{templateType} | Update a custom template
*AdminTenantApi* | [**create_tenant**](docs/apis/tags/AdminTenantApi.md#create_tenant) | **post** /api/provisioning/v1/admin/tenant | Create a new tenant
*AdminTenantApi* | [**delete_tenant**](docs/apis/tags/AdminTenantApi.md#delete_tenant) | **delete** /api/provisioning/v1/admin/tenant/{tenantId} | Delete a tenant
*AdminTenantApi* | [**get_tenant**](docs/apis/tags/AdminTenantApi.md#get_tenant) | **get** /api/provisioning/v1/admin/tenant/{tenantId} | Get a full tenant description
*AdminTenantApi* | [**list_tenants**](docs/apis/tags/AdminTenantApi.md#list_tenants) | **get** /api/provisioning/v1/admin/tenant | List tenants
*AdminTenantApi* | [**update_tenant**](docs/apis/tags/AdminTenantApi.md#update_tenant) | **put** /api/provisioning/v1/admin/tenant/{tenantId} | Edit a tenant
*AdminTenantUserApi* | [**create_user**](docs/apis/tags/AdminTenantUserApi.md#create_user) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/user | Create a new user
*AdminTenantUserApi* | [**get_user**](docs/apis/tags/AdminTenantUserApi.md#get_user) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/user/{userId} | Get a full user description
*AdminTenantUserApi* | [**list_tenant_users**](docs/apis/tags/AdminTenantUserApi.md#list_tenant_users) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/user | List all users associated with the tenant
*AdminTenantUserApi* | [**remove_user**](docs/apis/tags/AdminTenantUserApi.md#remove_user) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/user/{userId} | Remove the given user from the tenant, deleting it if it was the last tenant linked
*AdminTenantUserApi* | [**update_user**](docs/apis/tags/AdminTenantUserApi.md#update_user) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/user/{userId} | Edit a user
*AdminTypologyApi* | [**create_subtype**](docs/apis/tags/AdminTypologyApi.md#create_subtype) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId}/subtype | Create a subtype
*AdminTypologyApi* | [**create_type**](docs/apis/tags/AdminTypologyApi.md#create_type) | **post** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type | Create a type
*AdminTypologyApi* | [**delete_subtype**](docs/apis/tags/AdminTypologyApi.md#delete_subtype) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId}/subtype/{subtypeId} | Delete a subtype
*AdminTypologyApi* | [**delete_type**](docs/apis/tags/AdminTypologyApi.md#delete_type) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId} | Delete a type
*AdminTypologyApi* | [**get_subtype**](docs/apis/tags/AdminTypologyApi.md#get_subtype) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId}/subtype/{subtypeId} | Get a subtype with every information set
*AdminTypologyApi* | [**get_type**](docs/apis/tags/AdminTypologyApi.md#get_type) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId} | Get a type with every information set
*AdminTypologyApi* | [**list_subtypes**](docs/apis/tags/AdminTypologyApi.md#list_subtypes) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId}/subtype | Get subtypes
*AdminTypologyApi* | [**list_types**](docs/apis/tags/AdminTypologyApi.md#list_types) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type | List types
*AdminTypologyApi* | [**update_subtype**](docs/apis/tags/AdminTypologyApi.md#update_subtype) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId}/subtype/{subtypeId} | Edit a subtype
*AdminTypologyApi* | [**update_type**](docs/apis/tags/AdminTypologyApi.md#update_type) | **put** /api/provisioning/v1/admin/tenant/{tenantId}/typology/type/{typeId} | Edit a type
*AdminWorkflowDefinitionApi* | [**delete_workflow_definition**](docs/apis/tags/AdminWorkflowDefinitionApi.md#delete_workflow_definition) | **delete** /api/provisioning/v1/admin/tenant/{tenantId}/workflowDefinition/{workflowDefinitionKey} | Delete a workflow definition
*AdminWorkflowDefinitionApi* | [**list_workflow_definitions**](docs/apis/tags/AdminWorkflowDefinitionApi.md#list_workflow_definitions) | **get** /api/provisioning/v1/admin/tenant/{tenantId}/workflowDefinition | List workflow definitions

## Documentation For Models

 - [CertificateInformations](docs/models/CertificateInformations.md)
 - [DelegationSortBy](docs/models/DelegationSortBy.md)
 - [DeskDto](docs/models/DeskDto.md)
 - [DeskRepresentation](docs/models/DeskRepresentation.md)
 - [ErrorResponse](docs/models/ErrorResponse.md)
 - [ExternalSignatureConfigRepresentation](docs/models/ExternalSignatureConfigRepresentation.md)
 - [ExternalSignatureConfigSortBy](docs/models/ExternalSignatureConfigSortBy.md)
 - [ExternalSignatureProvider](docs/models/ExternalSignatureProvider.md)
 - [FolderSortBy](docs/models/FolderSortBy.md)
 - [InternalMetadata](docs/models/InternalMetadata.md)
 - [LayerRepresentation](docs/models/LayerRepresentation.md)
 - [LayerSortBy](docs/models/LayerSortBy.md)
 - [MetadataDto](docs/models/MetadataDto.md)
 - [MetadataRepresentation](docs/models/MetadataRepresentation.md)
 - [MetadataSortBy](docs/models/MetadataSortBy.md)
 - [MetadataType](docs/models/MetadataType.md)
 - [PageDeskRepresentation](docs/models/PageDeskRepresentation.md)
 - [PageMetadataRepresentation](docs/models/PageMetadataRepresentation.md)
 - [PageSealCertificateRepresentation](docs/models/PageSealCertificateRepresentation.md)
 - [PageSubtypeRepresentation](docs/models/PageSubtypeRepresentation.md)
 - [PageTenantRepresentation](docs/models/PageTenantRepresentation.md)
 - [PageTypeRepresentation](docs/models/PageTypeRepresentation.md)
 - [PageUserRepresentation](docs/models/PageUserRepresentation.md)
 - [PageWorkflowDefinitionRepresentation](docs/models/PageWorkflowDefinitionRepresentation.md)
 - [PageableObject](docs/models/PageableObject.md)
 - [PdfSignaturePosition](docs/models/PdfSignaturePosition.md)
 - [SealCertificateDto](docs/models/SealCertificateDto.md)
 - [SealCertificateRepresentation](docs/models/SealCertificateRepresentation.md)
 - [SealCertificateSortBy](docs/models/SealCertificateSortBy.md)
 - [SignatureFormat](docs/models/SignatureFormat.md)
 - [SignatureProtocol](docs/models/SignatureProtocol.md)
 - [SortObject](docs/models/SortObject.md)
 - [SubtypeDto](docs/models/SubtypeDto.md)
 - [SubtypeLayerAssociation](docs/models/SubtypeLayerAssociation.md)
 - [SubtypeLayerDto](docs/models/SubtypeLayerDto.md)
 - [SubtypeMetadataDto](docs/models/SubtypeMetadataDto.md)
 - [SubtypeRepresentation](docs/models/SubtypeRepresentation.md)
 - [TemplateType](docs/models/TemplateType.md)
 - [TenantDto](docs/models/TenantDto.md)
 - [TenantRepresentation](docs/models/TenantRepresentation.md)
 - [TenantSortBy](docs/models/TenantSortBy.md)
 - [TypeDto](docs/models/TypeDto.md)
 - [TypeRepresentation](docs/models/TypeRepresentation.md)
 - [TypologySortBy](docs/models/TypologySortBy.md)
 - [UserDto](docs/models/UserDto.md)
 - [UserPrivilege](docs/models/UserPrivilege.md)
 - [UserRepresentation](docs/models/UserRepresentation.md)
 - [UserSortBy](docs/models/UserSortBy.md)
 - [WorkflowDefinitionRepresentation](docs/models/WorkflowDefinitionRepresentation.md)
 - [WorkflowDefinitionSortBy](docs/models/WorkflowDefinitionSortBy.md)

## Documentation For Authorization

 Authentication schemes defined for the API:
## spring_oauth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: ./auth/realms/api/protocol/openid-connect/auth
- **Scopes**: N/A


## Author

iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop
iparapheur@libriciel.coop

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in iparapheur_provisioning.apis and iparapheur_provisioning.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from iparapheur_provisioning.apis.default_api import DefaultApi`
- `from iparapheur_provisioning.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import iparapheur_provisioning
from iparapheur_provisioning.apis import *
from iparapheur_provisioning.models import *
```
