import enum
from ctypes.util import find_library

LIBMOSQ_PATH = find_library("mosquitto")
if LIBMOSQ_PATH is None:
    raise ImportError("libmosquitto not found. Please install libmosquitto1")

LIBMOSQ_MIN_MAJOR_VERSION = 2


class ErrorCode(enum.IntEnum):
    AUTH_CONTINUE = -4
    NO_SUBSCRIBERS = -3
    SUB_EXISTS = -2
    CONN_PENDING = -1
    SUCCESS = 0
    NOMEM = 1
    PROTOCOL = 2
    INVAL = 3
    NO_CONN = 4
    CONN_REFUSED = 5
    NOT_FOUND = 6
    CONN_LOST = 7
    TLS = 8
    PAYLOAD_SIZE = 9
    NOT_SUPPORTED = 10
    AUTH = 11
    ACL_DENIED = 12
    UNKNOWN = 13
    ERRNO = 14
    EAI = 15
    PROXY = 16
    PLUGIN_DEFER = 17
    MALFORMED_UTF8 = 18
    KEEPALIVE = 19
    LOOKUP = 20
    MALFORMED_PACKET = 21
    DUPLICATE_PROPERTY = 22
    TLS_HANDSHAKE = 23
    QOS_NOT_SUPPORTED = 24
    OVERSIZE_PACKET = 25
    OCSP = 26
    TIMEOUT = 27
    RETAIN_NOT_SUPPORTED = 28
    TOPIC_ALIAS_INVALID = 29
    ADMINISTRATIVE_ACTION = 30
    ALREADY_EXISTS = 31


class ConnackCode(enum.IntEnum):
    ACCEPTED = 0
    REFUSED_PROTOCOL_VERSION = 1
    REFUSED_IDENTIFIER_REJECTED = 2
    REFUSED_SERVER_UNAVAILABLE = 3
    REFUSED_BAD_USERNAME_PASSWORD = 4
    REFUSED_NOT_AUTHORIZED = 5


class ReasonCode(enum.IntEnum):
    SUCCESS = 0
    NORMAL_DISCONNECTION = 0
    GRANTED_QOS0 = 0
    GRANTED_QOS1 = 1
    GRANTED_QOS2 = 2
    DISCONNECT_WITH_WILL_MSG = 4
    NO_MATCHING_SUBSCRIBERS = 16
    NO_SUBSCRIPTION_EXISTED = 17
    CONTINUE_AUTHENTICATION = 24
    REAUTHENTICATE = 25
    UNSPECIFIED = 128
    MALFORMED_PACKET = 129
    PROTOCOL_ERROR = 130
    IMPLEMENTATION_SPECIFIC = 131
    UNSUPPORTED_PROTOCOL_VERSION = 132
    CLIENTID_NOT_VALID = 133
    BAD_USERNAME_OR_PASSWORD = 134
    NOT_AUTHORIZED = 135
    SERVER_UNAVAILABLE = 136
    SERVER_BUSY = 137
    BANNED = 138
    SERVER_SHUTTING_DOWN = 139
    BAD_AUTHENTICATION_METHOD = 140
    KEEP_ALIVE_TIMEOUT = 141
    SESSION_TAKEN_OVER = 142
    TOPIC_FILTER_INVALID = 143
    TOPIC_NAME_INVALID = 144
    PACKET_ID_IN_USE = 145
    PACKET_ID_NOT_FOUND = 146
    RECEIVE_MAXIMUM_EXCEEDED = 147
    TOPIC_ALIAS_INVALID = 148
    PACKET_TOO_LARGE = 149
    MESSAGE_RATE_TOO_HIGH = 150
    QUOTA_EXCEEDED = 151
    ADMINISTRATIVE_ACTION = 152
    PAYLOAD_FORMAT_INVALID = 153
    RETAIN_NOT_SUPPORTED = 154
    QOS_NOT_SUPPORTED = 155
    USE_ANOTHER_SERVER = 156
    SERVER_MOVED = 157
    SHARED_SUBS_NOT_SUPPORTED = 158
    CONNECTION_RATE_EXCEEDED = 159
    MAXIMUM_CONNECT_TIME = 160
    SUBSCRIPTION_IDS_NOT_SUPPORTED = 161
    WILDCARD_SUBS_NOT_SUPPORTED = 162


class LogLevel(enum.IntEnum):
    NONE = 0
    INFO = 1 << 0
    NOTICE = 1 << 1
    WARNING = 1 << 2
    ERR = 1 << 3
    DEBUG = 1 << 4
    SUBSCRIBE = 1 << 5
    UNSUBSCRIBE = 1 << 6
    WEBSOCKETS = 1 << 7
    INTERNAL = 0x80000000
    ALL = 0xFFFFFFFF


class Option(enum.IntEnum):
    PROTOCOL_VERSION = 1
    SSL_CTX = 2
    SSL_CTX_WITH_DEFAULTS = 3
    RECEIVE_MAXIMUM = 4
    SEND_MAXIMUM = 5
    TLS_KEYFORM = 6
    TLS_ENGINE = 7
    TLS_ENGINE_KPASS_SHA1 = 8
    TLS_OCSP_REQUIRED = 9
    TLS_ALPN = 10
    TCP_NODELAY = 11
    BIND_ADDRESS = 12
    TLS_USE_OS_CERTS = 13


class ProtocolVersion(enum.IntEnum):
    MQTTv31 = 3
    MQTTv311 = 4
    MQTTv5 = 5


class MQTT5PropertyID(enum.IntEnum):
    PAYLOAD_FORMAT_INDICATOR = 1  # Byte : PUBLISH, Will Properties
    MESSAGE_EXPIRY_INTERVAL = 2  # 4 byte int : PUBLISH, Will Properties
    CONTENT_TYPE = 3  # UTF-8 string : PUBLISH, Will Properties
    RESPONSE_TOPIC = 8  # UTF-8 string : PUBLISH, Will Properties
    CORRELATION_DATA = 9  # Binary Data : PUBLISH, Will Properties
    SUBSCRIPTION_IDENTIFIER = 11  # Var int : PUBLISH, SUBSCRIBE
    SESSION_EXPIRY_INTERVAL = 17  # 4 byte int : CONNECT, CONNACK, DISCONNECT
    ASSIGNED_CLIENT_IDENTIFIER = 18  # UTF-8 string : CONNACK
    SERVER_KEEP_ALIVE = 19  # 2 byte int : CONNACK
    AUTHENTICATION_METHOD = 21  # UTF-8 string : CONNECT, CONNACK, AUTH
    AUTHENTICATION_DATA = 22  # Binary Data : CONNECT, CONNACK, AUTH
    REQUEST_PROBLEM_INFORMATION = 23  # Byte : CONNECT
    WILL_DELAY_INTERVAL = 24  # 4 byte int : Will properties
    REQUEST_RESPONSE_INFORMATION = 25  # Byte : CONNECT
    RESPONSE_INFORMATION = 26  # UTF-8 string : CONNACK
    SERVER_REFERENCE = 28  # UTF-8 string : CONNACK, DISCONNECT
    REASON_STRING = 31  # UTF-8 string : All except Will properties
    RECEIVE_MAXIMUM = 33  # 2 byte int : CONNECT, CONNACK
    TOPIC_ALIAS_MAXIMUM = 34  # 2 byte int : CONNECT, CONNACK
    TOPIC_ALIAS = 35  # 2 byte int : PUBLISH
    MAXIMUM_QOS = 36  # Byte : CONNACK
    RETAIN_AVAILABLE = 37  # Byte : CONNACK
    USER_PROPERTY = 38  # UTF-8 string pair : All
    MAXIMUM_PACKET_SIZE = 39  # 4 byte int : CONNECT, CONNACK
    WILDCARD_SUB_AVAILABLE = 40  # Byte : CONNACK
    SUBSCRIPTION_ID_AVAILABLE = 41  # Byte : CONNACK
    SHARED_SUB_AVAILABLE = 42  # Byte : CONNACK
