"""Add support for environment previous finalized snapshots."""

from sqlglot import exp

from sqlmesh.utils.migration import blob_text_type


def migrate_schemas(state_sync, **kwargs):  # type: ignore
    engine_adapter = state_sync.engine_adapter
    environments_table = "_environments"
    if state_sync.schema:
        environments_table = f"{state_sync.schema}.{environments_table}"

    blob_type = blob_text_type(engine_adapter.dialect)

    alter_table_exp = exp.Alter(
        this=exp.to_table(environments_table),
        kind="TABLE",
        actions=[
            exp.ColumnDef(
                this=exp.to_column("previous_finalized_snapshots"),
                kind=exp.DataType.build(blob_type),
            )
        ],
    )
    engine_adapter.execute(alter_table_exp)


def migrate_rows(state_sync, **kwargs):  # type: ignore
    pass
