import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdSecretLibraryConfig extends cdktf.TerraformMetaArguments {
    /**
    * The mount path for the AD backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#backend AdSecretLibrary#backend}
    */
    readonly backend: string;
    /**
    * Disable enforcing that service accounts must be checked in by the entity or client token that checked them out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#disable_check_in_enforcement AdSecretLibrary#disable_check_in_enforcement}
    */
    readonly disableCheckInEnforcement?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#id AdSecretLibrary#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The maximum amount of time, in seconds, a check-out last with renewal before Vault automatically checks it back in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#max_ttl AdSecretLibrary#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * The name of the set of service accounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#name AdSecretLibrary#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#namespace AdSecretLibrary#namespace}
    */
    readonly namespace?: string;
    /**
    * The names of all the service accounts that can be checked out from this set. These service accounts must already exist in Active Directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#service_account_names AdSecretLibrary#service_account_names}
    */
    readonly serviceAccountNames: string[];
    /**
    * The amount of time, in seconds, a single check-out lasts before Vault automatically checks it back in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library#ttl AdSecretLibrary#ttl}
    */
    readonly ttl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library vault_ad_secret_library}
*/
export declare class AdSecretLibrary extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_ad_secret_library";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_library vault_ad_secret_library} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdSecretLibraryConfig
    */
    constructor(scope: Construct, id: string, config: AdSecretLibraryConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _disableCheckInEnforcement?;
    get disableCheckInEnforcement(): boolean | cdktf.IResolvable;
    set disableCheckInEnforcement(value: boolean | cdktf.IResolvable);
    resetDisableCheckInEnforcement(): void;
    get disableCheckInEnforcementInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _serviceAccountNames?;
    get serviceAccountNames(): string[];
    set serviceAccountNames(value: string[]);
    get serviceAccountNamesInput(): string[] | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
