import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendIdentityWhitelistConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist#backend AwsAuthBackendIdentityWhitelist#backend}
    */
    readonly backend?: string;
    /**
    * If true, disables the periodic tidying of the identiy whitelist entries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist#disable_periodic_tidy AwsAuthBackendIdentityWhitelist#disable_periodic_tidy}
    */
    readonly disablePeriodicTidy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist#id AwsAuthBackendIdentityWhitelist#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist#namespace AwsAuthBackendIdentityWhitelist#namespace}
    */
    readonly namespace?: string;
    /**
    * The amount of extra time that must have passed beyond the roletag expiration, before it's removed from backend storage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist#safety_buffer AwsAuthBackendIdentityWhitelist#safety_buffer}
    */
    readonly safetyBuffer?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist vault_aws_auth_backend_identity_whitelist}
*/
export declare class AwsAuthBackendIdentityWhitelist extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_identity_whitelist";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_identity_whitelist vault_aws_auth_backend_identity_whitelist} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendIdentityWhitelistConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AwsAuthBackendIdentityWhitelistConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _disablePeriodicTidy?;
    get disablePeriodicTidy(): boolean | cdktf.IResolvable;
    set disablePeriodicTidy(value: boolean | cdktf.IResolvable);
    resetDisablePeriodicTidy(): void;
    get disablePeriodicTidyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _safetyBuffer?;
    get safetyBuffer(): number;
    set safetyBuffer(value: number);
    resetSafetyBuffer(): void;
    get safetyBufferInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
