import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultAdAccessCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * AD Secret Backend to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#backend DataVaultAdAccessCredentials#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#id DataVaultAdAccessCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#namespace DataVaultAdAccessCredentials#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials#role DataVaultAdAccessCredentials#role}
    */
    readonly role: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials vault_ad_access_credentials}
*/
export declare class DataVaultAdAccessCredentials extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_ad_access_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/ad_access_credentials vault_ad_access_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAdAccessCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultAdAccessCredentialsConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get currentPassword(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastPassword(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get username(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
