import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityEntityConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#alias_id DataVaultIdentityEntity#alias_id}
    */
    readonly aliasId?: string;
    /**
    * Accessor of the mount to which the alias belongs to. This should be supplied in conjunction with `alias_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#alias_mount_accessor DataVaultIdentityEntity#alias_mount_accessor}
    */
    readonly aliasMountAccessor?: string;
    /**
    * Name of the alias. This should be supplied in conjunction with `alias_mount_accessor`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#alias_name DataVaultIdentityEntity#alias_name}
    */
    readonly aliasName?: string;
    /**
    * ID of the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#entity_id DataVaultIdentityEntity#entity_id}
    */
    readonly entityId?: string;
    /**
    * Name of the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#entity_name DataVaultIdentityEntity#entity_name}
    */
    readonly entityName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#id DataVaultIdentityEntity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_entity#namespace DataVaultIdentityEntity#namespace}
    */
    readonly namespace?: string;
}
export interface DataVaultIdentityEntityAliases {
}
export declare function dataVaultIdentityEntityAliasesToTerraform(struct?: DataVaultIdentityEntityAliases): any;
export declare class DataVaultIdentityEntityAliasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVaultIdentityEntityAliases | undefined;
    set internalValue(value: DataVaultIdentityEntityAliases | undefined);
    get canonicalId(): string;
    get creationTime(): string;
    get id(): string;
    get lastUpdateTime(): string;
    get mergedFromCanonicalIds(): string[];
    private _metadata;
    get metadata(): cdktf.StringMap;
    get mountAccessor(): string;
    get mountPath(): string;
    get mountType(): string;
    get name(): string;
}
export declare class DataVaultIdentityEntityAliasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVaultIdentityEntityAliasesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_entity vault_identity_entity}
*/
export declare class DataVaultIdentityEntity extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_entity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_entity vault_identity_entity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityEntityConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultIdentityEntityConfig);
    private _aliasId?;
    get aliasId(): string;
    set aliasId(value: string);
    resetAliasId(): void;
    get aliasIdInput(): string | undefined;
    private _aliasMountAccessor?;
    get aliasMountAccessor(): string;
    set aliasMountAccessor(value: string);
    resetAliasMountAccessor(): void;
    get aliasMountAccessorInput(): string | undefined;
    private _aliasName?;
    get aliasName(): string;
    set aliasName(value: string);
    resetAliasName(): void;
    get aliasNameInput(): string | undefined;
    private _aliases;
    get aliases(): DataVaultIdentityEntityAliasesList;
    get creationTime(): string;
    get dataJson(): string;
    get directGroupIds(): string[];
    get disabled(): cdktf.IResolvable;
    private _entityId?;
    get entityId(): string;
    set entityId(value: string);
    resetEntityId(): void;
    get entityIdInput(): string | undefined;
    private _entityName?;
    get entityName(): string;
    set entityName(value: string);
    resetEntityName(): void;
    get entityNameInput(): string | undefined;
    get groupIds(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inheritedGroupIds(): string[];
    get lastUpdateTime(): string;
    get mergedEntityIds(): string[];
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get namespaceId(): string;
    get policies(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
