import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKubernetesAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional Audience claim to verify in the JWT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#audience DataVaultKubernetesAuthBackendRole#audience}
    */
    readonly audience?: string;
    /**
    * Unique name of the kubernetes backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#backend DataVaultKubernetesAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#id DataVaultKubernetesAuthBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#namespace DataVaultKubernetesAuthBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#role_name DataVaultKubernetesAuthBackendRole#role_name}
    */
    readonly roleName: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_bound_cidrs DataVaultKubernetesAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_explicit_max_ttl DataVaultKubernetesAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_max_ttl DataVaultKubernetesAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_no_default_policy DataVaultKubernetesAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_num_uses DataVaultKubernetesAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_period DataVaultKubernetesAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_policies DataVaultKubernetesAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_ttl DataVaultKubernetesAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role#token_type DataVaultKubernetesAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role vault_kubernetes_auth_backend_role}
*/
export declare class DataVaultKubernetesAuthBackendRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kubernetes_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_role vault_kubernetes_auth_backend_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKubernetesAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultKubernetesAuthBackendRoleConfig);
    get aliasNameSource(): string;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get boundServiceAccountNames(): string[];
    get boundServiceAccountNamespaces(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
