import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultPolicyDocumentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#id DataVaultPolicyDocument#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#namespace DataVaultPolicyDocument#namespace}
    */
    readonly namespace?: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#rule DataVaultPolicyDocument#rule}
    */
    readonly rule?: DataVaultPolicyDocumentRule[] | cdktf.IResolvable;
}
export interface DataVaultPolicyDocumentRuleAllowedParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#key DataVaultPolicyDocument#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#value DataVaultPolicyDocument#value}
    */
    readonly value: string[];
}
export declare function dataVaultPolicyDocumentRuleAllowedParameterToTerraform(struct?: DataVaultPolicyDocumentRuleAllowedParameter | cdktf.IResolvable): any;
export declare class DataVaultPolicyDocumentRuleAllowedParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVaultPolicyDocumentRuleAllowedParameter | cdktf.IResolvable | undefined;
    set internalValue(value: DataVaultPolicyDocumentRuleAllowedParameter | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string[];
    set value(value: string[]);
    get valueInput(): string[] | undefined;
}
export declare class DataVaultPolicyDocumentRuleAllowedParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataVaultPolicyDocumentRuleAllowedParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVaultPolicyDocumentRuleAllowedParameterOutputReference;
}
export interface DataVaultPolicyDocumentRuleDeniedParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#key DataVaultPolicyDocument#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#value DataVaultPolicyDocument#value}
    */
    readonly value: string[];
}
export declare function dataVaultPolicyDocumentRuleDeniedParameterToTerraform(struct?: DataVaultPolicyDocumentRuleDeniedParameter | cdktf.IResolvable): any;
export declare class DataVaultPolicyDocumentRuleDeniedParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVaultPolicyDocumentRuleDeniedParameter | cdktf.IResolvable | undefined;
    set internalValue(value: DataVaultPolicyDocumentRuleDeniedParameter | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string[];
    set value(value: string[]);
    get valueInput(): string[] | undefined;
}
export declare class DataVaultPolicyDocumentRuleDeniedParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataVaultPolicyDocumentRuleDeniedParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVaultPolicyDocumentRuleDeniedParameterOutputReference;
}
export interface DataVaultPolicyDocumentRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#capabilities DataVaultPolicyDocument#capabilities}
    */
    readonly capabilities: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#description DataVaultPolicyDocument#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#max_wrapping_ttl DataVaultPolicyDocument#max_wrapping_ttl}
    */
    readonly maxWrappingTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#min_wrapping_ttl DataVaultPolicyDocument#min_wrapping_ttl}
    */
    readonly minWrappingTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#path DataVaultPolicyDocument#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#required_parameters DataVaultPolicyDocument#required_parameters}
    */
    readonly requiredParameters?: string[];
    /**
    * allowed_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#allowed_parameter DataVaultPolicyDocument#allowed_parameter}
    */
    readonly allowedParameter?: DataVaultPolicyDocumentRuleAllowedParameter[] | cdktf.IResolvable;
    /**
    * denied_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#denied_parameter DataVaultPolicyDocument#denied_parameter}
    */
    readonly deniedParameter?: DataVaultPolicyDocumentRuleDeniedParameter[] | cdktf.IResolvable;
}
export declare function dataVaultPolicyDocumentRuleToTerraform(struct?: DataVaultPolicyDocumentRule | cdktf.IResolvable): any;
export declare class DataVaultPolicyDocumentRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataVaultPolicyDocumentRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataVaultPolicyDocumentRule | cdktf.IResolvable | undefined);
    private _capabilities?;
    get capabilities(): string[];
    set capabilities(value: string[]);
    get capabilitiesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _maxWrappingTtl?;
    get maxWrappingTtl(): string;
    set maxWrappingTtl(value: string);
    resetMaxWrappingTtl(): void;
    get maxWrappingTtlInput(): string | undefined;
    private _minWrappingTtl?;
    get minWrappingTtl(): string;
    set minWrappingTtl(value: string);
    resetMinWrappingTtl(): void;
    get minWrappingTtlInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _requiredParameters?;
    get requiredParameters(): string[];
    set requiredParameters(value: string[]);
    resetRequiredParameters(): void;
    get requiredParametersInput(): string[] | undefined;
    private _allowedParameter;
    get allowedParameter(): DataVaultPolicyDocumentRuleAllowedParameterList;
    putAllowedParameter(value: DataVaultPolicyDocumentRuleAllowedParameter[] | cdktf.IResolvable): void;
    resetAllowedParameter(): void;
    get allowedParameterInput(): cdktf.IResolvable | DataVaultPolicyDocumentRuleAllowedParameter[] | undefined;
    private _deniedParameter;
    get deniedParameter(): DataVaultPolicyDocumentRuleDeniedParameterList;
    putDeniedParameter(value: DataVaultPolicyDocumentRuleDeniedParameter[] | cdktf.IResolvable): void;
    resetDeniedParameter(): void;
    get deniedParameterInput(): cdktf.IResolvable | DataVaultPolicyDocumentRuleDeniedParameter[] | undefined;
}
export declare class DataVaultPolicyDocumentRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataVaultPolicyDocumentRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataVaultPolicyDocumentRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/policy_document vault_policy_document}
*/
export declare class DataVaultPolicyDocument extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_policy_document";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/policy_document vault_policy_document} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultPolicyDocumentConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultPolicyDocumentConfig);
    get hcl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _rule;
    get rule(): DataVaultPolicyDocumentRuleList;
    putRule(value: DataVaultPolicyDocumentRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | DataVaultPolicyDocumentRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
