import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityEntityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the entity is disabled. Disabled entities' associated tokens cannot be used, but are not revoked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#disabled IdentityEntity#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Manage policies externally through `vault_identity_entity_policies`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#external_policies IdentityEntity#external_policies}
    */
    readonly externalPolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#id IdentityEntity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata to be associated with the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#metadata IdentityEntity#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Name of the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#name IdentityEntity#name}
    */
    readonly name?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#namespace IdentityEntity#namespace}
    */
    readonly namespace?: string;
    /**
    * Policies to be tied to the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity#policies IdentityEntity#policies}
    */
    readonly policies?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_entity vault_identity_entity}
*/
export declare class IdentityEntity extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_entity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_entity vault_identity_entity} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityEntityConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IdentityEntityConfig);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalPolicies?;
    get externalPolicies(): boolean | cdktf.IResolvable;
    set externalPolicies(value: boolean | cdktf.IResolvable);
    resetExternalPolicies(): void;
    get externalPoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
