import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityGroupAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the group to which this is an alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#canonical_id IdentityGroupAlias#canonical_id}
    */
    readonly canonicalId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#id IdentityGroupAlias#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Mount accessor to which this alias belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#mount_accessor IdentityGroupAlias#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the group alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#name IdentityGroupAlias#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#namespace IdentityGroupAlias#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias vault_identity_group_alias}
*/
export declare class IdentityGroupAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_group_alias";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias vault_identity_group_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityGroupAliasConfig
    */
    constructor(scope: Construct, id: string, config: IdentityGroupAliasConfig);
    private _canonicalId?;
    get canonicalId(): string;
    set canonicalId(value: string);
    get canonicalIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
