"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthBackend = exports.JwtAuthBackendTuneList = exports.JwtAuthBackendTuneOutputReference = exports.jwtAuthBackendTuneToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function jwtAuthBackendTuneToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_response_headers: struct.allowedResponseHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedResponseHeaders),
        audit_non_hmac_request_keys: struct.auditNonHmacRequestKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.auditNonHmacRequestKeys),
        audit_non_hmac_response_keys: struct.auditNonHmacResponseKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.auditNonHmacResponseKeys),
        default_lease_ttl: struct.defaultLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.defaultLeaseTtl),
        listing_visibility: struct.listingVisibility === undefined ? null : cdktf.stringToTerraform(struct.listingVisibility),
        max_lease_ttl: struct.maxLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.maxLeaseTtl),
        passthrough_request_headers: struct.passthroughRequestHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform, false)(struct.passthroughRequestHeaders),
        token_type: struct.tokenType === undefined ? null : cdktf.stringToTerraform(struct.tokenType),
    };
}
exports.jwtAuthBackendTuneToTerraform = jwtAuthBackendTuneToTerraform;
class JwtAuthBackendTuneOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedResponseHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedResponseHeaders = this._allowedResponseHeaders;
        }
        if (this._auditNonHmacRequestKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacRequestKeys = this._auditNonHmacRequestKeys;
        }
        if (this._auditNonHmacResponseKeys !== undefined) {
            hasAnyValues = true;
            internalValueResult.auditNonHmacResponseKeys = this._auditNonHmacResponseKeys;
        }
        if (this._defaultLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.defaultLeaseTtl = this._defaultLeaseTtl;
        }
        if (this._listingVisibility !== undefined) {
            hasAnyValues = true;
            internalValueResult.listingVisibility = this._listingVisibility;
        }
        if (this._maxLeaseTtl !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxLeaseTtl = this._maxLeaseTtl;
        }
        if (this._passthroughRequestHeaders !== undefined) {
            hasAnyValues = true;
            internalValueResult.passthroughRequestHeaders = this._passthroughRequestHeaders;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = undefined;
            this._auditNonHmacRequestKeys = undefined;
            this._auditNonHmacResponseKeys = undefined;
            this._defaultLeaseTtl = undefined;
            this._listingVisibility = undefined;
            this._maxLeaseTtl = undefined;
            this._passthroughRequestHeaders = undefined;
            this._tokenType = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._allowedResponseHeaders = value.allowedResponseHeaders;
            this._auditNonHmacRequestKeys = value.auditNonHmacRequestKeys;
            this._auditNonHmacResponseKeys = value.auditNonHmacResponseKeys;
            this._defaultLeaseTtl = value.defaultLeaseTtl;
            this._listingVisibility = value.listingVisibility;
            this._maxLeaseTtl = value.maxLeaseTtl;
            this._passthroughRequestHeaders = value.passthroughRequestHeaders;
            this._tokenType = value.tokenType;
        }
    }
    get allowedResponseHeaders() {
        return this.getListAttribute('allowed_response_headers');
    }
    set allowedResponseHeaders(value) {
        this._allowedResponseHeaders = value;
    }
    resetAllowedResponseHeaders() {
        this._allowedResponseHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedResponseHeadersInput() {
        return this._allowedResponseHeaders;
    }
    get auditNonHmacRequestKeys() {
        return this.getListAttribute('audit_non_hmac_request_keys');
    }
    set auditNonHmacRequestKeys(value) {
        this._auditNonHmacRequestKeys = value;
    }
    resetAuditNonHmacRequestKeys() {
        this._auditNonHmacRequestKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacRequestKeysInput() {
        return this._auditNonHmacRequestKeys;
    }
    get auditNonHmacResponseKeys() {
        return this.getListAttribute('audit_non_hmac_response_keys');
    }
    set auditNonHmacResponseKeys(value) {
        this._auditNonHmacResponseKeys = value;
    }
    resetAuditNonHmacResponseKeys() {
        this._auditNonHmacResponseKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacResponseKeysInput() {
        return this._auditNonHmacResponseKeys;
    }
    get defaultLeaseTtl() {
        return this.getStringAttribute('default_lease_ttl');
    }
    set defaultLeaseTtl(value) {
        this._defaultLeaseTtl = value;
    }
    resetDefaultLeaseTtl() {
        this._defaultLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlInput() {
        return this._defaultLeaseTtl;
    }
    get listingVisibility() {
        return this.getStringAttribute('listing_visibility');
    }
    set listingVisibility(value) {
        this._listingVisibility = value;
    }
    resetListingVisibility() {
        this._listingVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listingVisibilityInput() {
        return this._listingVisibility;
    }
    get maxLeaseTtl() {
        return this.getStringAttribute('max_lease_ttl');
    }
    set maxLeaseTtl(value) {
        this._maxLeaseTtl = value;
    }
    resetMaxLeaseTtl() {
        this._maxLeaseTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlInput() {
        return this._maxLeaseTtl;
    }
    get passthroughRequestHeaders() {
        return this.getListAttribute('passthrough_request_headers');
    }
    set passthroughRequestHeaders(value) {
        this._passthroughRequestHeaders = value;
    }
    resetPassthroughRequestHeaders() {
        this._passthroughRequestHeaders = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passthroughRequestHeadersInput() {
        return this._passthroughRequestHeaders;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
}
exports.JwtAuthBackendTuneOutputReference = JwtAuthBackendTuneOutputReference;
_a = JSII_RTTI_SYMBOL_1;
JwtAuthBackendTuneOutputReference[_a] = { fqn: "@cdktf/provider-vault.JwtAuthBackendTuneOutputReference", version: "2.0.7" };
class JwtAuthBackendTuneList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new JwtAuthBackendTuneOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.JwtAuthBackendTuneList = JwtAuthBackendTuneList;
_b = JSII_RTTI_SYMBOL_1;
JwtAuthBackendTuneList[_b] = { fqn: "@cdktf/provider-vault.JwtAuthBackendTuneList", version: "2.0.7" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend}
*/
class JwtAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_jwt_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // tune - computed: true, optional: true, required: false
        this._tune = new JwtAuthBackendTuneList(this, "tune", true);
        this._boundIssuer = config.boundIssuer;
        this._defaultRole = config.defaultRole;
        this._description = config.description;
        this._id = config.id;
        this._jwksCaPem = config.jwksCaPem;
        this._jwksUrl = config.jwksUrl;
        this._jwtSupportedAlgs = config.jwtSupportedAlgs;
        this._jwtValidationPubkeys = config.jwtValidationPubkeys;
        this._local = config.local;
        this._namespace = config.namespace;
        this._namespaceInState = config.namespaceInState;
        this._oidcClientId = config.oidcClientId;
        this._oidcClientSecret = config.oidcClientSecret;
        this._oidcDiscoveryCaPem = config.oidcDiscoveryCaPem;
        this._oidcDiscoveryUrl = config.oidcDiscoveryUrl;
        this._oidcResponseMode = config.oidcResponseMode;
        this._oidcResponseTypes = config.oidcResponseTypes;
        this._path = config.path;
        this._providerConfig = config.providerConfig;
        this._tune.internalValue = config.tune;
        this._type = config.type;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get boundIssuer() {
        return this.getStringAttribute('bound_issuer');
    }
    set boundIssuer(value) {
        this._boundIssuer = value;
    }
    resetBoundIssuer() {
        this._boundIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundIssuerInput() {
        return this._boundIssuer;
    }
    get defaultRole() {
        return this.getStringAttribute('default_role');
    }
    set defaultRole(value) {
        this._defaultRole = value;
    }
    resetDefaultRole() {
        this._defaultRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultRoleInput() {
        return this._defaultRole;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get jwksCaPem() {
        return this.getStringAttribute('jwks_ca_pem');
    }
    set jwksCaPem(value) {
        this._jwksCaPem = value;
    }
    resetJwksCaPem() {
        this._jwksCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksCaPemInput() {
        return this._jwksCaPem;
    }
    get jwksUrl() {
        return this.getStringAttribute('jwks_url');
    }
    set jwksUrl(value) {
        this._jwksUrl = value;
    }
    resetJwksUrl() {
        this._jwksUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksUrlInput() {
        return this._jwksUrl;
    }
    get jwtSupportedAlgs() {
        return this.getListAttribute('jwt_supported_algs');
    }
    set jwtSupportedAlgs(value) {
        this._jwtSupportedAlgs = value;
    }
    resetJwtSupportedAlgs() {
        this._jwtSupportedAlgs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtSupportedAlgsInput() {
        return this._jwtSupportedAlgs;
    }
    get jwtValidationPubkeys() {
        return this.getListAttribute('jwt_validation_pubkeys');
    }
    set jwtValidationPubkeys(value) {
        this._jwtValidationPubkeys = value;
    }
    resetJwtValidationPubkeys() {
        this._jwtValidationPubkeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtValidationPubkeysInput() {
        return this._jwtValidationPubkeys;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get namespaceInState() {
        return this.getBooleanAttribute('namespace_in_state');
    }
    set namespaceInState(value) {
        this._namespaceInState = value;
    }
    resetNamespaceInState() {
        this._namespaceInState = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInStateInput() {
        return this._namespaceInState;
    }
    get oidcClientId() {
        return this.getStringAttribute('oidc_client_id');
    }
    set oidcClientId(value) {
        this._oidcClientId = value;
    }
    resetOidcClientId() {
        this._oidcClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientIdInput() {
        return this._oidcClientId;
    }
    get oidcClientSecret() {
        return this.getStringAttribute('oidc_client_secret');
    }
    set oidcClientSecret(value) {
        this._oidcClientSecret = value;
    }
    resetOidcClientSecret() {
        this._oidcClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientSecretInput() {
        return this._oidcClientSecret;
    }
    get oidcDiscoveryCaPem() {
        return this.getStringAttribute('oidc_discovery_ca_pem');
    }
    set oidcDiscoveryCaPem(value) {
        this._oidcDiscoveryCaPem = value;
    }
    resetOidcDiscoveryCaPem() {
        this._oidcDiscoveryCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryCaPemInput() {
        return this._oidcDiscoveryCaPem;
    }
    get oidcDiscoveryUrl() {
        return this.getStringAttribute('oidc_discovery_url');
    }
    set oidcDiscoveryUrl(value) {
        this._oidcDiscoveryUrl = value;
    }
    resetOidcDiscoveryUrl() {
        this._oidcDiscoveryUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryUrlInput() {
        return this._oidcDiscoveryUrl;
    }
    get oidcResponseMode() {
        return this.getStringAttribute('oidc_response_mode');
    }
    set oidcResponseMode(value) {
        this._oidcResponseMode = value;
    }
    resetOidcResponseMode() {
        this._oidcResponseMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseModeInput() {
        return this._oidcResponseMode;
    }
    get oidcResponseTypes() {
        return this.getListAttribute('oidc_response_types');
    }
    set oidcResponseTypes(value) {
        this._oidcResponseTypes = value;
    }
    resetOidcResponseTypes() {
        this._oidcResponseTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseTypesInput() {
        return this._oidcResponseTypes;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get providerConfig() {
        return this.getStringMapAttribute('provider_config');
    }
    set providerConfig(value) {
        this._providerConfig = value;
    }
    resetProviderConfig() {
        this._providerConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get providerConfigInput() {
        return this._providerConfig;
    }
    get tune() {
        return this._tune;
    }
    putTune(value) {
        this._tune.internalValue = value;
    }
    resetTune() {
        this._tune.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tuneInput() {
        return this._tune.internalValue;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bound_issuer: cdktf.stringToTerraform(this._boundIssuer),
            default_role: cdktf.stringToTerraform(this._defaultRole),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            jwks_ca_pem: cdktf.stringToTerraform(this._jwksCaPem),
            jwks_url: cdktf.stringToTerraform(this._jwksUrl),
            jwt_supported_algs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._jwtSupportedAlgs),
            jwt_validation_pubkeys: cdktf.listMapper(cdktf.stringToTerraform, false)(this._jwtValidationPubkeys),
            local: cdktf.booleanToTerraform(this._local),
            namespace: cdktf.stringToTerraform(this._namespace),
            namespace_in_state: cdktf.booleanToTerraform(this._namespaceInState),
            oidc_client_id: cdktf.stringToTerraform(this._oidcClientId),
            oidc_client_secret: cdktf.stringToTerraform(this._oidcClientSecret),
            oidc_discovery_ca_pem: cdktf.stringToTerraform(this._oidcDiscoveryCaPem),
            oidc_discovery_url: cdktf.stringToTerraform(this._oidcDiscoveryUrl),
            oidc_response_mode: cdktf.stringToTerraform(this._oidcResponseMode),
            oidc_response_types: cdktf.listMapper(cdktf.stringToTerraform, false)(this._oidcResponseTypes),
            path: cdktf.stringToTerraform(this._path),
            provider_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._providerConfig),
            tune: cdktf.listMapper(jwtAuthBackendTuneToTerraform, false)(this._tune.internalValue),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.JwtAuthBackend = JwtAuthBackend;
_c = JSII_RTTI_SYMBOL_1;
JwtAuthBackend[_c] = { fqn: "@cdktf/provider-vault.JwtAuthBackend", version: "2.0.7" };
// =================
// STATIC PROPERTIES
// =================
JwtAuthBackend.tfResourceType = "vault_jwt_auth_backend";
//# sourceMappingURL=data:application/json;base64,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