import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KvSecretV2Config extends cdktf.TerraformMetaArguments {
    /**
    * This flag is required if cas_required is set to true on either the secret or the engine's config. In order for a write to be successful, cas must be set to the current version of the secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#cas KvSecretV2#cas}
    */
    readonly cas?: number;
    /**
    * JSON-encoded secret data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#data_json KvSecretV2#data_json}
    */
    readonly dataJson: string;
    /**
    * If set to true, permanently deletes all versions for the specified key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#delete_all_versions KvSecretV2#delete_all_versions}
    */
    readonly deleteAllVersions?: boolean | cdktf.IResolvable;
    /**
    * If set to true, disables reading secret from Vault; note: drift won't be detected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#disable_read KvSecretV2#disable_read}
    */
    readonly disableRead?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#id KvSecretV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Path where KV-V2 engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#mount KvSecretV2#mount}
    */
    readonly mount: string;
    /**
    * Full name of the secret. For a nested secret, the name is the nested path excluding the mount and data prefix. For example, for a secret at 'kvv2/data/foo/bar/baz', the name is 'foo/bar/baz'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#name KvSecretV2#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#namespace KvSecretV2#namespace}
    */
    readonly namespace?: string;
    /**
    * An object that holds option settings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2#options KvSecretV2#options}
    */
    readonly options?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2 vault_kv_secret_v2}
*/
export declare class KvSecretV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kv_secret_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_v2 vault_kv_secret_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KvSecretV2Config
    */
    constructor(scope: Construct, id: string, config: KvSecretV2Config);
    private _cas?;
    get cas(): number;
    set cas(value: number);
    resetCas(): void;
    get casInput(): number | undefined;
    private _data;
    get data(): cdktf.StringMap;
    private _dataJson?;
    get dataJson(): string;
    set dataJson(value: string);
    get dataJsonInput(): string | undefined;
    private _deleteAllVersions?;
    get deleteAllVersions(): boolean | cdktf.IResolvable;
    set deleteAllVersions(value: boolean | cdktf.IResolvable);
    resetDeleteAllVersions(): void;
    get deleteAllVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _disableRead?;
    get disableRead(): boolean | cdktf.IResolvable;
    set disableRead(value: boolean | cdktf.IResolvable);
    resetDisableRead(): void;
    get disableReadInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _mount?;
    get mount(): string;
    set mount(value: string);
    get mountInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    get path(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
