import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KvSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * JSON-encoded secret data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret#data_json KvSecret#data_json}
    */
    readonly dataJson: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret#id KvSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret#namespace KvSecret#namespace}
    */
    readonly namespace?: string;
    /**
    * Full path of the KV-V1 secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret#path KvSecret#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kv_secret vault_kv_secret}
*/
export declare class KvSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kv_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kv_secret vault_kv_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KvSecretConfig
    */
    constructor(scope: Construct, id: string, config: KvSecretConfig);
    private _data;
    get data(): cdktf.StringMap;
    private _dataJson?;
    get dataJson(): string;
    set dataJson(value: string);
    get dataJsonInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
