import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaDuoConfig extends cdktf.TerraformMetaArguments {
    /**
    * API hostname for Duo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#api_hostname MfaDuo#api_hostname}
    */
    readonly apiHostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#id MfaDuo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Integration key for Duo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#integration_key MfaDuo#integration_key}
    */
    readonly integrationKey: string;
    /**
    * The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#mount_accessor MfaDuo#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the MFA method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#name MfaDuo#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#namespace MfaDuo#namespace}
    */
    readonly namespace?: string;
    /**
    * Push information for Duo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#push_info MfaDuo#push_info}
    */
    readonly pushInfo?: string;
    /**
    * Secret key for Duo.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#secret_key MfaDuo#secret_key}
    */
    readonly secretKey: string;
    /**
    * A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo#username_format MfaDuo#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo vault_mfa_duo}
*/
export declare class MfaDuo extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_mfa_duo";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/mfa_duo vault_mfa_duo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaDuoConfig
    */
    constructor(scope: Construct, id: string, config: MfaDuoConfig);
    private _apiHostname?;
    get apiHostname(): string;
    set apiHostname(value: string);
    get apiHostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationKey?;
    get integrationKey(): string;
    set integrationKey(value: string);
    get integrationKeyInput(): string | undefined;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _pushInfo?;
    get pushInfo(): string;
    set pushInfo(value: string);
    resetPushInfo(): void;
    get pushInfoInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
