import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendConfigCaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#backend PkiSecretBackendConfigCa#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#id PkiSecretBackendConfigCa#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#namespace PkiSecretBackendConfigCa#namespace}
    */
    readonly namespace?: string;
    /**
    * The key and certificate PEM bundle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#pem_bundle PkiSecretBackendConfigCa#pem_bundle}
    */
    readonly pemBundle: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca vault_pki_secret_backend_config_ca}
*/
export declare class PkiSecretBackendConfigCa extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_config_ca";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca vault_pki_secret_backend_config_ca} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendConfigCaConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendConfigCaConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    get pemBundleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
