import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendConfigUrlsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#backend PkiSecretBackendConfigUrls#backend}
    */
    readonly backend: string;
    /**
    * Specifies the URL values for the CRL Distribution Points field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#crl_distribution_points PkiSecretBackendConfigUrls#crl_distribution_points}
    */
    readonly crlDistributionPoints?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#id PkiSecretBackendConfigUrls#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the URL values for the Issuing Certificate field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#issuing_certificates PkiSecretBackendConfigUrls#issuing_certificates}
    */
    readonly issuingCertificates?: string[];
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#namespace PkiSecretBackendConfigUrls#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies the URL values for the OCSP Servers field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls#ocsp_servers PkiSecretBackendConfigUrls#ocsp_servers}
    */
    readonly ocspServers?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls vault_pki_secret_backend_config_urls}
*/
export declare class PkiSecretBackendConfigUrls extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_config_urls";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_urls vault_pki_secret_backend_config_urls} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendConfigUrlsConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendConfigUrlsConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _crlDistributionPoints?;
    get crlDistributionPoints(): string[];
    set crlDistributionPoints(value: string[]);
    resetCrlDistributionPoints(): void;
    get crlDistributionPointsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuingCertificates?;
    get issuingCertificates(): string[];
    set issuingCertificates(value: string[]);
    resetIssuingCertificates(): void;
    get issuingCertificatesInput(): string[] | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _ocspServers?;
    get ocspServers(): string[];
    set ocspServers(value: string[]);
    resetOcspServers(): void;
    get ocspServersInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
