import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface QuotaLeaseCountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#id QuotaLeaseCount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The maximum number of leases to be allowed by the quota rule. The max_leases must be positive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#max_leases QuotaLeaseCount#max_leases}
    */
    readonly maxLeases: number;
    /**
    * The name of the quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#name QuotaLeaseCount#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#namespace QuotaLeaseCount#namespace}
    */
    readonly namespace?: string;
    /**
    * Path of the mount or namespace to apply the quota. A blank path configures a global lease count quota.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count#path QuotaLeaseCount#path}
    */
    readonly path?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count vault_quota_lease_count}
*/
export declare class QuotaLeaseCount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_quota_lease_count";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/quota_lease_count vault_quota_lease_count} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QuotaLeaseCountConfig
    */
    constructor(scope: Construct, id: string, config: QuotaLeaseCountConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxLeases?;
    get maxLeases(): number;
    set maxLeases(value: number);
    get maxLeasesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
