import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransformRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#id TransformRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#name TransformRole#name}
    */
    readonly name: string;
    /**
    * The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#path TransformRole#path}
    */
    readonly path: string;
    /**
    * A comma separated string or slice of transformations to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_role#transformations TransformRole#transformations}
    */
    readonly transformations?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_role vault_transform_role}
*/
export declare class TransformRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transform_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_role vault_transform_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransformRoleConfig
    */
    constructor(scope: Construct, id: string, config: TransformRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _transformations?;
    get transformations(): string[];
    set transformations(value: string[]);
    resetTransformations(): void;
    get transformationsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
