import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransformTransformationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The set of roles allowed to perform this transformation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#allowed_roles TransformTransformation#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#id TransformTransformation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The character used to replace data when in masking mode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#masking_character TransformTransformation#masking_character}
    */
    readonly maskingCharacter?: string;
    /**
    * The name of the transformation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#name TransformTransformation#name}
    */
    readonly name: string;
    /**
    * The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#path TransformTransformation#path}
    */
    readonly path: string;
    /**
    * The name of the template to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#template TransformTransformation#template}
    */
    readonly template?: string;
    /**
    * Templates configured for transformation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#templates TransformTransformation#templates}
    */
    readonly templates?: string[];
    /**
    * The source of where the tweak value comes from. Only valid when in FPE mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#tweak_source TransformTransformation#tweak_source}
    */
    readonly tweakSource?: string;
    /**
    * The type of transformation to perform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation#type TransformTransformation#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation vault_transform_transformation}
*/
export declare class TransformTransformation extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transform_transformation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_transformation vault_transform_transformation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransformTransformationConfig
    */
    constructor(scope: Construct, id: string, config: TransformTransformationConfig);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maskingCharacter?;
    get maskingCharacter(): string;
    set maskingCharacter(value: string);
    resetMaskingCharacter(): void;
    get maskingCharacterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    resetTemplate(): void;
    get templateInput(): string | undefined;
    private _templates?;
    get templates(): string[];
    set templates(value: string[]);
    resetTemplates(): void;
    get templatesInput(): string[] | undefined;
    private _tweakSource?;
    get tweakSource(): string;
    set tweakSource(value: string);
    resetTweakSource(): void;
    get tweakSourceInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
