# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAutomationActionsActionResult',
    'AwaitableGetAutomationActionsActionResult',
    'get_automation_actions_action',
    'get_automation_actions_action_output',
]

@pulumi.output_type
class GetAutomationActionsActionResult:
    """
    A collection of values returned by getAutomationActionsAction.
    """
    def __init__(__self__, action_classification=None, action_data_references=None, action_type=None, allow_invocation_from_event_orchestration=None, allow_invocation_manually=None, creation_time=None, description=None, id=None, map_to_all_services=None, modify_time=None, name=None, only_invocable_on_unresolved_incidents=None, runner_id=None, runner_type=None, type=None):
        if action_classification and not isinstance(action_classification, str):
            raise TypeError("Expected argument 'action_classification' to be a str")
        pulumi.set(__self__, "action_classification", action_classification)
        if action_data_references and not isinstance(action_data_references, list):
            raise TypeError("Expected argument 'action_data_references' to be a list")
        pulumi.set(__self__, "action_data_references", action_data_references)
        if action_type and not isinstance(action_type, str):
            raise TypeError("Expected argument 'action_type' to be a str")
        pulumi.set(__self__, "action_type", action_type)
        if allow_invocation_from_event_orchestration and not isinstance(allow_invocation_from_event_orchestration, bool):
            raise TypeError("Expected argument 'allow_invocation_from_event_orchestration' to be a bool")
        pulumi.set(__self__, "allow_invocation_from_event_orchestration", allow_invocation_from_event_orchestration)
        if allow_invocation_manually and not isinstance(allow_invocation_manually, bool):
            raise TypeError("Expected argument 'allow_invocation_manually' to be a bool")
        pulumi.set(__self__, "allow_invocation_manually", allow_invocation_manually)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if map_to_all_services and not isinstance(map_to_all_services, bool):
            raise TypeError("Expected argument 'map_to_all_services' to be a bool")
        pulumi.set(__self__, "map_to_all_services", map_to_all_services)
        if modify_time and not isinstance(modify_time, str):
            raise TypeError("Expected argument 'modify_time' to be a str")
        pulumi.set(__self__, "modify_time", modify_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if only_invocable_on_unresolved_incidents and not isinstance(only_invocable_on_unresolved_incidents, bool):
            raise TypeError("Expected argument 'only_invocable_on_unresolved_incidents' to be a bool")
        pulumi.set(__self__, "only_invocable_on_unresolved_incidents", only_invocable_on_unresolved_incidents)
        if runner_id and not isinstance(runner_id, str):
            raise TypeError("Expected argument 'runner_id' to be a str")
        pulumi.set(__self__, "runner_id", runner_id)
        if runner_type and not isinstance(runner_type, str):
            raise TypeError("Expected argument 'runner_type' to be a str")
        pulumi.set(__self__, "runner_type", runner_type)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="actionClassification")
    def action_classification(self) -> _builtins.str:
        """
        (Optional) The category of the action. The only allowed values are `diagnostic` and `remediation`.
        """
        return pulumi.get(self, "action_classification")

    @_builtins.property
    @pulumi.getter(name="actionDataReferences")
    def action_data_references(self) -> Sequence['outputs.GetAutomationActionsActionActionDataReferenceResult']:
        """
        Action Data block. Action Data is documented below.
        """
        return pulumi.get(self, "action_data_references")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The type of the action. The only allowed values are `process_automation` and `script`.
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter(name="allowInvocationFromEventOrchestration")
    def allow_invocation_from_event_orchestration(self) -> _builtins.bool:
        """
        (Optional) Whether or not the action can be invoked automatically from a PagerDuty Event Orchestration.
        """
        return pulumi.get(self, "allow_invocation_from_event_orchestration")

    @_builtins.property
    @pulumi.getter(name="allowInvocationManually")
    def allow_invocation_manually(self) -> _builtins.bool:
        """
        (Optional) Whether or not the action can be invoked manually by a user on the PagerDuty website.
        """
        return pulumi.get(self, "allow_invocation_manually")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        The time action was created. Represented as an ISO 8601 timestamp.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Optional) The description of the action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the action.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mapToAllServices")
    def map_to_all_services(self) -> _builtins.bool:
        """
        (Optional) If the action should be able to be run against all services or just specified ones.
        """
        return pulumi.get(self, "map_to_all_services")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        (Optional) The last time action has been modified. Represented as an ISO 8601 timestamp.
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the action.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onlyInvocableOnUnresolvedIncidents")
    def only_invocable_on_unresolved_incidents(self) -> _builtins.bool:
        """
        (Optional) Whether or not the action can be invoked on unresolved incidents.
        """
        return pulumi.get(self, "only_invocable_on_unresolved_incidents")

    @_builtins.property
    @pulumi.getter(name="runnerId")
    def runner_id(self) -> _builtins.str:
        """
        (Optional) The Process Automation Actions runner to associate the action with.
        """
        return pulumi.get(self, "runner_id")

    @_builtins.property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> _builtins.str:
        """
        (Optional) The type of the runner associated with the action.
        """
        return pulumi.get(self, "runner_type")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of object. The value returned will be `action`.
        """
        return pulumi.get(self, "type")


class AwaitableGetAutomationActionsActionResult(GetAutomationActionsActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutomationActionsActionResult(
            action_classification=self.action_classification,
            action_data_references=self.action_data_references,
            action_type=self.action_type,
            allow_invocation_from_event_orchestration=self.allow_invocation_from_event_orchestration,
            allow_invocation_manually=self.allow_invocation_manually,
            creation_time=self.creation_time,
            description=self.description,
            id=self.id,
            map_to_all_services=self.map_to_all_services,
            modify_time=self.modify_time,
            name=self.name,
            only_invocable_on_unresolved_incidents=self.only_invocable_on_unresolved_incidents,
            runner_id=self.runner_id,
            runner_type=self.runner_type,
            type=self.type)


def get_automation_actions_action(action_classification: Optional[_builtins.str] = None,
                                  allow_invocation_from_event_orchestration: Optional[_builtins.bool] = None,
                                  allow_invocation_manually: Optional[_builtins.bool] = None,
                                  creation_time: Optional[_builtins.str] = None,
                                  description: Optional[_builtins.str] = None,
                                  id: Optional[_builtins.str] = None,
                                  map_to_all_services: Optional[_builtins.bool] = None,
                                  modify_time: Optional[_builtins.str] = None,
                                  only_invocable_on_unresolved_incidents: Optional[_builtins.bool] = None,
                                  runner_id: Optional[_builtins.str] = None,
                                  runner_type: Optional[_builtins.str] = None,
                                  type: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutomationActionsActionResult:
    """
    Use this data source to get information about a specific [automation actions action](https://developer.pagerduty.com/api-reference/357ed15419f64-get-an-automation-action).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_automation_actions_action(id="01CS1685B2UDM4I3XUUOXPPORM")
    ```


    :param _builtins.str action_classification: (Optional) The category of the action. The only allowed values are `diagnostic` and `remediation`.
    :param _builtins.bool allow_invocation_from_event_orchestration: (Optional) Whether or not the action can be invoked automatically from a PagerDuty Event Orchestration.
    :param _builtins.bool allow_invocation_manually: (Optional) Whether or not the action can be invoked manually by a user on the PagerDuty website.
    :param _builtins.str creation_time: The time action was created. Represented as an ISO 8601 timestamp.
    :param _builtins.str description: (Optional) The description of the action.
    :param _builtins.str id: The id of the automation actions action in the PagerDuty API.
    :param _builtins.bool map_to_all_services: (Optional) If the action should be able to be run against all services or just specified ones.
    :param _builtins.str modify_time: (Optional) The last time action has been modified. Represented as an ISO 8601 timestamp.
    :param _builtins.bool only_invocable_on_unresolved_incidents: (Optional) Whether or not the action can be invoked on unresolved incidents.
    :param _builtins.str runner_id: (Optional) The Process Automation Actions runner to associate the action with.
    :param _builtins.str runner_type: (Optional) The type of the runner associated with the action.
    :param _builtins.str type: The type of object. The value returned will be `action`.
    """
    __args__ = dict()
    __args__['actionClassification'] = action_classification
    __args__['allowInvocationFromEventOrchestration'] = allow_invocation_from_event_orchestration
    __args__['allowInvocationManually'] = allow_invocation_manually
    __args__['creationTime'] = creation_time
    __args__['description'] = description
    __args__['id'] = id
    __args__['mapToAllServices'] = map_to_all_services
    __args__['modifyTime'] = modify_time
    __args__['onlyInvocableOnUnresolvedIncidents'] = only_invocable_on_unresolved_incidents
    __args__['runnerId'] = runner_id
    __args__['runnerType'] = runner_type
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getAutomationActionsAction:getAutomationActionsAction', __args__, opts=opts, typ=GetAutomationActionsActionResult).value

    return AwaitableGetAutomationActionsActionResult(
        action_classification=pulumi.get(__ret__, 'action_classification'),
        action_data_references=pulumi.get(__ret__, 'action_data_references'),
        action_type=pulumi.get(__ret__, 'action_type'),
        allow_invocation_from_event_orchestration=pulumi.get(__ret__, 'allow_invocation_from_event_orchestration'),
        allow_invocation_manually=pulumi.get(__ret__, 'allow_invocation_manually'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        map_to_all_services=pulumi.get(__ret__, 'map_to_all_services'),
        modify_time=pulumi.get(__ret__, 'modify_time'),
        name=pulumi.get(__ret__, 'name'),
        only_invocable_on_unresolved_incidents=pulumi.get(__ret__, 'only_invocable_on_unresolved_incidents'),
        runner_id=pulumi.get(__ret__, 'runner_id'),
        runner_type=pulumi.get(__ret__, 'runner_type'),
        type=pulumi.get(__ret__, 'type'))
def get_automation_actions_action_output(action_classification: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         allow_invocation_from_event_orchestration: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         allow_invocation_manually: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         creation_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         id: Optional[pulumi.Input[_builtins.str]] = None,
                                         map_to_all_services: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         modify_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         only_invocable_on_unresolved_incidents: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         runner_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         runner_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutomationActionsActionResult]:
    """
    Use this data source to get information about a specific [automation actions action](https://developer.pagerduty.com/api-reference/357ed15419f64-get-an-automation-action).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_automation_actions_action(id="01CS1685B2UDM4I3XUUOXPPORM")
    ```


    :param _builtins.str action_classification: (Optional) The category of the action. The only allowed values are `diagnostic` and `remediation`.
    :param _builtins.bool allow_invocation_from_event_orchestration: (Optional) Whether or not the action can be invoked automatically from a PagerDuty Event Orchestration.
    :param _builtins.bool allow_invocation_manually: (Optional) Whether or not the action can be invoked manually by a user on the PagerDuty website.
    :param _builtins.str creation_time: The time action was created. Represented as an ISO 8601 timestamp.
    :param _builtins.str description: (Optional) The description of the action.
    :param _builtins.str id: The id of the automation actions action in the PagerDuty API.
    :param _builtins.bool map_to_all_services: (Optional) If the action should be able to be run against all services or just specified ones.
    :param _builtins.str modify_time: (Optional) The last time action has been modified. Represented as an ISO 8601 timestamp.
    :param _builtins.bool only_invocable_on_unresolved_incidents: (Optional) Whether or not the action can be invoked on unresolved incidents.
    :param _builtins.str runner_id: (Optional) The Process Automation Actions runner to associate the action with.
    :param _builtins.str runner_type: (Optional) The type of the runner associated with the action.
    :param _builtins.str type: The type of object. The value returned will be `action`.
    """
    __args__ = dict()
    __args__['actionClassification'] = action_classification
    __args__['allowInvocationFromEventOrchestration'] = allow_invocation_from_event_orchestration
    __args__['allowInvocationManually'] = allow_invocation_manually
    __args__['creationTime'] = creation_time
    __args__['description'] = description
    __args__['id'] = id
    __args__['mapToAllServices'] = map_to_all_services
    __args__['modifyTime'] = modify_time
    __args__['onlyInvocableOnUnresolvedIncidents'] = only_invocable_on_unresolved_incidents
    __args__['runnerId'] = runner_id
    __args__['runnerType'] = runner_type
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getAutomationActionsAction:getAutomationActionsAction', __args__, opts=opts, typ=GetAutomationActionsActionResult)
    return __ret__.apply(lambda __response__: GetAutomationActionsActionResult(
        action_classification=pulumi.get(__response__, 'action_classification'),
        action_data_references=pulumi.get(__response__, 'action_data_references'),
        action_type=pulumi.get(__response__, 'action_type'),
        allow_invocation_from_event_orchestration=pulumi.get(__response__, 'allow_invocation_from_event_orchestration'),
        allow_invocation_manually=pulumi.get(__response__, 'allow_invocation_manually'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        map_to_all_services=pulumi.get(__response__, 'map_to_all_services'),
        modify_time=pulumi.get(__response__, 'modify_time'),
        name=pulumi.get(__response__, 'name'),
        only_invocable_on_unresolved_incidents=pulumi.get(__response__, 'only_invocable_on_unresolved_incidents'),
        runner_id=pulumi.get(__response__, 'runner_id'),
        runner_type=pulumi.get(__response__, 'runner_type'),
        type=pulumi.get(__response__, 'type')))
