# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetJiraCloudAccountMappingResult',
    'AwaitableGetJiraCloudAccountMappingResult',
    'get_jira_cloud_account_mapping',
    'get_jira_cloud_account_mapping_output',
]

@pulumi.output_type
class GetJiraCloudAccountMappingResult:
    """
    A collection of values returned by getJiraCloudAccountMapping.
    """
    def __init__(__self__, base_url=None, id=None, subdomain=None):
        if base_url and not isinstance(base_url, str):
            raise TypeError("Expected argument 'base_url' to be a str")
        pulumi.set(__self__, "base_url", base_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subdomain and not isinstance(subdomain, str):
            raise TypeError("Expected argument 'subdomain' to be a str")
        pulumi.set(__self__, "subdomain", subdomain)

    @_builtins.property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> _builtins.str:
        """
        The base URL of the Jira Cloud instance, used for API calls and constructing links.
        """
        return pulumi.get(self, "base_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the found account mapping.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> _builtins.str:
        return pulumi.get(self, "subdomain")


class AwaitableGetJiraCloudAccountMappingResult(GetJiraCloudAccountMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJiraCloudAccountMappingResult(
            base_url=self.base_url,
            id=self.id,
            subdomain=self.subdomain)


def get_jira_cloud_account_mapping(subdomain: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJiraCloudAccountMappingResult:
    """
    Use this data source to get information about a specific [account mapping](https://developer.pagerduty.com/api-reference/8d707b61562b7-get-an-account-mapping).

    ## Example Usage


    :param _builtins.str subdomain: The service name to use to find a service in the PagerDuty API.
    """
    __args__ = dict()
    __args__['subdomain'] = subdomain
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getJiraCloudAccountMapping:getJiraCloudAccountMapping', __args__, opts=opts, typ=GetJiraCloudAccountMappingResult).value

    return AwaitableGetJiraCloudAccountMappingResult(
        base_url=pulumi.get(__ret__, 'base_url'),
        id=pulumi.get(__ret__, 'id'),
        subdomain=pulumi.get(__ret__, 'subdomain'))
def get_jira_cloud_account_mapping_output(subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJiraCloudAccountMappingResult]:
    """
    Use this data source to get information about a specific [account mapping](https://developer.pagerduty.com/api-reference/8d707b61562b7-get-an-account-mapping).

    ## Example Usage


    :param _builtins.str subdomain: The service name to use to find a service in the PagerDuty API.
    """
    __args__ = dict()
    __args__['subdomain'] = subdomain
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getJiraCloudAccountMapping:getJiraCloudAccountMapping', __args__, opts=opts, typ=GetJiraCloudAccountMappingResult)
    return __ret__.apply(lambda __response__: GetJiraCloudAccountMappingResult(
        base_url=pulumi.get(__response__, 'base_url'),
        id=pulumi.get(__response__, 'id'),
        subdomain=pulumi.get(__response__, 'subdomain')))
