var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/automation/function-code-updater.handler.ts
var function_code_updater_handler_exports = {};
__export(function_code_updater_handler_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(function_code_updater_handler_exports);
var import_client_lambda = require("@aws-sdk/client-lambda");
var client = new import_client_lambda.LambdaClient({});
async function handler(event) {
  const [eventRecord] = event.Records;
  const s3Data = eventRecord.s3;
  const bucketName = s3Data.bucket.name;
  const objectKey = s3Data.object.key;
  const version = s3Data.object.versionId;
  console.log(
    `Event received: s3://${bucketName}/${objectKey}?versionId=${version}`
  );
  if (bucketName !== process.env.BUCKET_NAME) {
    console.warn("Notification came from the wrong bucket, skipping");
    return;
  }
  if (objectKey !== process.env.OBJECT_KEY) {
    console.warn("Notification is for the wrong object key, skipping");
    return;
  }
  const response = await client.send(
    new import_client_lambda.UpdateFunctionCodeCommand({
      FunctionName: process.env.FUNCTION_NAME,
      S3Bucket: bucketName,
      S3Key: objectKey,
      S3ObjectVersion: version
    })
  );
  console.log("Function code updated", response.Version);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
