import { Grant, IGrantable } from "aws-cdk-lib/aws-iam";
import { IFunction } from "aws-cdk-lib/aws-lambda";
import { IBucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
/**
 * Constructor properties for FunctionCodeUpdater.
 */
export interface FunctionCodeUpdaterProps {
    /**
     * The bucket to monitor for changes.
     */
    readonly bucket: IBucket;
    /**
     * The object within the bucket to monitor (e.g. my-application/code.zip)
     */
    readonly objectKey: string;
    /**
     * The Lambda function to update.
     */
    readonly target: IFunction;
}
/**
 * Automates deployments of Lambda function code.
 *
 * In order to guarantee the least amount of privilege to the principal sending
 * new code revisions to S3 (e.g. a GitHub Action, a CodeBuild project), you can
 * use this construct to call the `UpdateFunctionCode` action of the Lambda API
 * any time a new revision is added to a bucket (which must support versioning).
 */
export declare class FunctionCodeUpdater extends Construct {
    #private;
    /**
     * Creates a new FunctionCodeUpdater.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope: Construct, id: string, props: FunctionCodeUpdaterProps);
    /**
     * Grants `s3:PutObject*` and `s3:AbortObject*` permissions for the S3 object
     * key of the Lambda function code.
     *
     * If encryption is used, permission to use the key to encrypt uploaded files
     * will also be granted to the same principal.
     *
     * @param identity - The principal
     */
    grantPutCode(identity: IGrantable): Grant;
}
