"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = handler;
// eslint-disable-next-line import/no-extraneous-dependencies
const client_lambda_1 = require("@aws-sdk/client-lambda");
const client = new client_lambda_1.LambdaClient({});
async function handler(event) {
    const [eventRecord] = event.Records;
    const s3Data = eventRecord.s3;
    const bucketName = s3Data.bucket.name;
    const objectKey = s3Data.object.key;
    const version = s3Data.object.versionId;
    console.log(`Event received: s3://${bucketName}/${objectKey}?versionId=${version}`);
    if (bucketName !== process.env.BUCKET_NAME) {
        console.warn("Notification came from the wrong bucket, skipping");
        return;
    }
    if (objectKey !== process.env.OBJECT_KEY) {
        console.warn("Notification is for the wrong object key, skipping");
        return;
    }
    const response = await client.send(new client_lambda_1.UpdateFunctionCodeCommand({
        FunctionName: process.env.FUNCTION_NAME,
        S3Bucket: bucketName,
        S3Key: objectKey,
        S3ObjectVersion: version,
    }));
    console.log("Function code updated", response.Version);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVuY3Rpb24tY29kZS11cGRhdGVyLmhhbmRsZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXV0b21hdGlvbi9mdW5jdGlvbi1jb2RlLXVwZGF0ZXIuaGFuZGxlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVNBLDBCQThCQztBQXZDRCw2REFBNkQ7QUFDN0QsMERBR2dDO0FBR2hDLE1BQU0sTUFBTSxHQUFHLElBQUksNEJBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUU3QixLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQWM7SUFDMUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7SUFDcEMsTUFBTSxNQUFNLEdBQUcsV0FBVyxDQUFDLEVBQUUsQ0FBQztJQUM5QixNQUFNLFVBQVUsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQztJQUN0QyxNQUFNLFNBQVMsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQztJQUNwQyxNQUFNLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQztJQUV4QyxPQUFPLENBQUMsR0FBRyxDQUNULHdCQUF3QixVQUFVLElBQUksU0FBUyxjQUFjLE9BQU8sRUFBRSxDQUN2RSxDQUFDO0lBRUYsSUFBSSxVQUFVLEtBQUssT0FBTyxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLG1EQUFtRCxDQUFDLENBQUM7UUFDbEUsT0FBTztJQUNULENBQUM7SUFDRCxJQUFJLFNBQVMsS0FBSyxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBQ3pDLE9BQU8sQ0FBQyxJQUFJLENBQUMsb0RBQW9ELENBQUMsQ0FBQztRQUNuRSxPQUFPO0lBQ1QsQ0FBQztJQUVELE1BQU0sUUFBUSxHQUFHLE1BQU0sTUFBTSxDQUFDLElBQUksQ0FDaEMsSUFBSSx5Q0FBeUIsQ0FBQztRQUM1QixZQUFZLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxhQUFhO1FBQ3ZDLFFBQVEsRUFBRSxVQUFVO1FBQ3BCLEtBQUssRUFBRSxTQUFTO1FBQ2hCLGVBQWUsRUFBRSxPQUFPO0tBQ3pCLENBQUMsQ0FDSCxDQUFDO0lBRUYsT0FBTyxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsRUFBRSxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDekQsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXNcbmltcG9ydCB7XG4gIExhbWJkYUNsaWVudCxcbiAgVXBkYXRlRnVuY3Rpb25Db2RlQ29tbWFuZCxcbn0gZnJvbSBcIkBhd3Mtc2RrL2NsaWVudC1sYW1iZGFcIjtcbmltcG9ydCB0eXBlIHsgUzNFdmVudCB9IGZyb20gXCJhd3MtbGFtYmRhXCI7XG5cbmNvbnN0IGNsaWVudCA9IG5ldyBMYW1iZGFDbGllbnQoe30pO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaGFuZGxlcihldmVudDogUzNFdmVudCkge1xuICBjb25zdCBbZXZlbnRSZWNvcmRdID0gZXZlbnQuUmVjb3JkcztcbiAgY29uc3QgczNEYXRhID0gZXZlbnRSZWNvcmQuczM7XG4gIGNvbnN0IGJ1Y2tldE5hbWUgPSBzM0RhdGEuYnVja2V0Lm5hbWU7XG4gIGNvbnN0IG9iamVjdEtleSA9IHMzRGF0YS5vYmplY3Qua2V5O1xuICBjb25zdCB2ZXJzaW9uID0gczNEYXRhLm9iamVjdC52ZXJzaW9uSWQ7XG5cbiAgY29uc29sZS5sb2coXG4gICAgYEV2ZW50IHJlY2VpdmVkOiBzMzovLyR7YnVja2V0TmFtZX0vJHtvYmplY3RLZXl9P3ZlcnNpb25JZD0ke3ZlcnNpb259YFxuICApO1xuXG4gIGlmIChidWNrZXROYW1lICE9PSBwcm9jZXNzLmVudi5CVUNLRVRfTkFNRSkge1xuICAgIGNvbnNvbGUud2FybihcIk5vdGlmaWNhdGlvbiBjYW1lIGZyb20gdGhlIHdyb25nIGJ1Y2tldCwgc2tpcHBpbmdcIik7XG4gICAgcmV0dXJuO1xuICB9XG4gIGlmIChvYmplY3RLZXkgIT09IHByb2Nlc3MuZW52Lk9CSkVDVF9LRVkpIHtcbiAgICBjb25zb2xlLndhcm4oXCJOb3RpZmljYXRpb24gaXMgZm9yIHRoZSB3cm9uZyBvYmplY3Qga2V5LCBza2lwcGluZ1wiKTtcbiAgICByZXR1cm47XG4gIH1cblxuICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNsaWVudC5zZW5kKFxuICAgIG5ldyBVcGRhdGVGdW5jdGlvbkNvZGVDb21tYW5kKHtcbiAgICAgIEZ1bmN0aW9uTmFtZTogcHJvY2Vzcy5lbnYuRlVOQ1RJT05fTkFNRSxcbiAgICAgIFMzQnVja2V0OiBidWNrZXROYW1lLFxuICAgICAgUzNLZXk6IG9iamVjdEtleSxcbiAgICAgIFMzT2JqZWN0VmVyc2lvbjogdmVyc2lvbixcbiAgICB9KVxuICApO1xuXG4gIGNvbnNvbGUubG9nKFwiRnVuY3Rpb24gY29kZSB1cGRhdGVkXCIsIHJlc3BvbnNlLlZlcnNpb24pO1xufVxuIl19