import type { IVpc } from "aws-cdk-lib/aws-ec2";
import { AwsLogDriver, Cluster, FargateTaskDefinition, ICluster } from "aws-cdk-lib/aws-ecs";
import { FargateServiceBaseProps, ApplicationLoadBalancedTaskImageOptions } from "aws-cdk-lib/aws-ecs-patterns";
import { Construct, IConstruct } from "constructs";
import { IFargateTask, BaseFargateTaskProps } from "../ecs";
/**
 * The properties for the FargateTask using an image.
 */
export interface FargateTaskImageOptions extends ApplicationLoadBalancedTaskImageOptions {
}
/**
 * Interface for RunnableFargateTask.
 */
export interface IRunnableFargateTask extends IConstruct {
    /**
     * The FargateTask in this construct.
     */
    readonly task: IFargateTask;
    /**
     * The FargateTaskDefinition in this construct.
     */
    readonly taskDefinition: FargateTaskDefinition;
}
/**
 * Constructor properties for RunnableFargateTask.
 */
export interface RunnableFargateTaskProps extends BaseFargateTaskProps, FargateServiceBaseProps {
    /**
     * The cluster that hosts the service.
     *
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     *
     * @default - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    readonly cluster?: ICluster;
    /**
     * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     *
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     *
     * @default - uses the VPC defined in the cluster or creates a new VPC.
     */
    readonly vpc?: IVpc;
    /**
     * The properties to define if the construct is to create a TaskDefinition.
     * taskDefinition or image must be defined, but not both.
     *
     * @default - none
     */
    readonly taskImageOptions?: FargateTaskImageOptions;
}
/**
 * An RunnableFargateTask construct.
 */
export declare class RunnableFargateTask extends Construct implements IRunnableFargateTask {
    readonly task: IFargateTask;
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * Creates a new RunnableFargateTask.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope: Construct, id: string, props: RunnableFargateTaskProps);
    /**
     * Creates a new AwsLogDriver.
     *
     * Modeled after "aws-cdk-lib/aws-ecs".
     */
    protected createAWSLogDriver(prefix: string): AwsLogDriver;
    /**
     * Returns the default cluster.
     *
     * Modeled after "aws-cdk-lib/aws-ecs-patterns".
     */
    protected getDefaultCluster(scope: Construct, vpc?: IVpc): Cluster;
}
