/**
 * An IPv4 or IPv6 address (or range of addresses).
 */
export declare class Address {
    #private;
    /**
     * Creates an address that represents the entire IPv4 addressing space.
     *
     * @returns The IPv4 network address
     */
    static anyIpv4(): Address;
    /**
     * Creates an address that represents the entire IPv4 addressing space.
     *
     * @returns The IPv4 network address
     */
    static anyIpv6(): Address;
    /**
     * Creates an IPv4 network address (either a single address or a range).
     *
     * @param address - The IP address (with optional netmask).
     * @returns The IPv4 network address
     */
    static ipv4(address: string): Address;
    /**
     * Creates an IPv6 network address (either a single address or a range).
     *
     * @param address - The IP address (with optional prefix length).
     * @returns The IPv6 network address
     */
    static ipv6(address: string): Address;
    /**
     * @ignore
     */
    private constructor();
    /**
     * Whether this address is an IPv4 address.
     *
     * @returns True if this is an IPv4 address
     */
    isIpv4(): boolean;
    /**
     * Whether this address is an IPv6 address.
     *
     * @returns True if this is an IPv6 address
     */
    isIpv6(): boolean;
    /**
     * Whether this address represents everything in the addressing space.
     *
     * @returns True if this address represents all addresses
     */
    isAny(): boolean;
    toString(): string;
}
