"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Address_address, _Address_version, _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Address = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const node_net_1 = require("node:net");
const aws_cdk_lib_1 = require("aws-cdk-lib");
function validateNetMask(mask) {
    if (!mask) {
        return;
    }
    const netmask = parseInt(mask);
    if (isNaN(netmask) || netmask < 1 || netmask > 32) {
        throw new Error(`Invalid IPv4 netmask: "/${mask}"`);
    }
}
function validatePrefixLength(prefixLength) {
    if (!prefixLength) {
        return;
    }
    const netmask = parseInt(prefixLength);
    if (isNaN(netmask) || netmask < 1 || netmask > 128) {
        throw new Error(`Invalid IPv6 prefix length: "/${prefixLength}"`);
    }
}
const ANY_IPV4 = "0.0.0.0/0";
const ANY_IPV6 = "::/0";
/**
 * An IPv4 or IPv6 address (or range of addresses).
 */
class Address {
    /**
     * Creates an address that represents the entire IPv4 addressing space.
     *
     * @returns The IPv4 network address
     */
    static anyIpv4() {
        return new Address(ANY_IPV4, 4);
    }
    /**
     * Creates an address that represents the entire IPv4 addressing space.
     *
     * @returns The IPv4 network address
     */
    static anyIpv6() {
        return new Address(ANY_IPV6, 6);
    }
    /**
     * Creates an IPv4 network address (either a single address or a range).
     *
     * @param address - The IP address (with optional netmask).
     * @returns The IPv4 network address
     */
    static ipv4(address) {
        if (!aws_cdk_lib_1.Token.isUnresolved(address)) {
            const [adr, netMask] = address.split("/", 2);
            if (!(0, node_net_1.isIPv4)(adr)) {
                throw new Error(`Invalid IPv4 address: "${adr}"`);
            }
            validateNetMask(netMask);
        }
        return new Address(address, 4);
    }
    /**
     * Creates an IPv6 network address (either a single address or a range).
     *
     * @param address - The IP address (with optional prefix length).
     * @returns The IPv6 network address
     */
    static ipv6(address) {
        if (!aws_cdk_lib_1.Token.isUnresolved(address)) {
            const [adr, prefixLength] = address.split("/", 2);
            if (!(0, node_net_1.isIPv6)(adr)) {
                throw new Error(`Invalid IPv6 address: "${adr}"`);
            }
            validatePrefixLength(prefixLength);
        }
        return new Address(address, 6);
    }
    /**
     * @ignore
     */
    constructor(address, version) {
        _Address_address.set(this, void 0);
        _Address_version.set(this, void 0);
        __classPrivateFieldSet(this, _Address_address, address, "f");
        __classPrivateFieldSet(this, _Address_version, version, "f");
    }
    /**
     * Whether this address is an IPv4 address.
     *
     * @returns True if this is an IPv4 address
     */
    isIpv4() {
        return __classPrivateFieldGet(this, _Address_version, "f") === 4;
    }
    /**
     * Whether this address is an IPv6 address.
     *
     * @returns True if this is an IPv6 address
     */
    isIpv6() {
        return __classPrivateFieldGet(this, _Address_version, "f") === 6;
    }
    /**
     * Whether this address represents everything in the addressing space.
     *
     * @returns True if this address represents all addresses
     */
    isAny() {
        if (__classPrivateFieldGet(this, _Address_version, "f") === 6) {
            return __classPrivateFieldGet(this, _Address_address, "f") === ANY_IPV6;
        }
        return __classPrivateFieldGet(this, _Address_address, "f") === ANY_IPV4;
    }
    toString() {
        return __classPrivateFieldGet(this, _Address_address, "f");
    }
}
exports.Address = Address;
_Address_address = new WeakMap(), _Address_version = new WeakMap(), _a = JSII_RTTI_SYMBOL_1;
Address[_a] = { fqn: "shady-island.networking.Address", version: "0.1.68" };
//# sourceMappingURL=data:application/json;base64,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