import { IResource, RemovalPolicy, Resource } from "aws-cdk-lib";
import { Grant, IGrantable } from "aws-cdk-lib/aws-iam";
import { Construct } from "constructs";
/**
 * An EC2 Elastic IP address.
 */
export interface IElasticIp extends IResource {
    /**
     * The allocation ID of the Elastic IP address.
     */
    readonly allocationId: string;
    /**
     * The ARN of the Elastic IP address.
     */
    readonly elasticIpArn: string;
    /**
     * Grant the given identity custom permissions.
     *
     * e.g. `ec2:AssociateAddress`, `ec2:DisableAddressTransfer`,
     * `ec2:DisassociateAddress`, `ec2:EnableAddressTransfer`, among others.
     *
     * @param identity - The resource with a grantPrincipal property
     * @param actions - The IAM actions to allow
     * @returns The new Grant
     */
    grant(identity: IGrantable, ...actions: string[]): Grant;
}
/**
 * Constructor properties for ElasticIp.
 */
export interface ElasticIpProps {
    /**
     * The removal policy for this resource.
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * The abstract base
 */
declare abstract class ElasticIpBase extends Resource implements IElasticIp {
    abstract readonly allocationId: string;
    abstract readonly elasticIpArn: string;
    grant(identity: IGrantable, ...actions: string[]): Grant;
}
/**
 * An EC2 Elastic IP address.
 */
export declare class ElasticIp extends ElasticIpBase implements IElasticIp {
    /**
     * Import an existing EIP from its ARN.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param arn - The EIP ARN
     * @returns The imported Elastic IP
     */
    static fromElasticIpArn(scope: Construct, id: string, arn: string): IElasticIp;
    /**
     * Import an existing EIP from the given allocation ID.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param allocationId - The EIP allocation ID.
     * @returns The imported Elastic IP
     */
    static fromAllocationId(scope: Construct, id: string, allocationId: string): IElasticIp;
    readonly allocationId: string;
    readonly elasticIpArn: string;
    /**
     * The IPv4 address.
     */
    readonly publicIp: string;
    /**
     * Creates a new Elastic IP address.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope: Construct, id: string, props?: ElasticIpProps);
}
export {};
