"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretHttpHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_elasticloadbalancingv2_1 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
/**
 * The default header name.
 */
const DEFAULT_HEADER_NAME = "X-Secret-Passphrase";
/**
 * Common behavior for secret HTTP header constructs.
 */
class BaseSecretHttpHeader extends constructs_1.Construct {
    createListenerCondition() {
        return aws_elasticloadbalancingv2_1.ListenerCondition.httpHeader(this.headerName, [
            this.headerValue.unsafeUnwrap(),
        ]);
    }
    createOriginCustomHeaders() {
        return { [this.headerName]: this.headerValue.unsafeUnwrap() };
    }
}
/**
 * Configure a secret header an ALB can require for every request.
 */
class SecretHttpHeader extends BaseSecretHttpHeader {
    /**
     * Gets the default header name.
     *
     * @returns the default header name
     */
    static get defaultHeaderName() {
        return DEFAULT_HEADER_NAME;
    }
    /**
     * Create a SecretHttpHeader from an existing Secrets Manager secret.
     *
     * The secret must be in JSON format and have two fields: `name` and `value`.
     *
     * @param scope - The parent scope
     * @param id - The ID for the new construct
     * @param secret - The existing Secrets Manager secret
     * @returns The new ISecretHttpHeader
     */
    static fromSecret(scope, id, secret) {
        class Import extends BaseSecretHttpHeader {
            constructor() {
                super(...arguments);
                this.headerName = secret
                    .secretValueFromJson("name")
                    .unsafeUnwrap();
                this.headerValue = secret.secretValueFromJson("value");
            }
        }
        return new Import(scope, id);
    }
    /**
     * Creates a new SecretHttpHeader.
     *
     * @param scope - The parent scope.
     * @param id - The construct identifier.
     * @param props - The configuration properties.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { headerName = DEFAULT_HEADER_NAME } = props;
        this._name = headerName;
        this.secret = new aws_secretsmanager_1.Secret(this, "Secret", {
            description: "Custom header used to restrict load balancer access",
            generateSecretString: {
                excludePunctuation: false,
                includeSpace: false,
                generateStringKey: "value",
                excludeCharacters: `\`'"$\\`,
                secretStringTemplate: `{"name":"${headerName}"}`,
            },
        });
        this._value = this.secret.secretValueFromJson("value");
    }
    get headerName() {
        return this._name;
    }
    get headerValue() {
        return this._value;
    }
}
exports.SecretHttpHeader = SecretHttpHeader;
_a = JSII_RTTI_SYMBOL_1;
SecretHttpHeader[_a] = { fqn: "shady-island.networking.SecretHttpHeader", version: "0.1.68" };
//# sourceMappingURL=data:application/json;base64,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