# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class AccessInfoModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'big_query': 'AccessInfoBigQueryModel',
        'parquet': 'AccessInfoParquetModel'
    }

    attribute_map = {
        'big_query': 'bigQuery',
        'parquet': 'parquet'
    }

    def __init__(self, big_query=None, parquet=None, local_vars_configuration=None):  # noqa: E501
        """AccessInfoModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._big_query = None
        self._parquet = None
        self.discriminator = None

        if big_query is not None:
            self.big_query = big_query
        if parquet is not None:
            self.parquet = parquet

    @property
    def big_query(self):
        """Gets the big_query of this AccessInfoModel.  # noqa: E501


        :return: The big_query of this AccessInfoModel.  # noqa: E501
        :rtype: AccessInfoBigQueryModel
        """
        return self._big_query

    @big_query.setter
    def big_query(self, big_query):
        """Sets the big_query of this AccessInfoModel.


        :param big_query: The big_query of this AccessInfoModel.  # noqa: E501
        :type: AccessInfoBigQueryModel
        """

        self._big_query = big_query

    @property
    def parquet(self):
        """Gets the parquet of this AccessInfoModel.  # noqa: E501


        :return: The parquet of this AccessInfoModel.  # noqa: E501
        :rtype: AccessInfoParquetModel
        """
        return self._parquet

    @parquet.setter
    def parquet(self, parquet):
        """Sets the parquet of this AccessInfoModel.


        :param parquet: The parquet of this AccessInfoModel.  # noqa: E501
        :type: AccessInfoParquetModel
        """

        self._parquet = parquet

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessInfoModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccessInfoModel):
            return True

        return self.to_dict() != other.to_dict()
