# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BillingProfileModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'billing_account_id': 'str',
        'profile_name': 'str',
        'biller': 'str',
        'description': 'str',
        'cloud_platform': 'CloudPlatform',
        'tenant_id': 'str',
        'subscription_id': 'str',
        'resource_group_name': 'str',
        'application_deployment_name': 'str',
        'created_date': 'str',
        'created_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'billing_account_id': 'billingAccountId',
        'profile_name': 'profileName',
        'biller': 'biller',
        'description': 'description',
        'cloud_platform': 'cloudPlatform',
        'tenant_id': 'tenantId',
        'subscription_id': 'subscriptionId',
        'resource_group_name': 'resourceGroupName',
        'application_deployment_name': 'applicationDeploymentName',
        'created_date': 'createdDate',
        'created_by': 'createdBy'
    }

    def __init__(self, id=None, billing_account_id=None, profile_name=None, biller=None, description=None, cloud_platform=None, tenant_id=None, subscription_id=None, resource_group_name=None, application_deployment_name=None, created_date=None, created_by=None, local_vars_configuration=None):  # noqa: E501
        """BillingProfileModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._billing_account_id = None
        self._profile_name = None
        self._biller = None
        self._description = None
        self._cloud_platform = None
        self._tenant_id = None
        self._subscription_id = None
        self._resource_group_name = None
        self._application_deployment_name = None
        self._created_date = None
        self._created_by = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if billing_account_id is not None:
            self.billing_account_id = billing_account_id
        if profile_name is not None:
            self.profile_name = profile_name
        if biller is not None:
            self.biller = biller
        if description is not None:
            self.description = description
        if cloud_platform is not None:
            self.cloud_platform = cloud_platform
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if subscription_id is not None:
            self.subscription_id = subscription_id
        if resource_group_name is not None:
            self.resource_group_name = resource_group_name
        if application_deployment_name is not None:
            self.application_deployment_name = application_deployment_name
        if created_date is not None:
            self.created_date = created_date
        if created_by is not None:
            self.created_by = created_by

    @property
    def id(self):
        """Gets the id of this BillingProfileModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BillingProfileModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def billing_account_id(self):
        """Gets the billing_account_id of this BillingProfileModel.  # noqa: E501

        unique identifier of the billing account from Google  # noqa: E501

        :return: The billing_account_id of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._billing_account_id

    @billing_account_id.setter
    def billing_account_id(self, billing_account_id):
        """Sets the billing_account_id of this BillingProfileModel.

        unique identifier of the billing account from Google  # noqa: E501

        :param billing_account_id: The billing_account_id of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._billing_account_id = billing_account_id

    @property
    def profile_name(self):
        """Gets the profile_name of this BillingProfileModel.  # noqa: E501

        display name to be used for the profile;  # noqa: E501

        :return: The profile_name of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_name

    @profile_name.setter
    def profile_name(self, profile_name):
        """Sets the profile_name of this BillingProfileModel.

        display name to be used for the profile;  # noqa: E501

        :param profile_name: The profile_name of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._profile_name = profile_name

    @property
    def biller(self):
        """Gets the biller of this BillingProfileModel.  # noqa: E501

        either “direct” or the reseller of the sub-account that sends the bill (like “on_spend”)  # noqa: E501

        :return: The biller of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._biller

    @biller.setter
    def biller(self, biller):
        """Sets the biller of this BillingProfileModel.

        either “direct” or the reseller of the sub-account that sends the bill (like “on_spend”)  # noqa: E501

        :param biller: The biller of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._biller = biller

    @property
    def description(self):
        """Gets the description of this BillingProfileModel.  # noqa: E501

        Free text that describes the profile  # noqa: E501

        :return: The description of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BillingProfileModel.

        Free text that describes the profile  # noqa: E501

        :param description: The description of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def cloud_platform(self):
        """Gets the cloud_platform of this BillingProfileModel.  # noqa: E501


        :return: The cloud_platform of this BillingProfileModel.  # noqa: E501
        :rtype: CloudPlatform
        """
        return self._cloud_platform

    @cloud_platform.setter
    def cloud_platform(self, cloud_platform):
        """Sets the cloud_platform of this BillingProfileModel.


        :param cloud_platform: The cloud_platform of this BillingProfileModel.  # noqa: E501
        :type: CloudPlatform
        """

        self._cloud_platform = cloud_platform

    @property
    def tenant_id(self):
        """Gets the tenant_id of this BillingProfileModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The tenant_id of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this BillingProfileModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param tenant_id: The tenant_id of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def subscription_id(self):
        """Gets the subscription_id of this BillingProfileModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The subscription_id of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this BillingProfileModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param subscription_id: The subscription_id of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._subscription_id = subscription_id

    @property
    def resource_group_name(self):
        """Gets the resource_group_name of this BillingProfileModel.  # noqa: E501

        an optional resource group name for Azure  # noqa: E501

        :return: The resource_group_name of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._resource_group_name

    @resource_group_name.setter
    def resource_group_name(self, resource_group_name):
        """Sets the resource_group_name of this BillingProfileModel.

        an optional resource group name for Azure  # noqa: E501

        :param resource_group_name: The resource_group_name of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._resource_group_name = resource_group_name

    @property
    def application_deployment_name(self):
        """Gets the application_deployment_name of this BillingProfileModel.  # noqa: E501

        an optional name for an application deployment for Azure  # noqa: E501

        :return: The application_deployment_name of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._application_deployment_name

    @application_deployment_name.setter
    def application_deployment_name(self, application_deployment_name):
        """Sets the application_deployment_name of this BillingProfileModel.

        an optional name for an application deployment for Azure  # noqa: E501

        :param application_deployment_name: The application_deployment_name of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._application_deployment_name = application_deployment_name

    @property
    def created_date(self):
        """Gets the created_date of this BillingProfileModel.  # noqa: E501

        Date the profile was created  # noqa: E501

        :return: The created_date of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this BillingProfileModel.

        Date the profile was created  # noqa: E501

        :param created_date: The created_date of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    @property
    def created_by(self):
        """Gets the created_by of this BillingProfileModel.  # noqa: E501

        Identity of the user who originally created the profile  # noqa: E501

        :return: The created_by of this BillingProfileModel.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this BillingProfileModel.

        Identity of the user who originally created the profile  # noqa: E501

        :param created_by: The created_by of this BillingProfileModel.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BillingProfileModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BillingProfileModel):
            return True

        return self.to_dict() != other.to_dict()
