# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class TransactionModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'status': 'str',
        'lock': 'str',
        'description': 'str',
        'created_at': 'str',
        'created_by': 'str',
        'terminated_at': 'str',
        'terminated_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'status': 'status',
        'lock': 'lock',
        'description': 'description',
        'created_at': 'created_at',
        'created_by': 'created_by',
        'terminated_at': 'terminated_at',
        'terminated_by': 'terminated_by'
    }

    def __init__(self, id=None, status=None, lock=None, description=None, created_at=None, created_by=None, terminated_at=None, terminated_by=None, local_vars_configuration=None):  # noqa: E501
        """TransactionModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._status = None
        self._lock = None
        self._description = None
        self._created_at = None
        self._created_by = None
        self._terminated_at = None
        self._terminated_by = None
        self.discriminator = None

        self.id = id
        if status is not None:
            self.status = status
        if lock is not None:
            self.lock = lock
        if description is not None:
            self.description = description
        self.created_at = created_at
        self.created_by = created_by
        if terminated_at is not None:
            self.terminated_at = terminated_at
        if terminated_by is not None:
            self.terminated_by = terminated_by

    @property
    def id(self):
        """Gets the id of this TransactionModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TransactionModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this TransactionModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def status(self):
        """Gets the status of this TransactionModel.  # noqa: E501


        :return: The status of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this TransactionModel.


        :param status: The status of this TransactionModel.  # noqa: E501
        :type: str
        """
        allowed_values = ["active", "committed", "rolled_back"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def lock(self):
        """Gets the lock of this TransactionModel.  # noqa: E501

        the id of the flight that is locking the transaction or empty if the transaction is not locked  # noqa: E501

        :return: The lock of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._lock

    @lock.setter
    def lock(self, lock):
        """Sets the lock of this TransactionModel.

        the id of the flight that is locking the transaction or empty if the transaction is not locked  # noqa: E501

        :param lock: The lock of this TransactionModel.  # noqa: E501
        :type: str
        """

        self._lock = lock

    @property
    def description(self):
        """Gets the description of this TransactionModel.  # noqa: E501

        the transaction's description, if one was specified  # noqa: E501

        :return: The description of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TransactionModel.

        the transaction's description, if one was specified  # noqa: E501

        :param description: The description of this TransactionModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def created_at(self):
        """Gets the created_at of this TransactionModel.  # noqa: E501

        timestamp of transaction creation in RFC3339  # noqa: E501

        :return: The created_at of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TransactionModel.

        timestamp of transaction creation in RFC3339  # noqa: E501

        :param created_at: The created_at of this TransactionModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def created_by(self):
        """Gets the created_by of this TransactionModel.  # noqa: E501

        the creator of the transaction  # noqa: E501

        :return: The created_by of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this TransactionModel.

        the creator of the transaction  # noqa: E501

        :param created_by: The created_by of this TransactionModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and created_by is None:  # noqa: E501
            raise ValueError("Invalid value for `created_by`, must not be `None`")  # noqa: E501

        self._created_by = created_by

    @property
    def terminated_at(self):
        """Gets the terminated_at of this TransactionModel.  # noqa: E501

        timestamp of transaction creation in RFC3339  # noqa: E501

        :return: The terminated_at of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._terminated_at

    @terminated_at.setter
    def terminated_at(self, terminated_at):
        """Sets the terminated_at of this TransactionModel.

        timestamp of transaction creation in RFC3339  # noqa: E501

        :param terminated_at: The terminated_at of this TransactionModel.  # noqa: E501
        :type: str
        """

        self._terminated_at = terminated_at

    @property
    def terminated_by(self):
        """Gets the terminated_by of this TransactionModel.  # noqa: E501

        the creator of the transaction  # noqa: E501

        :return: The terminated_by of this TransactionModel.  # noqa: E501
        :rtype: str
        """
        return self._terminated_by

    @terminated_by.setter
    def terminated_by(self, terminated_by):
        """Sets the terminated_by of this TransactionModel.

        the creator of the transaction  # noqa: E501

        :param terminated_by: The terminated_by of this TransactionModel.  # noqa: E501
        :type: str
        """

        self._terminated_by = terminated_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransactionModel):
            return True

        return self.to_dict() != other.to_dict()
