# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class UserStatusInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'user_subject_id': 'str',
        'user_email': 'str',
        'enabled': 'bool'
    }

    attribute_map = {
        'user_subject_id': 'userSubjectId',
        'user_email': 'userEmail',
        'enabled': 'enabled'
    }

    def __init__(self, user_subject_id=None, user_email=None, enabled=None, local_vars_configuration=None):  # noqa: E501
        """UserStatusInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user_subject_id = None
        self._user_email = None
        self._enabled = None
        self.discriminator = None

        self.user_subject_id = user_subject_id
        self.user_email = user_email
        self.enabled = enabled

    @property
    def user_subject_id(self):
        """Gets the user_subject_id of this UserStatusInfo.  # noqa: E501

        user id  # noqa: E501

        :return: The user_subject_id of this UserStatusInfo.  # noqa: E501
        :rtype: str
        """
        return self._user_subject_id

    @user_subject_id.setter
    def user_subject_id(self, user_subject_id):
        """Sets the user_subject_id of this UserStatusInfo.

        user id  # noqa: E501

        :param user_subject_id: The user_subject_id of this UserStatusInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_subject_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_subject_id`, must not be `None`")  # noqa: E501

        self._user_subject_id = user_subject_id

    @property
    def user_email(self):
        """Gets the user_email of this UserStatusInfo.  # noqa: E501

        user email  # noqa: E501

        :return: The user_email of this UserStatusInfo.  # noqa: E501
        :rtype: str
        """
        return self._user_email

    @user_email.setter
    def user_email(self, user_email):
        """Sets the user_email of this UserStatusInfo.

        user email  # noqa: E501

        :param user_email: The user_email of this UserStatusInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_email is None:  # noqa: E501
            raise ValueError("Invalid value for `user_email`, must not be `None`")  # noqa: E501

        self._user_email = user_email

    @property
    def enabled(self):
        """Gets the enabled of this UserStatusInfo.  # noqa: E501

        true if the user is enabled in ldap  # noqa: E501

        :return: The enabled of this UserStatusInfo.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this UserStatusInfo.

        true if the user is enabled in ldap  # noqa: E501

        :param enabled: The enabled of this UserStatusInfo.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and enabled is None:  # noqa: E501
            raise ValueError("Invalid value for `enabled`, must not be `None`")  # noqa: E501

        self._enabled = enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserStatusInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserStatusInfo):
            return True

        return self.to_dict() != other.to_dict()
