# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from authentik_client.models.flow_stage_binding import FlowStageBinding
from typing import Optional, Set
from typing_extensions import Self

class FlowInspectorPlan(BaseModel):
    """
    Serializer for an active FlowPlan
    """ # noqa: E501
    current_stage: FlowStageBinding
    next_planned_stage: FlowStageBinding
    plan_context: Dict[str, Any] = Field(description="Get the plan's context, sanitized")
    session_id: StrictStr = Field(description="Get a unique session ID")
    __properties: ClassVar[List[str]] = ["current_stage", "next_planned_stage", "plan_context", "session_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowInspectorPlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "current_stage",
            "next_planned_stage",
            "plan_context",
            "session_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of current_stage
        if self.current_stage:
            _dict['current_stage'] = self.current_stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of next_planned_stage
        if self.next_planned_stage:
            _dict['next_planned_stage'] = self.next_planned_stage.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowInspectorPlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "current_stage": FlowStageBinding.from_dict(obj["current_stage"]) if obj.get("current_stage") is not None else None,
            "next_planned_stage": FlowStageBinding.from_dict(obj["next_planned_stage"]) if obj.get("next_planned_stage") is not None else None,
            "plan_context": obj.get("plan_context"),
            "session_id": obj.get("session_id")
        })
        return _obj


