# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from authentik_client.models.initial_permissions_mode_enum import InitialPermissionsModeEnum
from authentik_client.models.permission import Permission
from typing import Optional, Set
from typing_extensions import Self

class InitialPermissions(BaseModel):
    """
    InitialPermissions serializer
    """ # noqa: E501
    pk: StrictInt
    name: Annotated[str, Field(strict=True, max_length=150)]
    mode: InitialPermissionsModeEnum
    role: UUID
    permissions: Optional[List[StrictInt]] = None
    permissions_obj: List[Permission]
    __properties: ClassVar[List[str]] = ["pk", "name", "mode", "role", "permissions", "permissions_obj"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InitialPermissions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "permissions_obj",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions_obj (list)
        _items = []
        if self.permissions_obj:
            for _item_permissions_obj in self.permissions_obj:
                if _item_permissions_obj:
                    _items.append(_item_permissions_obj.to_dict())
            _dict['permissions_obj'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InitialPermissions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "name": obj.get("name"),
            "mode": obj.get("mode"),
            "role": obj.get("role"),
            "permissions": obj.get("permissions"),
            "permissions_obj": [Permission.from_dict(_item) for _item in obj["permissions_obj"]] if obj.get("permissions_obj") is not None else None
        })
        return _obj


