# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from authentik_client.models.delivery_method_enum import DeliveryMethodEnum
from authentik_client.models.events_requested_enum import EventsRequestedEnum
from authentik_client.models.ssf_provider import SSFProvider
from typing import Optional, Set
from typing_extensions import Self

class SSFStream(BaseModel):
    """
    SSFStream Serializer
    """ # noqa: E501
    pk: UUID
    provider: StrictInt
    provider_obj: SSFProvider
    delivery_method: DeliveryMethodEnum
    endpoint_url: Optional[StrictStr] = None
    events_requested: Optional[List[EventsRequestedEnum]] = None
    format: StrictStr
    aud: Optional[List[StrictStr]] = None
    iss: StrictStr
    __properties: ClassVar[List[str]] = ["pk", "provider", "provider_obj", "delivery_method", "endpoint_url", "events_requested", "format", "aud", "iss"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SSFStream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "provider_obj",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider_obj
        if self.provider_obj:
            _dict['provider_obj'] = self.provider_obj.to_dict()
        # set to None if endpoint_url (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_url is None and "endpoint_url" in self.model_fields_set:
            _dict['endpoint_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SSFStream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "provider": obj.get("provider"),
            "provider_obj": SSFProvider.from_dict(obj["provider_obj"]) if obj.get("provider_obj") is not None else None,
            "delivery_method": obj.get("delivery_method"),
            "endpoint_url": obj.get("endpoint_url"),
            "events_requested": obj.get("events_requested"),
            "format": obj.get("format"),
            "aud": obj.get("aud"),
            "iss": obj.get("iss")
        })
        return _obj


