# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.6.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class TransactionPolicyBindingRequest(BaseModel):
    """
    PolicyBindingSerializer which does not require target as target is set implicitly
    """ # noqa: E501
    policy: Optional[UUID] = None
    group: Optional[UUID] = None
    user: Optional[StrictInt] = None
    negate: Optional[StrictBool] = Field(default=None, description="Negates the outcome of the policy. Messages are unaffected.")
    enabled: Optional[StrictBool] = None
    order: Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]
    timeout: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = Field(default=None, description="Timeout after which Policy execution is terminated.")
    failure_result: Optional[StrictBool] = Field(default=None, description="Result if the Policy execution fails.")
    __properties: ClassVar[List[str]] = ["policy", "group", "user", "negate", "enabled", "order", "timeout", "failure_result"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionPolicyBindingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if policy (nullable) is None
        # and model_fields_set contains the field
        if self.policy is None and "policy" in self.model_fields_set:
            _dict['policy'] = None

        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionPolicyBindingRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "policy": obj.get("policy"),
            "group": obj.get("group"),
            "user": obj.get("user"),
            "negate": obj.get("negate"),
            "enabled": obj.get("enabled"),
            "order": obj.get("order"),
            "timeout": obj.get("timeout"),
            "failure_result": obj.get("failure_result")
        })
        return _obj


